{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
{This unit is added because Delphi's code limit has been reached in MainUnit}
unit overflow;

interface

uses Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls, ComCtrls, nwinc32;

//public

    Procedure GetCacheStats;
    Procedure GetCPUStats;
    Procedure GetDirCacheStats;
    Procedure GetServerInfoStats;
    Procedure GetGarbageStats;
    Procedure GetIPXStats;
    Procedure GetLSLStats;
    Procedure GetPacketBurstStats;
    Procedure GetNCPStats;
    Procedure GetLANStats;

implementation
uses
   mainunit;


procedure GetCacheStats;
var
  fseCacheInfo : NWFSE_CACHE_INFO;
begin
//  Form1.application.processmessages;
  try
    ccode:=NWGetCacheinfo(connHandle,fseCacheInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    if (inttohex(ccode,2)='89C6')then
      form1.sgdStats.Cells[0,1]:='No Console rights'
    else
      form1.sgdStats.Cells[0,1]:='NWGetCacheInfo Failed: '+inttohex(ccode,2);
    exit;
  end;
  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('Current Server Time:|'+ticktostr(fseCacheInfo.serverTimeAndVConsoleInfo.currentServerTime));
    lstStats.Items.Add('Vconsole Version:|'+FormatFloat('###,###,###,##0',fseCacheInfo.serverTimeAndVConsoleInfo.vconsoleVersion));
    lstStats.Items.Add('Vconsole Revision:|'+FormatFloat('###,###,###,##0',fseCacheInfo.serverTimeAndVConsoleInfo.vconsoleRevision));
    lstStats.Items.Add('Original Num Of Cache Buffers:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.originalNumOfCacheBuffers));
    lstStats.Items.Add('Current Num Of Cache Buffers:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.currentNumOfCacheBuffers));
    lstStats.Items.Add('Cache Dirty Block Threshold:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.cacheDirtyBlockThreshold));
    lstStats.Items.Add('Wait Node Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.waitNodeCount));
    lstStats.Items.Add('Wait Node Alloc Failure Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.waitNodeAllocFailureCount));
    lstStats.Items.Add('Move Cache Node Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.moveCacheNodeCount));
    lstStats.Items.Add('Move Cache Node From Avail Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.moveCacheNodeFromAvailCount));
    lstStats.Items.Add('Accelerate Cache Node Write Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.accelerateCacheNodeWriteCount));
    lstStats.Items.Add('Remove Cache Node Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.removeCacheNodeCount));
    lstStats.Items.Add('Remove Cache Node From Avail Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheMemCounters.removeCacheNodeFromAvailCount));
    lstStats.Items.Add('Read Existing Block Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.readExistingBlockCount));
    lstStats.Items.Add('Read Existing Write Wait Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.readExistingWriteWaitCount));
    lstStats.Items.Add('Read Existing Partial Read Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.readExistingPartialReadCount));
    lstStats.Items.Add('Read Existing Read Error Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.readExistingReadErrorCount));
    lstStats.Items.Add('Write Block Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.writeBlockCount));
    lstStats.Items.Add('Write Entire Block Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.writeEntireBlockCount));
    lstStats.Items.Add('Get Disk Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getdiskcount));
    lstStats.Items.Add('Get Disk Need To Alloc Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskNeedToAllocCount));
    lstStats.Items.Add('Get Disk Someone Beat Me Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskSomeoneBeatMeCount));
    lstStats.Items.Add('Get Disk Partial Read Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskPartialReadCount));
    lstStats.Items.Add('Get Disk Read Error Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskReadErrorCount));
    lstStats.Items.Add('Get Async Disk Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getAsyncDiskCount));
    lstStats.Items.Add('Get Async Disk Need To Alloc:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getAsyncDiskNeedToAlloc));
    lstStats.Items.Add('Get Async Disk Someone Beat Me:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getAsyncDiskSomeoneBeatMe));
    lstStats.Items.Add('Error Doing Async Read Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.errorDoingAsyncReadCount));
    lstStats.Items.Add('Get Disk No Read Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskNoReadCount));
    lstStats.Items.Add('Get Disk No Read Alloc Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskNoReadAllocCount));
    lstStats.Items.Add('Get Disk No Read Beat Me Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.getDiskNoReadSomeoneBeatMeCount));
    lstStats.Items.Add('Disk Write Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.diskWriteCount));
    lstStats.Items.Add('Disk Write Alloc Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.diskWriteAllocCount));
    lstStats.Items.Add('Disk Write Someone Beat Me Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.diskWriteSomeoneBeatMeCount));
    lstStats.Items.Add('Write Error Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.writeErrorCount));
    lstStats.Items.Add('Wait On Semaphore Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.waitOnSemaphoreCount));
    lstStats.Items.Add('Alloc Block Wait For Someone Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.allocBlockWaitForSomeoneCount));
    lstStats.Items.Add('Alloc Block Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.allocBlockCount));
    lstStats.Items.Add('Alloc Block Wait Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheCounters.allocBlockWaitCount));
    lstStats.Items.Add('Num Cache Checks:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.numCacheChecks));
    lstStats.Items.Add('Num Cache Hits:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.numCacheHits));
    lstStats.Items.Add('Num Dirty Cache Checks:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.numDirtyCacheChecks));
    lstStats.Items.Add('Num Dirty Cache Hits:|'+ticktostr(fseCacheInfo.cacheTrendCounters.numDirtyCacheHits));
    lstStats.Items.Add('Cache Used While Checking:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.cacheUsedWhileChecking));
    lstStats.Items.Add('Wait For Dirty Blocks Decrease Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.waitForDirtyBlocksDecreaseCount));
    lstStats.Items.Add('Alloc Block From Avail Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.allocBlockFromAvailCount));
    lstStats.Items.Add('Alloc Block From LRU Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.allocBlockFromLRUCount));
    lstStats.Items.Add('Alloc Block Already Waiting:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheTrendCounters.allocBlockAlreadyWaiting));
    lstStats.Items.Add('LRU Sitting Time:|'+ticktostr(fseCacheInfo.cacheTrendCounters.LRUSittingTime));
    lstStats.Items.Add('Max Byte Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.maxByteCount));
    lstStats.Items.Add('Min Num Of Cache Buffers:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.minNumOfCacheBuffers));
    lstStats.Items.Add('Min Cache Report Threshold:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.minCacheReportThreshold));
    lstStats.Items.Add('Alloc Waiting Count:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.allocWaitingCount));
    lstStats.Items.Add('Num Dirty Blocks:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.numDirtyBlocks));
    lstStats.Items.Add('Cache Dirty Wait Time:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.cacheDirtyWaitTime));
    lstStats.Items.Add('Cache Max Concurrent Writes:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.cacheMaxConcurrentWrites));
    lstStats.Items.Add('Max Dirty Time:|'+ticktostr(fseCacheInfo.cacheInformation.maxDirtyTime));
    lstStats.Items.Add('Num Of Dir Cache Buffers:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.numOfDirCacheBuffers));
    lstStats.Items.Add('Cache Byte To Block Shift Factor:|'+FormatFloat('###,###,###,##0',fseCacheInfo.cacheInformation.cacheByteToBlockShiftFactor));
    populatestats;
  end;
end;

procedure GetCPUStats;
var
  cpuname : Array [0..100] of char;
  coprocessor : Array [0..100] of char;
  bus : Array [0..100] of char;
  fseCPUInfo : NWFSE_CPU_INFO;
begin
  try
    ccode := NWGetCPUInfo(connHandle,0,@cpuname,@coprocessor,@bus,fseCPUInfo);
  except
    Exit;
  end;
  if (ccode <>0) then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetCPUInfo Failed: '+inttohex(ccode,2);
    exit;
  end;

  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('CPU Name|'+strpas(cpuname));
    lstStats.Items.Add('Coprocessor|'+strpas(coprocessor));
    lstStats.Items.Add('Bus|'+bus);
    lstStats.Items.Add('Number of CPUs|'+FormatFloat('###,###,###,##0',fseCPUInfo.numOfCPUs));
    lstStats.Items.Add('Page Table Owner Flag|'+FormatFloat('###,###,###,##0',fseCPUInfo.cpuinfo.pageTableOwnerFlag));
  end;

  if fseCPUInfo.cpuinfo.CPUTypeFlag=0 then
      form1.lstStats.Items.Add('CPU Type|'+'80386')
  else if fseCPUInfo.cpuinfo.CPUTypeFlag=1 then
      form1.lstStats.Items.Add('CPU Type|'+'80486')
  else if fseCPUInfo.cpuinfo.CPUTypeFlag=2 then
      form1.lstStats.Items.Add('CPU Type|'+'Pentium')
  else
      form1.lstStats.Items.Add('CPU Type|'+'');

  if fseCPUInfo.cpuinfo.coProcessorFlag=1 then
      form1.lstStats.Items.Add('CoProcessor|'+'True')
  else
      form1.lstStats.Items.Add('CoProcessor|'+'False');

  if inttohex(fseCPUInfo.cpuinfo.busTypeFlag,2)='01' then
      form1.lstStats.Items.Add('Bus Type Flag|'+'micro channel')
  else if inttohex(fseCPUInfo.cpuinfo.busTypeFlag,2)='02' then
      form1.lstStats.Items.Add('Bus Type Flag|'+'EISA')
  else if inttohex(fseCPUInfo.cpuinfo.busTypeFlag,2)='04' then
      form1.lstStats.Items.Add('Bus Type Flag|'+'PCI')
  else if inttohex(fseCPUInfo.cpuinfo.busTypeFlag,2)='08' then
      form1.lstStats.Items.Add('Bus Type Flag|'+'PCMCIA')
  else if inttohex(fseCPUInfo.cpuinfo.busTypeFlag,2)='10' then
      form1.lstStats.Items.Add('Bus Type Flag|'+'ISA')
  else
      form1.lstStats.Items.Add('Bus Type Flag|'+'');

  if fseCPUInfo.cpuinfo.IOEngineFlag = 1 then
      form1.lstStats.Items.Add('IO Engine Flag|'+'True')
  else
      form1.lstStats.Items.Add('IO Engine Flag|'+'False');

  if fseCPUInfo.cpuinfo.FSEngineFlag = 1 then
      form1.lstStats.Items.Add('FS Engine Flag|'+'True')
  else
      form1.lstStats.Items.Add('FS Engine Flag|'+'False');

  form1.lstStats.Items.Add('Non Dedicated CPU Flag|'+FormatFloat('###,###,###,##0',fseCPUInfo.cpuinfo.FSEngineFlag));
  form1.populatestats;
end;

procedure GetDirCacheStats;
var
   fseDirCacheInfo : NWFSE_DIR_CACHE_INFO;
begin
  try
    ccode := NWGetDirCacheInfo(connHandle,fseDirCacheInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
     form1.sgdStats.Cells[0,1]:='NWGetDirCacheInfo Failed: '+inttohex(ccode,2);
     Exit;
  end;
  with form1 do
  begin
    sgdstats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('Min Time Since File Delete|'+ticktostr(fseDirCacheInfo.dirCacheInfo.minTimeSinceFileDelete));
    lstStats.Items.Add('absMinTimeSinceFileDelete|'+ticktostr(fseDirCacheInfo.dirCacheInfo.absMinTimeSinceFileDelete));
    lstStats.Items.Add('Minimum Number Of Dir Cache Buffers|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.minNumOfDirCacheBuffers));
    lstStats.Items.Add('Maximum Number Of Dir Cache Buffers|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.maxNumOfDirCacheBuffers));
    lstStats.Items.Add('Number Of Dir Cache Buffers|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.numOfDirCacheBuffers));
    lstStats.Items.Add('dCMinNonReferencedTime|'+ticktostr(fseDirCacheInfo.dirCacheInfo.dCMinNonReferencedTime));
    lstStats.Items.Add('dCWaitTimeBeforeNewBuffer|'+ticktostr(fseDirCacheInfo.dirCacheInfo.dCWaitTimeBeforeNewBuffer));
    lstStats.Items.Add('dCMaxConcurrentWrites|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.dCMaxConcurrentWrites));
    lstStats.Items.Add('dCDirtyWaitTime|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.dCDirtyWaitTime));
    lstStats.Items.Add('dCDoubleReadFlag|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.dCDoubleReadFlag));
    lstStats.Items.Add('mapHashNodeCount|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.mapHashNodeCount));
    lstStats.Items.Add('spaceRestrictionNodeCount|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.spaceRestrictionNodeCount));
    lstStats.Items.Add('trusteeListNodeCount|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.trusteeListNodeCount));
    lstStats.Items.Add('percentOfVolumeUsedByDirs|'+FormatFloat('###,###,###,##0',fseDirCacheInfo.dirCacheInfo.percentOfVolumeUsedByDirs));
    populatestats;
  end;
end;

procedure GetGarbageStats;
var
  fseGarbageCollectionInfo : NWFSE_GARBAGE_COLLECTION_INFO;
begin
  try
    ccode := NWGetGarbageCollectionInfo(connHandle,fseGarbageCollectionInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetGarbageCollection Failed: '+inttohex(ccode,2);
    Exit;
  end;
  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('failedAllocRequestCount|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.failedAllocRequestCount));
    lstStats.Items.Add('numOfAllocs|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.numOfAllocs));
    lstStats.Items.Add('noMoreMemAvailableCount|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.noMoreMemAvailableCount));
    lstStats.Items.Add('numOfGarbageCollections|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.numOfGarbageCollections));
    lstStats.Items.Add('garbageFoundSomeMem|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.garbageFoundSomeMem));
    lstStats.Items.Add('garbageNumOfChecks|'+FormatFloat('###,###,###,##0',fseGarbageCollectionInfo.garbageNumOfChecks));
    populatestats;
  end;
end;

procedure GetIPXStats;
var
  fseIPXSPXInfo : NWFSE_IPXSPX_INFO;
begin
  try
    ccode := NWGetIPXSPXInfo(connHandle, fseIPXSPXInfo);
  except
    Exit;
  end;
  if (ccode<>0)then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetIPXSPXInfo Failed: '+inttohex(ccode,2);
    Exit;
  end;

  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('IPXSendPacketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXSendPacketCount));
    lstStats.Items.Add('IPXMalformPacketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXMalformPacketCount));
    lstStats.Items.Add('IPXGetECBRequestCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXGetECBRequestCount));
    lstStats.Items.Add('IPXGetECBFailCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXGetECBFailCount));
    lstStats.Items.Add('IPXAESEventCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXAESEventCount));
    lstStats.Items.Add('IPXPostponedAESCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXPostponedAESCount));
    lstStats.Items.Add('IPXMaxConfiguredSocketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXMaxConfiguredSocketCount));
    lstStats.Items.Add('IPXMaxOpenSocketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXMaxOpenSocketCount));
    lstStats.Items.Add('IPXOpenSocketFailCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXOpenSocketFailCount));
    lstStats.Items.Add('IPXListenECBCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXListenECBCount));
    lstStats.Items.Add('IPXECBCancelFailCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXECBCancelFailCount));
    lstStats.Items.Add('IPXGetLocalTargetFailCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.IPXInfo.IPXGetLocalTargetFailCount));
    lstStats.Items.Add('SPXMaxConnsCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXMaxConnsCount));
    lstStats.Items.Add('SPXMaxUsedConns|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXMaxUsedConns));
    lstStats.Items.Add('SPXEstConnReq|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXEstConnReq));
    lstStats.Items.Add('SPXEstConnFail|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXEstConnFail));
    lstStats.Items.Add('SPXListenConnectReq|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXListenConnectReq));
    lstStats.Items.Add('SPXListenConnectFail|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXListenConnectFail));
    lstStats.Items.Add('SPXSendCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXSendCount));
    lstStats.Items.Add('SPXWindowChokeCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXWindowChokeCount));
    lstStats.Items.Add('SPXBadSendCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXBadSendCount));
    lstStats.Items.Add('SPXSendFailCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXSendFailCount));
    lstStats.Items.Add('SPXAbortedConn|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXAbortedConn));
    lstStats.Items.Add('SPXListenPacketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXListenPacketCount));
    lstStats.Items.Add('SPXBadListenCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXBadListenCount));
    lstStats.Items.Add('SPXIncomingPacketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXIncomingPacketCount));
    lstStats.Items.Add('SPXBadInPacketCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXBadInPacketCount));
    lstStats.Items.Add('SPXSuppressedPackCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXSuppressedPackCount));
    lstStats.Items.Add('SPXNoSesListenECBCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXNoSesListenECBCount));
    lstStats.Items.Add('SPXWatchDogDestSesCount|'+FormatFloat('###,###,###,##0',fseIPXSPXInfo.SPXInfo.SPXWatchDogDestSesCount));
    populatestats;
  end;
end;

procedure GetLANStats;
var
  fseLANConfigInfo : NWFSE_LAN_CONFIG_INFO;
  fseLANCommonCountersInfo : NWFSE_LAN_COMMON_COUNTERS_INFO;
  LogicalName : string;
  i : Integer;
  boardnum : Integer;
begin
  boardnum:=0;
  if form1.rbnLAN1.Checked=True then
    boardnum:=1
  else if form1. rbnLAN2.Checked=True then
    boardnum:=2
  else if form1.rbnLAN3.Checked=True then
    boardnum:=3
  else if form1.rbnLAN4.Checked=True then
    boardnum:=4;
  try
    ccode := NWGetLANConfigInfo(connHandle, boardnum, fseLANConfigInfo);
  except
    Exit;
  end;
  if (ccode<>0)then
  begin
    if inttohex(ccode,2)='8979' then
    begin
      form1.sgdStats.Cells[0,1]:='Frame Type';
      form1.sgdStats.Cells[1,1]:='Not Loaded';
    end
    else
    begin
      form1.sgdStats.Cells[0,1]:='Error Code';
      form1.sgdStats.Cells[1,1]:=inttohex(ccode,2);
    end;
    Exit;
  end;
  ccode := NWGetLANCommonCountersInfo(connHandle, 1,0, fseLANCommonCountersInfo);
  if (ccode<>0)then
  begin
    if inttohex(ccode,2)='8979' then
    begin
      form1.sgdStats.Cells[0,1]:='Frame Type';
      form1.sgdStats.Cells[1,1]:='Not Loaded';
    end
    else
    begin
      form1.sgdStats.Cells[0,1]:='Error Code';
      form1.sgdStats.Cells[1,1]:=inttohex(ccode,2);
    end;
    Exit;
  end;
  with form1 do
  begin
  sgdStats.Cells[0,0]:='Statistic';
  sgdStats.Cells[1,0]:='Value';
  lstStats.Items.Add('DriverCFG_MajorVersion|'+
  FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverCFG_MajorVersion));
  lstStats.Items.Add('DriverNodeAddress|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[0])+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[1])+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[2])+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[3])+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[4])+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverNodeAddress[5]));
  lstStats.Items.Add('DriverCFG_MinorVersion|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverCFG_MinorVersion));
  lstStats.Items.Add('DriverModeFlags|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverModeFlags));
  lstStats.Items.Add('DriverBoardNum|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverBoardNum));
  lstStats.Items.Add('DriverBoardInstance|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverBoardInstance));
  lstStats.Items.Add('DriverMaxSize|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMaxSize));
  lstStats.Items.Add('DriverMaxRecvSize|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMaxRecvSize));
  lstStats.Items.Add('DriverRecvSize|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverRecvSize));
  lstStats.Items.Add('DriverCardID|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverCardID));
  lstStats.Items.Add('DriverMediaID|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMediaID));
  lstStats.Items.Add('DriverTransportTime|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverTransportTime));
  lstStats.Items.Add('DriverMajorVersion|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMajorVersion));
  lstStats.Items.Add('DriverMinorVersion|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMinorVersion));
  lstStats.Items.Add('DriverFlags|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverFlags));
  lstStats.Items.Add('DriverSendRetries|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverSendRetries));
  lstStats.Items.Add('DriverLink|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverLink));
  lstStats.Items.Add('DriverSharingFlags|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverSharingFlags));
  lstStats.Items.Add('DriverSlot|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverSlot));
  lstStats.Items.Add('DriverIOPortsAndLengths|'+inttohex(fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[0],2)+'-'+
      inttohex(fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[0]+fseLanConfigInfo.LANConfigInfo.DriverIOPortsAndLengths[1]-1,2));
  lstStats.Items.Add('DriverMemDecode0|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMemDecode0));
  lstStats.Items.Add('DriverLength0|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverLength0));
  lstStats.Items.Add('DriverMemDecode1|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverMemDecode1));
  lstStats.Items.Add('DriverLength1|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverLength1));
  lstStats.Items.Add('DriverInterrupt|'+'Primary: '+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverInterrupt[0])+', Secondary: '+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverInterrupt[1]));
  lstStats.Items.Add('DriverDMAUsage|'+'Primary: '+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverDMAUsage[0])+', Secondary: '+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverDMAUsage[1]));
  for i:=0 to 17 do
  begin
    if char(fseLANConfigInfo.LANConfigInfo.DriverLogicalName[i])=#0 then
      break;
    LogicalName:=LogicalName+char(fseLANConfigInfo.LANConfigInfo.DriverLogicalName[i]);
  end;
  lstStats.Items.Add('DriverLogicalName|'+LogicalName);
  lstStats.Items.Add('DriverLinearMem|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverLinearMem[0])+', '+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverLinearMem[1]));
  lstStats.Items.Add('DriverChannelNum|'+FormatFloat('###,###,###,##0',fseLANConfigInfo.LANConfigInfo.DriverChannelNum));
  lstStats.Items.Add('totalTxPacketCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.totalTxPacketCount));
  lstStats.Items.Add('totalRxPacketCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.totalRxPacketCount));
  lstStats.Items.Add('noECBAvailableCount |'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.noECBAvailableCount));
  lstStats.Items.Add('packetTxTooBigCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetTxTooBigCount));
  lstStats.Items.Add('packetTxTooSmallCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetTxTooSmallCount));
  lstStats.Items.Add('packetRxOverflowCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetRxOverflowCount));
  lstStats.Items.Add('packetRxTooBigCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetRxTooBigCount));
  lstStats.Items.Add('packetRxTooSmallCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetRxTooSmallCount));
  lstStats.Items.Add('packetTxMiscErrorCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetTxMiscErrorCount));
  lstStats.Items.Add('packetRxMiscErrorCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.packetRxMiscErrorCount));
  lstStats.Items.Add('retryTxCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.retryTxCount));
  lstStats.Items.Add('checksumErrorCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.checksumErrorCount));
  lstStats.Items.Add('hardwareRxMismatchCount|'+FormatFloat('###,###,###,##0',fseLANCommonCountersInfo.LANCommonInfo.hardwareRxMismatchCount));
  populatestats;
  end;
end;

procedure GetPacketBurstStats;
var
  fsePacketBurstInfo : NWFSE_PACKET_BURST_INFO;
begin
  try
    ccode := NWGetPacketBurstInfo(connHandle,fsePacketBurstInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetPacketBurstStats Failed: '+inttohex(ccode,2);
    Exit;
  end;
  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('bigInvalidSlotCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigInvalidSlotCount));
    lstStats.Items.Add('bigForgedPacketCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigForgedPacketCount));
    lstStats.Items.Add('bigInvalidPacketCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigInvalidPacketCount));
    lstStats.Items.Add('bigStillTransmittingCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigStillTransmittingCount));
    lstStats.Items.Add('stillDoingTheLastRequestCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.stillDoingTheLastRequestCount));
    lstStats.Items.Add('invalidCtrlRequestCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.invalidCtrlRequestCount));
    lstStats.Items.Add('ctrlInvalidMessageNumCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.ctrlInvalidMessageNumCount));
    lstStats.Items.Add('ctrlBeingTornDownCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.ctrlBeingTornDownCount));
    lstStats.Items.Add('bigRepeatTheFileReadCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigRepeatTheFileReadCount));
    lstStats.Items.Add('bigSendExtraCCCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigSendExtraCCCount));
    lstStats.Items.Add('bigReturnAbortMessageCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReturnAbortMessageCount));
    lstStats.Items.Add('bigReadInvalidMessageNumCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadInvalidMessageNumCount));
    lstStats.Items.Add('bigReadDoItOverCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadDoItOverCount));
    lstStats.Items.Add('bigReadBeingTornDownCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadBeingTornDownCount));
    lstStats.Items.Add('previousCtrlPacketCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.previousCtrlPacketCount));
    lstStats.Items.Add('sendHoldOffMessageCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.sendHoldOffMessageCount));
    lstStats.Items.Add('bigReadNoDataAvailableCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadNoDataAvailableCount));
    lstStats.Items.Add('bigReadTryingToReadTooMuchCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadTryingToReadTooMuchCount));
    lstStats.Items.Add('asyncReadErrorCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.asyncReadErrorCount));
    lstStats.Items.Add('bigReadPhysicalReadErrorCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigReadPhysicalReadErrorCount));
    lstStats.Items.Add('ctrlBadACKFragmentListCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.ctrlBadACKFragmentListCount));
    lstStats.Items.Add('ctrlNoDataReadCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.ctrlNoDataReadCount));
    lstStats.Items.Add('writeDuplicateRequestCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeDuplicateRequestCount));
    lstStats.Items.Add('shouldntBeACKingHereCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.shouldntBeACKingHereCount));
    lstStats.Items.Add('writeInconsistentPktLengthsCnt|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeInconsistentPktLengthsCnt));
    lstStats.Items.Add('firstPacketIsntAWriteCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.firstPacketIsntAWriteCount));
    lstStats.Items.Add('writeTrashedDuplicateRequestCnt|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeTrashedDuplicateRequestCnt));
    lstStats.Items.Add('bigWriteInvalidMessageNumCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigWriteInvalidMessageNumCount));
    lstStats.Items.Add('bigWriteBeingTornDownCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigWriteBeingTornDownCount));
    lstStats.Items.Add('bigWriteBeingAbortedCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bigWriteBeingAbortedCount));
    lstStats.Items.Add('zeroACKFragmentCountCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.zeroACKFragmentCountCount));
    lstStats.Items.Add('writeCurrentlyTransmittingCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeCurrentlyTransmittingCount));
    lstStats.Items.Add('tryingToWriteTooMuchCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.tryingToWriteTooMuchCount));
    lstStats.Items.Add('writeOutOfMemForCtrlNodesCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeOutOfMemForCtrlNodesCount));
    lstStats.Items.Add('writeDidntNeedThisFragmentCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeDidntNeedThisFragmentCount));
    lstStats.Items.Add('writeTooManyBuffsCheckedOutCnt|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeTooManyBuffsCheckedOutCnt));
    lstStats.Items.Add('writeTimeOutCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeTimeOutCount));
    lstStats.Items.Add('writeGotAnACKCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeGotAnACKCount));
    lstStats.Items.Add('writeGotAnACKCount1|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeGotAnACKCount1));
    lstStats.Items.Add('pollerAbortedTheConnCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.pollerAbortedTheConnCount));
    lstStats.Items.Add('maybeHadOutOfOrderWritesCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.maybeHadOutOfOrderWritesCount));
    lstStats.Items.Add('hadAnOutOfOrderWriteCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.hadAnOutOfOrderWriteCount));
    lstStats.Items.Add('movedTheACKBitDownCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.movedTheACKBitDownCount));
    lstStats.Items.Add('bumpedOutOfOrderWriteCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.bumpedOutOfOrderWriteCount));
    lstStats.Items.Add('pollerRemovedOldOutOfOrderCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.pollerRemovedOldOutOfOrderCount));
    lstStats.Items.Add('writeDidntNeedButRequestACKCnt|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeDidntNeedButRequestACKCnt));
    lstStats.Items.Add('writeTrashedPacketCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.writeTrashedPacketCount));
    lstStats.Items.Add('tooManyACKFragmentsCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.tooManyACKFragmentsCount));
    lstStats.Items.Add('savedAnOutOfOrderPacketCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.savedAnOutOfOrderPacketCount));
    lstStats.Items.Add('connBeingAbortedCount|'+FormatFloat('###,###,###,##0',fsePacketBurstInfo.packetBurstInfo.connBeingAbortedCount));
    populatestats;
  end;
end;

procedure GetLSLStats;
var
  fseLSLInfo : NWFSE_LSL_INFO;
begin
  try
    ccode := NWGetLSLInfo(connHandle, fseLSLInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetLSLInfo Failed: '+inttohex(ccode,2);
    Exit;
  end;
  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('rxBufs|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.rxBufs));
    lstStats.Items.Add('rxBufs75PerCent|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.rxBufs75PerCent));
    lstStats.Items.Add('rxBufsCheckedOut|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.rxBufsCheckedOut));
    lstStats.Items.Add('rxBufMaxSize|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.rxBufMaxSize));
    lstStats.Items.Add('maxPhysicalSize(ECB)|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.maxPhysicalSize));
    lstStats.Items.Add('lastTimeRxBufAllocated|'+ticktostr(fseLSLInfo.LSLInfo.lastTimeRxBufAllocated));
    lstStats.Items.Add('maxNumsOfProtocols|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.maxNumsOfProtocols));
    lstStats.Items.Add('maxNumsOfMediaTypes(Frame Types)|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.maxNumsOfMediaTypes));
    lstStats.Items.Add('totalTXPackets|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.totalTXPackets));
    lstStats.Items.Add('getECBBfrs|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.getECBBfrs));
    lstStats.Items.Add('getECBFails|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.getECBFails));
    lstStats.Items.Add('AESEventCounts|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.AESEventCounts));
    lstStats.Items.Add('postponedEvents|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.postponedEvents));
    lstStats.Items.Add('ECBCxlFails|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.ECBCxlFails));
    lstStats.Items.Add('validBfrsReused(ECBs)|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.validBfrsReused));
    lstStats.Items.Add('enqueuedSendCount|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.enqueuedSendCount));
    lstStats.Items.Add('totalRXPackets|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.totalRXPackets));
    lstStats.Items.Add('unclaimedPackets|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.unclaimedPackets));
    lstStats.Items.Add('StatisticsTableMajorVersion|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.StatisticsTableMajorVersion));
    lstStats.Items.Add('StatisticsTableMinorVersion|'+FormatFloat('###,###,###,##0',fseLSLInfo.LSLInfo.StatisticsTableMinorVersion));
    populatestats;
  end;
end;

procedure GetNCPStats;
var
  startNCPExtensionID : nuint32;
  itemsInList : nuint16;
  NCPExtensionIDList : Array [0..128] of nuint32;
  NCPExtensionName : Array [0..255] of char;
  i : Integer;
begin
  form1.sgdStats.Cells[0,0]:='Statistic';
  form1.sgdStats.Cells[1,0]:='Value';
  startNCPExtensionID := 0;
  try
    ccode := NWGetNCPExtensionsList(connHandle, @startNCPExtensionID, @itemsInList, @NCPExtensionIDList);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    if inttohex(ccode,2)='89FF' then
       form1.lstStats.Items.Add('No Extensions Found')
    else
       form1.lstStats.Items.Add('NWGetNCPExtensionsList Failed: '+inttohex(ccode,2));
  end;
  for i:=0 to itemsInList-1 do
  begin
      ccode := NWGetNCPExtensionInfo(connHandle, NCPExtensionIDList[i], @NCPExtensionName,nil,nil,nil,nil);
      if (ccode<>0) then
      begin
        form1.lstStats.Items.Add('NWGetNCPExtensionsInfo Failed: '+inttohex(ccode,2));
      end
      else
        form1.lstStats.Items.Add('Extension Name|'+strpas(NCPExtensionName));
  end;
  form1.populatestats;
end;

procedure GetServerInfoStats;
var
  fseFileServerInfo : NWFSE_FILE_SERVER_INFO;
begin
  try
    ccode := NWGetFileServerInfo(connHandle,fseFileServerInfo);
  except
    Exit;
  end;
  if (ccode<>0) then
  begin
    form1.sgdStats.Cells[0,1]:='NWGetFileServerInfo Failed: '+inttohex(ccode,2);
    Exit;
  end;
  with form1 do
  begin
    sgdStats.Cells[0,0]:='Statistic';
    sgdStats.Cells[1,0]:='Value';
    lstStats.Items.Add('NCPStationsInUseCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.NCPStationsInUseCount));
    lstStats.Items.Add('NCPPeakStationsInUseCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.NCPPeakStationsInUseCount));
    lstStats.Items.Add('numOfNCPRequests|'+FormatFloat('###,###,###,##0',fseFileServerInfo.numOfNCPRequests));
    lstStats.Items.Add('serverUtilization|'+FormatFloat('###,###,###,##0',fseFileServerInfo.serverUtilization));
    lstStats.Items.Add('tooManyHops|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.tooManyHops));
    lstStats.Items.Add('unknownNetwork|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.unknownNetwork));
    lstStats.Items.Add('noSpaceForService|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.noSpaceForService));
    lstStats.Items.Add('noReceiveBuffers|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.noReceiveBuffers));
    lstStats.Items.Add('notMyNetwork|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.notMyNetwork));
    lstStats.Items.Add('netBIOSProgatedCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.netBIOSProgatedCount));
    lstStats.Items.Add('totalPacketsServiced|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.totalPacketsServiced));
    lstStats.Items.Add('totalPacketsRouted|'+FormatFloat('###,###,###,##0',fseFileServerInfo.fileServerCounters.totalPacketsRouted));
    lstStats.Items.Add('replyCanceledCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.replyCanceledCount));
    lstStats.Items.Add('writeHeldOffCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.writeHeldOffCount));
    lstStats.Items.Add('writeHeldOffWithDupRequest|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.writeHeldOffWithDupRequest));
    lstStats.Items.Add('invalidRequestTypeCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.invalidRequestTypeCount));
    lstStats.Items.Add('beingAbortedCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.beingAbortedCount));
    lstStats.Items.Add('alreadyDoingReallocCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.alreadyDoingReallocCount));
    lstStats.Items.Add('deAllocInvalidSlotCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.deAllocInvalidSlotCount));
    lstStats.Items.Add('deAllocBeingProcessedCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.deAllocBeingProcessedCount));
    lstStats.Items.Add('deAllocForgedPacketCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.deAllocForgedPacketCount));
    lstStats.Items.Add('deAllocStillTransmittingCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.deAllocStillTransmittingCount));
    lstStats.Items.Add('startStationErrorCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.startStationErrorCount));
    lstStats.Items.Add('invalidSlotCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.invalidSlotCount));
    lstStats.Items.Add('beingProcessedCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.beingProcessedCount));
    lstStats.Items.Add('forgedPacketCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.forgedPacketCount));
    lstStats.Items.Add('stillTransmittingCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.stillTransmittingCount));
    lstStats.Items.Add('reExecuteRequestCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.reExecuteRequestCount));
    lstStats.Items.Add('invalidSequenceNumCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.invalidSequenceNumCount));
    lstStats.Items.Add('duplicateIsBeingSentAlreadyCnt|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.duplicateIsBeingSentAlreadyCnt));
    lstStats.Items.Add('sentPositiveAcknowledgeCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.sentPositiveAcknowledgeCount));
    lstStats.Items.Add('sentDuplicateReplyCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.sentDuplicateReplyCount));
    lstStats.Items.Add('noMemForStationCtrlCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.noMemForStationCtrlCount));
    lstStats.Items.Add('noAvailableConnsCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.noAvailableConnsCount));
    lstStats.Items.Add('reallocSlotCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.reallocSlotCount));
    lstStats.Items.Add('reallocSlotCameTooSoonCount|'+FormatFloat('###,###,###,##0',fseFileServerInfo.ServerInfo.reallocSlotCameTooSoonCount));
    populatestats;
  end;
end;

end.
