{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit set1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, nwinc32, MainUnit;

type
  TSetForm1 = class(TForm)
    Label1: TLabel;
    edtSetStr: TEdit;
    Bevel1: TBevel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    rgpSet: TRadioGroup;
    rbnON: TRadioButton;
    rbnOFF: TRadioButton;
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SetForm1: TSetForm1;

implementation

{$R *.DFM}

procedure TSetForm1.BitBtn2Click(Sender: TObject);
begin
  Close;
end;

procedure TSetForm1.BitBtn1Click(Sender: TObject);
var
  ccode : NWCCODE;
  Category : Integer;
  SetValue : array [0..400] of char;
  SetIntVal : nuint32;
  setCommandName : array [0..255] of char;
  TempString : string;
begin
  Category := strtoint(copy(Label2.caption,Length(Label2.Caption),1));
  case category of
  0:
    begin
      TempString:=edtSetStr.Text;
      strpcopy(setCommandName,Label1.Caption);
      SetIntVal:=strtoint(Tempstring);
      ccode:=NWSMSetDynamicCmdIntValue(connHandle, @setCommandName, SetIntVal);
      if (ccode<>0) then
      begin
       if ccode=518 then
         ShowMessage('Unable to set the command')
       else
         ShowMessage('NWSMSetDynamicCmdIntValue Failed: '+inttohex(ccode,2));
       exit;
      end;
    Close;
    end;
  5,3:
    begin
      strpcopy(setCommandName,Label1.Caption);
      strpcopy(SetValue,edtSetStr.Text);
      ccode:=NWSMSetDynamicCmdStrValue(connHandle, @setCommandName, @SetValue);
      if (ccode<>0) then
      begin
       if ccode=518 then
         ShowMessage('Unable to set the command')
       else
         ShowMessage('NWSMSetDynamicCmdStrValue Failed: '+inttohex(ccode,2));
       exit;
      end;
    Close;
    end;
  1,6:
    begin
      if rbnON.Checked=False then
        SetIntVal:=0
      else
        SetIntVal:=1;
      strpcopy(setCommandName,Label1.Caption);
      ccode:=NWSMSetDynamicCmdIntValue(connHandle, @setCommandName, SetIntVal);
      if (ccode<>0) then
      begin
       if ccode=518 then
         ShowMessage('Unable to set the command')
       else
         ShowMessage('NWSMSetDynamicCmdStrValue Failed: '+inttohex(ccode,2));
       exit;
      end;
    Close;
    end;
  end;
  Form1.GetSetItem;
end;

end.
