{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit set2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Spin, ExtCtrls, Buttons, MainUnit, NwInc32;

type
  TSetForm2 = class(TForm)
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    Label2: TLabel;
    Hours: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    SpinEdit5: TSpinEdit;
    Label5: TLabel;
    Bevel1: TBevel;
    Label6: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SetForm2: TSetForm2;

implementation

{$R *.DFM}

procedure TSetForm2.SpinEdit5Change(Sender: TObject);
begin
 If SpinEdit5.Value=18 then
 begin
   SpinEdit4.Value:=SpinEdit4.Value+1;
   SpinEdit5.Value:=0;
 end;
end;

procedure TSetForm2.SpinEdit4Change(Sender: TObject);
begin
 If SpinEdit4.Value=60 then
 begin
   SpinEdit3.Value:=SpinEdit3.Value+1;
   SpinEdit4.Value:=0;
 end;
end;

procedure TSetForm2.SpinEdit3Change(Sender: TObject);
begin
 If SpinEdit3.Value=60 then
 begin
   SpinEdit2.Value:=SpinEdit2.Value+1;
   SpinEdit3.Value:=0;
 end;
end;

procedure TSetForm2.SpinEdit2Change(Sender: TObject);
begin
 If SpinEdit2.Value=24 then
 begin
   SpinEdit1.Value:=SpinEdit1.Value+1;
   SpinEdit2.Value:=0;
 end;
end;

procedure TSetForm2.BitBtn2Click(Sender: TObject);
begin
 Close;
end;

procedure TSetForm2.BitBtn1Click(Sender: TObject);
var
  ccode : NWCCODE;
  Category : Integer;
  SetValue : nuint32;
  FinalTick: extended;
  Days, Hrs, Min, Sec, Tick: Integer;
  setCommandName : array [0..255] of char;
begin
  Category := strtoint(copy(Label6.caption,Length(Label6.Caption),1));
  case category of
  2:
    begin
      Days:=SpinEdit1.Value;
      Hrs:=SpinEdit2.Value;
      Min:=SpinEdit3.Value;
      Sec:=SpinEdit4.Value;
      Tick:=SpinEdit5.Value;
      FinalTick:=(Days*60*60*24*18.205)+(Hrs*60*60*18.205)+(Min*60*18.205)+(Sec*18.205)+Tick;
      strpcopy(setCommandName,Label1.Caption);
      SetValue:=Trunc(FinalTick);
      ccode:=NWSMSetDynamicCmdIntValue(connHandle, @setCommandName, SetValue);
      if (ccode<>0) then
      begin
       if ccode=518 then
         ShowMessage('Unable to set the command')
       else
         ShowMessage('NWSMSetDynamicCmdIntValue Failed: '+inttohex(ccode,2));
       exit;
      end;
    Close;
    end;
  4:
    begin
      SHowMessage('Not done');
    end;
  end;
  Form1.GetSetItem;
end;

end.
