{****************************************************************************

    Copyright (c) 1992 Novell, Inc.  All Rights Reserved.

    THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND
    TREATIES.  USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE
    LICENSE AGREEMENT ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK)
    THAT CONTAINS THIS WORK.

    Pursuant to the SDK License Agreement, Novell hereby grants to
    Developer a royalty-free, non-exclusive license to include the
    sample code ONSITE.EXE and derivative binaries in its product.
    Novell grants to Developer worldwide distribution rights to market,
    distribute or sell the sample code ONSITE.EXE and derivative
    binaries as a component of Developer's product(s).  Novell shall
    have no obligations to Developer or Developer's customers with
    respect to this code.

    DISCLAIMER:

    Novell, Inc. makes no representations or warranties with respect
    to the contents or use of this code, and specifically disclaims any
    express or implied warranties of merchantability or fitness for any
    particular purpose.  Further, Novell, Inc. reserves the right to revise
    this publication and to make changes to its content, at any time,
    without obligation to notify any person or entity of such revisions or
    changes.

    Further, Novell, Inc. makes no representations or warranties with
    respect to any software, and specifically disclaims any express or
    implied warranties of merchantability or fitness for any particular
    purpose.  Further, Novell, Inc. reserves the right to make changes to
    any and all parts of the software, at any time, without obligation to
    notify any person or entity of such changes.

    Application: OnSite Administrator
    
    Description:
    OnSite Administrator provides a very robust level of Server Administration
    from any Windows 95/NT system.This program works with NetWare 3.x and 4.x
    Servers without any additional NLM loaded. Because of the new managability
    features found in NetWare 4.x, more administration tools are available for
    4.x systems.  OnSite Admin does provide partial support for NetWare 3.x
    versions. See On-Line help for feature List.

    Programmers:

             Ini          Who                      Firm
             -------------------------------------------------------------------
             SMW        Steven Wootton            Novell Developer Support

    History:

             When               Who             What
             -------------------------------------------------------------------
             12-17-96           SMW             First code.
}
unit Tree;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, nwinc32;

type
  TTreeForm = class(TForm)
    tvwDS: TTreeView;
    lblTTree: TLabel;
    edtTree: TEdit;
    lstTrees: TListBox;
    lblTContext: TLabel;
    edtContext: TEdit;
    grpWho: TGroupBox;
    lblWho: TLabel;
    bbtModObj: TBitBtn;
    bbtRemoveObj: TBitBtn;
    bbtAddObj: TBitBtn;
    bbtContext: TBitBtn;
    bbtClose: TBitBtn;
    bbtLogin: TBitBtn;
    procedure bbtCloseClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure bbtContextClick(Sender: TObject);
    procedure edtContextKeyPress(Sender: TObject; var Key: Char);
    procedure lstTreesDblClick(Sender: TObject);
    procedure bbtAddObjClick(Sender: TObject);
    procedure bbtRemoveObjClick(Sender: TObject);
    procedure lstTreesClick(Sender: TObject);
    procedure GetDSList;
    procedure tvwDSDblClick(Sender: TObject);
    procedure tvwDSClick(Sender: TObject);
    procedure tvwDSMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure edtTreeKeyPress(Sender: TObject; var Key: Char);
    procedure bbtLoginClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TreeForm: TTreeForm;

implementation

uses mainunit, Login, attrib, Add;

{$R *.DFM}

procedure TTreeForm.bbtCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TTreeForm.GetDSList;
var
  outBuf:^Buf_T;
  ccode:NWDSCCODE;
  nContext:array [0..MAX_DN_CHARS] of char;
  ppoutBuf:pointer;
  iterator:NWDS_ITERATION;
  typelessName: array [0..255] of char;
  objectCount:NWCOUNT;
  flags: nuint32;
  i:Integer;
  attrCount:nint32;
  ObjectInfo:Object_Info_T;
  GObjectNAme: array[0..255] of char;
  Node : TTreeNode;
  RNode : TTreeNode;
  objName : array [0..200] of char;
  BaseClass : String;
  treeName : array [0..100] of char;

begin
  Screen.Cursor := crHourGlass;
  TreeForm.tvwDS.Enabled:=False;

  dcode:=NWDSGetContext(dContext,DCK_TREE_NAME,@TreeName);
  if (dcode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSGetContext Failed'+#13+'Error Code: '+inttostr(dcode));
     NWDSFreeContext(dContext);
     exit;
  end;

  dcode:=NWDSWhoAmI(dContext,@objName);
  if (dcode<0) then
  begin
    ShowMessage('NWDSWhoAmI Failed: '+inttostr(dcode));
  end;

  TreeForm.lblWho.Caption:=strpas(objName);

  TreeForm.edtTree.Text:=strpas(TreeName);

  {Get the current context and display it in ectContext}

  dcode:=NWDSGetContext(dContext,DCK_NAME_CONTEXT,@nContext);
  if (dcode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSGetContext Failed'+#13+'Error Code: '+inttostr(dcode));
     NWDSFreeContext(dContext);
     exit;
  end;

  TreeForm.edtContext.Text:=strpas(nContext);

  ccode:=NWDSRemoveAllTypes(dContext,@nContext,@typelessName);
  if (ccode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSRemoveAllTypes Failed'+#13+'Error Code: '+inttostr(ccode));
     exit;
  end;

  ccode:=NWDSGetContext(dContext,DCK_FLAGS,@flags);
  if (ccode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSGetContext Flags Failed'+#13+'Error Code: '+inttostr(ccode));
     exit;
  end;

  flags:=flags OR DCV_TYPELESS_NAMES;
  flags:=flags AND (NOT(DCV_CANONICALIZE_NAMES));

  ccode:=NWDSSetContext(dContext,DCK_FLAGS,@flags);
  if (ccode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSSetContext Flags Failed'+#13+'Error Code: '+inttostr(ccode));
     exit;
  end;

  {Allocates a Buf_T for a result buffer to a Directory Services function}
  ccode:=NWDSAllocBuf(DEFAULT_MESSAGE_LEN, @outBuf);
  if (ccode<0)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSAllocBuf Failed'+#13+'Error Code: '+inttostr(ccode));
     NWDSFreeContext(dContext);
     exit;
  end;

  {Use dummy pointers to avoid GPFs in Delphi}
  ppoutbuf := outbuf;

  {Add DS Objects in context to TreeView1}
  iterator:=-1;

  repeat
  ccode:=NWDSList(dContext,@nContext,@iterator,ppoutbuf);
  if (ccode=-601)then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('Could not locate object in the tree');
     exit;
  end;
  if (ccode<0) then
  begin
     Screen.Cursor := crDefault;
     TreeForm.tvwDS.Enabled:=True;
     ShowMessage('NWDSList Failed'+#13+'Error Code: '+inttostr(ccode));
     exit;
  end;

  {Determine the number of subordinate objects contained in the result buffer}
  ccode:=NWDSGetObjectCount(dContext, ppoutbuf, @objectCount);
  if (ccode <> 0)then
  begin
     ShowMessage('NWDSGetObjectCount Failed'+#13+'Error Code: '+inttostr(ccode));
     TreeForm.tvwDS.Enabled:=True;
     Screen.Cursor := crDefault;
     exit;
  end;

  if (TreeForm.tvwDS.selected=nil) then
  begin
    RNode:=TreeForm.tvwDS.Items.Add(TreeForm.tvwDS.Selected,TreeForm.edtContext.text);
    if (uppercase(TreeForm.edtContext.text)='[ROOT]') then
    Begin
      RNode.ImageIndex:=rootbmp;
      RNode.SelectedIndex:=rootbmp;
    end
    else
    begin
      RNode.ImageIndex:=oubmp;
      RNode.SelectedIndex:=oubmp;
    end;
  end
  else
  begin
    RNode:=TreeForm.tvwDS.selected;
  end;
  for i := 1 to objectCount do
  begin
     ccode := NWDSGetObjectName(dContext,ppoutbuf,@gobjectName,@attrCount,@objectInfo);
     if (ccode <> 0)then
     begin
        ShowMessage('NWDSGetObjectName Failed'+#13+'Error Code: '+inttostr(ccode));
        Screen.Cursor := crDefault;
        TreeForm.tvwDS.Enabled:=True;
        exit;
     end;

     BaseClass:=strpas(ObjectInfo.baseClass);

     if pos('User',baseClass)>0 then
     begin
         Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
         Node.ImageIndex:=userbmp;
         Node.SelectedIndex:=userbmp;
     end
     else if pos('Queue',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=pqueuebmp;
        Node.SelectedIndex:=pqueuebmp;
     end
     else if pos('Organizational Unit',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=oubmp;
        Node.SelectedIndex:=oubmp;
     end
     else if pos('NCP Server',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=serverbmp;
        Node.SelectedIndex:=serverbmp;
     end
     else if pos('Volume',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=volumebmp;
        Node.SelectedIndex:=volumebmp;
     end
     else if pos('Organizational Role',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=orolebmp;
        Node.SelectedIndex:=orolebmp;
     end
     else if pos('Print Server',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=pserverbmp;
        Node.SelectedIndex:=pserverbmp;
     end
     else if pos('GroupWise',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=15;
        Node.SelectedIndex:=15;
     end
     else if pos('Group',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=groupbmp;
        Node.SelectedIndex:=groupbmp;
     end
     else if pos('Bindery Object',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=bobjbmp;
        Node.SelectedIndex:=bobjbmp;
     end
     else if pos('Printer',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=printerbmp;
        Node.SelectedIndex:=printerbmp;
     end
     else if pos('Application',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=15;
        Node.SelectedIndex:=15;
     end
     else if pos('Organization',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=orgbmp;
        Node.SelectedIndex:=orgbmp;
     end
     else if pos('Alias',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=aliasbmp;
        Node.SelectedIndex:=aliasbmp;
     end
     else if pos('Tserver',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=serverbmp;
        Node.SelectedIndex:=serverbmp;
     end
     else if pos('Computer',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=16;
        Node.SelectedIndex:=16;
     end
     else if pos('Directory Map',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=18;
        Node.SelectedIndex:=18;
     end
     else if pos('Profile',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=19;
        Node.SelectedIndex:=19;
     end
     else if pos('Template',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=20;
        Node.SelectedIndex:=20;
     end
     else if pos('Country',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=21;
        Node.SelectedIndex:=21;
     end
     else if pos('AFP',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=17;
        Node.SelectedIndex:=17;
     end
     else if pos('Network Service',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=10;
        Node.SelectedIndex:=10;
     end
     else if pos('Audit',baseClass)>0then
     begin
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName));
        Node.ImageIndex:=22;
        Node.SelectedIndex:=22;
     end
     else
     begin
//        ShowMessage('Unknown Object Base Class: '+strpas(ObjectInfo.baseClass));
        Node:=TreeForm.tvwDS.Items.AddChild(RNode,strpas(gobjectName)+'('+baseClass+')');
        Node.ImageIndex:=unknownbmp;
        Node.SelectedIndex:=unknownbmp;
     end;
  end;
  until iterator=-1;
  Screen.Cursor := crDefault;  {Show Default cursor}
  Form1.StatusBar1.Panels[5].Text:=inttostr(TreeForm.tvwDS.Items.Count-1)+' objects';
  NWDSFreeBuf(ppoutbuf);
  TreeForm.tvwDS.FullExpand;
  TreeForm.tvwDS.Enabled:=True;
end;

procedure TTreeForm.FormShow(Sender: TObject);
var
  add : Boolean;
  scanFilter : array [0..2] of char;
  scanIndex : nint32;
  treeName : array [0..100] of char;
  g : Integer;
begin
  Screen.Cursor:=CrHourGlass;
  scanIndex:=-1;
  strpcopy(scanFilter, '*');
  while dcode=0 do
  begin
     add:=TRUE;
     dcode := NWDSScanForAvailableTrees(dContext, connHandle, @scanFilter, scanIndex, @treeName);
     for g:=0 to TreeForm.lstTrees.Items.Count-1 do
     begin
       if CompareText(treeName, TreeForm.lstTrees.Items[g])=0 then
       begin
         add:=FALSE;
         break;
       end;
     end;
     if add=TRUE then
       TreeForm.lstTrees.Items.Add(treeName);
  end;
  GetDSList;
  Screen.Cursor:=CrDefault;
end;

procedure TTreeForm.bbtContextClick(Sender: TObject);
var
  newcontext:array [0..255] of char;
  newTree:Array [0..100] of char;
  objName : Array [0..200] of char;
begin
  strpcopy(newTree,TreeForm.edtTree.text);
  dcode:=NWDSSetContext(dContext,DCK_TREE_NAME,@newTree);
  if (dcode<>0) then
  begin
    ShowMessage('NWDSSetContext Failed: '+inttostr(dcode));
    Exit;
  end;

  if edtContext.text='' then
    strpcopy(newcontext,'[Root]')
  else
    strpcopy(newcontext,TreeForm.edtContext.text);
  dcode:=NWDSSetContext(dContext,DCK_NAME_CONTEXT,@newcontext);
  if (dcode<>0) then
  begin
    ShowMessage('NWDSSetContext Failed: '+inttostr(dcode));
    Exit;
  end;

  dcode:=NWDSWhoAmI(dContext,@objName);
  if (dcode<>0) then
  begin
    ShowMessage('NWDSWhoAmI Failed: '+inttostr(dcode));
  end;

  if objName='[Public]' then
  begin
    if MessageDlg('You are authenticated as [Public] to '+newTree+#13+'Do you want to login to the tree as a different user?',mtConfirmation,[mbNo,mbYes],0)=mrYes then
    begin
      loginform.lblServer.Caption:=newTree;
      loginform.Caption:='NetWare Tree Login';
      loginform.Show;
      exit;
    end;
  end;
  TreeForm.tvwDS.Items.Clear;
  GetDsList;
end;

procedure TTreeForm.edtContextKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then
     bbtContextClick(TreeForm.edtContext);
end;

procedure TTreeForm.lstTreesDblClick(Sender: TObject);
begin
  bbtContextClick(TreeForm.lstTrees);
end;

procedure TTreeForm.bbtAddObjClick(Sender: TObject);
begin
  attribform.Caption:='Adding Directory Object';
  attribform.edtName.Text:='';
  attribform.sgdAttr.Options:=[goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,goColSizing,goEditing,goTabs,goAlwaysShowEditor,goThumbTracking];  
  AddForm.Show;
end;

procedure TTreeForm.bbtRemoveObjClick(Sender: TObject);
var
  selnode : TTreeNode;
  ObjectName : Array [0..255] of char;
begin
  selnode:=TreeForm.tvwDS.selected;
  if selnode=nil then
    exit;

  if MessageDlg('Are you sure you want to remove '+selnode.text+'?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
    Exit;

  if TreeForm.edtContext.Text='' then
     strpcopy(ObjectName, selnode.text)
  else
     strpcopy(ObjectName, selnode.text+'.'+TreeForm.edtContext.text);

  dcode := NWDSRemoveObject(dContext,@ObjectName);
  if (dcode<0) then
  begin
    if dcode=-672 then
      ShowMessage('You do not have sufficient rights')
    else
      ShowMessage('NWDSRemoveObject Failed: '+inttostr(dcode));
    exit;
  end;

  TreeForm.tvwDS.Items.Clear;
  getdslist;
end;

procedure TTreeForm.lstTreesClick(Sender: TObject);
begin
  TreeForm.edtTree.Text:=TreeForm.lstTrees.Items[TreeForm.lstTrees.ItemIndex];
  TreeForm.edtContext.Text:='[ROOT]';
end;

procedure TTreeForm.tvwDSDblClick(Sender: TObject);
var
  selnode, parentnode : TTreeNode;
  newcontext:array [0..255] of char;
  buildstring: string;
  ccode:NWDSCCODE;
begin
   selnode:=TreeForm.tvwDS.selected;
   if (selnode.imageindex=1) or (selnode.imageindex=11) then
   begin
     selnode.deletechildren;
     buildstring:=selnode.text;
     parentnode:=selnode.parent;
     while (parentnode<>nil) do
     begin
       if (uppercase(parentnode.text)<>'[ROOT]') then
        buildstring:=buildstring+'.'+parentnode.text;
       selnode:=parentnode;
       parentnode:=selnode.parent;
     end;
     strpcopy(newcontext, buildstring);
     ccode:=NWDSSetContext(dContext,DCK_NAME_CONTEXT,@newcontext);
     if ccode <> 0 then
       ShowMessage('NWDSSetContext failed');
     GetDSList;
   end
   else
   begin
     strpcopy(@gobjectName,selnode.text+'.'+TreeForm.edtContext.Text);
     attribform.edtName.Text:=selnode.text;
     Form1.GetAttributes;
   end;
end;

procedure TTreeForm.tvwDSClick(Sender: TObject);
var
  selnode, parentnode : TTreeNode;
  newcontext:array [0..255] of char;
  ccode:NWDSCCODE;
  buildstring:string;
begin
  selnode:=TreeForm.tvwDS.selected;
  if (selnode.parent<>nil) then
  begin
    parentnode:=selnode.parent;
    while (parentnode<>nil) do
    begin
      if (uppercase(parentnode.text)<>'[ROOT]') then
       if buildstring='' then
         buildstring:=parentnode.text
       else
         buildstring:=buildstring+'.'+parentnode.text;
      selnode:=parentnode;
      parentnode:=selnode.parent;
    end;
    strpcopy(newcontext, buildstring);
    ccode:=NWDSSetContext(dContext,DCK_NAME_CONTEXT,@newcontext);
    if ccode <> 0 then
       ShowMessage('NWDSSetContext failed');
    TreeForm.edtContext.Text:=strpas(newcontext);
  end;
end;

procedure TTreeForm.tvwDSMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  selnode : TTreeNode;
begin
 if (Button=mbRight) then
 begin
   selnode:=TreeForm.tvwDS.selected;
   strpcopy(@gobjectName,selnode.text+'.'+TreeForm.edtContext.Text);
   Form1.GetAttributes;
 end;
end;

procedure TTreeForm.edtTreeKeyPress(Sender: TObject; var Key: Char);
begin
  If Key=#13 then
    bbtContextClick(edtTree);
end;

procedure TTreeForm.bbtLoginClick(Sender: TObject);
begin
  if lblWho.Caption<>'[Public]' then
  begin
    if MessageDlg('You are already logged in to this tree as '+lblWho.Caption+', you will lose any mapped drives to this tree.'+#13+'Do you want to login to '+edtTree.Text+' as a different user?',mtConfirmation,[mbNo,mbYes],0)=mrNo then
      Exit;
  end;
  dcode:=NWDSLogout(dContext);
  loginform.lblServer.Caption:=edtTree.text;
  loginform.Caption:='NetWare Tree Login';
  loginform.Show;
end;

end.
