/*
# X-BASED SKEWB
#
#  Skewb.c
#
###
#
#  Copyright (c) 1994		David Albert Bagley, bagleyd@source.asset.com
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Methods file for Skewb */

#include <stdio.h>
#include <math.h>
#ifdef __DECC
#include <unixlib.h>
#endif /* __DECC */
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "SkewbP.h"

static void InitializeSkewb();
static void DestroySkewb();
static Boolean SetValuesSkewb();
static void get_color();

SkewbClassRec skewbClassRec =
{
  {
    (WidgetClass) &widgetClassRec,	/* superclass */
    "Skewb",				/* class name */
    sizeof(SkewbRec),			/* widget size */
    NULL,				/* class initialize */
    NULL,				/* class part initialize */
    FALSE,				/* class inited */
    InitializeSkewb,			/* initialize */
    NULL,				/* initialize hook */
    XtInheritRealize,			/* realize */
    NULL,				/* actions */
    0,					/* num actions */
    NULL,				/* resources */
    0,					/* num resources */
    NULLQUARK,				/* xrm class */
    TRUE,				/* compress motion */
    TRUE,				/* compress exposure */
    TRUE,				/* compress enterleave */
    TRUE,				/* visible interest */
    DestroySkewb,			/* destroy */
    NULL,				/* resize */
    NULL,				/* expose */
    SetValuesSkewb,			/* set values */
    NULL,				/* set values hook */
    XtInheritSetValuesAlmost,		/* set values almost */
    NULL,				/* get values hook */
    NULL,				/* accept focus */
    XtVersion,				/* version */
    NULL,				/* callback private */
    NULL,				/* tm table */
    NULL,				/* query geometry */
    NULL,				/* display accelerator */
    NULL				/* extension */
  },
  {
    0					/* ignore */
  }
};

WidgetClass skewbWidgetClass = (WidgetClass) &skewbClassRec;

static void InitializeSkewb(request, new)
SkewbWidget request, new;
{
  XGCValues values;
  XtGCMask valueMask;
  int face;

  reset_polyhedrons(new);
  new->skewb.practice = FALSE;
  SRAND(getpid());
  valueMask = GCForeground | GCBackground;
  values.foreground = new->skewb.foreground;
  values.background = new->core.background_pixel;
  new->skewb.puzzle_GC = XtGetGC((Widget) new, valueMask, &values);
  new->skewb.depth = DefaultDepthOfScreen(XtScreen(new));
  valueMask = GCForeground | GCBackground;
  values.foreground = new->core.background_pixel;
  values.background = new->skewb.foreground;
  new->skewb.inverse_GC = XtGetGC((Widget) new, valueMask, &values);
  for (face = 0; face < MAXFACES; face++)
    get_color(new, face, TRUE);
}

static void DestroySkewb(w)
SkewbWidget w;
{
  int face;

  for (face = 0; face < MAXFACES; face++)
    XtReleaseGC((Widget) w, w->skewb.face_GC[face]);
  XtReleaseGC((Widget) w, w->skewb.puzzle_GC);
  XtReleaseGC((Widget) w, w->skewb.inverse_GC);
  XtRemoveCallbacks((Widget) w, XtNselectCallback, w->skewb.select);
}

static Boolean SetValuesSkewb(current, request, new)
SkewbWidget current, request, new;
{
  XGCValues values;
  XtGCMask valueMask;
  Boolean redraw = FALSE;
  int face;

  if (new->skewb.foreground != current->skewb.foreground) {
    valueMask = GCForeground | GCBackground;
    values.foreground = new->skewb.foreground;
    values.background = new->core.background_pixel;
    XtReleaseGC((Widget) new, new->skewb.puzzle_GC);
    new->skewb.puzzle_GC = XtGetGC((Widget) new, valueMask, &values);
    if (new->skewb.mono || new->skewb.depth == 1) {
      for (face = 0; face < MAXFACES; face++) {
        values.background = new->core.background_pixel;
        values.foreground = new->skewb.foreground;
        XtReleaseGC((Widget) new, new->skewb.face_GC[face]);
        new->skewb.face_GC[face] = XtGetGC((Widget) new, valueMask, &values);
      }
      current->skewb.mono = new->skewb.mono;
    }
    redraw = TRUE;
  }
  if (new->core.background_pixel != current->core.background_pixel) {
    valueMask = GCForeground | GCBackground;
    values.foreground = new->core.background_pixel;
    values.background = new->skewb.foreground;
    XtReleaseGC((Widget) new, new->skewb.inverse_GC);
    new->skewb.inverse_GC = XtGetGC((Widget) new, valueMask, &values);
    redraw = TRUE;
  }
  for (face = 0; face < MAXFACES; face++) {
    if (strcmp(new->skewb.face_name[face], current->skewb.face_name[face]))
      get_color(new, face, FALSE);
  }
  if (new->skewb.orient != current->skewb.orient) {
    reset_polyhedrons(new);
    new->skewb.practice = FALSE;
    redraw = TRUE;
  } else if (new->skewb.practice != current->skewb.practice) {
    reset_polyhedrons(new);
    redraw = TRUE;
  }
  return redraw;
}

void quit_skewb(w, event, args, n_args)
SkewbWidget w;
XEvent *event;
char *args[];
int n_args;
{
  XtCloseDisplay(XtDisplay(w));
  exit(0);
}

static void get_color(w, face, init)
SkewbWidget w;
int face, init;
{
  XGCValues values;
  XtGCMask valueMask;
  XColor color_cell, rgb;
 
  valueMask = GCForeground | GCBackground;
  values.background = w->core.background_pixel;
  if (w->skewb.depth > 1 && !w->skewb.mono) {
    if (XAllocNamedColor(XtDisplay(w),
        DefaultColormap(XtDisplay(w), XtWindow(w)),
        w->skewb.face_name[face], &color_cell, &rgb)) {
      values.foreground = w->skewb.face_color[face] = color_cell.pixel;
      if (!init)
        XtReleaseGC((Widget) w, w->skewb.face_GC[face]);
      w->skewb.face_GC[face] = XtGetGC((Widget) w, valueMask, &values);
      return;
    } else {
      char buf[121];

      sprintf(buf, "Color name \"%s\" is not defined",
        w->skewb.face_name[face]);
      XtWarning(buf);
    }
  }
  values.foreground = w->skewb.foreground;
  if (!init)
    XtReleaseGC((Widget) w, w->skewb.face_GC[face]);
  w->skewb.face_GC[face] = XtGetGC((Widget) w, valueMask, &values);
}

void reset_polyhedrons(new)
SkewbWidget new;
{
  int face, cube;

  for (face = 0; face < MAXFACES; face++)
    for (cube = 0; cube < MAXCUBES; cube++) {
      new->skewb.cube_loc[face][cube].face = face;
      new->skewb.cube_loc[face][cube].rotation = STRT - MAXORIENT;
    }
  new->skewb.started = FALSE;
  new->skewb.randomized = FALSE;
}

void read_diagonal(w, face, corner, orient, size)
SkewbWidget w;
int face, corner, orient, size;
{
  int g;

  if (size == MINOR)
    w->skewb.minor_loc[orient] = w->skewb.cube_loc[face][corner];
  else /* size == MAJOR */
  {
    for (g = 1; g < MAXORIENT; g++)
      w->skewb.major_loc[orient][g - 1] =
        w->skewb.cube_loc[face][(corner + g) % MAXORIENT];
    w->skewb.major_loc[orient][MAXORIENT - 1] =
      w->skewb.cube_loc[face][MAXORIENT];
  }
}

void rotate_diagonal(w, rotate, orient, size)
SkewbWidget w;
int rotate, orient, size;
{
  int g;

  if (size == MINOR)
    w->skewb.minor_loc[orient].rotation =
      (w->skewb.minor_loc[orient].rotation + rotate) % MAXORIENT;
  else /* size == MAJOR */
    for (g = 0; g < MAXORIENT; g++)
      w->skewb.major_loc[orient][g].rotation =
        (w->skewb.major_loc[orient][g].rotation + rotate) % MAXORIENT;
}

int check_solved(w)
SkewbWidget w;
{
  int face, cube;
  SkewbLoc test;

  for (face = 0; face < MAXFACES; face++)
    for (cube = 0; cube < MAXCUBES; cube++)
    {
      if (cube == 0)
      {
        test.face =
          w->skewb.cube_loc[face][cube].face;
        test.rotation =
          w->skewb.cube_loc[face][cube].rotation;
      }
      else if (test.face != /*face*/
               w->skewb.cube_loc[face][cube].face ||
               (w->skewb.orient && test.rotation != /*STRT - MAXORIENT*/
                w->skewb.cube_loc[face][cube].rotation))
          return FALSE;
    }
  return TRUE;
}

#ifdef DEBUG

void print_cube(w)
SkewbWidget w;
{
  int face, cube;

  for (face = 0; face < MAXFACES; face++) {
    for (cube = 0; cube < MAXCUBES; cube++)
      printf("%d %d  ", w->skewb.cube_loc[face][cube].face,
             w->skewb.cube_loc[face][cube].rotation);
    printf("\n");
  }
  printf("\n");
}

#endif
