/*
# X-BASED SKEWB
#
#  SkewbP.h
#
###
#
#  Copyright (c) 1994		David Albert Bagley, bagleyd@source.asset.com
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Skewb */
#ifndef _SkewbP_h
#define _SkewbP_h

#include "Skewb.h"

/*** random generator ***/
#if	defined(HAS_48)		/* Use lrand48() and srand48() */
#define	LRAND()		lrand48()
#define	SRAND(X)	srand48((long) (X))
extern long     lrand48(
#if	NeedFunctionPrototypes
    void
#endif
);
#else
#if	defined(HAS_RANDOM)	/* Use random() and srandom() */
#define	LRAND()		random()
#define	SRAND(X)	srandom((unsigned int) (X))
extern long     random(
#if	NeedFunctionPrototypes
    void
#endif
);
#else				/* Use rand() and srand() */
#define	LRAND()		((long) rand())
#define	SRAND(X)	srand(X)
#endif
#endif
#define NRAND(X)	((int)(LRAND()%(X)))

#define IGNORE (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define MAXORIENT 4
#define MAXROTATE 3
#define MAXCUBES (MAXORIENT+1)
#define MINOR 0
#define MAJOR 1

/* The following is in xskewb.c also */
#define MAXFACES 6

#define MIN(a,b) (((a)<(b))?(a):(b))
#define MAX(a,b) (((a)>(b))?(a):(b))

typedef struct _SkewbLoc
{
  int face, rotation;
} SkewbLoc;

typedef struct _SkewbPart
{
  Pixel foreground;
  Pixel face_color[MAXFACES];
  SkewbLoc cube_loc[MAXFACES][MAXCUBES];
  SkewbLoc minor_loc[MAXORIENT], major_loc[MAXORIENT][MAXORIENT];
  int started, randomized;
  int practice, mode, orient, vertical, mono;
  int depth;
  int face, cube, direction;
  Position delta;
  Position orient_line_length;
  Position puzzle_width, puzzle_height;
  XPoint puzzle_offset, letter_offset;
  GC puzzle_GC;
  GC face_GC[MAXFACES];
  GC inverse_GC;
  String face_name[MAXFACES];
  XtCallbackList select;
} SkewbPart;

typedef struct _SkewbRec
{
  CorePart core;
  SkewbPart skewb;
} SkewbRec;

/* This gets around C's inability to do inheritance */
typedef struct _SkewbClassPart
{
  int ignore;
} SkewbClassPart;

typedef struct _SkewbClassRec
{
  CoreClassPart core_class;
  SkewbClassPart skewb_class;
} SkewbClassRec;

typedef struct _RowNext
{
  int face, direction, side_face;
} RowNext;

extern SkewbClassRec skewbClassRec;

extern void quit_skewb();
extern void reset_polyhedrons();
/* rc : row or column */
extern void read_diagonal();
extern void rotate_diagonal();
extern int check_solved();

#ifdef DEBUG
extern void print_cube();
#endif

#endif /* _SkewbP_h */
