/* image.h : image display routines
**
** Written and Copyright (C) 1994 by Michael J. Gourlay
**
** NO WARRANTEES, EXPRESS OR IMPLIED.
*/

#ifndef _IMAGE_H__INCLUDED_
#define _IMAGE_H__INCLUDED_

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#ifndef UCHAR
#define UCHAR unsigned char
#endif

#define OPAQUE 255

typedef struct rgba_image_ {
  int nrows;
  int ncols;
  int compressed;
  int pixel_size;
  int color_mapped;
  int type;
  UCHAR *ri;
  UCHAR *gi;
  UCHAR *bi;
  UCHAR *ai;
} rgba_image_t;

#define NUM_ORIG_IMAGES 2
extern rgba_image_t orig_image[];

extern void reset_images(int type);

extern int load_img(char *fn, rgba_image_t *imgP);

extern int save_img(char *fn, rgba_image_t *si, rgba_image_t *di, double t);

extern void dither_image(Visual *visual, rgba_image_t *srcP, rgba_image_t *dstP, double t, double brite, XImage *ximage);

extern int make_test_image(rgba_image_t *imgP, int type);

#endif
