< c bldtab.f                                 6-28-90   D. Kerr" c     subroutine called by smplx.f c & c     builds primal simplex tableau on c        constraint matrix A, 7 c        relationship vector of constrainta to rhs, rel  c        rhs vector, bA c        non-negativity constraints on original variables, nonneg  c < c   first, each constraint is checked to see that b(i) >= 0;A c          if not, the constraint is multiplied by -1 as is rel() 9 c   then, each unrestricted variable is "replaced" by two C c         non-negative variables whose difference will be the value B c         of the original variable.  the 1st has the same cost and> c         constraint coefficients as the original, the 2nd has@ c         the negatives of the cost and constraint coefficients.E c         the 2nd variable is put in the next unoccupied columns in A ( c         ie, starting in column NVar+1.F c   then, the constraint matrix is examined column by column to see ifA c         there is a potential basic variable in the constraints: @ c         if a column has 1 non-zero element > 0 then the column4 c         corresponds to a potential basic variable.C c   then, <= constraints are handled:  slack variable added in next ! c         unoccupied column of A. @ c         >= constraints get a slack and an artificial variable.3 c         = constraints get an artificial variable. F c         artificial variables are placed in the rightmost columns of C c         the tableau A.  This allows easy determination of whether ? c         a variable is artificial and allows the smplx code to > c         truncate iterations on the tableau in phase 2 at the& c         artificial variable columns. c K c   the program returns the completed tableau A, the basic variable vector, D c         the count of artificial variables and "doubled" variables,E c         and the total number of columns in the completed tableau, N  c H c ********************************************************************** c 6       subroutine bldtab( NVar, M, c, A, rel, b, nonneg1      &                 , basic, artct, dblct, N )  c ;       dimension c( NVar*2+M*2 ), A( M, NVar*2+M*2 ), b( M ) 0       logical*1 rel( M ), nonneg( NVar ), needBV7 c arrays for storing ids of basic & non-basic variables $       integer basic( M ), NVar, M, N9       integer*2 dblct, slackct, artct, BVcnt, NZcnt, BVid #      &      , icolumn, idbl, artidx       &      , i, j, k  c  c  initialize arrays       do 10 i = 1, M         basic(i) = 0  10   continue       dblct = 0        slackct = 0        artct = 0 # c  build tableau for primal simplex  c - c     force all rhs values to be non-negative        do 40 i = 1, M!         if ( b( i ) .lt. 0 ) then            do 30 j = 1, NVar "             A( i, j ) = -A( i, j )  30       continue           rel( i ) = -rel( i )           b( i ) = -b( i )         end if  40     continue c        do 50 j = 1, NVar 3         if ( nonneg( j ) .ne. 1 ) dblct = dblct + 1    50  continue c        do 60 i = 1, M c 3 c  ******** depends on -1 and 1 evaluating to true: K c           there will be one slack variable for each inequality constraint  c +         if ( rel(i) ) slackct = slackct + 1  c 9 c           there will be an artificial variable for each $ c           ">=" and "=" constraints c .         if ( rel(i) .ge. 0 ) artct = artct + 1   60  continue c H c ********************************************************************** c 2 c    see if any column has a single non-zero value' c    if so, it can be a basic variable!  c 2 c                BVcnt is count of basic variables/ c                j counts columns, i count rows        BVcnt = 0        j = 1    70  continue5 c               loop until j or BVcnt exceed limit... 
         i = 1 > c              NZcnt  is count of non-zero entries in column j         NZcnt = 0    80    continue3         if (( i .le. M ).and.( NZcnt .lt. 2 )) then &           if ( A( i, j ) .ne. 0 ) then             NZcnt = NZcnt + 1              BVid = i           end if           i = i + 1          else           go to 90         end if         go to 80 c    90    continue"         if (( NZcnt .eq. 1 ) .and.E      &     (( A( BVid, j ) .gt. 0 ) .or. ( b( BVid ) .eq. 0 )) ) then 
 c  found one! H           if (( A( BVid, j ) .lt. 0 ) .and. ( rel( BVid ) .ne. 0 )) then&             rel( BVid ) = -rel( BVid )           end if           basic( BVid ) = j            BVcnt = BVcnt + 1 )           if ( A( BVid, j ) .ne. 1 ) then "             Abvidj = A( BVid, j )              do 100 i = 1, NVar2               A( BVid, i ) = A( BVid, i ) / Abvidj   100       continue*             b( BVid ) = b( BVid ) / Abvidj           end if         end if         j = j + 1 @       if (( j .le. NVar + dblct ).and.( BVcnt .lt. M )) go to 70 c B c  have now found all basic variables within original constraints;- c  need that many fewer artificial variables!        artct = artct - BVcnt #       if ( artct .lt. 0 ) artct = 0  c H c ********************************************************************** c @ c compute total number of variables, N = # of columns in tableau c (       N = NVar + dblct + slackct + artct c  c   TablWidth = N  c  c  build out tableau: ; c    handle unrestricted variables by substituting for each 4 c           such variable two non-negative variables6 c           whose difference is the original variable.J c           corresponding to the added variable ( was 1, now 2 = added 1 )A c           add a column of copied coefficients, reversed in sign I c           to both the tableau and the cost (objective function) vector. C c      ==>  position the added variables in the column(s) just past G c           the original coefficient columns - ie, start at col NVar+1.  c > c     idbl  counts "doubled" variables as they are encountered c        do 130 i = 1, M          idbl = 0         do 120 j = 1, NVar; c              nonneg(*) = 1 => variable * must be nonneg;  8 c                          0 => variable * unrestricted.(           if ( nonneg( j ) .eq. 0 ) THEN             idbl = idbl+1 -             A( i, NVar + idbl ) = - A( i, j )            end if  120    continue  130  continue c        idbl = 0       do 135 j = 1, NVar&         if ( nonneg( j ) .eq. 0 ) THEN           idbl = idbl+1 #           c( NVar+idbl ) = - c( j )          end if  135  continue c = c    Build out tableau past doubled (unrestricted) variables.  c  c    Slack Variables.  c        icolumn = NVar + idbl        do 160 i = 1, M "         if ( rel(i) .eq. -1 ) then           icolumn = icolumn + 1            A( i, icolumn ) = 1 7 c                                  zero out rest of row !           do 140 j = icolumn+1, N              A( i, j ) = 0   140      continue: c                                  zero out rest of column$           do 150 k = i+1, M                      A( k, icolumn ) = 0   150      continue@           if (( BVcnt .le. M ) .and. ( basic( i ) .eq. 0 )) then              basic( i ) = icolumn             BVcnt = BVcnt + 1            end if         end if  160  continue c 9 c            icolumn stores last-filled column of tableau  c > c    Artificial Variables.      rel(*) = 1 =>  ">=" constraint> c                                      = 0 =>  " =" constraint c @ c     artidx is first column for artificial variables in tableau c %       artidx = NVar + dblct + slackct        do 200 i = 1, M !         if ( rel(i) .eq. 1 ) then 1 c                                  slack variable            icolumn = icolumn + 1            A( i, icolumn ) = -18 c                                       zero rest of row#           do 170 j = icolumn + 1, N              A( i, j ) = 0   170      continue; c                                       zero rest of column            do 180 j = i+1, M              A( j, icolumn ) = 0   180      continueA c                  if a basic variable was discovered in original E c                  constraints, might not need this artificial var...  c ?           needBV = (( BVcnt .lt. M ) .and. ( basic(i) .eq. 0 ))            if ( needBV ) thenE c                               position art. var. past last possiblee1 c                               slack variable...u             artidx = artidx + 1              A( i, artidx ) = 1             basic( i ) = artidxs             BVcnt = BVcnt + 1r5 c                                 zero rest of columni             do 190 j = i+1, M                 A( j, artidx ) = 0  190        continue           end if         end if  200  continue cy       do 230 i = 1, Mh@         if (( rel(i) .eq. 0 ) .and. ( basic(i) .eq. 0 )) then   E c                               position art. var. past last possiblet1 c                               slack variable...d             artidx = artidx + 1t             A( i, artidx ) = 1             basic( i ) = artidxs             BVcnt = BVcnt + 1 3 c                                  zero rest of rowi!           do 210 j = icolumn+1, Nr             A( i, j ) = 0   210      continue6 c                                  zero rest of column           do 220 j = i+1, Mv             A( j, artidx ) = 0  220      continue
         endife  230  continue c        return	       endo