#include "xbill.h"
#include "widgets.h"

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Text.h>

extern menutype menu;
extern Pixmap logo;
Widget pausebutton;

Widget CreateMenuBar(char *name, Widget parent, menutype menu) {
	int i, j;
	Widget menubar, temp;
	menubar = XmCreateMenuBar(parent, name, NULL, 0);
	XtManageChild(menubar);
	for (j=0; j<menu.size; j++) {
		temp = XtCreateManagedWidget(menu.submenu[j].name,
			xmCascadeButtonWidgetClass, menubar, NULL, 0);
		menu.submenu[j].pulldown = XmCreatePulldownMenu(menubar,
			"submenu", NULL, 0);
		XtVaSetValues (temp, XmNsubMenuId, menu.submenu[j].pulldown, NULL);
		for (i=0; i<menu.submenu[j].size; i++) {
			temp = XtCreateManagedWidget(
				menu.submenu[j].button[i].name,
				xmPushButtonWidgetClass,
				menu.submenu[j].pulldown, NULL, 0);
			if (!strcmp(menu.submenu[j].button[i].name, "Pause game"))
				pausebutton=temp;
			XtAddCallback (temp, XmNactivateCallback,
				menu.submenu[j].button[i].callback,
				menu.submenu[j].button[i].arg);
			if (i != menu.submenu[j].size-1)
				XtCreateManagedWidget("sep",
					xmSeparatorGadgetClass,
					menu.submenu[j].pulldown, NULL, 0);
		}
	}
	return menubar;
}

Widget CreatePixmapBox(char *name, Widget parent, Pixmap pixmap,
	char *text)
{
	Arg wargs[2];
	Widget dialog, base;
	XmString mstr;
DPRINTF ("start create pixmap box\n");
	dialog = XmCreateMessageDialog(parent, name, NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);

	base = CreateRowCol("", dialog);

	XtSetArg(wargs[0], XmNlabelType, XmPIXMAP);
	XtSetArg(wargs[1], XmNlabelPixmap, logo);
	XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 2);
DPRINTF ("make a logo pixmap\n");

	CreateSep ("bar", base);
DPRINTF ("make a sep\n");

	XtSetArg(wargs[0], XmNlabelType, XmPIXMAP);
	XtSetArg(wargs[1], XmNlabelPixmap, pixmap);
	XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 2);
DPRINTF ("make a pixmap\n");

	if (text) {
		mstr=XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
		XtSetArg(wargs[0], XmNlabelString, mstr);
		XtCreateManagedWidget("", xmLabelWidgetClass, base, wargs, 1);
		XmStringFree(mstr);
DPRINTF ("make a text label\n");
	}

	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(XtParent(dialog), XtNpopdownCallback, (XtCallbackProc) popdown, NULL);
	return dialog;
}

void warp_apply (Widget w, Widget text, XtPointer client_data) {
	char *str;
	int i;
	str = XmTextGetString(text);
	i=atoi(str);
	XtFree(str);
	warp_to_level(i);
}

void enter_name (Widget w, Widget text, XtPointer client_data) {
	char *str;
	str = XmTextGetString(text);
	if (!strcmp(str,"")) strcpy(str, "Anonymous");
	str[20] = 0;  /* truncate string if too long */
	recalc_high_scores(str);
	XtFree(str);
}

Widget CreateEnterText
	(char *name, Widget parent, int buttonmask, char *text, XtCallbackProc callback)
{
	Widget dialog;
	XmString mstr;
	dialog = XmCreatePromptDialog(parent, name, NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);
	mstr=XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog, XmNselectionLabelString, mstr, NULL);
	if (!(buttonmask&OK))
		XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	if (!(buttonmask&CANCEL))
		XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	XtAddCallback(dialog, XmNokCallback, callback,
		XmSelectionBoxGetChild(dialog, XmDIALOG_TEXT));
	XtAddCallback(XtParent(dialog), XtNpopdownCallback, popdown, NULL);
	return dialog;
}

Widget CreateDialog (char *name, Widget parent, int buttonmask, Pixmap icon,
	char *text, char *buttonlabel, XtCallbackProc callback)
{
	Widget dialog;
	XmString mstr;
	dialog = XmCreateMessageDialog(parent, name, NULL, 0);
	XtVaSetValues(dialog, XmNdialogStyle, XmDIALOG_APPLICATION_MODAL, NULL);
	if (!(buttonmask&OK))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON));
	if (!(buttonmask&CANCEL))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
	if (!(buttonmask&(OK|CANCEL)))
		XtUnmanageChild(XmMessageBoxGetChild(dialog, XmDIALOG_SEPARATOR));
	if (buttonlabel) {
		mstr=XmStringCreateLtoR(buttonlabel, XmSTRING_DEFAULT_CHARSET);
		XtVaSetValues(XmMessageBoxGetChild(dialog, XmDIALOG_OK_BUTTON),
			XmNlabelString, mstr, NULL);
		XmStringFree(mstr);
	}
	if (icon) XtVaSetValues(dialog, XmNsymbolPixmap, icon, NULL);
	if (callback) XtAddCallback(dialog, XmNokCallback, callback, NULL);
	mstr = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(dialog, XmNmessageString, mstr, NULL);
	XmStringFree(mstr);
	XtAddCallback(XtParent(dialog), XtNpopdownCallback, popdown, NULL);
	return dialog;
}

Widget CreateDrawingArea(char *name, Widget parent, int width, int height) {
	Widget area;
        area = XtCreateManagedWidget(name, xmDrawingAreaWidgetClass, parent, NULL, 0);
	XtVaSetValues(area, XtNwidth, width, XtNheight, height, XmNresizePolicy, FALSE, XtNbackground, WhitePixelOfScreen(XtScreen(area)), NULL);
	return area;
}

void update_high_scores(Widget highscorebox, scorelist scores[10]) {
	char str[1000], temp[40];
	int i, j;
	strcpy (str,"               High Scores:          \n\n");
	strcat (str, "Name                     Level     Score\n");
	for (i=0; i<10; i++) {
		strcat (str, scores[i].name);
		for (j=strlen(scores[i].name); j<25; j++) strcat (str, " ");
		sprintf (temp, "%5d   %7d\n", scores[i].level, scores[i].score);
		strcat (str, temp);
	}
	print_to_widget(XmMessageBoxGetChild(highscorebox, XmDIALOG_MESSAGE_LABEL), str);
}

void update_scorebox(Widget scorebox, int level, int score) {
	char str[40];
	sprintf (str, "After Level %d:\nYour score: %d", level, score);
	print_to_widget(XmMessageBoxGetChild(scorebox, XmDIALOG_MESSAGE_LABEL), str);
}


void print_to_widget(Widget w, char *str) {
	XmString mstr = XmStringCreateLtoR(str, XmSTRING_DEFAULT_CHARSET);
	XtVaSetValues(w, XmNlabelString, mstr, NULL);
	XmStringFree(mstr);
}

Widget CreateLabel(char *name, Widget parent) {
        return XtCreateManagedWidget(name, xmLabelWidgetClass, parent, NULL, 0);
}

Widget CreateSep(char *name, Widget parent) {
        return XtCreateManagedWidget(name, xmSeparatorWidgetClass, parent, NULL, 0);
}

Widget CreateRowCol(char *name, Widget parent) {
        return XtCreateManagedWidget(name, xmRowColumnWidgetClass, parent, NULL, 0);
}

