 #pragma module DQDRIVER "X-49"   #ifdef DEBUG  G #define TRACING (16384*4)	/* Size of buffer or undefine this if none */ T #define TRACE_DATA_TOO		/* If you'd like all the data register read/writes logged */\ #define TRACE_PIO_READ_DATA_TOO /* If you'd like PIO mode read data from the drive logged */Y //#define TRACE_PIO_WRITE_DATA_TOO /* If you'd like PIO write data to the drive logged */ 6 #define TRACE_PER_DRIVE		/* Per-drive trace buffers */I //#define TRACE_COMMON		/* One global trace buffer for all four drives */ A //#define BREAKPOINTS		/* Include or exclude BREAK breakpoints */ F //#define EXTRA_STATS		/* Include or exclude extra stats in RDSTATS */   #endif  J /*************************************************************************J  *                                                                       *J  * Copyright 1994-2003 Compaq Computer Corporation                       *J  *                                                                       *J  * COMPAQ Registered in U.S. Patent and Trademark Office.                *J  *                                                                       *J  * Confidential computer software. Valid license from Compaq or          *J  * authorized sublicensor required for possession, use or copying.       *J  * Consistent with FAR 12.211 and 12.212, Commercial Computer Software,  *J  * Computer Software Documentation, and Technical Data for Commercial    *J  * Items are licensed to the U.S. Government under vendor's standard     *J  * commercial license.                                                   *J  *                                                                       *J  * Compaq shall not be liable for technical or editorial errors or       *J  * omissions contained herein. The information in this document is       *J  * subject to change without notice.                                     *J  *                                                                       *K  *************************************************************************/   J /************************************************************************/
 /*									*/  /* Facility:								*/  /*      IDE Disk Driver							*/
 /*									*/  /* Abstract:								*/A /*      This driver controls a standard IDE/ATA/EIDE r/w disk		*/ . /*        or an ATAPI CD-/DVD-ROM drive.				*/
 /*									*/  /* Author:								*// /*      Benjamin J. Thomas III / May 1994				*/ 
 /*									*/ . /* Original dedication from Ben Thomas:					*/
 /*									*/ J /* My brother-in-law and nephew were killed in a small plane crash just	*/D /* off Nantucket island, on June 6, 1994, shortly after I started	*/E /* writing this driver.  This effort is dedicated to the memory of	*/ F /* of Reginald Marden and Christopher Marden.  They will be missed.	*/
 /*									*/ 
 /*									*/  /* Revision History:							*/  /*									*/     4 /*	X-49	Hoff	    Stephen Hoffman		    22-Sep-2003 */J /*              IO$_DIAGNOSE now returns an actual condition status, no */J /*              longer slamming SS$_NORMAL.  (This could cause programs */J /*              with latent errors around IO$_DIAGNOSE calls to appear  */J /*              to start failing.  The code had been silently failing.) */
 /*									*/ 4 /*	X-48	WCC	    William Clemence		    23-Aug-2003 */< /*		Fix IOST byte count. We didn't fill in the upper byte	*/> /*		count so requests over 65535 bytes returned bad values.	*/1 /*		Thank you Mark Hopkins for finding this. 		*/ 
 /*									*/ 4 /*	X-47	WCC	    William Clemence		    21-Aug-2003 */9 /*		While doing CDrecord commands some of the commands	*/ ; /*		can take several minutes to complete. Cdrecord calls	*/ ) /*		us with a timeout time passed in			*/ < /*		'ucb->diagnose_disconnect_timeout'.   Use it only if 	*/: /*		it is greater than our TIMEOUT_TIME. Track timeout 	*/; /*		times in the UCB 'ucb$l_int_max_wait'. For direction	*/ ; /*		checking in atapi_packet_command we didn't check for	*/ ; /*		0xAA(write_12) command.  The ACER chip setup for the	*/ 7 /*		fifo threshold was programmed wrong. Enhance the	*/ , /*		trace function code to work better.			*/0 /*		The above fixes corrects PTR 75-83-1280.		*/: /*		There was a bug if the user requested more than 120	*/; /*		blocks of data. In the read_atapi_2K_seg when we got	*/ 9 /*		an non-aligned 2k segment or not a full 2k segment	*/ ; /*		we would read at least a 2k or and extra 2k segment 	*/ : /*		to handle the offset. This would incorrectly count 	*/6 /*		against our next logical block and byte count.		*/< /*		The fix is to save the requested block count so that 	*/< /*		we pass up the correct amount of blocks read and the 	*/; /*		upper level can correctly handle the proper transfer	*/  /*		block count.						*/: /*		With the fix above we are now able to increase the 	*/6 /*		UCB$L_MAXBCNT to a larger value for CD drives.		*/8 /*		We won't today, we need to do a lot more testing,	*/7 /*		but we will fill in the UCB$L_MAXBCNT to a real 	*/ : /*		value on all other drives as opposed to the default	*/  /*		0 meaning 127 blocks.					*/< /*		Removed the "disable ignorecallval" from the compile.	*/7 /*		Those compile errors have been fixed for several	*/  /*		releases.						*/  /*									*/     7 /*	X-46	SGS0265	    Steve Skonetski		    23-Jun-2003 */ > /*		Force pio mode if io$_diagnose and not CMD649.          */ /*									*/     4 /*	X-45	PJR228	    Paul J Rivera		    19-May-2003 */> /*		The conditionalized statement for i2000 did not check   */9 /*		for legacy mode addressing.  Thus, it would affect	*/   /*		native mode adapters.					*/ /*									*/     4 /*	X-44	PJR227	    Paul J Rivera		    29-Apr-2003 */> /*		1. Implement Legacy Mode Addressing for IDE controllers	*/: /*		that does not fill the PCI BAR like the Intel PIIXE	*/> /*		Conditionalize for Alpha where all CMD649 is a PRIMARY  */< /*		2. Implement a work-around because ioc$kp_reqchan is 	*/, /*		not returning correct error status.			*/> /*		3. Add wait_ready on *_seg_pio because we need to check */8 /*		for RDY bit before requesting/sending the next IO	*/ /*		segment.						*/K /*                                                                      */	 4 /*	X-43	PJR221	    Paul J Rivera		    21-Apr-2003 */> /*		Add support for RX2600/ZX2000 IDE chip by removing DMA  */0 /*		support until SG works for I64 systems.			*/ /*								        */7 /*	X-42	RAB056	    Robert A. Brooks		    27-Mar-2003 */ ) /*		Remove all traces of QIOserver.				*/ 
 /*									*/ 3 /*	X-41	PJR185	    Paul Rivera			    03-Mar-2003 */ > /*		a) Remove IA_64 workaround for shifting the REG_ALT_STS */> /*		register, instead, modify the base status register to   */ /*		0x374.							*/ > /*		b) Change disk geometry calculation and add get_geom(). */> /*		This will optimize geometry calculation of the device   */& /*		especially IDE hard drives.				*/ K /*                                                                      */  3 /*	X-40	PJR170	    Paul Rivera			    10-Jan-2003 */ 3 /*		a) Disable DMA in PIIXE controller for IA64		*/ ; /*		b) Wait for DRVRDY bit on read_seg_pio() before each	*/  /*		IO transfer.						*/
 /*									*/ 3 /*	X-39	PJR169	    Paul Rivera			    09-Jan-2003 */ ! /*		IA64 Specific changes:					*/ 4 /*		a) Put a shift for ALT_DRV_STS bit in inp().		*/: /*		b) Remove PTE$M_ASM for IA-64 in map_user_buffer().	*/8 /*		c) Remove workaround when calling ioc$initiate().	*/7 /*		d) Conditionalize statements for ALPHA and IA64		*/ 
 /*									*/ 3 /*	X-38	PJR166	    Paul Rivera			    06-Jan-2003 */  /*		IA-64 Debug						*/ > /*		a) Add a workaround not to call ioc$initiate when VMSD1 */ /*		is not set.						*/ > /*		b) Driver is rigged to poll mode to workaround SAPIC.   */ /*									*/ J /*      X-37    PJR077      Paul Rivera                     04-Nov-2002 */J /*              Change in REGDUMP which would check if it is a CMD649   */J /*              before accessing the PIO registers.  PTR 75-83-436      */J /*                                                                      */J /*      X-36    JFA         Juan Astorga                    22-Oct-2002 */4 /*            - Delete useless QIOSERVER code.				*/J /*                                                                      */J /*      X-35    PJR         Paul Rivera                     28-Jun-2002 */; /*		DMA does not work in CMD649 because the driver could	*/ > /*		not access legacy PIO registers when DMA is active.    	*/+ /*		This check-in solves that problem.			*/ 7 /*		Added support for acknowledging DMA interrupts.		*/ , /*		Added DMA support for IO$_DIAGNOSE.			*// /*		- Added more DMA register definitions.			*/ J /*              - Set the DMA Control Timing on CMD649.                 */1 /*		- Added dq_dma_wfikpch to process dma io.		*/ : /*		- Changes in isr() to clear dma pending interrupts.	*/< /*		- Changes in read_ata_seg_dma, write_ata_seg_dma, and	*/0 /*		    packet_command when calling wfikpch.		*/8 /*		- Moved the setting of DMA_INACTIVE bit after the	*/$ /*		    completion of wfikpch.				*/; /*		- In fetch_drive_info, set l_unsolicited_int to zero	*/ 9 /*		    to make sure that an IDENTIFY message is sent.	*/ : /*		- Changes in packet_command and diagnose to support	*/. /*		    IO$_DIAGNOSE DMA read and writes.			*/
 /*									*/ J /*      X-34    PJR         Paul Rivera                     08-Jul-2002 */J /*              - Disable DMA for CMD649 because it is causing register */J /*                timing issues caused by inaccesible registers during  */J /*                a DMA transfer.       PTR 75-66-1296                  */J /*              - Set the error status asc=0x21 to SS$_VOLINV instead   */J /*                of SS$_BADPARAM.                                      */J /*                                                                      */0 /*	X-33	PJR	    Paul Rivera			    28-Mar-2002 */> /*		X-32 had DATACHECK problems with BRICKS which is caused */> /*		by timing out during the transfer.  This only happens   */> /*		on a PIO write (ATA).  The solution is implement DMA,   */> /*		and getting rid of delays when transferring to/from     */# /*		the ATA or ATAPI drive					*/   
 /*									*/ 0 /*	X-32	PJR	    Paul Rivera			    27-Mar-2002 */E /*	        In move_sec_to_driver, add a wait_drq after writing the */ < /*		data instead of the kludge fix that was put it.  This	*/7 /*		solves a problem installing VMS on a DQ device.		*/ $ /*		PTR 75-66-1050, 75-66-1034				*/
 /*									*/ 3 /*	X-31	PJR063	    Paul Rivera			    29-Jan-2002	*/ ? /*	      - Add support for CMD649 based on the work by Steve	*/ > /*		Skonetski and Sue Lewis.  This change enables support   */7 /*	        for Native-mode PCI to the IDE devices.			*/ < /*	      - Renamed read to io_read and write to io_write		*/J /*            - Use wait_ready for DRQ in move_sec_to and move_sec_from */8 /*		to prevent a hang seen while testing the CMD649		*/	
 /*									*/ J /*      X-30    JFA         Juan Astorga                    14-Jan-2002 */J /*            - Delete QIOSERVER_NEW_UNIT call, obsolete.               */J /*                                                                      */3 /*	X-29	PJR057	    Paul Rivera			    11-Jan-2002 */ C /*	      - Change TIMEOUT_TIME value to 60 secs for CDRW support	*/ 
 /*									*/ 7 /*	X-28	SGS0201	    Steve Skonetski		    17-Oct-2001 */ @ /*	      - Fix readrct fdt routine to pay attention to status	*/* /*		and prevent crash. PTR 75-66-437.			*/E /*	      - check for DRQ and BSY bits to be in the correct state   */ > /*		before moving data in move_sec_from_ and _to_drive.     */
 /*									*/ 5 /*	x-27	SGS0198   Steve Skonetski		    08-Oct-2001	*/ > /*		Fix, 75-61-828, can't boot CD on some platforms. Failed */> /*		to set up Acer config regs 54 thru 57, the DMA/FIFO ctl */> /*		for individual devices.                                 */
 /*									*/ > /*		Remove cut-paste error from X-26 that calls set_geom()  */> /*		for ATAPI devices. Results in illegal command sent to   */> /*		ATAPI devs causing mount to take 15 seconds longer.     */J /*                                                                      */0 /*	X-26	SGS0185 Steve Skonetski			14-Feb-2001	*/> /*		Really big drives cause problems with current geometry  */> /*		calcuation. Cause divide-by-zero crashes when truncated */> /*		cylinder count is zero. Redo algorithm to use the full  */J /*              range of cyl/trk/sec that a ATA can handle.             */ /*		PTR 70-3-3939.						*/J /*                                                                      */4 /*	X-25	SGS0181		Steve Skonetski		26-Aug-2000     */> /*		Privateer Pass 2 has new Acer chip.  DMA no longer works*/> /*		and system has to be reset to recover from it.  Fix is  */J /*              to:                                                     */> /*		- select drive/head before writing DMA info             */J /*              - write DMA descriptor as a longword                    */J /*              - reset disk if ATAPI_PACKET_COMMAND WFIKPCH timeout    */
 /*									*/ > /*   	X-24	            	Sue Lewis          	10-Aug-2000     */> /*		In the previous check-in, I neglected to initialize     */: /*		a variable, which leaves cypress-based machines in 	*/ /*		deep trouble.						*/ > /*   	X-23	            	Sue Lewis          	11-Jul-2000     */& /*		Propagate from Pele:				        */7 /*		Re-do determination of CSR and DMA addresses.  		*/ > /*		This allows multiple Acer IDE adapters per system, and  */> /*		removes the restriction that every primary must have    */ /*		a secondary. 						*/ 
 /*									*/ J /*      X-22    JMB267          James M. Blue           10-Jul-2000     */J /*              Add modifications to make the driver QIOServer          */J /*              capable.  This includes adding entry point to DDT,      */J /*              a flag to DPT, a flag in DEVCHAR, masks to the FDT,     */J /*              initialization code to the unit init fork routine,      */J /*              and a helper routine.                                   */
 /*									*/ : /*   	X-21	PAJ1129  	Paul A. Jacobi	   	27-Mar-2000     */> /*		Add support for CD-ROM audio via the IO$_DIAGNOSE       */> /*		function.  Add DPT$M_SVP flags as required for          */J /*              ioc_std$movtouser()/ioc_std$movfromuser().              */J /*              Reset module IDENT to match VDE.                        */J /*                                                                      */F /*      X-24    Atlant G. Schmidt                       28-DEC-1999	*/
 /*									*/ C /*              - Modify the ATAPI "Sony bypass", similar to the	*/ I /*                removal of the bypass from the ATA/IDE code in X-14.	*/ E /*                On our fastest processors, this bypass seems to 	*/ I /*                hang the system as the driver tries to read the data	*/ D /*                with PIO while the drive tries to DMA the data.	*/C /*                This change may be problematic for Sony drives	*/ D /*                but they aren't supported by the hardware group	*/D /*                anyway and I haven't seen any Sony drives since	*/E /*                the very earliest one. They are believed to have	*/ F /*                not been working correctly with this driver for a	*/+ /*                while now, anyway.					*/ 
 /*									*/ 
 /*									*/ F /*      X-23    Atlant G. Schmidt                       27-SEP-1999	*/
 /*									*/ H /*              - What a mess! While we believe that it *IS* possible	*/E /*                to make the Cypress and the Clipper co-exist (by	*/ F /*                using buffers that are aligned to a 64KB boundary	*/G /*                in PCI space, thereby allowing a single PRDT entry	*/ E /*                to cover the entire buffer, thereby allowing the	*/ F /*                Cypress chip to work), we're concerned that there	*/G /*                may be other Cypress weirdnesses, especially given	*/ C /*                the problems shown with certain models of disk	*/ 5 /*                drives on the Eiger platform.				*/ 
 /*									*/ E /*                Therefore, we're finally following Fred K's lead	*/ G /*                and de-committing from any DMA support on Cypress.	*/ C /*                For performance reasons, this also means we're	*/ E /*                de-committing from hard-disk support on Cypress.	*/ 
 /*									*/ E /*                This change is easily made -- if we see that the	*/ I /*                controller is a Cypress, we'll clear the "Controller	*/ 6 /*                is DMA-capable" bit in the UCB.			*/
 /*									*/ H /*                Having done this, this version re-instates the X-19	*/7 /*                ("Clipper KZPAC in Hose 0") fix.			*/ 
 /*									*/ 
 /*									*/ 
 /*									*/ F /*      X-22    Atlant G. Schmidt                       01-SEP-1999	*/
 /*									*/ C /*              - The X-21 correction to the X-19 change was not	*/ A /*                completely effective. While it did cure the		*/ D /*                problem with the PRDT pointer, the Cypress chip	*/G /*                seemed to be suffering from several other problems	*/ C /*                as well. X-22 backs out both the X-19 and X-21	*/ C /*                changes, temporarily re-instating the Clipper		*/ @ /*                "KZPAC in Hose 0" bug but leaving in force		*/, /*                the X-20 build fix.					*/
 /*									*/ 
 /*									*/ 4 /*      X-21   (THIS CHANGE HAS BEEN REMOVED!)				*/
 /*									*/ F /*              Atlant G. Schmidt                       27-AUG-1999	*/
 /*									*/ C /*              - Corrects a problem introduced in X-19 whereby		*/ C /*                the Cypress chip doesn't reset its DMA pointer	*/ B /*                if the transfer is an exact multiple of 8KB.		*/
 /*									*/ D /*                This is believed to be related to the fact that	*/C /*                X-19 made the PRDT windows each 8KB in length.	*/ 
 /*									*/ D /*                The PRDT is accessed by a 32-bit pointer value.	*/C /*                At the start of a block of DMA transfers, this	*/ D /*                pointer is broadside loaded by DQDRIVER writing	*/H /*                the four bytes of the register, one byte at a time.	*/D /*                The low 16 bits of this register then increment	*/E /*                (by four) from time-to-time as PRD table entries	*/ G /*                are consumed. I'm guessing that, immediately after	*/ H /*                the counter has been incremented, a logic bug makes	*/I /*                the broadside-load fail. This leaves the PRD pointer	*/ G /*                pointing to wrong entry in the PRD table and makes	*/ E /*                our DMA target adresses that are "farther along"	*/ C /*                in the buffer than its beginning. (Reading the	*/ F /*                PRD pointer doesn't reveal the problem -- perhaps	*/D /*                there's an internal copy. Obvious hacks such as	*/F /*                reading back the bytes or writing the bytes twice	*/D /*                writing them in a different order had no effect	*/) /*                on the problem.)					*/ 
 /*									*/ F /*                The correction employed, at least for the moment,	*/C /*                is to avoid, on Cypress, transfers that are an	*/ E /*                exact multiple of 8KB in length. These transfers	*/ C /*                are instead fragmented into two transfers: one	*/ E /*                of n-1 blocks and one of 1 block. This doubtless	*/ H /*                hurts some because paging I/O tends to be multiples	*/C /*                of 8KB, but the subsequent second transfer is		*/ G /*                almost certainly satisfied out of the disk drive's	*/ D /*                cache so it shouldn't hurt as much as it might.	*/
 /*									*/ 
 /*									*/ F /*      X-20    Atlant G. Schmidt                       24-JUN-1999	*/
 /*									*/ C /*              - Corrects a problem building in the V71R stream	*/ G /*                (where the EV6'ish symbol IOC$K_BYTE isn't defined	*/ D /*                and that I/O subfunction doesn't yet exist). We	*/D /*                now do the byte-laning ourselves (as in the EV4	*/> /*                through EV56 worlds). We also define the		*/C /*                IOC$K_BYTE_LANED symbol ourselves if it isn't		*/ ? /*                already defined (which it isn't in V71R).		*/ 
 /*									*/ 
 /*									*/ F /*      X-19    Atlant G. Schmidt                       07-JUN-1999	*/
 /*									*/ B /*              - Corrects the problem whereby the PRDT didn't		*/C /*                handle the situation when the transfer buffer		*/ D /*                (xfer_buffer) spanned more than one 64KB region	*/F /*                of PCI-bus address space. This typically occurred	*/D /*                when a Clipper had a KZPAC in Hose 0; the KZPAC	*/C /*                could allocate some map registers ahead of us,	*/ H /*                forcing our map registers out of natural alignment.	*/
 /*									*/ 
 /*									*/ F /*      X-18    Atlant G. Schmidt                       29-APR-1999	*/
 /*									*/ C /*              - Allow the SFF-8038 DMA registers to be located	*/ A /*                anywhere within a 32MB I/O space. (For some		*/ I /*                reason, when there's no video card in some machines,	*/ G /*                the Console assigns these registers at *VERY* high	*/ % /*                addresses.)						*/ G /*              - Cleans up a few warnings from DECC /WARN=ENAB=ALL.	*/ C /*              - Removes any reading of the register at offset		*/ C /*                0x3F7/0x377 -- this register really belongs to	*/ F /*                the Floppy Disk controller. Just for convenience,	*/D /*                we don't remove the CRAM or the UCB CRAM vector	*/H /*                entries so that all that stuff doesn't shift around	*/$ /*                yet again.						*/) /*              - Tracing changes:					*/ E /*                  o When compiled with NEVER defined, traces the	*/ D /*                    initial state of all IDE registers whenever	*/E /*                    each drive does a PACKACK (or half-packack).	*/ C /*                  o Traces the call to ioc$kp_reqchan because		*/ H /*                    this is often the point where the trace changes	*/5 /*                    from one drive to another.			*/ 
 /*									*/ 
 /*									*/ F /*      X-17    Atlant G. Schmidt                       18-MAR-1999	*/
 /*									*/ A /*              This is the version released into V7.1-2R for		*/ 6 /*                the Clipper/Brick hardware kit.			*/
 /*									*/ F /*              - Ignores the REL bit in the ATAPI Interrupt Reason	*/H /*                register. For some reason, when we operate multiple	*/D /*                drive simultaneously, we're seeing that bit set	*/G /*                even though we don't set OVL in the ATAPI Features	*/ # /*                register.						*/ D /*              - Fixes a problem whereby ATA drives operating in	*/3 /*                PIO mode could miss errors.				*/ C /*              - Fixes a problem introduced sometime around the	*/ D /*                addition of DMA whereby ATAPI devices that used	*/F /*                2Kbyte sectors transfer only 1/4 as much data per	*/E /*                transfer as they should (owing to a 2048- versus	*/ 0 /*                512-byte miscalculation.				*/G /*              - Includes a work-around to a UCB corruption problem	*/ E /*                discovered by Dave Carlson during Brick testing.	*/ G /*                This exhibited itself as VBNMAPFAIL bugchecks when	*/ G /*                running QVET while booted from an IDE system disk.	*/ F /*                The problem may or may not be within DQDRIVER but	*/4 /*                the workaround is effective.				*/C /*              - Allows configuration of all odd-lettered units	*/ E /*                (DQAn:, DQCn:, DQEn:, etc.) as using the Primary	*/ C /*                IDE bus while all even-lettered units (DQBn:,		*/ C /*                DQDn:, DQFn:, etc.) use the Secondary IDE bus.	*/ E /*                This change may someday help resolve the problem	*/ H /*                of redundant DQan: names in a SCSI cluster (because	*/G /*                the second system could configure DQCn: and DQDn:,	*/ E /*                the thrid system DQEn: and DQFn:, and so forth.)	*/ E /*              - Changes the tracing to optionally allow a single	*/ < /*                trace log shared among the four units.		*/D /*              - Changes the tracing to allow STARTIO to capture	*/J /*                the IRP address, the passed-in LBA, and the passed-   */E /*                in bytecount info and also all four words of the	*/ 1 /*                IOSB eventually returned.				*/ 
 /*									*/ 
 /*									*/ F /*      X-16    Atlant G. Schmidt                       15-MAR-1999	*/
 /*									*/ F /*              - Adds "volatile" to the counter in the Brick delay	*/@ /*                kludge so that the kludge will survive the		*/0 /*                compiler's optimization.				*/D /*              - Updates the register cheat sheet, corrects some	*/E /*                typos regarding the DMA registers, and re-orders	*/ < /*                REGDUMP's saving of the DMA registers.		*/
 /*									*/ 
 /*									*/ F /*      X-15    Atlant G. Schmidt                       04-FEB-1999	*/
 /*									*/ I /*              - Introduces formal support for IDE (ATA) hard drives.	*/ E /*                While this support has been latent in the driver	*/ G /*                all along (and was the only point of the driver in	*/ D /*                X-1 and X-2), only ATAPI drives were officially	*/I /*                supported since X-3. This restriction is now lifted.	*/ C /*              - Adds half-DMA. This version will DMA into our		*/ C /*                transfer buffer with us still using the CPU to	*/ H /*                move data between the user and our transfer buffer.	*/B /*              - Unfortunately, this means we've now got some		*/C /*                code that's controller-chip-dependent. It may		*/ G /*                also mean that we can only execute on PCIbus-based	*/ H /*                controllers; although I've tried to allow continued	*/G /*                ISA bus operation, I have no ISA bus test platform	*/ C /*                into which to stick my DTC2280 interface card.	*/ D /*              - Removes a limitation with IDE (ATA) hard drives	*/F /*                larger than ~8.4GB. From Day 1, we were depending	*/F /*                on calculating IDE (ATA) hard drive capacity from	*/B /*                the Cylinder/Head/Sector (C/H/S) information		*/D /*                returned by the drive. Unfortunately, this tops	*/C /*                out at 8.455GB. Now, we look at the total LBN		*/ C /*                information returned by the drive and use that	*/ I /*                if it's non-zero and the C/H/S info seems to suggest	*/ F /*                0x3FFF cylinders, 16 heads, and 63 sectors. (Unix	*/I /*                experienced problems with an old drive that reported	*/ C /*                the total LBN information, but with the words		*/ C /*                swapped! Hopefully, our check will avoid that		*/ # /*                problem.)						*/ I /*              - Consolidates all the very-similar WFIKPCH paragraphs	*/ F /*                into a single routine and which now allows all of	*/C /*                the callers to handle unsolicited interrupts.		*/ I /*              - Corrects the declaration of ucb$xxx_iohandle so that	*/ G /*                its storage doesn't overlap ucb$l_unsolicited_int.	*/ E /*                This bug, while latent in previous versions, had	*/ H /*                no effects before the centralized interrupt-handler	*/4 /*                was added in this baselevel.				*/F /*              - Hacks around a problem found very late in testing	*/E /*                whereby ATAPI drives that are sharing a bus with	*/ G /*                a DQ-controlled system disk don't seem to have the	*/ H /*                expected ATAPI signature in them. (Probably someone	*/G /*                before us has munched the signature already. Pre-)	*/ G /*                viously, this problem ws mostly-masked by the fact	*/ E /*                that such a drive was never auto-configured, but	*/ I /*                Fred K's new SYS$ICBM.EXE will reveal this problem.)	*/ G /*                We probably ought to re-init the drive, but that's	*/ F /*                too risky a change to make just before submitting	*/F /*                the driver so I'm going to just bypass the ready-	*/H /*                test in this one instance. (The drives are known to	*/5 /*                operate correctly henceforth.)			*/ G /*              - Always builds the same UCB whether TRACING or not,	*/ J /*                but marks the UCB distinctively if we're not tracing.	*/E /*              - The formerly-disjoint TRACING and INIBRK schemes	*/ J /*                were rationalized and merged into one unified scheme.	*/E /*              - Introduces one more supportable hard drive (from	*/ G /*                Fujitsu, a vendor we haven't seeen before) and one	*/ B /*                more supportable CD-ROM drive (from Hitachi,		*/D /*                another vendor we haven't seen before), and one	*/6 /*                more supportable DVD-ROM drive.			*/
 /*									*/ 
 /*									*/ F /*      X-14    Atlant G. Schmidt                       14-JAN-1999	*/
 /*									*/ F /*              - Fixes a bug introduced by the X-13 change whereby	*/G /*                certain drives (such as the most-recent WDC Caviar	*/ F /*                drives) are slow to de-assert DRQ when you've fed	*/H /*                them a sector of write data. They keep DRQ asserted	*/J /*                for a microsecond or two and we were mis-interpreting	*/I /*                that as the signal to bypass the wait-for-interrupt.	*/ H /*                This was causing all sorts of trouble in the drive.	*/J /*                By comparison, the Quantum drives seem to immediately	*/A /*                remove DRQ and didn't provoke this problem.		*/ F /*              - Kludges a problem whereby the Brick processor was	*/G /*                apparently able to over-run the DATA register upon	*/ H /*                writing to the drive. Rather than just losing data,	*/G /*                this seemed to provoke some metastable behavior in	*/ E /*                the ALT_STS register of both the Quantum and WDC	*/ F /*                drives, causing them to occasionally show 0xFF as	*/D /*                their status. The kludge fix adds a small delay	*/< /*                after each write in MOVE_SEC_TO_DRIVE.		*/E /*              - Introduces several more supportable hard drives.	*/ @ /*              - Introduces support for the DS-10 platform.		*/
 /*									*/ 
 /*									*/ F /*      X-13    Atlant G. Schmidt                       05-JAN-1999	*/
 /*									*/ A /*              This is the version released into V7.1-2R for		*/ + /*                Blizzard Update 2.					*/ 
 /*									*/ G /*              - Fixes an apparent Day-1 bug whereby a fast IDE/ATA	*/ C /*                drive can beat the loop around to the WFIKPCH,	*/ C /*                generating an apparently unsolicited interrupt	*/ E /*                and a subsequent WFIKPCH timeout. This condition	*/ E /*                is analagous to the situation already handled by	*/ D /*                the ATAPI loop. This problem was detected using	*/< /*                the latest WDC 36400 6.4GB IDE drive.			*/
 /*									*/ 
 /*									*/ F /*      X-12    Atlant G. Schmidt                       23-DEC-1998	*/C /*              - Forks before calling EXE$KP_RESTART. This fix		*/ C /*                was developed by Stephen Shirron to correct a		*/ E /*                Day-1 problem which manifested itself as Clipper	*/ A /*                multiprocessors hanging during installation		*/ / /*                from the V7.1-2 CD-ROM.				*/ H /*              - Adds init-time code to correctly identify the drive	*/E /*                type, removing the confusing "Generic SCSI disk"	*/ E /*                appelation. This is done by using the logic that	*/ E /*                used to pass the IO$_PACKACK for system disks to	*/ B /*                now pass IO$_SENSECHAR for non-system disks.		*/F /*                STARTIO now dispatches this function to the half-	*/C /*                packack logic that's been latent in the driver	*/DG /*                for several versions now. Also, the devtype string	*/eG /*                is pre-loaded to "Generic IDE/ATAPI disk" prior to	*/a* /*                doing any sizing.					*/F /*              - Upon failing to get basic information from a unit	*/H /*                during PACKACK or SENSECHAR, we now set its devtype	*/= /*                string to "Nonexistent IDE/ATAPI disk".		*/	F /*              - Corrected an apparent typo in the ATA reset logic	*/H /*                which looks like it would have prevented recovering	*/8 /*                from an attempt to reset a drive.			*/G /*              - The words of the ATAPI packet are now written with	*/*F /*                a separate outw_t routine that always traces even	*/7 /*                if TRACE_DATA_TOO isn't defined.			*/ H /*              - We now trace the storing of the sense_key, asc, and	*/D /*                ascq. This makes it easier to read traces where	*/C /*                TRACE_DATA_TOO is turned off but the drive has	*/ 7 /*                passed us a sense code or three.			*/ G /*              - The old ucb$l_read_cmd and ucb$l_write_cmd fields,	*/lG /*                which were mostly unused, are now entirely unused.	*/fF /*                We're going to do DMA commands in a different way	*/C /*                than Ben had apparently originally envisioned.	*/m
 /*									*/e
 /*									*/rF /*      X-11    Atlant G. Schmidt                       04-DEC-1998	*/G /*              - Re-ordered a few routines in the source so related	*/ 5 /*                routines are closer together.				*/ F /*              - Splits the read/write_atapi_segment routines into	*/F /*                separate routines for 512-byte-sector devices and	*/F /*                2Kbyte-sector devices. This allows easier support	*/3 /*                of multi-block ATAPI reads.				*/*G /*              - Re-introduces ATA transfers larger than 1 512-byte	*/ D /*                block (backs out the X-2 change). This required	*/E /*                correcting a day-1 bug with regard to taking the	*/*E /*                device lock for each sector transferred and also	*/iC /*                correcting an X-10-introduced bug whereby our		*/hB /*                transfer buffer offset was no longer getting		*/D /*                updated after each sector transferred. This bug	*/A /*                was introduced when I took out the level of		*/*J /*                indirection in the params to move_sec_to/from_drive.  */E /*                This change appears to *DOUBLE* the PIO transfer	*/o0 /*                rate of ATA disk drives.				*/F /*              - Introduces ATAPI transfers larger than 1 512-byte	*/I /*                block for 512-byte sector devices (such as the Zip).	*/ H /*                This change appears to improve the transfer rate of	*/B /*                the Zip drive (which is PIO only, so this is		*/1 /*                important!) by about 15%.				*/ F /*              - Introduces ATAPI transfers larger than 1 512-byte	*/G /*                block for 2Kbyte sector devices (such as CD-ROMs).	*/oE /*                This change appears to ??? the PIO transfer rate	*/ - /*                of a typical CD-ROM.					*/	F /*              - wait_ready no longer depends on wait_busy for the	*/C /*                usual case where the drive is actually ready.		*/qC /*              - I now set a ucb$l_media_id of DQ|IDE50 so that	*/pC /*                MSCP will be willingto serve my disks across a	*/ " /*                cluster.						*/D /*              - I now set the DEV$M_NLT bit in DEVCHAR2 so that	*/A /*                $INITIALIZE and ANALYZE/DISK won't look for		*/ C /*                bad block info in the last track. This should		*/t1 /*                fix my own PTR 75-3-2500.				*/MD /*              - Introduces some of the underpinnings to support	*/G /*                DMA. At least for the moment, the register mapping	*/ D /*                window is increased to 64Kbytes to allow access	*/. /*                to the DMA registers.					*/
 /*									*/u
 /*									*/wF /*      X-10    Atlant G. Schmidt                       04-DEC-1998	*/
 /*									*/ A /*              This is the version released into V7.1-2R for		*/r+ /*                Blizzard Update 1.					*/a
 /*									*/n/ /*              - Adds Iomega Zip support				*/ < /*              - As part of adding Zip support, adds an		*/B /*                write_atapi_segment routine to match up with		*/= /*                the existing write_ata_segment routine.		*/t> /*              - As part of adding Zip support, moved the		*/H /*                interrupt-acknowledging RD_STS (almost) exclusively	*/F /*                to the ISR. It probably should have been this way	*/& /*                since Day 1.						*/I /*              - Corrects a customer-reported bug whereby ATAPI discs	*/dH /*                that had a maximum LBN of 0x...1FF were sized 0x100	*/A /*                2k blocks (1024 512-byte blocks) too small.		*//H /*              - Corrects a possible buglette whereby an ATAPI drive	*/H /*                could have told us to transfer an invalid amount of	*/I /*                data and possibly cause us to over-run our allocated	*/vI /*                buffer. The lower-level routines probably would have	*/tG /*                prevented damage, but it's nicer to catch it early	*/a5 /*                and flag the error explicitly.			*/ H /*              - Adds a full tracing facility that can be condition-	*/5 /*                ally compiled into the driver.			*/	D /*              - Takes out a level of indirection in passing the	*/I /*                buffer_adx parameter to both move_sec_to/from_drive.	*/ D /*              - Splits the DEBUG feature into its four separate	*/7 /*                components for easier selection.			*/aB /*              - Standardizes a lot of comments and automatic		*/< /*                variable names among similar routines.		*/
 /*									*/h
 /*									*/ F /*      X-9     Atlant G. Schmidt                       18-NOV-1998	*/
 /*									*/ E /*              This is the version released into V7.1-2 and V7.2.	*/J
 /*									*/ H /*              - Fix a Day-1 bug whereby the memory that we allocate	*/F /*                to build our system disk PACKACK IRP wasn't being	*/F /*                cleared (initialized). Sometimes, this led to the	*/? /*                IRP$V_FAST_FINISH bit (and others?) being		*/*F /*                inadvertently set. This led to IOC_STD$REQCOM not	*/B /*                cleaning up after us and thereby leaving our		*/C /*                UCB$V_BSY bit set. This led to subsequent I/Os	*/CC /*                assuming we were already busy and thereby not		*/ E /*                calling our STARTIO entry point. This (finally!)	*/rJ /*                led to the system hanging trying to load SYSINIT.EXE.	*/: /*                Now we memset the memory to zeroes.			*/
 /*									*/*
 /*									*/AF /*      X-8     Atlant G. Schmidt                       13-OCT-1998	*/7 /*              - Fixed-up the build instructions.			*/	B /*              - Adds symbols for many items, removing "magic		*/" /*                numbers"						*/E /*              - Corrects a bug whereby, during packack, a second	*/SG /*                command could be issued to a drive while the first	*/nC /*                command was still executing. This caused many		*/IB /*                very odd flaky effects including most of the		*/B /*                faiures originally blamed on the TEAC drive.		*/E /*                This fix also fixes an interrupt-timeout problem	*/eB /*                the Panasonic SR-8583 DVD-ROM drive and some		*/B /*                intermittent errors with all Toshiba drives.		*/B /*              - Adds support for the Compaq/Panasonic SR8583		*/" /*                DVD-ROM.						*/B /*              - Substantially modifies and extends my INIBRK		*/* /*                debugging scheme.					*/
 /*									*/ 
 /*									*/6F /*      X-7     Atlant G. Schmidt                       08-OCT-1998	*/> /*              - Changes the device timeout to 15 seconds		*/F /*                to accommodate the Toshiba XM-6302B CD-ROM drive.	*/
 /*									*/a
 /*									*/ F /*      X-6     Atlant G. Schmidt                       11-JUN-1998	*/> /*              - Corrects the problem Goldrush was having		*/E /*                autoconfiguring the DQDRIVER. The "hack" that we	*/dF /*                grew from the original Ben Thomas code proved too	*/E /*                clever for its long-term good. Now the code only	*/*D /*                accepts autoconfiguration or a manual, explicit	*/- /*                ISA bus I/O address.					*/ 
 /*									*/*
 /*									*/iF /*      X-5     Atlant G. Schmidt                       01-JUN-1998	*/F /*              - Correct two compile-time diagnostics newly issued	*/' /*                by DECC V5.7.						*/I
 /*									*/e
 /*									*/ F /*      X-4     Atlant G. Schmidt                       27-MAY-1998	*/J /*              - Supply "F11" as the default ACP prefix at DDB$L_ACPD.	*/E /*                This wasn't necessary for Files-11 ODS2 support,	*/ C /*                but *IS* necessary for ISO-9660 (F11CACP) and		*/45 /*                High Sierra (F11DACP) support.			*/2
 /*									*/ 
 /*									*/lF /*      X-3     Atlant G. Schmidt                       30-SEP-1997	*/
 /*									*/sI /*              This is the version released as the V7.1-1H2 SHIP kit.	*/ 
 /*									*/25 /*              - Add ATAPI (IDE CD-ROM) support			*/ 
 /*									*/ 
 /*									*/nF /*      X-2     CMF378          C M Fariz               19-Feb-1996	*/J /*              Update the driver with the necessary changes for 64bits.*/
 /*									*/ I /*              TEMPORARILY change the driver so that it writes only 1	*/oF /*              sector at a time.  This is to work-around a problem	*// /*              discovered in 3PB testing				*/(
 /*									*/t
 /*									*/tD /*      X-1     Benjamin J. Thomas III                  May, 1994	*/' /*              Initial version.					*/ 
 /*									*/ 
 /*									*/ J /************************************************************************/     q3 /* Miscellaneous tidbits (from Ben, 'way back when)e  *A  *   o Always check the BUSY bit.  If set, none of the other bitsaD  *     can be fully trusted.  If clear, it's ok to believe the other"  *     bits and to issue commands.  *A  *   o Make sure the correct drive is selected before any action. A  *     This means checking the BUSY bit for clear, then selectingpA  *     the desired driver, then checking BUSY again for clear for D  *     that drive.  Note that VMS allows a channel concept, and thisD  *     driver obtains ownership of the channel.  Therefore, we don'tA  *     have to be quite so paranoid about ownership changes.  Get*A  *     the channel, then get ownership...release the channel whenJ  *     all done.  *>  *   o It's mandatory to keep the sector count to 256 or fewer?  *     sectors because that's the biggest value you can express @  *     in the byte-size SSEC_CNT register. And even then, do you9  *     trust all drives to interpret 0x00 as 256?  [AGS].p  *@  *   o It's a good idea to keep sector count under 128.  This isC  *     just a caution against drives that may not handle the numbersC  *     as unsigned. [Well, it's probably a doubly-good idea becausekA  *     the ATAPI byte-count is restricted to 65,536 (or 65,535 ifm6  *     you're a Zip drive) and 128*512=65,536! -- AGS]  *C  *   o Read ALT_STS for the status bits unless the direct intent isi#  *     also to clear the interrupt.l  *@  *   o Read/Write multiple commands don't seem to work very wellC  *     all the time.  Based on advice, those commands seem aimed at D  *     treating the disk as if it had a different sector size.  ThisA  *     driver uses the simple read/write commands.  This means an C  *     interrupt per sector, which can't be avoided.  A DMA version @  *     could possibly help this (someday).  For now, read/writesC  *     will be done with the simple commands, and not exceeding 127*.  *     blocks at a time (see previous bullet).  *  *%  * Basic ATA (IDE) transfer algorithme  *,  *   1) Use ALT_STATUS to check for BUSY = 07  *                      Error -> RESET, then retry once   *   2) Select the proper drive 4  *   3) Check ALT_STATUS again, for BUSY=0, DRDY = 19  *                      Error -> RESET, retry from step 1   *   4) Write the CSRs  *   5) Write the command	  *   6) Wait for interrupt;  *                      Timeout -> RESET, retry from step 3n,  *   7) Read STATUS (which clears interrupt)&  *   8) Transfer data is DRQ=1, BUSY=0F  *                      Error ->  DRQ=0 -> goto step 9 (ERR should =1)9  *                      BUSY=1-> RESET, retry from step 3r7  *   9) Check that STATUS (saved from step 7) has ERR=0*-  *                      Error -> handle errorA8  *  10) If not done, goto step 6 (multisector transfers)4  *      If done, goto step 3 (next command/transfer)  *  * A write would modify as:e  **  *  5a) Check ALT_STATUS for BUSY=0, DRQ=1  *  5b) Send all of the data  *   8) Remove step 8	  *                          * Powerup algorithm  *?  *   1) Poll ALT_STATUS for up to 40 seconds for BUSY=0, DRDY=1e&  *                      Error -> Fatal  *   2) Select drive 0*  *   3) Read ALT_STATUS for BUSY=0, DRDY=1&  *                      Error -> Fatal  *   4) Drive 0 exists  *   5) Select drive 1*  *   6) Read ALT_STATUS for BUSY=0, DRDY=1H  *                      Error->BUSY=1 fatal master/slave incompatability*  *                      DRDY=0  no drive 1  *   7) drive 1 exists  *  *  */a     h /* Basic Build instructions:  * =========================  *  * $ COMPILE_IT:#  * $  CC /STANDARD=RELAXED_ANSI89 - '  *      /INSTRUCTION=NOFLOATING_POINT -o  *      /EXTERN=STRICT -M  *      /DEFINE=(BASEALIGN_SUPPORT)                           ! Not debugging I  *      /DEBUG /NOOPTIMIZE /DEFINE=(DEBUG,BASEALIGN_SUPPORT)  ! Debugging   *      'CC_OPT' -  *      /LIS='LISFILE' -  *      /MACHINE_CODE -   *      /OBJ='OBJFILE' -4  *      'SRCFILE'+SYS$LIBRARY:SYS$LIB_C.TLB /LIBRARY  * $
  * $ LINK_IT:o  * $  GOSUB WRITE_OPTFILE   * $  LINK /ALPHA -   *         /USERLIB=PROC -  *         /NATIVE_ONLY -   *         /BPAGE=14 -  *         /SECTION -   *         /REPLACE -   *         /NODEMAND_ZERO -t  *         /NOTRACEBACK -   *         /SYSEXE -  *         /NOSYSSHR -9  *         /SHARE='EXEFILE' -              ! Driver imagee>  *         /DSF='DSFFILE' -                ! Debug symbol file9  *         /SYMBOL='STBFILE' -             ! Symbol tabler8  *         /MAP='MAPFILE' /FULL /CROSS -   ! Map listing@  *         'OPTFILE' /OPTIONS              ! Linker options file  * $
  * $ FINI:
  * $  EXIT 01   * $  * $  * $ WRITE_OPTFILE: "  * $  OPEN/WRITE OPTIONS 'OPTFILE'*  * $  WRITE OPTIONS "SYMBOL_TABLE=GLOBALS"  * $  WRITE OPTIONS ""R  * $  WRITE OPTIONS "CLUSTER=VMSDRIVER,,, -    ! Cluster_name, base_address, pfc,"B  * $  WRITE OPTIONS "      ", OBJFILE, ", -    ! Now filenames..."i  * $  WRITE OPTIONS "!     USER$DISK1:[]SYSLOA                         /INCLUDE=(KPRINTF)        /LIB, -"oi  * $  WRITE OPTIONS "      SYS$LIBRARY:VMS$VOLATILE_PRIVATE_INTERFACES /INCLUDE=(BUGCHECK_CODES) /LIB, -" m  * $  WRITE OPTIONS "      SYS$LIBRARY:STARLET                         /INCLUDE=(SYS$DRIVER_INIT,SYS$DOINIT)"   * $  WRITE OPTIONS ""O  * $  WRITE OPTIONS "COLLECT=NONPAGED_EXECUTE_PSECTS   /ATTRIBUTES=RESIDENT, -"e   * $  WRITE OPTIONS "    $CODE$"  * $  WRITE OPTIONS ""O  * $  WRITE OPTIONS "COLLECT=NONPAGED_READWRITE_PSECTS /ATTRIBUTES=RESIDENT, -"t#  * $  WRITE OPTIONS "    $PLIT$, -" &  * $  WRITE OPTIONS "    $INITIAL$, -"%  * $  WRITE OPTIONS "    $GLOBAL$, -" "  * $  WRITE OPTIONS "    $OWN$, -",  * $  WRITE OPTIONS "    $$$105_PROLOGUE, -"(  * $  WRITE OPTIONS "    $$$110_DATA, -"+  * $  WRITE OPTIONS "    $$$115_LINKAGE, -"i"  * $  WRITE OPTIONS "    $BSS$, -"#  * $  WRITE OPTIONS "    $DATA$, -"f#  * $  WRITE OPTIONS "    $LINK$, -"*&  * $  WRITE OPTIONS "    $LITERAL$, -"$  * $  WRITE OPTIONS "    $READONLY$"  * $  WRITE OPTIONS ""Z  * $  WRITE OPTIONS "COLLECT=INITIALIZATION_PSECTS     /ATTRIBUTES=INITIALIZATION_CODE, -"*  * $  WRITE OPTIONS "    EXEC$INIT_000, -"*  * $  WRITE OPTIONS "    EXEC$INIT_001, -"*  * $  WRITE OPTIONS "    EXEC$INIT_002, -"+  * $  WRITE OPTIONS "    EXEC$INIT_CODE, -"r.  * $  WRITE OPTIONS "    EXEC$INIT_LINKAGE, -"0  * $  WRITE OPTIONS "    EXEC$INIT_SSTBL_000, -"0  * $  WRITE OPTIONS "    EXEC$INIT_SSTBL_001, -"-  * $  WRITE OPTIONS "    EXEC$INIT_SSTBL_002""  * $  WRITE OPTIONS ""+  * $  WRITE OPTIONS "PSECT_ATTR=$LINK$,WRT" .  * $  WRITE OPTIONS "PSECT_ATTR=$INITIAL$,WRT":  * $  WRITE OPTIONS "PSECT_ATTR=$LITERAL$,NOPIC,NOSHR,WRT";  * $  WRITE OPTIONS "PSECT_ATTR=$READONLY$,NOPIC,NOSHR,WRT"o6  * $  WRITE OPTIONS "PSECT_ATTR=$$$105_PROLOGUE,NOPIC"2  * $  WRITE OPTIONS "PSECT_ATTR=$$$110_DATA,NOPIC"3  * $  WRITE OPTIONS "PSECT_ATTR=$$$115_LINKAGE,WRT"o5  * $  WRITE OPTIONS "PSECT_ATTR=EXEC$INIT_CODE,NOSHR".  * $  WRITE OPTIONS ""  * $  WRITE OPTIONS ""  * $  CLOSE OPTIONS,  * $  RETURN  *  */n     l /* Usage Instructions:  * ===================  *?  * This driver was originally written as an IDE/ATA-only driver	?  * and was tested with a $19 ISA IDE controller plugged into an @  * ISA bus. Since that time, it was extensively modified to also?  * operate ATAPI drives and to use the built-in IDE controllers*=  * in several low-end systems. In either environment, someone*B  * (VMS or the user) needs to make sure that everything is set up.  *E  * For the system supported directly by VMS, this is easy. We include*@  * an appropriate paragraph in [SYSEXE]SYS$CONFIG.DAT. This willA  * cause recognition of the PCI-to-ISA bridge chip and the driver 5  * will be automatically loaded and units configured.h  *A  * For other systems where we don't explicitly support the drivertA  * (such as the Digital AlphaStation 400 4/233), you must run theoC  * ENABLE-IDE progam (from the Freeware CD) to enable the IDE port.hA  * This port will use IRQ 14 and is on the ISA bus.  You may need @  * to run the console's ISACFG utility to reserve IRQ 14 for the@  * device.  For a separate ISA board, there is no need to do any  * special hardware setup.  *  *)  * A sample ISACFG line, might look like:   *R  * >>>isacfg -mk -slot 3 -dev 0 -iobase 1f0 -irq0 14 -etyp 1 -enadev 1 -handle IDE  *  *1  * To load the driver, use the following command:   *  *   $ MCR SYSMANr!  *     SYSMAN> IO CONNECT DQA0: -s)  *                 /DRIVER=SYS$DQDRIVER -s  *                 /CSR=%X1F0 -   *                 /ADAPTER=x -h  *                 /VECTOR=y -  *                 /NODE=n  *&  * This command assumes (or requires):  *A  *   CSR is %X1F0, this is the standard address for a primary IDE/  *+  *   VECTOR is usually 56 (IRQ=14, 14*4=56)t  *;  *   ADAPTER is the TR Number of the bus adapter that hostsrC  *     the controller, usually found using $ MCR SYSMAN IO SHOW BUS "  *     or SDA> CLUE CONFIGURATION.  *>  *   NODE is the slot number into which the board was plugged.  *  *  */i            t" /* Supported and/or tested devices  *<  * So far, this driver is known to have been recently tested  * with the following devices:  *  * Magnetic disk drives:  *1  *   Conner CP-3024          (Ancient 20MB drive) A  *   Conner CP-2084          (Old 85MB 2-1/2" drive, aka RED11-E) 5  *   Fujitsu MPD3108AT       (Very recent 10GB drive) 1  *   Quantum ProDrive LPS52A (Ancient 52MB drive) Q  *   Quantum LP240A          (Old 245MB drive, aka RE24L-E, like ProDrive LPS240)h4  *   Quantum Fireball 1080A  (Recent 1.090 GB drive)8  *   Quantum Fireball SE8.4A (Very Recent 8.455GB drive)6  *   Quantum Fireball SE6.4A (Very Recent 6.4GB drive)6  *   Quantum Fireball SE4.3A (Very Recent 4.3GB drive)1  *   WDC Caviar 2850         (Recent 833MB drive)s5  *   WDC Caviar 31200        (Recent 1.xGB drive) (1)n1  *   WDC Caviar 21600        (Recent 1.6GB drive)*1  *   WDC Caviar 24300        (Recent 4.3GB drive)s1  *   WDC Caviar 33200        (Recent 3.2GB drive)d:  *   WDC Caviar 36400        (Very Recent 6.4GB drive) (2)  *  *  * CD-ROM drives:s  *D  *   Compaq CR-588     (32x CD-ROM OEM'ed from Panasonic/Matsushita)>  *   Compaq CRD-8322B  (32x CD-ROM OEM'ed from Lucky/Goldstar))  *   Hitachi CDR-8435  (32x CD-ROM) (3,4)*#  *   Sony CDU711       (32x CD-ROM)c)  *   TEAC CD-532E      (32x CD-ROM) (3,5) #  *   Toshiba XM-5702B  (12x CD-ROM)n*  *   Toshiba XM-6102B  (12x-to-24x CD-ROM)#  *   Toshiba XM-6202B  (32x CD-ROM) '  *   Toshiba XM-6302B  (32x CD-ROM) (6)PD  *   Toshiba XM-6402B  (32x CD-ROM rebranded as a "Compaq XM-6402B")  *  *  * DVD-ROM drives:  *O  *   Compaq SR-8583    (as a ?? CD-ROM drive, OEM'ed from Panasonic/Matsushita),2  *   Toshiba SD-M1102  (as a 24x CD-ROM drive) (7)-  *   Toshiba SD-M1212  (as a ?? CD-ROM drive)	  *  *  * ATAPI Read/Write drives:   *0  *   Iomega ZIP 100    100 MB diskette drive (8)  *  *	  * Notes:   *E  *   (1) This WDC Caviar drive eventually experienced data corruption C  *       on writes. The drive also failed PC-based diagnostics so IeB  *       assume a genuine hardware failure occurred; the drive wasC  *       returned to the vendor for exchange and a different, more- #  *       recent model was returned.   *C  *   (2) This WDC Caviar drive was observed to be slow to de-assert ?  *       DRQ after you've fed it the 0x200 bytes of write data.*=  *       Because of this, you can't use DRQ .AND. NOT_BUSY to*=  *       bypass the WFIKPTCH the way we do for CD-ROM drives.e  *H  *   (3) The Hitachi and TEAC CD-ROM drives contain a green activity LED/  *       rather than the more-usual orange LED.u  *G  *   (4) The Hitachi CD-ROM drive doesn't contain any front-panel audio 7  *       output (earphone) connector or volume control.n  *B  *   (5) Due to electrical considerations on the IDE bus regardingA  *       pull-up and pull-down resistors, the TEAC CD532-E CD-ROMaA  *       drive causes problems in multi-drive configurations. The E  *       drive is believed to be unsupported by hardware engineering.   *B  *   (6) One sample (out of three) of this Toshiba XM-6302B CD-ROME  *       drive was getting random positioning errors and was returned E  *       to Storage Engineering (along with the failing CD-ROM disc);	F  *       this sample of this drive is no longer available for testing.  *A  *   (7) My one sample of this Toshiba SD-M1102 DVD-ROM drive has	E  *       since suffered a hardware failure and is no longer availablea  *       for testing.   *E  *   (8) The version of the Zip drive that was tested succesfully was J  *       labled as Iomega "P/N 270928-003" (beige bezel) or the apparentlyJ  *       electrically-similar "P/N 270928-703" (with a white bezel). These@  *       were "Oprah 2" mechanisms and contained V12.A firmware.  *F  *       Another version labled as Digital "P/N PCXRJ-AG, Rev 001" wasE  *       also tested but experienced *VERY OCCASIONAL* timeout errors F  *       that were recovered on retries within the driver. This drive,C  *       on the other hand, appears about one third faster than the F  *       Iomega-labled drive when running the "ALIGN" buffer-alignmentM  *       stress test. This was an "Oprah" drive and contained V23.D firmware.u  *I  *      "Bought-off-the-street" generic Iomega Zip drives were not testednG  *       but we believe they track the revs of the Iomega-branded part.N  *  */u       /* Caveats:   *F  * This driver was written from the X3T9.2 specs, which may or may notC  * accurately reflect working drives. The driver has been tested on C  * a few different IDE drives, but the following are known items tol  * watch out for:o  *=  *   o The driver ran into a lot of weird problems supporting:;  *     DMA on the Cypress chips (documented in the revisionh:  *     history). For this reason, DMA is only supported on  *     the Acer chips.  *<  *   o Driver has been used only with 16 bit data interfaces  *.  * I'm sure that there are others - good luck.  *  *G  * One obvious place for improvement is the copying of data to and fromoE  * the transfer buffer.  It would be better to move the data directlyhF  * to/from the user buffer, but there were some reasons that I didn't.F  * First, it's just plain a pain to get it right.  You have to accountC  * for the alignment issues;  this is no good if you are constantlyrC  * taking alignment faults or if you are constantly loading/mergingsC  * data.  Secondly, you need to always empty/fill the disk's buffercE  * and that means handling non-sector-sized counts.  Overall, not tooeE  * hard, but a pain. Finally, the SFF-8038i spec simply isn't capable G  * of handling buffers that aren't at least word-aligned, so we'd often %  * end up copying data around anyway.e  *  *  */h      . /* Registers - Here's my register cheat sheet.  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+tL  * |  7  |  6  |  5  |  4  ||  3  |  2  |  1  |  0  |   Pri ISA Adx   SYMBOLJ  * +-----+-----+-----+-----++-----+-----+-----+-----+   [CRAM idx]    Name  *P  * +-----+-----+-----+-DSC/++-----+-----+-----+-----+   [00]    Alternate StatusK  * | BSY | DRDY| DWF | SVC || DRQ |CORR | IDX | ERR |   3F6 R   REG_ALT_STS15  * |-----+-----+-----+-----++-----+-----+-----+-----|rK  * |  x  |   x |  x  |  x  ||  1  | SRST| nIEN|  0  |   3F6 W   REG_DEV_CTLoN  * +-----+-----+-----+-----++-----+-----+-----+-----+   [01]    Device control  *  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+ L  * | HiZ | nWTG| nHS3| nHS2|| nHS1| nHS0| nDS1| nDS0|   3F7 R   REG_DRV_ADDRM  * +-----+-----+-----+-----++-----+-----+-----+-----+   [02/03] Drive addressoK  *                                                      (Belongs to FDC!!!)n  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+sH  * |                                                |   1F0 RW  REG_DATAN  * +-----+-----+-----+-----++-----+-----+-----+-----+   [04/05] Data (16 bits)  *  *E  * +-----+-----+-----+-----++-----+-----+-----+-----+   [06]    ErrorbI  * | BBK | UNC | MC  | IDNF|| MCR |ABRT |TK0NF|AMNF |   1F1 R   REG_ERRORn5  * +-----+-----+-----+-----++-----+-----+-----+-----+IL  * |                                                |   1F1 W   REG_FEATURESH  * +-----+-----+-----+-----++-----+-----+-----+-----+   [07]    Features  *  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+ K  * |                                                |   1F2 RW  REG_SEC_CNTaL  * +-----+-----+-----+-----++-----+-----+-----+-----+   [08/09] Sector countF  * |                              | RLS | I/O | CoD |           Reason5  * +-----+-----+-----+-----++-----+-----+-----+-----+h  *K  * +-----+-----+-----+-----++-----+-----+-----+-----+           (REG_LBA_0)tJ  * |                                                |   1F3 RW  REG_SECTORM  * +-----+-----+-----+-----++-----+-----+-----+-----+   [0A/0B] Sector number*K  *                                                              (or LBA0-7)   *K  * +-----+-----+-----+-----++-----+-----+-----+-----+           (REG_LBA_8) J  * |                                                |   1F4 RW  REG_CYL_LOL  * +-----+-----+-----+-----++-----+-----+-----+-----+   [0C/0D] Cylinder lowL  *                                                              (or LBA8-15)  *L  * +-----+-----+-----+-----++-----+-----+-----+-----+           (REG_LBA_16)J  * |                                                |   1F5 RW  REG_CYL_HIM  * +-----+-----+-----+-----++-----+-----+-----+-----+   [0E/0F] Cylinder high M  *                                                              (or LBA16-23)   *L  * +-----+-LBA-+-----+-----++-----+-----+-----+-----+           (REG_LBA_24)J  * |  1  | MODE|  1  | DRV || HS3 | HS2 | HS1 | HS0 |   1F6 RW  REG_DRV_HDJ  * +-----+-----+-----+-----++-----+-----+-----+-----+   [10/11] Drive/headM  *                                                              (or LBA24-27)   *F  * +-----+-----+-----+-DSC/++-----+-----+-----+-----+   [12]    StatusG  * | BSY | DRDY| DWF | SVC || DRQ |CORR | IDX | ERR |   1F7 R   REG_STS.5  * +-----+-----+-----+-----++-----+-----+-----+-----+mG  * |                                                |   1F7 W   REG_CMDeG  * +-----+-----+-----+-----++-----+-----+-----+-----+   [13]    Commandi  *  */      o /* DMA Registers  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+tL  * |  7  |  6  |  5  |  4  ||  3  |  2  |  1  |  0  |   Pri ISA Adx   SYMBOLJ  * +-----+-----+-----+-----++-----+-----+-----+-----+   [CRAM idx]    Name  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+kI  * |XXXXX|XXXXX|XXXXX|XXXXX|| R/W |XXXXX|XXXXX| ACT |   nnn0 R/W  DMA_CMD R  * +-----+-----+-----+-----++-----+-----+-----+-----+   [14/15]   DMA Cmd Register@  *                                                              5  * +-----+-----+-----+-----++-----+-----+-----+-----+mI  * |  ?  |  ?  |  ?  |  ?  ||  ?  |  ?  |  ?  |  ?  |   nnn1 R/W  DMA_DS1e]  * +-----+-----+-----+-----++-----+-----+-----+-----+   [16/17]   Device-specific Register #1   *5  * +-----+-----+-----+-----++-----+-----+-----+-----+*I  * |Smplx| DRV1| DRV0|XXXXX||XXXXX| Int | Err | BSY |   nnn2 R/W  DMA_STS U  * +-Only+-DMA-+-DMA-+-----++-----+-----+-----+-----+   [18/19]   DMA Status Registero  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+ I  * |  ?  |  ?  |  ?  |  ?  ||  ?  |  ?  |  ?  |  ?  |   nnn3 R/W  DMA_DS2	]  * +-----+-----+-----+-----++-----+-----+-----+-----+   [1A/1B]   Device-specific Register #2   *G  * +-----+-----+-----+-----++-----+-----+-----+-----+             (LSB) I  * |                                    |XXXXX|XXXXX|   nnn4 R/W  DMA_AD0hU  * +-----+-----+-----+-----++-----+-----+-----+-----+   [1C/1D]   PRDT Address Byte 0n  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+ I  * |                                                |   nnn5 R/W  DMA_AD1 U  * +-----+-----+-----+-----++-----+-----+-----+-----+   [1E/1F]   PRDT Address Byte 1,  *5  * +-----+-----+-----+-----++-----+-----+-----+-----+ I  * |                                                |   nnn6 R/W  DMA_AD2eU  * +-----+-----+-----+-----++-----+-----+-----+-----+   [20/21]   PRDT Address Byte 2e  *G  * +-----+-----+-----+-----++-----+-----+-----+-----+             (MSB)hI  * |                                                |   nnn7 R/W  DMA_AD3 U  * +-----+-----+-----+-----++-----+-----+-----+-----+   [22/23]   PRDT Address Byte 3a  *  *  *4  *   +----------------------+--------------------+-+4  *   |          Base Address  [31:01]            |0|D  *   +---+------------------+--------------------+-+    A PRDT entry4  *   |EOT| ---------------- | Byte Count [15:01] |0|4  *   +---+------------------+--------------------+-+  *  *  */d     p /* IDE/ATA Basicsp  *J  * IDE ("Integrated Device Electronics" or "Integrated Drive Electronics",G  * depending on whom you ask) is a very inexpensive way to connect disksF  * drives to computers. The drive bus is, essentially, an extension ofD  * the ISA bus with more-limited functionality. This interface firstA  * made its appearance on the IBM PC-AT computer, hence its othera  * name: ATA  -- AT Attachment.K  *>  * Most modern IDE controller chips actually emit two separate@  * IDE busses known as the Primary and Secondary busses. On each<  * bus, you can connect up to two drives which are knwon forA  * historical reasons as the "Master" and "Slave" drives althoughpA  * all modern drives are completely autonomous. This leads to the0!  * following basic block diagram:*  *B  *                                        +-------+      +-------+B  *                                        |Master |      | Slave |B  *                                        | Drive |      | Drive |B  *                                        | DQA0: |      | DQA1: |B  *       +------------+                   +-------+      +-------+?  *       |            |______________________| |____________| |R?  *  -----|    Dual    |___Primary IDE Bus_____________________|e  *   PCI |    IDE     | >  *   bus | Controller |_______________________________________?  *  -----|            |___Secondary IDE Bus__   ____________  |h?  *       |            |                      | |            | | B  *       +------------+                   +-------+      +-------+B  *                                        |Master |      | Slave |B  *                                        | Drive |      | Drive |B  *                                        | DQB0: |      | DQB1: |B  *                                        +-------+      +-------+  *C  * From an "ISA" perspective, the two halves of the IDE controllers/F  * usually are completely autonomous and use separate sets of "legacy"  * addresses and IRQs:  *;  *                       |      Primary      |    Secondary A  *  ---------------------+-------------------+------------------- ?  *    IDE Address        |  0x3F6 and 0x1F0  |  0x376 and 0x170 :  *    DMA Reg Addresses  |      0x90A0       |      0x90A89  *    IRQ                |        14.        |        15.   *  *  * NOTE:  *=  *   Not all implementations "pin-out" the Secondary IDE bus.   *  */e     o /* IDE/ATA Basics (Cont'd)  *9  *  From a PCI perspective, it's a little more confusing..#  *  There are two basic approaches:e  *%  *  Shared PCI Config Space registers %  *  ---------------------------------a  *H  *  Here, the two IDE ports share one set of PCI config space registers.G  *  The Intel SIO and Acer Labs chips exemplify this school of thought.	  *F  *                                            +-------+      +-------+F  *           +------------+                   | Drive |      | Drive |F  *      -----|   ISA      |                   |Master |      | Slave |F  *     |   --|  Bridge    |                   | DQA0: |      | DQA1: |F  *     |  |  +------------+                   +-------+      +-------+C  *     |  |  |            |______________________| |____________| |wC  *   --    --|    Dual    |___Primary IDE Bus_____________________|e  *      PCI  |    IDE     | B  *      bus  | Controller |_______________________________________C  *   --    --|            |___Secondary IDE Bus__   ____________  |/C  *     |  |  |            |                      | |            | |	F  *     |  |  +------------+                   +-------+      +-------+F  *     |   --|    USB     |                   |Master |      | Slave |F  *      -----|   Bridge   |                   | Drive |      | Drive |F  *           +------------+                   | DQB0: |      | DQB1: |F  *                                            +-------+      +-------+  *  *'  *  Separate PCI Config Space registers	'  *  -----------------------------------f  *J  *  Here, the each IDE port has its own set of PCI config space registers.8  *  The Cypress chip exemplifies this school of thought.  *F  *                                            +-------+      +-------+F  *           +------------+                   | Drive |      | Drive |F  *      -----|   ISA      |                   |Master |      | Slave |F  *     |   --|  Bridge    |                   | DQA0: |      | DQA1: |F  *     |  |  +------------+                   +-------+      +-------+C  *     |   --|  Primary   |______________________| |____________| |aC  *     |   --|    IDE     |___Primary IDE Bus_____________________|   *   --   |  | Controller |   *   PCI  |  +------------+	B  *   bus  |  | Secondary  |_______________________________________C  *   --    --|    IDE     |___Secondary IDE Bus__   ____________  |sC  *     |   --| Controller |                      | |            | |tF  *     |  |  +------------+                   +-------+      +-------+F  *     |   --|    USB     |                   |Master |      | Slave |F  *      -----|   Bridge   |                   | Drive |      | Drive |F  *           +------------+                   | DQB0: |      | DQB1: |  *  */S       e /* ATAPI Basicsm  *@  * ATAPI (ATA Packet Interface) eveolved when it became apparent?  * that the limited functionality of an ATA interface would not =  * be sufficient to handle devices that were more-complicated 2  * than ordinary fixed-media magnetic disk drives.  *<  * Essentially, ATAPI allows SCSI commands to be passed over?  * the ATA bus and SCSI status to be returned over the ATA bus.	:  * It's vastly simplified SCSI, though, with no concept of;  * disconnect/reconnect, much-simplified phases, and so on.K  *  */a     c /* DISK ADDRESSING  *J  * Disk addressing in the ATA world is, umm, "less than straight-forward".  *4  * Firstly, there are two major modes of addressing:  *.  *  o CHS -- "Cylinder, Head, and Sector" mode,  *  o LBA -- "Logical Block Addressing" mode*  *  o MSF -- "Minutes:Seconds:Frames" mode  *  *A  * CHS mode is the legacy mode (from whence came the famous 528MBsB  * IDE disk-size limit). In this mode, you select the disk address*  * by loading values into three registers:  *#  *   o The 16-bit Cylinder Registerg   *   o The 8-bit Sector Register&  *   o The 4-bit Head (Track) Register  *H  * This sounds easy enough, but just to make your life more interesting,(  * the numbering scheme is a bit screwy:  *.  *   o The Cylinders are numbered from 0 to x.L  *     The identify_device command returns the number of cylinders (so x+1).  *,  *   o The Sectors are numbered from 1 to y.H  *     The identify_device command returns the number of sectors (so y).  **  *   o The Heads are numbered from 0 to z.H  *     The identify_device command returns the number of heads (so z+1).  *  *I  * And just FYI, early BIOS's were limited to 1024 cylinders [0000:03FF], H  * 63 sectors [00:3F], and 16 heads [00:0F]. This produces 1032192 total%  * blocks or 528,482,304 total bytes.a  *  *C  * LBA mode is newer and simple. The 28-bit Logical Block Number iscB  * simply parsed up into an 8-bit low portion that is then stuffedA  * into the Sector Register, a 16-bit middle portion that is theni?  * stuffed into the Cylinder Register, and a 4-bit high portion >  * that is stuffed into the Head Register. And all three parts  * are zero-based.  *  *H  * As more FYI, many recent PC BIOS are limited to a 24-bit disk addressE  * consisting of 14 bits of cylinder, 4 bits of head, and six bits ofp6  * sector. This limits disks on these BIOS's to either  *I  *   16383 (cyls) * 16 (heads) * 63 (sectors) * 512 = 8,455 million bytess  *
  *     - or -i  *N  *   16383-1024 (cyls) * 16 (heads) * 63 (sectors) * 512 = 7,927 million bytes  **  * This driver suffers from no such limit.  *  *E  * Fiinally, all CDs (SCSI or ATA) can also be addressed in an audio-	?  * relevant mode called "Minutes:Seconds:Frame" (MSF) mode. Thee  * resulting LBN is simply:   *9  *     LBN = ( ( ( Min * 60 ) + Seconds ) * 75 ) + Frames   *  */        /* CD-DA BASICSm  *>  * CD's all use the same basic physical structure, a 2352-byteC  * block ("big frame") of data. On the original CD-DA (Compact DiskeF  * Digital Audio) disks, this corresponds to 1/75 of a second of music9  * sampled at 44,100 Hz rate, 2 channels, 16-bits/sample..  *@  * So:  44,100 (samples/s) * 2 (chans/sample) * 2 (bytes/chan) =>  *                                           176,400 bytes/secA  * And: 2352 (bytes/frame) * 75 (frames/s) = 176,400 bytes/secondt  */  * This is the famous 1X CD data transfer rate.   *  *K  * Within this 2352-byte frame, there's actually a finer-grained structure.AH  * The big frame actually consists of 98 "small frames" of 24 data bytes-  * each. These small frames actually contain:n  *F  *   +------+----------+-----------+----------+-----------+----------+F  *   | Sync | Sub-chnl |   data    |   CRC    |   data    |   CRC    |F  *   | 24+3 |   14+3   | 12*(14+3) | 4*(14+3) | 12*(14+3) | 4*(14+3) |F  *   +------+----------+-----------+----------+-----------+----------+  *+  * For a total of 588 bits per small frame.   *D  * The sets of "14" bits come about through EFM -- Eight-to-FourteenG  * Modulation. To mimimize dc and high frequency content and to controlfH  * the maximum and minimum pit lengths (the dual of the frequency-domainG  * stuff), each byte is converted by a look-up table in the drive from/eG  * to a unique run of 14 bits. The sets of "3" bits then come into playeC  * in so-called "merging bits" that further minimize dc content and 8  * control minimum and maximum pit length between bytes.  *@  * The CRC bits aren't exactly a CRC but I'll describe them more  * fully in the next release.a  *<  * So 98 small frames contain 98 * (12*2) = 2352 data bytes.  *?  * The sub-channel byte is used (bitwise) to provide eight sub-o6  * channels of data called P, Q, R, S, T, U, V, and W:  *?  *   o The "P" Channel provides "Pause" information, signalling ?  *     the time interval between tracks or times when the audiol6  *     should be muted (such as computer data tracks).  *C  *   o The "Q" Channel provides most of the interesting informationhB  *     such as the lead-in and lead-out indications, track number,=  *     minutes:seconds:frames absolute and relative time, the ?  *     Universal Product Code (UPC), and International Standard   *     Record Code (ISRC).  *  */	     * /* CD-ROM STANDARDS*  *E  * The great thing about standards is that there are so many of them!   *G  * Built atop the basic CD-DA standard are a variety of CD data storage F  * standards. Basically, they all devolve down to storing data in fiveF  * types of records, all superimposed within the basic 2352-byte CD-DA	  * frame:p  *M  *    CD-DA           +-----------------------------------------------------+ M  *   "Red Book"       |     2352 data bytes, no extra error-correction      |fM  *    Audio           +-----------------------------------------------------+.  *M  *                    +------+--------+---------------+-----+-------+-------+ M  *    CD-ROM          | sync | header |   user data   | EDC | blank |  ECC  | M  *   "Yellow Book"    | 12 b |  4 b   |  2048 bytes   | 4 b |  8 b  | 276 b |TM  *    Mode-1 Data     +------+--------+---------------+-----+-------+-------+   *M  *                    +------+--------+-------------------------------------+dM  *    CD-ROM          | sync | header |    user data, no extra error-corr   | M  *   "Yellow Book"    | 12 b |  4 b   |             2336 bytes              |tM  *    Mode-2 Data     +------+--------+-------------------------------------+i  *N  *                    +------+--------+--------+---------------+-----+-------+N  *    CDROM-XA        | sync | header | subhdr |   user data   | EDC |  ECC  |N  *   "Green Book"     | 12 b |  4 b   |  8 b   |   2048 bytes  | 4 b | 276 b |N  *    Mode-2, Form 1  +------+--------+--------+---------------+-----+-------+  *N  *                    +------+--------+--------+-----------------------+-----+N  *    CDROM-XA        | sync | header | subhdr |       user data       | EDC |N  *   "Green Book"     | 12 b |  4 b   |  8 b   |       2324 bytes      | 4 b |N  *    Mode-2, Form 2  +------+--------+--------+-----------------------+-----+  *  *  *G  * The "header" field is the LBN, used for position-checking just as in   * magnetic disk drive headers.a  *D  * Green Book disks allow intermixing audio, video, and data sectorsH  * within a track. The sub-header describes which type of data is stored  * in each sector.        *0  * The EDC is the extended Error Detection Code.  *(  * The ECC is the Error Correction Code.  *  *	  * *NOTE*c  *I  *   *THIS DRIVER ONLY SUPPORTS YELLOW BOOK, MODE 1 (2048-byte) SECTORS!*x  *  */*        /* CD TRACKS, TOCs, AND SESSIONS  *@  * CDs are divided into "tracks, which are simply collections of>  * contiguous blocks. A Table-of-Contents describes the tracks6  * within a disk (or session of a multi-session disk).  *>  * Within a track, the blocks must all be of the same "color"."  * That is, they must be entirely:  *  *    o Red Book CD-DA, or  *    o Yellow-Book CD-ROM, or?  *    o Green Book (which allows mixing Audio, Video, and Data)   *  *F  * So-called "Mixed Mode" disks may store one or more tracks of CD-ROMG  * and one or more tracks of audio data. The most common way to do thismD  * is to record the CD-ROM data on Track 1 and the Audio data on all  * subsequent tracks.   *  *E  * The Table-of-Contents (TOC) is stored as Q-subcode data within the   * Lead-in track of the CD.m  *  *@  * Conceptually, an entire CD is recorded in one "session", fromE  * lead-in (and TOC) through the data tracks, through to the lead-out,D  * track. At that point, the session is "closed" and no further dataB  * can be recorded on the CD-ROM (because it won't be described in  * the already-recorded TOC).l  *@  * More-modern CD drives can read additional complete "sessions"D  * (complete with their own TOCs) beyond the first session. PhotoCDs?  * are probably the most common example of such a multi-session A  * CD(-ROM). I have never tested this driver with a multi-session C  * CD and have no idea if it works. It's quite unlikely: since eachtB  * session is, conceptually, a complete CD, we would probably needC  * to materialize additional devices to the VMS file system so thatQ,  * each session could be separately mounted.  *  */g     p1 /* Mapping 512-byte VMS blocks to 2K-byte sectors>  *@  * Because CD-ROM drives read 2Kbyte sectors, it is necessary to@  * map VMS's 512-byte blocks onto this structure. The mapping is@  * straightforward, mapping 4 VMS LBNs into each CD-ROM LBN. The?  * only interesting part is determining how many CD-ROM sectorsm!  * to read. The equation used is:T  *I  *    # of CD_ROM sectors = ( Int( VMS_blocks + VMS_LBN%4 - 1 ) / 4 ) + 1*  *A  * The diagrams below show all the interesting cases of differingAF  * VMS read lengths and VMS 512-byte block alignment within the 2Kbyte  * CD-ROM sectors.  *  *W  *                                                                                   __tX  *  Length: 0                                                                          |X  *                                                                                     |X  *  +|--------+---------+---------+---------+  Length =  0                             |X  *  ||0 1 2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _0_                            |X  *  +|--------+---------+---------+---------+            0 --> Would read 0 2K blocks  |X  *                                                                                     |X  *  +--|------+---------+---------+---------+  Length =  0                             |X  *  | 0|1 2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _1_                            |q  *  +--|------+---------+---------+---------+            1 --> Would read 1 2K block   |-  Special case all these X  *                                                                                     |X  *  +----|----+---------+---------+---------+  Length =  0                             |X  *  | 0 1|2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _2_                            |X  *  +----|----+---------+---------+---------+            2 --> Would read 1 2K block   |X  *                                                                                     |X  *  +------|--+---------+---------+---------+  Length =  0                             |X  *  | 0 1 2|3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _3_                            |X  *  +------|--+---------+---------+---------+            3 --> Would read 1 2K block   |X  *                                                                                   __|  *
  *  Length: 1   *    _w:  *  +|-|------+---------+---------+---------+  Length =  1;  *  ||0|1 2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _0_oN  *  +|_|------+---------+---------+---------+            1 --> Read 1 2K block	  *      __:  *  +--|-|----+---------+---------+---------+  Length =  1;  *  | 0|1|2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _1_IN  *  +--|_|----+---------+---------+---------+            2 --> Read 1 2K block  *        _B:  *  +----|-|--+---------+---------+---------+  Length =  1;  *  | 0 1|2|3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _2_RN  *  +----|_|--+---------+---------+---------+            3 --> Read 1 2K block
  *          _ :  *  +------|-|+---------+---------+---------+  Length =  1;  *  | 0 1 2|3|| 4 5 6 7 | 8 9 A B | C D E F |  Offset = _3_$N  *  +------|_|+---------+---------+---------+            4 --> Read 1 2K block  *  *
  *  Length: 2-	  *    ___R:  *  +|---|----+---------+---------+---------+  Length =  2;  *  ||0 1|2 3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _0_NN  *  +|___|----+---------+---------+---------+            2 --> Read 1 2K block  *      ___T:  *  +--|---|--+---------+---------+---------+  Length =  2;  *  | 0|1 2|3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _1_ N  *  +--|___|--+---------+---------+---------+            3 --> Read 1 2K block
  *        ___$:  *  +----|---|+---------+---------+---------+  Length =  2;  *  | 0 1|2 3|| 4 5 6 7 | 8 9 A B | C D E F |  Offset = _2_NN  *  +----|___|+---------+---------+---------+            4 --> Read 1 2K block  *          _____N:  *  +------|--+--|------+---------+---------+  Length =  2;  *  | 0 1 2|3 | 4|5 6 7 | 8 9 A B | C D E F |  Offset = _3_IO  *  +------|_____|------+---------+---------+            5 --> Read 2 2K blocksT  *  *
  *  Length: 3R  *    _____C:  *  +|-----|--+---------+---------+---------+  Length =  3;  *  ||0 1 2|3 | 4 5 6 7 | 8 9 A B | C D E F |  Offset = _0_ N  *  +|_____|--+---------+---------+---------+            3 --> Read 1 2K block
  *      ______:  *  +--|-----|+---------+---------+---------+  Length =  3;  *  | 0|1 2 3|| 4 5 6 7 | 8 9 A B | C D E F |  Offset = _1_aN  *  +--|_____|+---------+---------+---------+            4 --> Read 1 2K block  *        _______n:  *  +----|----+--|------+---------+---------+  Length =  3;  *  | 0 1|2 3 | 4|5 6 7 | 8 9 A B | C D E F |  Offset = _2_vO  *  +----|_______|------+---------+---------+            5 --> Read 2 2K blocksl  *          _______o:  *  +------|--+----|----+---------+---------+  Length =  3;  *  | 0 1 2|3 | 4 5|6 7 | 8 9 A B | C D E F |  Offset = _3_*O  *  +------|_______|----+---------+---------+            6 --> Read 2 2K blocksp  *  *
  *  Length: 4E
  *    _______A:  *  +|-------|+---------+---------+---------+  Length =  4;  *  ||0 1 2 3|| 4 5 6 7 | 8 9 A B | C D E F |  Offset = _0_tN  *  +|_______|+---------+---------+---------+            4 --> Read 1 2K block  *      _________ :  *  +--|------+--|------+---------+---------+  Length =  4;  *  | 0|1 2 3 | 4|5 6 7 | 8 9 A B | C D E F |  Offset = _1_tO  *  +--|_________|------+---------+---------+            5 --> Read 2 2K blocks   *        _________u:  *  +----|----+----|----+---------+---------+  Length =  4;  *  | 0 1|2 3 | 4 5|6 7 | 8 9 A B | C D E F |  Offset = _2_eO  *  +----|_________|----+---------+---------+            6 --> Read 2 2K blocksl  *          _________ :  *  +------|--+------|--+---------+---------+  Length =  4;  *  | 0 1 2|3 | 4 5 6|7 | 8 9 A B | C D E F |  Offset = _3_rO  *  +------|_________|--+---------+---------+            7 --> Read 2 2K blocks   *  *
  *  Length: 5=  *    ___________ :  *  +|--------+--|------+---------+---------+  Length =  5;  *  ||0 1 2 3 | 4|5 6 7 | 8 9 A B | C D E F |  Offset = _0_rO  *  +|___________|------+---------+---------+            5 --> Read 2 2K blocks   *      ___________y:  *  +--|------+----|----+---------+---------+  Length =  5;  *  | 0|1 2 3 | 4 5|6 7 | 8 9 A B | C D E F |  Offset = _1_fO  *  +--|___________|----+---------+---------+            6 --> Read 2 2K blocks   *        ___________r:  *  +----|----+------|--+---------+---------+  Length =  5;  *  | 0 1|2 3 | 4 5 6|7 | 8 9 A B | C D E F |  Offset = _2_ O  *  +----|___________|--+---------+---------+            7 --> Read 2 2K blocks   *          ___________ :  *  +------|--+--------|+---------+---------+  Length =  5;  *  | 0 1 2|3 | 4 5 6 7|| 8 9 A B | C D E F |  Offset = _3_ O  *  +------|___________|+---------+---------+            8 --> Read 2 2K blocksP  *  *
  *  Length: 6e  *    _____________0:  *  +|--------+----|----+---------+---------+  Length =  6;  *  ||0 1 2 3 | 4 5|6 7 | 8 9 A B | C D E F |  Offset = _0_*O  *  +|_____________|----+---------+---------+            6 --> Read 2 2K blocks.  *      _____________r:  *  +--|------+------|--+---------+---------+  Length =  6;  *  | 0|1 2 3 | 4 5 6|7 | 8 9 A B | C D E F |  Offset = _1_CO  *  +--|_____________|--+---------+---------+            7 --> Read 2 2K blockse  *        _____________C:  *  +----|----+--------|+---------+---------+  Length =  6;  *  | 0 1|2 3 | 4 5 6 7|| 8 9 A B | C D E F |  Offset = _2_ O  *  +----|_____________|+---------+---------+            8 --> Read 2 2K blocks5  *          _______________m:  *  +------|--+---------+--|------+---------+  Length =  6;  *  | 0 1 2|3 | 4 5 6 7 | 8|9 A B | C D E F |  Offset = _3_MO  *  +------|_______________|------+---------+            9 --> Read 3 2K blocksM  *  *
  *  Length: 7X  *    _______________ :  *  +|--------+------|--+---------+---------+  Length =  7;  *  ||0 1 2 3 | 4 5 6|7 | 8 9 A B | C D E F |  Offset = _0_PO  *  +|_______________|--+---------+---------+            7 --> Read 2 2K blocks*  *      _______________ :  *  +--|------+--------|+---------+---------+  Length =  7;  *  | 0|1 2 3 | 4 5 6 7|| 8 9 A B | C D E F |  Offset = _1_vO  *  +--|_______________|+---------+---------+            8 --> Read 2 2K blockst  *        _________________I:  *  +----|----+---------+--|------+---------+  Length =  7;  *  | 0 1|2 3 | 4 5 6 7 | 8|9 A B | C D E F |  Offset = _2_rO  *  +----|_________________|------+---------+            9 --> Read 3 2K blocks*  *          _________________e:  *  +------|--+---------+----|----+---------+  Length =  7;  *  | 0 1 2|3 | 4 5 6 7 | 8 9|A B | C D E F |  Offset = _3_oO  *  +------|_________________|----+---------+           10 --> Read 3 2K blocks   *  *
  *  Length: 8Q  *    _________________0:  *  +|--------+--------|+---------+---------+  Length =  8;  *  ||0 1 2 3 | 4 5 6 7|| 8 9 A B | C D E F |  Offset = _0_tO  *  +|_________________|+---------+---------+            8 --> Read 2 2K blocks   *      ___________________ :  *  +--|------+---------+--|------+---------+  Length =  8;  *  | 0|1 2 3 | 4 5 6 7 | 8|9 A B | C D E F |  Offset = _1_uO  *  +--|___________________|------+---------+            9 --> Read 3 2K blockst  *        ___________________t:  *  +----|----+---------+----|----+---------+  Length =  8;  *  | 0 1|2 3 | 4 5 6 7 | 8 9|A B | C D E F |  Offset = _2_iO  *  +----|___________________|----+---------+           10 --> Read 3 2K blocksb  *          ___________________ :  *  +------|--+---------+------|--+---------+  Length =  8;  *  | 0 1 2|3 | 4 5 6 7 | 8 9 A|B | C D E F |  Offset = _3_wO  *  +------|___________________|--+---------+           11 --> Read 3 2K blocks)  *  *  */t     p /* BLOCKS and SECTORSl  *G  * Most ATA devices employ 512-byte sectors the same as any traditional1H  * VMS or SCSI disk. Most magnetic read-write ATAPI devices (such as the2  * Iomega Zip drive) also employ 512-byte sectors.  *C  * Devices based on CD technology, however, employ CD-sized sectors H  * (which contain at least 2352 raw bytes of data but, after subtractingL  * extra error-handling codes, result in a net data transfer of 2048 bytes).  *D  * Generally speaking, within the driver, I've tried to refer to theG  * on-disk, variable-sized things as "sectors" and to only use the termaD  * "blocks" to refer to the standard VMS-sized 512-byte data blocks.  *  */e                                 /* REQUEST SEGMENTATION   *H  * A single large I/O request may be segmented (fragmented) into severalH  * smaller I/O requests at least two different points in the life of the  * I/O request. In particular:  *I  *   - [SYS]SYSFASTIO  or [SYS]SYSACPFDT will segment I/Os into transferseG  *     of no more than UCB$L_MAXBCNT (or 127 blocks/65024 bytes if thatvP  *     field is zero). I'm not sure why this is done, but it's handy for us. ...  *B  *   - Our READ/WRITE/DATACHECK routines will also segment requestB  *     into transfers of varying sizes (depending on exactly whichA  *     segment-handler will then process the I/O onwards to whichoC  *     target device). This is required because the ATA, ATAPI, andoC  *     SFF-8038i (DMA) specs impose limits on the size of transfers   *     or DMA buffers.  *  *     In particular:r  *@  *       o a single ATA PIO command can't transfer more than oneF  *         sector (typically, 512 bytes) bytes per interrupt (althoughB  *         it can certainly transfer more in a single command that%  *         spans several interrupts).u  *E  *       o a single ATAPI PIO command can't transfer more than 65,535uA  *         bytes per interrupt (although it can probably transfersC  *         more in a single command that spans several interrupts).n  *E  *       o a single ATA or ATAPI DMA command can't transfer more thanaD  *         65,536 bytes using a single DMA window (although the PRDT?  *         mapping table can specify more than one DMA window.)   *  *H  * Devices that employ 2KB sectors make this all a bit more interesting.I  * Although VMS's upper-level segmentation shields ATA and 512-byte ATAPInC  * devices from a lot of these concerns, 2KByte ATAPI devices couldnC  * have to transfer 33 sectors (33*2048=67584 bytes) to fulfill anyhF  * arbitrarily-aligned group of 127 512-byte blocks. VMS's upper-levelC  * segmentation won't help here -- the driver must correctly handle D  * this case or set UCB$L_MAXBCNT to, say 124*512 so no transfer can4  * span more than 65536 bytes worth of on-disk data.  *D  * In principal, we could probably set UCB$L_MAXBCNT and rely on VMS#  * to do all the segmentation, but:E  *G  *   - Belt-and-suspenders (VMS doing it *AND* us doing it) is probably|  *     safer, and   *F  *   - Because our segmentation need pass through fewer levels, we canJ  *     do it faster. We may well someday want to set a large UCB$L_MAXBCNT4  *     to disable some or all of VMS's segmentation.  *  */n     H /* IDE/ATAPI Bus Mastering DMA  *A  * This is a term used in the PC industry to describe the concept0?  * that you or I would simply think of as "DMA". This describes C  * the capability of a controller to actually become the bus master-A  * (Be still my heart!) and thereby affect its own DMA transfers. >  * This is also described as "First Party DMA", as compared toE  * "Third Party DMA" where a dedicated DMA controller on the bus does-B  * PIO to the device and then transfers the data into main memory.  *?  * For ATA and ATAPI devices, this capability is defined not by-C  * the ATAPI spec but rather by a working group of the Small Factor 5  * Task force. The ruling spec is known as SFF-8038i.   *                            @  * Essentially, the spec defines two sets of registers (one eachA  * for the Primary and Secondary IDE controllers) that each point B  * to tables (Called the PRDT or Physical Region Descriptor Table)@  * that then allow scatter-gather DMA through the PCI bus memoryE  * window(s). In each table, the PRDT entries are stored sequentially-@  * in the table and the data transfer proceeds until all regions;  * described by the table have been transfered or the drive0  * terminates the transfer.   *,  * Each PRDT entry has the following format:  *5  *    +----------------------+--------------------+-+/5  *    |          Base Address  [31:01]            |0| 5  *    +---+------------------+--------------------+-++5  *    |EDT| ---------------- | Byte Count [15:01] |0|R5  *    +---+------------------+--------------------+-+   *  *
  * NOTE WELL:_  *A  *   - Regions *CAN NOT* exceed 64K bytes. Transfers (or at least B  *     mapping windows) must be segmented to be smaller than that./  *     A byte count of 0x0000 implies 64Kbytes.+  *F  *   - Regions *CAN NOT SPAN* a 64K boundary in the PCI address space!  *B  *   - Regions *MUST BE* word-aligned! We need to manually shuffle/  *     bytes to the user buffer if they aren't.y  *C  *   - The Descriptor Table itself *CAN NOT SPAN* a 64K boundary in   *     the PCI address space!-  *>  *   - The Descriptor Table itself *MUST BE* longword aligned!  *I  *   - The EDT (End-Descriptor-Table) flag is set in the last PRDT entry.*  *?  *   - The table must describe at least enough space to containe?  *     the entire transfer conducted by the drive. If the table A  *     describes more bytes than will be transfered by the drive,-@  *     the driver must clear the "ACTIVE" bit (in DMA_CMD) after   *     the transfer is complete!  *  */+     -* /* IDE/ATAPI Bus Mastering DMA (Continued)  *F  * We open two mapping windows per unit: One for the PRDT (controller-C  * chip-based scatter/gather map table) and one for the actual data 
  * window.  *B  * Right now, our data window is pointed at our own buffer. In the@  * near future, it should be pointed to directly the user buffer=  * any time the DMA is "simple". Simple DMAs are those where:-  *9  *   o The transfer length is less than or equal to 64KB.+?  *     This is a "gimme" given that VMS defaults to fragmentingX?  *     our requests to 127 or fewer blocks (63.5K) and we force+8  *     smaller fragmentation for 2K-byte sector devices.  *;  *   o The transfer length is an integral number of blocks.*<  *     For non-integral write transfers, we probably need to@  *     pad the last block. (Although the DVDRIVER has discoveredA  *     that this is automatic for floppy controllers, I won't yet <  *     take that on faith for all possible IDE controllers.)=  *     For non-integral read transfers, we need to do further &  *     investigation at a future date.  *=  *   o The transfer is word-aligned. This is required becauseM-  *     there's no hardware to do the shuffle.-  *  *	  * Notes:-  *A  *   Rather than open one window per unit, we could probably open3B  *   only one window per controller, but I'm not going to get into  *   that now.  *?  *   For systems with less than 1GB of memory, we could use the-A  *   direct-mapping window rather than the scatter/gather window.   *  */X     X /* More PRDT Fun  *>  * Some day when we start doing direct I/O, the PRDT could, in?  * principle, be used to automate some of work that needs to be-  * done. For example:*  *=  *   o We currently face the problem that for CD/DVD-ROM read_B  *     transfers, we must transfer 2Kbyte sectors and then (often)?  *     extract only a portion of our buffer to transfer onwards-=  *     to the user. We could easily use the PRDT to cause the ;  *     transfer of the leading/trailing unwanted VMS blocks-8  *     into a "junk" buffer while the desired blocks are.  *     transfered into the actual user buffer.  *?  *     Similarly, for writes to 2KByte-sector devices, we could <  *     easily use the PRDT to do the "merge" between the old<  *     data blocks (previously read into our buffer) and the<  *     new data blocks (transferred from the user's buffer).?  *     This would make the required RMW operation much simpler.-  *  *#  * We could get even fancier still:   *A  *   o Currently, we must do data extraction for all devices (not*=  *     just 2Kbyte-sector devices) when the user asks for thed;  *     reading of less than a full sector. We could use theE<  *     PRDT to accomplish this for any transfer with an even?  *     byte-count, transferring the desired bytes to the user'si>  *     buffer while transferring the undesired bytes to a junk?  *     buffer. (We're still stuck doing it by hand for at leastf@  *     the last sector/block of transfers with odd byte counts.)  *9  *   o Currently, we must do buffer-filling (with zeroes)E9  *     extraction for all devices (not just 2Kbyte-sector :  *     devices) when the user asks for the writing of less>  *     than a full sector. We could use the PRDT to accomplish=  *     this for any even byte-count, transferring the desiredl=  *     bytes from the user's buffer and transferring the rest*:  *     of the bytes from a pre-zeroed buffer. (We're still:  *     stuck doing it by hand for the last sector/block of'  *     transfers with odd byte counts.)   *=  *  o We could also use the PRDT to facilitate transfers that ?  *    are less-than page-aligned (all the way down to transfers <  *    that are just word-aligned).  (We're still stuck doing<  *    it by entirely by hand for transfers to odd addresses,9  *    that is, transfers that are not even word-aligned.)D  *  */_     _6 /* Define system data structure types and constants */  E #include   bufiodef				/* BUFfered I/O header                      */eC #include   ccbdef				/* Channel Control Block                    */ C #include   crbdef				/* Controller Request Block                 */ D #include   crabdef				/* Counted Resource Allocation Block        */D #include   cramdef				/* Controller Register Access Method        */E #include   crctxdef				/* Counted Resource Context Block           */ B #include   dcdef				/* Device Codes                             */C #include   ddbdef				/* Device Data Block                        */vC #include   ddtdef				/* Driver dispatch table                    */uC #include   devdef				/* Device characteristics                   */ C #include   dptdef				/* Driver Prologue Table                    */-C #include   dtndef				/* Define the DTNs                          */ C #include   dyndef				/* Dynamic type definitions                 */|E #include   embdvdef				/* Error log entry for devices              */ C #include   fdtdef				/* Function Decision Table                  */oC #include   fkbdef				/* ForK Block                               */sC #include   idbdef				/* Interrupt Data Block                     */uC #include   iocdef				/* IOC constants                            */iB #include   iodef				/* I/O function codes                       */C #include   irpdef				/* I/O Request Packet                       */ C #include   orbdef				/* Object Rights Block                      */tD #include   pagedef				/* Get page definitions and disk block size */C #include   pcbdef				/* Process Control Block                    */ C #include   pcidef				/* PCIbus definitions                       */ C #include   prvdef				/* Privilege bit definitions                */ B #include   ssdef				/* System service status codes              */C #include   stddef				/* Common definitions                       */|C #include   stsdef				/* STatuS value fields                      */_C #include   ucbdef				/* Unit Control Block                       */rC #include   vadef		 		/* Virtual Address definitions              */ H #include   "sys$library:arch_defs"		/* Architectural definitions		    */  = #ifndef IOC$K_BYTE_LANED			/* Defined in V7-1.2 onwards... */-? #define IOC$K_BYTE_LANED 1			/* Define this for V71R as well */  #endif  4 /* Define function prototypes for system routines */  ; #include   acp_routines				/* ACP$ and ACP_STD$ routines */ ; #include   erl_routines				/* erl$ and erl_std$ routines */|; #include   exe_routines				/* exe$ and exe_std$ routines */-; #include   ioc_routines				/* ioc$ and ioc_std$ routines */i; #include   ldr_routines				/* ldr$ and ldr_std$ routines */e9 #include   starlet				/* Define SYS$SETPRV prototypes */ i  ) /* Define various device driver macros */   < #include   vms_drivers				/* Device driver support macros */8 #include   vms_macros				/* Define bug_check and such */  4 /* Define the DEC C functions used by this driver */  B #include   builtins				/* C builtin functions -- unused, but... */9 #include   string				/* String rtns from "kernel CRTL" */:   /* Define some useful types */  ? typedef unsigned short int WORD;		/* Define a WORD (16 bits) */ > typedef unsigned char      BYTE;		/* Define a BYTE (8 bits) */= typedef unsigned int       UINT;		/* Usigned int (32 bits) */|     l. /* Define constants specific to this driver */  7 						/* Miscellaneous controller-related constants: */*  M #define NUMBER_OF_CMDBLK_CRAMS      8*2         /* Crams for cmdblk access */|c #define NUMBER_OF_CTLBLK_CRAMS      1*2         /* Number of CRAMs needed to map the non-DMA CSRs*/ ` #define NUMBER_OF_DMA_CRAMS         9*2         /* Number of CRAMs needed to map the DMA CSRs */^ #define NUMBER_OF_CRAMS      NUMBER_OF_CMDBLK_CRAMS+NUMBER_OF_CTLBLK_CRAMS+NUMBER_OF_DMA_CRAMSR                                                 /* Total number of CRAMs needed */% #define PRIMARY_MODE                1v% #define SECONDARY_MODE              4 . #define ACER                        0x522910B9. #define CMD649                      0x06491095. #define CYPRESS                     0xC6931080" #define INTELPIIXE		    0x76018086  P #define PRI_LEG_CMDREG		    0x1F0	/* Legacy Mode Command Register for Primary */R #define SEC_LEG_CMDREG		    0x170	/* Legacy Mode Command Register for Secondary */Q #define PRI_LEG_CNTRLREG	    0x3F4	/* Legacy Mode Control Register for Primary */ T #define SEC_LEG_CNTRLREG	    0x374	/* Legacy Mode Control Register for Secondary */  			    t: #define MODEL_LENGTH        40			/* Model string length */Y #define ERR_BYTES       (EMB$C_DV_LENGTH+12+5+8)/* Size of error log buffer (in bytes) */lP #define RDSTATS_LEN     ((TIMEOUT_TIME + 9) * 4)/* Size of RDSTATS_LEN buffer */4 #define DEVICE_IPL          21			/* IPL of device */     						/* Timeout times */IL #define DRQ_TIME     (1000 * 1000)		/* DRQ wait time (i.e, 1 millisecond) */O #define RESET_TIME           4			/* Reset time (seconds) (Ensure two passes) */rM #define READY_TIME    (100 * 1000)		/* Ready time (i.e., 100 microseconds) */u  A #define TIMEOUT_TIME        60			/* I/O Timeout time (seconds) */b    J 						/* Geometry and transfer constants                                */e #define MAX_UCB_CYL       4095			/* UCB max values based on max ata lba of 0x0fffffff              */1 #define MAX_UCB_TRK        255 #define MAX_UCB_SEC        255e #define MAX_RETRY            8			/* Maximum number of retries                                      */te #define MAX_SECTOR          63			/* Max sector allowed [1:n]                                       */se #define MAX_HEAD            15			/* Max head allowed [0:n]                                         */5e #define MAX_CYLINDER     16383			/* Max cylinder allowed [0:n]                                     */ J 						/* (That could be as big as 65535                                 */J 						/*   but real drives seem to top out at 14 bits = 0x3FFF)         */j #define MAX_BLOCKS_PER_CYLINDER 1008		/* 63 sectors per track * 16 heads                                */  e #define MAX_ATA_XFER       127			/* Max ATA/IDE transfer size (blocks)                             */sJ 						/*                                                                */e #define MAX_ATAPI_512_XFER 127			/* Max ATAPI transfer size (blocks) on a 512-byte-sector device   */ J 						/*                                                                */J 						/*   Both of these are limited to 127 blocks (63.5K) just in      */J 						/*   case there are drives out there that have trouble with       */J 						/*   a 64K transfer. The Zip *IS* an example of such a drive --   */J 						/*   It reports a SCSI parity Error is you command it to do       */J 						/*   a read with the byte count register = 0x0000.                */J 						/*                                                                */J 						/*   127 is also a good value because it matches the size         */J 						/*   to which VMS segments transfers by default if ucb$l_maxbcnt  */J 						/*   is left set to 0.                                            */J 						/*                                                                */J 						/*                                                                */e #define MAX_ATAPI_2K_XFER  120			/* Max ATAPI transfer size (blocks) on a 2Kbyte-sector device     */eJ 						/*                                                                */J 						/*   In much the same fashion as we limit ATA and ATAPI_512 reads */J 						/*   to 63.5K, we've also limited ATAPI_2K reads to 62K (31 2K    */J 						/*   blocks) to avoid any problems with drives that might have    */J 						/*   trouble with 64K transfers.                                  */J 						/*                                                                */J 						/*   We then further limit this to 60K so that we can fulfill,    */J 						/*   from within this 62K buffer, any arbitrary set of 512-byte   */J 						/*   blocks. And keeping this "by 4" will keep an aligned         */J 						/*   transfer aligned through all segments.                       */    ^ #define BLK_SIZE_CAPACITY    8			/* Size of returned capacity data block in bytes           */^ #define BLK_SIZE_SENSE      18			/* Size of returned sense data block in bytes              */^ #define BLK_SIZE_512       512			/* Size of a VMS (and typical IDE/ATA) disk block in bytes */^ #define BLK_SIZE_2048     2048			/* Size of a typical CD-ROM data block in bytes            */^ #define BLK_SIZE_2352     2352			/* Size of a maximum CD-ROM data block in bytes            */a #define BLK_SIZE_63_5K   (127*512)		/* Size of a 127 block buffer in bytes                     */eC 						/*   (maximum practical ATA/ATAPI transfer)                */ta #define BLK_SIZE_64K     (128*512)		/* Size of a 128 block buffer in bytes                     */TC 						/*   (maximum ATA/ATAPI transfer)                          */s  H #define BLK_MASK     IOC$M_BLOCK_BYTEMASK	/* "Byte within block" mask */  G #define BLK_SHIFT            9			/* Shift factor for blocks to bytes */d  ] #define XFER_BUFFER_SIZE  BLK_SIZE_63_5K	/* Size of each transfer buffer                   */N: 						/*                                                */: 						/* When the page size calculation is applied,     */: 						/*   this will round up to a 64K buffer. But      */: 						/*   we want the smaller size in the constant so  */: 						/*   we don't take 0x00010000 (64K) and end up    */: 						/*   passing 0x0000 to the ATA and ATAPI drives.  */: 						/*   At least some of them (like the Zip) take    */: 						/*   that as 0, not 64K.                          */  V #define XFER_BUFFER_MAP_PAGES  8		/* Number of map pages to cover the xfer buffer   */  e #define SENSE_BUFFER_SIZE ( (BLK_SIZE_CAPACITY>BLK_SIZE_SENSE) ? BLK_SIZE_CAPACITY : BLK_SIZE_SENSE )|: 						/* Size of each sense buffer (Max of those two)   */: 						/*                                                */: 						/* When the page size calculation is applied,     */: 						/*   this will round up to at least an 8K buffer. */: 						/*                                                */: 						/* Later, rather than waste the space, maybe      */: 						/*    re-use the end of this buffer for the       */: 						/*    for the DMA PRDT table.                     */    N #define PRDT_ENTRIES 8				/* Number of PRDT (Scatter/Gather Table) entries  */3 #define PRDT_TABLE_SIZE (PRDT_ENTRIES*sizeof(PRDT)) : 						/* Total size of the PRDT table                   */_ #define PRDT_ADX_MASK ~(PRDT_TABLE_SIZE-1)	/* Mask to force natural alignment of the PRDT    */|       /* External references */-  9 extern int   MMG$GL_PAGE_SIZE;			/* Page size in bytes */ ? extern int   MMG$GL_VPN_TO_VA;			/* Page to byte shift count */+  E extern PTE   * const mmg$gl_sptbase;		/* Base of system page table */|  . extern DDT   driver$ddt;			/* Prototype DDT */. extern DPT   driver$dpt;			/* Prototype DPT */. extern FDT   driver$fdt;			/* Prototype FDT */. extern UCB   *sys$ar_bootucb;			/* Boot UCB */  3 /* Shortcuts for some of the external references */i  5 #define _ddt  driver$ddt			/* Abbreviation for DDT */i5 #define _dpt  driver$dpt			/* Abbreviation for DPT */*5 #define _fdt  driver$fdt			/* Abbreviation for FDT */   ) extern int  exe$kprintf(char *form, ...);  extern void ini$brk();  ( /* OWN values used for debugging only */   #ifdef TRACE_COMMONd  J int  trc_dummy;					/* An ASCII tag to help you find this               */H int *trc_buf;					/* Pointer to the base of the common tracing buffer */J int  trc_index;					/* Current index into the common tracing buffer     */O int  trc_buf_alloc=0;				/* Have we already allocated this?                  */r  G int  fixup_dummy;				/* An ASCII tag to help you find this           */aF int  fixup_bcnt;				/* The number of times we've fixed UCB$L_BCNT   */F int  fixup_boff;				/* The number of times we've fixed UCB$L_BOFF   */H int  fixup_svapte;				/* The number of times we've fixed UCB$L_SVAPTE */   #endif     a' /* Define the IDE disk controller CSRs.a  *B  * The following are the characteristics of the PCI IDE controller,  *  when it is operating in Native-PCI mode.  *9  *                              Primary         Secondaryb4  * Data/Control Ports           BA_0            BA_24  * Control/Status Ports         BA_1            BA_34  * DMA Registers                BA_4            BA_4  *  */a n) /* Offsets for control block registers */   I #define REG_ALT_STS     0x2             /* READ: Alternate status      */tI #define REG_DEV_CTL     0x2             /* WRITE:Device control        */n  ) /* Offsets for command block registers */-  I #define REG_DATA        0x0             /* R/W:  Data                  */hI #define REG_ERROR       0x1             /* READ: Error                 */cI #define REG_FEATURES    0x1             /* WRITE:Features              */iI #define REG_SEC_CNT     0x2             /* R/W:  Sector count          */iI #define REG_SECTOR      0x3             /* R/W:  Sector number         */uI #define REG_CYL_LO      0x4             /* R/W:  Cylinder (low)        */eI #define REG_CYL_HI      0x5             /* R/W:  Cylinder (high)       */ I #define REG_DRV_HD      0x6             /* R/W:  Drive / Head          */rI #define REG_STATUS      0x7             /* READ: Status                */oI #define REG_CMD         0x7             /* WRITE:Command               */i  ! /* LBA fields (read and write) */e  J #define REG_LBA_0       0x3             /* LBA bits 0-7                 */J #define REG_LBA_8       0x4             /* LBA bits 8-15                */J #define REG_LBA_16      0x5             /* LBA bits 16-23               */J #define REG_LBA_24      0x6             /* LBA bits 24-27               */   /* Device Control Register */*  O #define CTL_M_nIEN     0x01             /* Interrupt enable bit for the host */ E #define CTL_M_SRST     0x02             /* Host software reset bit */      /* Drive/Head Register */   8 #define DRVHD_M_BASE  0xA0		/* Bits 7 and 5 must be 1 */4 #define DRVHD_M_LBA   0x40		/* LBA addressing bit */     /* ATAPI Features Register */   ( #define FEAT_M_DMA   0x01		/* Use DMA */3 #define FEAT_M_OVL   0x02		/* Overlap operations */     , /* Status (and Alternate Status) Register */  % #define STS_M_ERR   0x01		/* Error */ * #define STS_M_IDX   0x02		/* Index mark */. #define STS_M_CORR  0x04		/* Corrected data */, #define STS_M_DRQ   0x08		/* Data request */@ #define STS_M_DSC   0x10		/* Drive seek complete (in old spec)*/< #define STS_M_SVC   0x10		/* Service request (in new spec)*/1 #define STS_M_DWF   0x20		/* Drive write fault */-+ #define STS_M_DRDY  0x40		/* Drive ready */b$ #define STS_M_BSY   0x80		/* Busy */  # #define STS_V_ERR   0			/* Error */ ( #define STS_V_IDX   1			/* Index mark */, #define STS_V_CORR  2			/* Corrected data */* #define STS_V_DRQ   3			/* Data request */> #define STS_V_DSC   4			/* Drive seek complete (in old spec)*/: #define STS_V_SVC   5			/* Service request (in new spec)*// #define STS_V_DWF   6			/* Drive write fault */K) #define STS_V_DRDY  7			/* Drive ready */ " #define STS_V_BSY   8			/* Busy */      1 /* Offsets for DMA block (SFF-8038i) registers */-  < 					/*                            Actual Legacy Address  */< 					/*                             Primary    Secondary  */< 					/*                           ----------------------- */Q #define DMA_CMD        0		/* R/W: Command                0xnnnnn0    0xnnnnn8  */ Q #define DMA_DS1        1		/* R/W: Device-Specific 1      0xnnnnn1    0xnnnnn9  */ Q #define DMA_STS        2		/* R/W: Status                 0xnnnnn2    0xnnnnnA  */ Q #define DMA_DS2        3		/* R/W: Device-Specific 2      0xnnnnn3    0xnnnnnB  */ Q #define DMA_AD0        4		/* R/W: PRD Table Address LSB  0xnnnnn4    0xnnnnnC  */-Q #define DMA_AD1        5		/* R/W:  :                     0xnnnnn5    0xnnnnnD  */ Q #define DMA_AD2        6		/* R/W:  :                     0xnnnnn6    0xnnnnnE  */ Q #define DMA_AD3        7		/* R/W: PRD Table Address MSB  0xnnnnn7    0xnnnnnF  */     $ /* DMA Command Register (BMIDECR) */M #define DMA_CMD_M_INACTIVE 0x00		/* Make the DMA controller inactive       */kM #define DMA_CMD_M_ACTIVE   0x01		/* Make the DMA controller active         */*  N #define DMA_CMD_M_OUTBOUND 0x00		/* The DMA direction "OUTBOUND" or WRITE   */K #define DMA_CMD_M_INBOUND  0x08		/* The DMA direction "INBOUND" or READ  */     # /* DMA Status Register (BMIDESR) */-L #define DMA_STS_M_ACTIVE  0x01		/* DMA Active                             */L #define DMA_STS_M_ERR     0x02		/* DMA Error                              */L #define DMA_STS_M_INT     0x04		/* DMA Interrupt                          */L #define DMA_STS_M_RSV3    0x08		/*   <Reserved>                           */L #define DMA_STS_M_RSV4    0x10		/*   <Reserved>                           */L #define DMA_STS_M_DRV0    0x20		/* Drive 0 is DMA-capable (Master)        */L #define DMA_STS_M_DRV1    0x40		/* Drive 1 is DMA-capable (Slave)         */7 #define DMA_STS_M_SIMPLEX 0x80		/* Simplex Only				  */b    $ /* DMA Control Register (MRDMODE) */= #define DMA_CTL_M_MEM_READ	  0x00		/* Memory Read Mode			  */ J #define DMA_CTL_M_MEM_READ_MULT	  0x01		/* Memory Read Multiple Mode		  */F #define DMA_CTL_M_MEM_READ_LINE	  0x02		/* Memory Read Line Mode		  */M #define DMA_CTL_M_PIRQ_PEND	  0x04		/* Primary Channel Interrupt Pending	  */|O #define DMA_CTL_M_SIRQ_PEND	  0x08		/* Secondary Channel Interrupt Pending	  */-M #define DMA_CTL_M_PIRQ_BLOCK	  0x10		/* Block Primary Channel Interrupts	  */-V #define DMA_CTL_M_SIRQ_BLOCK	  0x20	        /* Block Secondary Channel Interrupts	  */H #define DMA_CTL_M_PRI_RESET	  0x40		/* Keep Primary Reset Asserted		  */I #define DMA_CTL_M_SEC_RESET	  0x80		/* Keep Secondary Reset Asserted	  */-    , /* DMA Control Status Register (BMIDECSR) */L #define	DMA_CSR_M_PRI_80PIN	  0x01		/* 80 Pin cable detected in Primary	  */N #define	DMA_CSR_M_SEC_80PIN	  0x02		/* 80 Pin cable detected in Secondary	  */  S #define	DMA_CSR_M_RFIFO_EMPTY	  0x00		/* FIFO Threshold for READ Empty (Default)	*/ T #define DMA_CSR_M_RFIFO_QUART	  0x10	        /* FIFO Threshold for READ 1/4 Full		*/L #define DMA_CSR_M_RFIFO_HALF	  0x20		/* FIFO Threshold for READ 1/2 Full		*/O #define DMA_CSR_M_RFIFO_TFOURTH   0x30		/* FIFO Threshold for READ 3/4 Full		*/    S #define DMA_CSR_M_WFIFO_EMPTY	  0x00          /* FIFO Threshold for WRITE Empty		*/aS #define DMA_CSR_M_WFIFO_QUART     0x40		/* FIFO Threshold for WRITE 1/4 Full		*/   tU #define DMA_CSR_M_WFIFO_HALF	  0x80		/* FIFO Threshold for WRITE 1/2 Full(Default)	*/|Q #define DMA_CSR_M_WFIFO_TFOURTH   0xC0		/* FIFO Threshold for WRITE 3/4 Full		*/ u    2 /* DMA Timing Control Register (UDIDETCR) */						I #define DMA_TCR_M_MDMA		  0x00		/* Master DMA Mode	1:UDMA 0:MWDMA		    */-H #define DMA_TCR_M_SDMA		  0x01		/* Slave DMA Mode	1:UDMA 0:MWDMA		    */T #define DMA_TCR_M_MCCR		  0x04		/* Master Cycle Clock	1:UDMA-3,4,5 0:UDMA-0,1,2   */[ #define DMA_TCR_M_SCCR		  0x08          /* Slave Cycle Clock	1:UDMA-3,4,5 0:UDMA-0,1,2   */-  Q #define DMA_TCR_M_MCT2		  0x10		/* Master Cycle Time	Ultra DMA Mode 2 or 4	    */_V #define DMA_TCR_M_MCT1		  0x20		/* Master Cycle Time    Ultra DMA Mode 1 or 3       */f #define DMA_TCR_M_MCT0            0x30          /* Master Cycle Time    Ultra DMA Mode 0            */f #define DMA_TCR_M_MCT3            0x00          /* Master Cycle Time    Ultra DMA Mode 5            */  d #define DMA_TCR_M_SCT2	          0x40          /* Slave Cycle Time    Ultra DMA Mode 2 or 4       */e #define DMA_TCR_M_SCT1            0x80          /* Slave Cycle Time    Ultra DMA Mode 1 or 3       */-e #define DMA_TCR_M_SCT0            0xC0          /* Slave Cycle Time    Ultra DMA Mode 0            */-e #define DMA_TCR_M_SCT3            0x00          /* Slave Cycle Time    Ultra DMA Mode 5            */-     /* DMA PRDT (DTPR) */n typedef struct    {					/* The PRDT structure */+     UINT phys_adx;			/* Physical address */|3     WORD count;				/* Byte count for this region */kM     WORD flags;				/* Flags: Only high bit is meaningful as EDT (end) flag */-
       } PRDT;   I #define DMA_PRDT_M_EDT  0x8000		/* The EDT (End-Descriptor-Table) flag */*     _$ /* ATAPI magic "Signature" values */  L #define ATAPI_SIG_STS    0x00		/* In the Status/Alternate Status Register */\ #define ATAPI_SIG_STSE   0x01		/* In the Status/Alternate Status Register (Error bit set) */  B #define ATAPI_SIG_CYL_HI 0xEB		/* In the Cylinder "Hi" Register */  B #define ATAPI_SIG_CYL_LO 0x14		/* In the Cylinder "Lo" Register */     - /* ATA Commandst  *	  * Notes:   *>  *  o All of these commands are issued to the command registerB  *    in the IDE/ATA "Task file" (the controller's register file).  *@  *  o CMD_ATA_ATAPI_SOFT_RESET belongs here because that command@  *    is issued to the task file also, and not sent as a command  *    within an ATAPI packet._  *(  *  o This list is complete as of ATA-3.  *  */K  f #define CMD_ATA_NOP                      0x00	/* NOP                                                */f #define CMD_ATA_ATAPI_SOFT_RESET         0x08	/* Reset an ATAPI drive                               */  f #define CMD_ATA_RECALIBRATE              0x10	/* Recalibrate                                        */  f #define CMD_ATA_READ_SECS                0x20	/* Read Sector(s) w/ retries                          */f #define CMD_ATA_READ_SECS_WO_RET         0x21	/* Read Sector(s) w/o retries                         */f #define CMD_ATA_READ_LONG                0x22	/* Read Long (i.e., including ECC bytes) w/ retries   */f #define CMD_ATA_READ_LONG_WO_RET         0x23	/* Read Long (i.e., including ECC bytes) w/o retries  */  f #define CMD_ATA_WRITE_SECS               0x30	/* Write Sector(s) w/ retries                         */f #define CMD_ATA_WRITE_SECS_WO_RET        0x31	/* Write Sector(s) w/o retries                        */f #define CMD_ATA_WRITE_LONG               0x32	/* Write Long (i.e., including ECC bytes) w/ retries  */f #define CMD_ATA_WRITE_LONG_WO_RET        0x33	/* Write Long (i.e., including ECC bytes) w/o retries */f #define CMD_ATA_WRITE_VFY                0x3C	/* Write Verify                                       */  f #define CMD_ATA_READ_VFY_SECS            0x40	/* Read Verify Sector(s) w/ retries                   */f #define CMD_ATA_READ_VFY_SECS_WO_RET     0x41	/* Read Verify Sector(s) w/o retries                  */  f #define CMD_ATA_FORMAT_TRACK             0x50	/* Format Track                                       */  f #define CMD_ATA_SEEK                     0x70	/* Seek                                               */  f #define CMD_ATA_80                       0x80	/* Unused group 0x8n                                  */  f #define CMD_ATA_EXEC_DEV_DIAGS           0x90	/* Execute Device Diagnostic                          */f #define CMD_ATA_INIT_DEV_PARAMS          0x91	/* Initialize Device Parameters                       */f #define CMD_ATA_DOWNLOAD_UCODE           0x92	/* Download Microcode                                 */f #define CMD_ATA_STANDBY_IMMED_94         0x94	/* Standby Immediate 94                               */f #define CMD_ATA_IDLE_IMMED_95            0x95	/* Idle Immediate 95                                  */f #define CMD_ATA_STANDBY_96               0x96	/* Standby 96                                         */f #define CMD_ATA_IDLE_97                  0x97	/* Idle 97                                            */f #define CMD_ATA_CHK_PWR_MODE_98          0x98	/* Check Power Mode 98                                */f #define CMD_ATA_SLEEP_99                 0x99	/* Sleep 99                                           */  f #define CMD_ATA_PACKET_CMD               0xA0	/* Send a command packet to ATAPI drive               */f #define CMD_ATA_PACKET_IDENTIFY          0xA1	/* Get an ATAPI drive to identify itself              */  f #define CMD_ATA_SMART_DSBL_OPS           0xB0	/* SMART Disable Operations                           */f #define CMD_ATA_SMART_ENBLDSBL_ATTR_AUTO 0xB0	/* SMART Enable/Disable Attribute Autosave            */f #define CMD_ATA_SMART_ENBL_OPERATIONS    0xB0	/* SMART Enable Operations                            */f #define CMD_ATA_SMART_READ_ATTR_THRESH   0xB0	/* SMART Read Attribute Thresholds                    */f #define CMD_ATA_SMART_RETURN_STATUS      0xB0	/* SMART Return Status                                */f #define CMD_ATA_SECUR_SET_PSWD_OBS       0xBA	/* Security Set Password (Obsolete Version)           */f #define CMD_ATA_SECUR_UNLOCK_OBS         0xBB	/* Security Unlock (Obsolete Version)                 */f #define CMD_ATA_SECUR_ERASE_PREPARE_OBS  0xBC	/* Security Erase Prepare (Obsolete Version)          */f #define CMD_ATA_SECUR_ERASE_UNIT_OBS     0xBD	/* Security Erase Unit (Obsolete Version)             */f #define CMD_ATA_SECUR_FREEZE_LOCK_OBS    0xBE	/* Security Freeze Lock (Obsolete Version)            */f #define CMD_ATA_SECUR_DSBL_PSWD_OBS      0xBF	/* Security Disable Password (Obsolete Version)       */  f #define CMD_ATA_READ_MULTIPLE            0xC4	/* Read Multiple                                      */f #define CMD_ATA_WRITE_MULTI              0xC5	/* Write Multiple                                     */f #define CMD_ATA_SET_MULTI_MODE           0xC6	/* Set Multiple Mode                                  */f #define CMD_ATA_READ_DMA                 0xC8	/* Read DMA w/ retries                                */f #define CMD_ATA_READ_DMA_WO_RET          0xC9	/* Read DMA w/o retries                               */f #define CMD_ATA_WRITE_DMA                0xCA	/* Write DMA w/ retries                               */f #define CMD_ATA_WRITE_DMA_WO_RET         0xCB	/* Write DMA w/o retries                              */  f #define CMD_ATA_DOOR_LOCK                0xDE	/* Door Lock                                          */f #define CMD_ATA_DOOR_UNLOCK              0xDF	/* Door Unlock                                        */  f #define CMD_ATA_STANDBY_IMMED_E0         0xE0	/* Standby Immediate E0                               */f #define CMD_ATA_IDLE_IMMED_E1            0xE1	/* Idle Immediate E1                                  */f #define CMD_ATA_STANDBY_E2               0xE2	/* Standby E2                                         */f #define CMD_ATA_IDLE_E3                  0xE3	/* Idle E3                                            */f #define CMD_ATA_READ_BUFFER              0xE4	/* Read Buffer                                        */f #define CMD_ATA_CHK_PWR_MODE_E5          0xE5	/* Check Power Mode E5                                */f #define CMD_ATA_SLEEP_E6                 0xE6	/* Sleep E6                                           */f #define CMD_ATA_WRITE_BUFFER             0xE8	/* Write Buffer                                       */f #define CMD_ATA_IDENTIFY_DEV             0xEC	/* Identify Device                                    */f #define CMD_ATA_MEDIA_EJECT              0xED	/* Media Eject                                        */f #define CMD_ATA_IDENTIFY_DEV_DMA         0xEE	/* Identify Device DMA                                */f #define CMD_ATA_SET_FEATURES             0xEF	/* Set Features                                       */  f #define CMD_ATA_SECUR_SET_PSWD           0xF1	/* Security Set Password                              */f #define CMD_ATA_SECUR_UNLOCK             0xF2	/* Security Unlock                                    */f #define CMD_ATA_SECUR_ERASE_PREPARE      0xF3	/* Security Erase Prepare                             */f #define CMD_ATA_SECUR_ERASE_UNIT         0xF4	/* Security Erase Unit                                */f #define CMD_ATA_SECUR_FREEZE_LOCK        0xF5	/* Security Freeze Lock                               */f #define CMD_ATA_SECUR_DSBL_PSWD          0xF6	/* Security Disable Password                          */     l /* ATAPI Commands   *	  * Notes:   *1  *  o These commands are issued in ATAPI packets.O  *>  *  o These commands are now defined by Annex B of the "SCSI-3<  *     Multi-Media Commands". Details of the commands can be-  *     found in several different SCSI specs:*  *,  *        - SCSI-3 Primary Commands    (SPC),  *        - SCSI-3 Block Commands      (SBC),  *        - SCSI-3 Multimedia Commands (MMC)  *  *(  *  o This list is complete as of MMC-3.  *  */r  f #define CMD_ATAPI_TEST_UNIT_READY        0x00	/* Test Unit Ready                              (SPC) */f #define CMD_ATAPI_REQUEST_SENSE          0x03	/* Request Sense                                (SPC) */f #define CMD_ATAPI_FORMAT_UNIT            0x04	/* Format Unit                                        */  f #define CMD_ATAPI_INQUIRY                0x12	/* Inquiry                                      (SPC) */f #define CMD_ATAPI_START_STOP_UNIT        0x1B	/* Start/Stop Unit                              (SBC) */f #define CMD_ATAPI_PREVENT_ALLOW          0x1E	/* Prevent/Allow Medium Removal                 (SPC) */  f #define CMD_ATAPI_READ_CAPACITY          0x25	/* Read Recorded Capacity                             */f #define CMD_ATAPI_READ_10                0x28	/* Read (10)                                    (SBC) */f #define CMD_ATAPI_WRITE_10               0x2A	/* Write (10)                                   (SBC) */f #define CMD_ATAPI_SEEK                   0x2B	/* Seek                                         (SBC) */  f #define CMD_ATAPI_SYNCHRONIZE_CACHE      0x35	/* Synchronize Cache                                  */  f #define CMD_ATAPI_READ_SUBCHANNEL        0x42	/* Read Sub-channel                                   */f #define CMD_ATAPI_READ_TOC_PMA_ATIP      0x43	/* Read TOC/PMA/ATIP                                  */f #define CMD_ATAPI_READ_HEADER            0x44	/* Read Header                                        */f #define CMD_ATAPI_PLAY_AUDIO_10          0x45	/* Play Audio (10)                                    */f #define CMD_ATAPI_PLAY_AUDIO_MSF         0x47	/* Play Audio MSF                                     */f #define CMD_ATAPI_PAUSE_RESUME           0x4B	/* Pause/Resume                                       */f #define CMD_ATAPI_STOP_PLAY_SCAN         0x4E	/* Stop Play/Scan                                     */  f #define CMD_ATAPI_READ_DISK_INFORMATION  0x51	/* Read Disk Information                              */f #define CMD_ATAPI_READ_TRACK_INFORMATION 0x52	/* Read Track Information                             */f #define CMD_ATAPI_RESERVE_TRACK          0x53	/* Reserve Track                                      */f #define CMD_ATAPI_SEND_OPC_INFORMATION   0x54	/* Send OPC Information                               */f #define CMD_ATAPI_MODE_SELECT_10         0x55	/* Mode Select (10)                             (SPC) */f #define CMD_ATAPI_REPAIR_TRACK           0x58	/* Repair Track                                       */f #define CMD_ATAPI_READ_MASTER_CUE        0x59	/* Read Master Cue                                    */f #define CMD_ATAPI_MODE_SENSE_10          0x5A	/* Mode Sense (10)                              (SPC) */f #define CMD_ATAPI_CLOSE_TRACK_SESSION    0x5B	/* Close Track/Session                                */f #define CMD_ATAPI_READ_BUFFER_CAPACITY   0x5C	/* Read Buffer Capacity                               */f #define CMD_ATAPI_SEND_CUE_SHEET         0x5D	/* Send Cue Sheet                                     */  f #define CMD_ATAPI_60                     0x60	/* Unused group 0x6n                                  */  f #define CMD_ATAPI_70                     0x70	/* Unused group 0x7n                                  */  f #define CMD_ATAPI_80                     0x80	/* Unused group 0x8n                                  */  f #define CMD_ATAPI_90                     0x90	/* Unused group 0x9n                                  */  f #define CMD_ATAPI_BLANK                  0xA1	/* Blank                                              */f #define CMD_ATAPI_PLAY_AUDIO_12          0xA5	/* Play Audio (12)                                    */f #define CMD_ATAPI_LOAD_UNLOAD_CD         0xA6	/* Load/Unload CD                                     */f #define CMD_ATAPI_READ_12                0xA8	/* Read (12)                                    (SBC) */f #define CMD_ATAPI_WRITE_12               0xAA	/* Write (12)                                   (SBC) */  f #define CMD_ATAPI_READ_CD_MSF            0xB9	/* Read CD MSF                                        */f #define CMD_ATAPI_SCAN                   0xBA	/* Scan                                               */f #define CMD_ATAPI_SET_CD_SPEED           0xBB	/* Set CD Speed                                       */f #define CMD_ATAPI_PLAY_CD                0xBC	/* Play CD                                            */f #define CMD_ATAPI_MECHANISM_STATUS       0xBD	/* Mechanism Status                                   */f #define CMD_ATAPI_READ_CD                0xBE	/* Read CD                                            */  f #define CMD_ATAPI_C0                     0xC0	/* Unused group 0xCn                                  */  f #define CMD_ATAPI_D0                     0xD0	/* Unused group 0xDn                                  */  f #define CMD_ATAPI_E0                     0xE0	/* Unused group 0xEn                                  */  f #define CMD_ATAPI_F0                     0xF0	/* Unused group 0xFn                                  */     *E /* Set up the table for CRAM initialization.  This table contains the-D  * CSR offset, the command used in this CRAM and the byte lane shift=  * value.  The byte lane shift value is computed at run time.   *  */i   typedef struct/   {					/* The CRAM initialization structure */ #     int cmd;				/* Command index */c(     int offset;				/* Register offset */-     int shift;				/* Byte lane shift count */        } cram_item;      4 /* Define the indices in this (and the UCB) table */   #define RD_DATA         0O #define WT_DATA         1    #define RD_ERROR        2d #define WT_FEATURES     3    #define RD_SEC_CNT      4c #define WT_SEC_CNT      5u   #define RD_SECTOR       6  #define WT_SECTOR       7	   #define RD_CYL_LO       8  #define WT_CYL_LO       9e   #define RD_CYL_HI      10i #define WT_CYL_HI      11    #define RD_DRV_HD      12r #define WT_DRV_HD      13    #define RD_STS         14i #define WT_CMD         15s     /* Control Block Crams */c   #define RD_ALT_STS      16 #define WT_DEV_CTL      17     /* DMA (SFF-8038i) CRAMs */s   #define RD_DMA_CMD     18  #define WT_DMA_CMD     19e   #define RD_DMA_DS1     20  #define WT_DMA_DS1     21c   #define RD_DMA_STS     22lA #define WT_DMA_STS     23               /* Probably Read-ONLY! */n   #define RD_DMA_DS2     24  #define WT_DMA_DS2     25	   #define RDL_DMA_AD0    26n #define WTL_DMA_AD0    27e   #define RD_DMA_AD0     28* #define WT_DMA_AD0     29	   #define RD_DMA_AD1     30L #define WT_DMA_AD1     31    #define RD_DMA_AD2     32_ #define WT_DMA_AD2     33i   #define RD_DMA_AD3     34f #define WT_DMA_AD3     35o eG #define cram_def(cmd,csr) CRAMCMD$K_##cmd##32, ##csr, ((##csr & 3) <<3)D  & cram_item cram_init[NUMBER_OF_CRAMS] = {      /* Command Block crams */      cram_def(RDWORD,REG_DATA),     cram_def(WTWORD,REG_DATA),       cram_def(RDBYTE,REG_ERROR),d"     cram_def(WTBYTE,REG_FEATURES),  !     cram_def(RDBYTE,REG_SEC_CNT),o!     cram_def(WTBYTE,REG_SEC_CNT),*        cram_def(RDBYTE,REG_SECTOR),      cram_def(WTBYTE,REG_SECTOR),        cram_def(RDBYTE,REG_CYL_LO),      cram_def(WTBYTE,REG_CYL_LO),        cram_def(RDBYTE,REG_CYL_HI),      cram_def(WTBYTE,REG_CYL_HI),        cram_def(RDBYTE,REG_DRV_HD),      cram_def(WTBYTE,REG_DRV_HD),        cram_def(RDBYTE,REG_STATUS),     cram_def(WTBYTE,REG_CMD),	       /* Control Block crams */T!     cram_def(RDBYTE,REG_ALT_STS),e!     cram_def(WTBYTE,REG_DEV_CTL),W       /* DMA (SFF-8038i) CRAMs */      cram_def(RDBYTE,DMA_CMD),T     cram_def(WTBYTE,DMA_CMD),/       cram_def(RDBYTE,DMA_DS1),;     cram_def(WTBYTE,DMA_DS1),        cram_def(RDBYTE,DMA_STS),fZ     cram_def(WTBYTE,DMA_STS),           /* Probably read-only register --  Don't write! */       cram_def(RDBYTE,DMA_DS2),      cram_def(WTBYTE,DMA_DS2),s       cram_def(RDLONG,DMA_AD0),A     cram_def(WTLONG,DMA_AD0),f       cram_def(RDBYTE,DMA_AD0),C     cram_def(WTBYTE,DMA_AD0),R       cram_def(RDBYTE,DMA_AD1),      cram_def(WTBYTE,DMA_AD1),C       cram_def(RDBYTE,DMA_AD2),      cram_def(WTBYTE,DMA_AD2),R       cram_def(RDBYTE,DMA_AD3),A     cram_def(WTBYTE,DMA_AD3) };  N /* Define Device-Dependent Unit Control Block with extensions for DQ device */  & #define MAX_DIAGNOSE_COMMAND_LENGTH 12+ #define MAX_DIAGNOSE_DATA_SIZE BLK_SIZE_64Kx #define MIN(x,y) (x<y?x:y)    typedef struct _diagnose_param {     UINT opcode;     UINT flags;3     unsigned char *command;      UINT command_length;     unsigned char *data;     UINT data_length;s     UINT pad_length;     UINT phase_timeout;      UINT disconnect_timeout; } DIAGNOSE_PARAM;r                typedef struct   {3N     DT_UCB ucb$r_dtucb;			/* Generic UCB                                    */A     union				/* LBN as a longword (LBN) or CHS                 */        {OH         UINT lbn;			/* Block number                                   */         struct           {zL             BYTE sec;			/* Sector number                                  */L             BYTE trk;			/* Track number                                   */L             WORD cyl;			/* Cylinder number                                */               } pa;i           } ucb$l_media;L     int    ucb$l_bcr;			/* Byte count remaining                           */Q     UINT   ucb$l_org_media;		/* Original LBN                                   */uS     void   *ucb$l_org_svapte;		/* Original SVAPTE address                        */GP     UINT   ucb$l_org_bcnt;		/* Original byte count                            */P     UINT   ucb$l_org_boff;		/* Original byte offset                           */P     UINT   ucb$l_drv_head;		/* Drive/head info                                */N     KPB    *ucb$ps_kpb;			/* KPB pointer                                    */\     CRAM   *ucb$ps_crams[NUMBER_OF_CRAMS];/* Table of CRAMs                               */U     UINT   *ucb$ps_xfer_buffer;		/* Transfer buffer pointer                        */ U     UINT   *ucb$ps_sense_buffer;	/* Sense buffer pointer                           */aR     int    ucb$l_dummy_flgs;		/* ASCII-tag the beginning of flag words          */X     UINT   ucb$l_drive_lba_capable;	/* 0=CSH, 1=Drive is capable of LBA addressing    */X     UINT   ucb$l_drive_dma_capable;	/* 0=PIO, 1=Drive is capable of DMA               */O     int    ucb$l_ctrl_id;		/* PCIbus ID of the controller                    */7W     UINT   ucb$l_ctrl_dma_capable;	/* 0=PIO, 1=Controller is capable of DMA          */ R     UINT   ucb$l_atapi_flag;		/* 0=ATA, 1=ATAPI                                 */O     UINT   ucb$l_2K_flag;		/* 0=512 byte blocks, 1=CD-ROM-style 2KB blocks   */	R     int    ucb$l_dummy_sens;		/* ASCII-tag the beginning of saved sense keys    */Q     UINT   ucb$l_sense_key;		/* Latest sense key                               */hL     UINT   ucb$l_asc;			/* Latest additional sense code                   */M     UINT   ucb$l_ascq;			/* Latest additional sense code qualifier         */ S     PTE    *ucb$ps_s0_svapte;		/* Pointer to base SPTE                           */oO     BYTE   *ucb$ps_s0_va;		/* Pointer to user buffer                         */ L     uint64 ucb$q_iohandle_1;		/* Handle for command block I/O registers	  */L     uint64 ucb$q_iohandle_2;		/* Handle for control block I/O registers	  */\     uint64 ucb$q_iohandle_3;            /* Handle for dma controller registers            */V     int    ucb$l_unsolicited_int;	/* An unsolicited interrupt is pending            */R     int    ucb$l_dummy_pakt;		/* ASCII-tag the beginning of saved packet        */R     BYTE   ucb$b_packet[12];		/* The most-recent ATAPI packet                   */R     int    ucb$l_dummy_ints;		/* ASCII-tag the total interrupts                 */R     int    ucb$l_total_ints;		/* Total interrupts count                         */R     int    ucb$l_dummy_unso;		/* ASCII-tag the unsolicited interrupts           */R     int    ucb$l_unsol_ints;		/* Count of unsolicited interrupts                */R     int    ucb$l_dummy_hist;		/* ASCII-tag the beginning of interrupt histogram */k     int    ucb$l_int_hist[TIMEOUT_TIME+1];/* Timeout histogram vector, allowing an entry for [0] as well */ T     int    ucb$l_int_max_wait;		/* Maximum initerupt time we wait for interrupt   */Q     int    ucb$l_dummy_tmo;		/* ASCII-tag the count of interrupt timeouts      */	O     int    ucb$l_int_tmo;		/* Count interrupt timeouts                       */fT     int    ucb$l_dummy_resets;		/* ASCII-tag the count of drive resets            */N     int    ucb$l_resets;		/* Count of drive resets issued by us             */S     int    ucb$l_dummy_trace;		/* ASCII-tag the trace-buffer pointer and index   */IP     int    *ucb$l_trc_buf;		/* Pointer to the tracing buffer                  */Q     int    ucb$l_trc_index;		/* Current index within the tracing buffer        */iP     int    ucb$l_trc_unit;		/* DQA0:=1, DQA1:=2, DQB0:=3, DQB1:=4             */N     int    *ucb$l_prdt;			/* Pointer to the PRDT                            */T     CRCTX  *ucb$ps_prdt_crctx;		/* Pointer to the PRDT map-register CRCTX         */Q     void   *ucb$l_prdt_phy;		/* Pointer to the PRDT PCIbus (DMA) address       */	T     CRCTX  *ucb$ps_xfer_crctx;		/* Pointer to the xfer buffer map-register CRCTX  */Q     void   *ucb$l_xfer_phy;		/* Pointer to the xfer buffer PCIbus (DMA) adx    */ \     int    ucb$l_prog_intfc;            /* program interface mode, 0=legacy !0 = native   */\     int    ucb$l_primary;               /* 1=primary channel, 0=secondary channel         */ 					 ' 					/* Diagnose command information */c     UINT diagnose_opcode;      UINT diagnose_flags;@     unsigned char diagnose_command[MAX_DIAGNOSE_COMMAND_LENGTH];!     UINT diagnose_command_length;*     UINT diagnose_data_length;     UINT diagnose_pad_length;p      UINT diagnose_phase_timeout;%     UINT diagnose_disconnect_timeout;o  Q     int    ucb$l_dummy_end;		/* ASCII-tag the end of the UCB                   */        } DQ_UCB; +                                            g  C #define ucb$r_dq_ucb ucb$r_dtucb.ucb$r_dpucb.ucb$r_erlucb.ucb$r_ucbZ9 #define ucb$r_dq_erl ucb$r_dtucb.ucb$r_dpucb.ucb$r_erlucbE, #define ucb$r_dq_dp  ucb$r_dtucb.ucb$r_dpucb  #define ucb$r_dq_dt  ucb$r_dtucb  ! #define baseucb ucb->ucb$r_dq_ucb '                                        c   o/ /* Define the Identify Drive information bufferu@  *   Use the nomember_alignment to make sure that this structure   *   matches what the drive uses  *  */a   #pragma member_alignment save + #pragma nomember_alignment                 f   typedef structD   {					/* Word(s):  ATA-5 description                            */A 					/*--------------------------------------------------------*/tP     WORD  config;			/*  0:       Configuration information                    */O     WORD  cyls;				/*  1:       Number of cylinders                          */-O     WORD  rsvd2;			/*  2:       Reserved word                                */eO     WORD  heads;			/*  3:       Number of heads                              */iV     WORD  ubytes_track;			/*  4:       Unformatted bytes/track           (retired)  */V     WORD  ubytes_sector;		/*  5:       Unformatted bytes/sector          (retired)  */Q     WORD  sectors;			/*  6:       Number of sectors                            */ T     WORD  unique7[3];			/*  7-9:     Vendor unique                     (retired)  */Z     char  serial_number[20];		/*  10-19:   ASCII serial number                          */U     WORD  buffer_type;			/*  20:      Buffer type (retired)                        */ [     WORD  buffer_size_blocks;		/*  21:      Buffer size (in blocks)           (retired)  */;S     WORD  ecc_bytes;			/*  22:      Number of ECC bytes/sector        (obsolete) */y]     char  firmware_revision[8];		/*  23-26:   ASCII firmware revision                      */hb     char  model_number[MODEL_LENGTH];	/*  27-46:   ASCII drive model                            */U     BYTE  rw_multiple;			/*  47:      Max number of sectors/interrupt              */ R     BYTE  unique47;			/*  47.5:    0x80                                         */P     WORD  rsvd48;			/*  48:      Reserved                                     */X     WORD  capabilities_49;		/*  49:      Capabilities                                 */X     WORD  capabilities_50;		/*  50:      More Capabilities                            */S     WORD  pio_cycle;			/*  51:      PIO data transfer mode                       */lS     WORD  dma_cycle;			/*  52:      DMA I/O cycle times               (retired)  */ T     WORD  valid_bits;			/*  53:      Valid bits for several fields                */S     WORD  curr_cyls;			/*  54:      Current logical cylinder count               */4T     WORD  curr_heads;			/*  55:      Current logical head count                   */V     WORD  curr_sectors;			/*  56:      Current logical sector count                 */V     int   curr_capacity;		/*  57-58:   Current capacity in sectors                  */Y     WORD  multiple_sectors;		/*  59:      Current sectors/interrupt setting            */ Y     UINT  lba_total_blocks;		/*  60-61:   Total number of user-adx'ible sectors        */TX     WORD  single_word_dma;		/*  62:      Single word DMA info              (retired)  */W     WORD  multi_word_dma;		/*  63:      Multi word DMA info                          */R\     WORD  pio_modes_supported;		/*  64:      Advanced PIO modes supported                 */[     WORD  min_dma_cycle_time;		/*  65:      Min multiword DMA transfer cycle time        */f[     WORD  rec_dma_cycle_time;		/*  66:      Rec multiword DMA transfer cycle time        */ [     WORD  min_pio_cycle_time;		/*  67:      Min non-IORDY PIO transfer cycle time        */ `     WORD  min_iordy_pio_cycle_time;	/*  68:      Min IORDY PIO transfer cycle time            */P     WORD  rsvd69;			/*  69:      Reserved (for command queuing)               */P     WORD  rsvd70;			/*  70:      Reserved (for command queuing)               */W     WORD  atapi_pkt_time;		/*  71:      ns from PACKET cmd to bus release (ATAPI)    */bW     WORD  atapi_svc_time;		/*  72:      ns from SERVICE to clearing BSY   (ATAPI)    */0P     WORD  rsvd73;			/*  73:      Reserved                          (ATAPI)    */P     WORD  rsvd74;			/*  74:      Reserved                          (ATAPI)    */U     WORD  queue_depth;			/*  75:      Maximum queue depth                          */LP     WORD  rsvd76;			/*  76:      Reserved                                     */P     WORD  rsvd77;			/*  77:      Reserved                                     */P     WORD  rsvd78;			/*  78:      Reserved                                     */P     WORD  rsvd79;			/*  79:      Reserved                                     */]     WORD  major_version_number;		/*  80:      Major version number (e.g, 4=ATA/ATAPI-4)    */e]     WORD  minor_version_number;		/*  81:      Minor version number                         */n\     WORD  cmd_set_supported_1;		/*  82:      Command set supported, word 1                */\     WORD  cmd_set_supported_2;		/*  83:      Command set supported, word 2                */\     WORD  cmd_set_supported_x;		/*  84:      Command set supported, extension             */Z     WORD  cmd_set_enabled_1;		/*  85:      Command set enabled, word 1                  */Z     WORD  cmd_set_enabled_2;		/*  86:      Command set enabled, word 2                  */X     WORD  cmd_set_default;		/*  87:      Command set default                          */S     WORD  ultra_dma;			/*  88:      Ultra DMA control                            */ R     WORD  dse_time;			/*  89:      Data Security Erase time (~secs/2)           */Z     WORD  enhanced_dse_time;		/*  90:      Enhanced Data Security Erase time (~secs/2)  */V     WORD  cur_apm_value;		/*  91:      Current Advanced Power Management value      */Z     WORD  master_passwd_rev;		/*  92:      Master Password Revision Code                */T     WORD  rsvd94[33];			/*  94-126:  Reserved                                     */a     WORD  media_status_notification;	/*  127:     Removable Media Status Notification          */ X     WORD  security_status;		/*  128:     Security Status                              */\     WORD  vendor_specific[31];		/*  129-159: Vendor specific                              */U     WORD  rsvd160[96];			/*  160-255: Reserved                                     */n       } ID_PAGE;    #pragma member_alignment restore   /* Capabilities bits */N2 #define  CAP_M_LBA  0x200			/* Handles LBA mode */- #define  CAP_M_DMA  0x100			/* Handles DMA */e     A6 #define IS_SET(   reg, bits ) ( (reg & bits) == bits )6 #define IS_CLEAR( reg, bits ) ( (reg & bits) == 0    )  8 #define $SUCCESS( code )  ( (code & STS$M_SUCCESS) == 1)8 #define $FAIL( code )     ( (code & STS$M_SUCCESS) == 0)   #define TRUE    1_ #define FALSE   0A      ; /* Prototypes for driver routines defined in this module */2         i int     atapi_packet_command(     DQ_UCB *ucb, BYTE *buffer, int xfer_req, int *xfer_cnt, int dma_flag ); 8 								/* xfer_req is implicit in the command packet */0 int     atapi_process_size(       DQ_UCB *ucb );> int     atapi_read_capacity(      DQ_UCB *ucb, BYTE *buffer );> int     atapi_request_sense(      DQ_UCB *ucb, BYTE *buffer );0 int     atapi_xlate_error_to_vms( DQ_UCB *ucb ); #ifdef BREAKPOINTS9 void    call_ini$brk( int code, int p1, int p2, int p3 );l #endifO void    compute_address(          DQ_UCB *ucb, int *sec, int *head, int *cyl );/8 int     ctrl_init(       IDB *idb, DDB *ddb, CRB *crb );0 int     datacheck(                DQ_UCB *ucb );/ int     diagnose(                 DQ_UCB *ucb);dN int     diagnose_fdt(             IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb );A int     dq_wfikpch(      KPB *kpb, int orig_ipl, int erl_param );CE int     dq_dma_wfikpch(      KPB *kpb, int orig_ipl, int erl_param );  int     driver$init_tables();s0 int     drvclr(                   DQ_UCB *ucb );= void    get_geom(                UINT volsize, DQ_UCB *ucb );_T int     fetch_drive_info(         DQ_UCB *ucb, int atapi_flag, int init_time_flag );0 int     fill_packet_w_adx(        DQ_UCB *ucb );9 BYTE    inp(                      DQ_UCB *ucb, int reg );S9 WORD    inpw(                     DQ_UCB *ucb, int reg ); # void    isr(             IDB *idb);20 void    load_prdt(                DQ_UCB *ucb );H BYTE   *map_user_buffer(          DQ_UCB *ucb, int offset, int length );M void    move_sec_from_drive(      DQ_UCB *ucb, BYTE *buffer, int bytecount );AM void    move_sec_to_drive(        DQ_UCB *ucb, BYTE *buffer, int bytecount ); D void    out(                      DQ_UCB *ucb, int reg, BYTE data );D void    outw(                     DQ_UCB *ucb, int reg, WORD data );D void    outw_t(                   DQ_UCB *ucb, int reg, WORD data );0 void	outl(			  DQ_UCB *ucb, int reg, int data );D int     packack(                  DQ_UCB *ucb, int init_time_flag );0 int     process_drive_info(       DQ_UCB *ucb );E int     rct_fdt(         IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb );DE int     rdstats_fdt(     IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb );	3 int     io_read(                     DQ_UCB *ucb );dm int     read_ata_seg_pio(         DQ_UCB *ucb, int xfer_req, int *xfer_cnt );	/* Buffer adx comes from UCB */em int     read_ata_seg_dma(         DQ_UCB *ucb, int xfer_req, int *xfer_cnt );	/* Buffer adx comes from UCB */M[ int     read_atapi_512_seg(       DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag );M) 										/* Buffer adx comes from UCB */	[ int     read_atapi_2K_seg     (   DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag ); ) 										/* Buffer adx comes from UCB */lM int     read_dispatcher(          DQ_UCB *ucb, int xfer_req, int *xfer_cnt );*0 int     readrct(                  DQ_UCB *ucb );@ void    regdump(         BYTE *buffer, int arg_2, DQ_UCB *ucb );0 int     reset_ctrl(               DQ_UCB *ucb );0 int     seek(                     DQ_UCB *ucb );H int     set_features(             DQ_UCB *ucb, int feature, int value );0 int     set_geom(                 DQ_UCB *ucb );= int     sleep(                    DQ_UCB *ucb, int seconds );0$ void    startio(         KPB *kpb );O void    struc_init(      CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb );*O void    struc_reinit(    CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb );u #ifdef TRACINGC void    trace(                    DQ_UCB *ucb, int code, int bpt );i #endif1 int     unit_init(       IDB *idb, DQ_UCB *ucb );n< void    unit_init_fork(  void *fr3, IDB *idb, DQ_UCB *ucb );0 int     unload(                   DQ_UCB *ucb );0 int     wait_busy(                DQ_UCB *ucb );0 int     wait_drq(                 DQ_UCB *ucb );0 int     wait_ready(               DQ_UCB *ucb );0 int     io_write(                 DQ_UCB *ucb );m int     write_ata_seg_pio(        DQ_UCB *ucb, int xfer_req, int *xfer_cnt );	/* Buffer adx comes from UCB */em int     write_ata_seg_dma(        DQ_UCB *ucb, int xfer_req, int *xfer_cnt );	/* Buffer adx comes from UCB */t[ int     write_atapi_512_seg(      DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag );P) 										/* Buffer adx comes from UCB */a[ int     write_atapi_2K_seg(       DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag );a) 										/* Buffer adx comes from UCB */oM int     write_dispatcher(         DQ_UCB *ucb, int xfer_req, int *xfer_cnt );   Z /* following is a modified prototype for exe_std$alononpaged in [lib_h]exe_routines.h   */T int   exe$alononpaged_aln (int reqsize, int align, void **pool_p, int32 *alosize_p);       #ifdef TRACE_PER_DRIVE  V /* TRACE - This routine is used to write a debugging entry in our tracing tumble-table  *	  * Input:r"  *      ucb     pointer to the UCB5  *      data    A longword to be written to the table*Q  *      bpt     A flag as to whether or not to do a breakpoint trap after tracing   *
  * Output:  *      none  *  * Side effect(s):8  *   The tracing buffer and its index value are updated.  *   ini$brk may be invoked.  *  */   , void trace( DQ_UCB *ucb, int code, int bpt )     {S  &     ADP *adp;					/* Address of ADP */9     int *ptr;					/* Bind onto the ucb's pointer value */E4     int save_ipl;				/* Place to save the old IPL */  5     adp = baseucb.ucb$ps_adp;			/* Get ADP address */ >     device_lock( adp->adp$ps_spinlock, RAISE_IPL, &save_ipl );- 						/* Ensure exclusive access at IPL 31 */   >     ptr = &ucb->ucb$l_trc_index;		/* Fill our local pointer */j     code = code | (ucb->ucb$l_trc_unit<<28);	/* Shift the unit into the high nibble, .OR. into the code */C     ucb->ucb$l_trc_buf[*ptr] = code;		/* Save the new trace code */ (     (*ptr)++;					/* Bump the pointer */0     if (*ptr >= TRACING)			/* Beyond the end? */6       *ptr = 0;					/* If so, back to the beginning */K     ucb->ucb$l_trc_buf[*ptr] = 0x0FEEEEEE;	/* Mark the current end point */   A     device_unlock( adp->adp$ps_spinlock, save_ipl, SMP_RESTORE );    #ifdef BREAKPOINTS5 						/* Release exclusive access, back to old IPL */ :     if (bpt)					/* Does this caller want a breakpoint? */X         call_ini$brk( code, (int) ucb, (int) ucb->ucb$l_trc_buf, ucb->ucb$l_trc_index ); 						/* If so, make it so *// #endif         }N    2 #define TRACE( data )    trace( ucb, data, FALSE )2 #define BPTRACE( data )  trace( ucb, data, TRUE  )   #endif       #ifdef TRACE_COMMONr  V /* TRACE - This routine is used to write a debugging entry in our tracing tumble-table  *	  * Input:a"  *      ucb     pointer to the UCB5  *      data    A longword to be written to the tablelQ  *      bpt     A flag as to whether or not to do a breakpoint trap after tracing   *
  * Output:  *      none  *  * Side effect(s):8  *   The tracing buffer and its index value are updated.  *   ini$brk may be invoked.  *  */   , void trace( DQ_UCB *ucb, int code, int bpt )     {   &     ADP *adp;					/* Address of ADP */4     int save_ipl;				/* Place to save the old IPL */  5     adp = baseucb.ucb$ps_adp;			/* Get ADP address */ >     device_lock( adp->adp$ps_spinlock, RAISE_IPL, &save_ipl );- 						/* Ensure exclusive access at IPL 31 */   j     code = code | (ucb->ucb$l_trc_unit<<28);	/* Shift the unit into the high nibble, .OR. into the code */>     trc_buf[trc_index] = code;			/* Save the new trace code */*     trc_index++;				/* Bump the pointer */5     if (trc_index >= TRACING)			/* Beyond the end? */*:       trc_index = 0;				/* If so, back to the beginning */F     trc_buf[trc_index] = 0x0FEEEEEE;		/* Mark the current end point */  A     device_unlock( adp->adp$ps_spinlock, save_ipl, SMP_RESTORE );0   #ifdef BREAKPOINTS5 						/* Release exclusive access, back to old IPL */_:     if (bpt)					/* Does this caller want a breakpoint? */B         call_ini$brk( code, (int) ucb, (int) trc_buf, trc_index ); 						/* If so, make it so */( #endif         }     2 #define TRACE( data )    trace( ucb, data, FALSE )2 #define BPTRACE( data )  trace( ucb, data, TRUE  )   #endif    I /* One way or another, make sure we have TRACE and BPTRACE macros definede  *0  * If neither real tracing routine defined them,  * then define them as nothing.t  *  */e  
 #ifndef TRACE  #define TRACE( data )_ #define BPTRACE( data )0 #endif      2 /* Define or null-out the debugging breakpoints */   #ifdef BREAKPOINTS  ? /* CALL_INI$BRK - This routine is used to help debug the driver   *	  * Input:n8  *      code    A code to clue me in as to who called us7  *      ucb     The affected unit's ucb, also as a clueR  *
  * Output:D  *      The side-effect of a breakpoint trap if XDELTA is installed.$  *      Look in R16 to see the code.6  *      Typically, look in R17 to see the ucb address.<  *      Typically, look in R18 to see the trace buffer base.=  *      Typically, look in R19 to see the trace buffer index._  *  */D  5 void call_ini$brk( int code, int p1, int p2, int p3 )    { (     ini$brk( );					/* And then break */       }     C #define BREAK( code, p1, p2, p3 )  call_ini$brk( code, p1, p2, p3 )f   #elseT  ! #define BREAK( code, p1, p2, p3 )i   #endif  ? #define insque(x,y) (__PAL_INSQUEL_D((void **)(x),(void *)(y)))CC #define remque(x,y) (__PAL_REMQUEL_D((void **)(x),(void **)(y))>=0)     0 /* DRIVER$INIT_TABLES - Initialize Driver Tables  *F  * This routine is used to initialize the driver tables.  The DPT, DDT!  * and FDT structures are set up.a  *	  * Usage:E&  *      status = driver$init_tables();  *	  * Input:E  *      none  *
  * Output:  *      none  *  * Return value:1  *      SS$_NORMAL  -- tables successfully set up   *  */E   int driver$init_tables( void )     {   ^ /*  BREAK( 0x00010000, 0, 0, 0 );				/@ BREAK: driver$init_tables called -- Can't TRACE yet */  > /* Finish initialization of the Driver Prologue Table (DPT) */  A     ini_dpt_name(         &_dpt, "DQDRIVER" );		/* Driver name */ A     ini_dpt_adapt(        &_dpt, AT$_ISA );		/* ISA bus device */ 9     ini_dpt_flags(        &_dpt, DPT$M_SMPMOD|DPT$M_SVP);  							/* Set flags */9     ini_dpt_maxunits(     &_dpt, 4 );			/* 4 units max */_A     ini_dpt_ucbsize(      &_dpt, sizeof(DQ_UCB) );	/* UCB size */ H     ini_dpt_struc_init(   &_dpt, struc_init );		/* Structure init rtn */K     ini_dpt_struc_reinit( &_dpt, struc_reinit );	/* Structure reinit rtn */JM     ini_dpt_ucb_crams(    &_dpt, NUMBER_OF_CRAMS );	/* Allocate some CRAMs */ (     ini_dpt_end(          &_dpt );        > /* Finish initialization of the Driver Dispatch Table (DDT) */  I     ini_ddt_ctrlinit(      &_ddt, ctrl_init );		/* Controller init rtn */ C     ini_ddt_unitinit(      &_ddt, unit_init );		/* Unit init rtn */	R     ini_ddt_start(         &_ddt, exe_std$kp_startio );	/* Exec's Start I/O rtn */F     ini_ddt_kp_startio(    &_ddt, startio );		/* KP's Start I/O rtn */K     ini_ddt_kp_stack_size( &_ddt, KPB$K_MIN_IO_STACK );	/* KP stack size */ O     ini_ddt_kp_reg_mask(   &_ddt, KPREG$K_HLL_REG_MASK );/* KP register mask */SF     ini_ddt_cancel(        &_ddt, ioc_std$cancelio );	/* Cancel rtn */I     ini_ddt_regdmp(        &_ddt, regdump );		/* Register dump routine */ H     ini_ddt_erlgbf(        &_ddt, ERR_BYTES );		/* Set error log size */"     ini_ddt_end(           &_ddt);  @ /* Finish initialization of the Function Decision Table (FDT) */  K     ini_fdt_act( &_fdt, IO$_READLBLK,   acp_std$readblk,     DIRECT_64   ); K     ini_fdt_act( &_fdt, IO$_READPBLK,   acp_std$readblk,     DIRECT_64   ); K     ini_fdt_act( &_fdt, IO$_READVBLK,   acp_std$readblk,     DIRECT_64   );3K     ini_fdt_act( &_fdt, IO$_WRITECHECK, acp_std$readblk,     DIRECT_64   );   K     ini_fdt_act( &_fdt, IO$_WRITELBLK,  acp_std$writeblk,    DIRECT_64   );sK     ini_fdt_act( &_fdt, IO$_WRITEPBLK,  acp_std$writeblk,    DIRECT_64   ); K     ini_fdt_act( &_fdt, IO$_WRITEVBLK,  acp_std$writeblk,    DIRECT_64   );E  K     ini_fdt_act( &_fdt, IO$_ACCESS,     acp_std$access,      BUFFERED    );fK     ini_fdt_act( &_fdt, IO$_CREATE,     acp_std$access,      BUFFERED    );   K     ini_fdt_act( &_fdt, IO$_DEACCESS,   acp_std$deaccess,    BUFFERED    );y  K     ini_fdt_act( &_fdt, IO$_ACPCONTROL, acp_std$modify,      BUFFERED    );IK     ini_fdt_act( &_fdt, IO$_DELETE,     acp_std$modify,      BUFFERED    );nK     ini_fdt_act( &_fdt, IO$_MODIFY,     acp_std$modify,      BUFFERED    ); 6                                                       K     ini_fdt_act( &_fdt, IO$_MOUNT,      acp_std$mount,       BUFFERED    );   K     ini_fdt_act( &_fdt, IO$_READRCT,    rct_fdt,             DIRECT      ); K     ini_fdt_act( &_fdt, IO$_RDSTATS,    rdstats_fdt,         DIRECT      );   K     ini_fdt_act( &_fdt, IO$_UNLOAD,     exe_std$lcldskvalid, BUFFERED_64 ); K     ini_fdt_act( &_fdt, IO$_AVAILABLE,  exe_std$lcldskvalid, BUFFERED_64 );MK     ini_fdt_act( &_fdt, IO$_PACKACK,    exe_std$lcldskvalid, BUFFERED_64 );   K     ini_fdt_act( &_fdt, IO$_NOP,        exe_std$zeroparm,    BUFFERED_64 );nK     ini_fdt_act( &_fdt, IO$_DRVCLR,     exe_std$zeroparm,    BUFFERED_64 ); K     ini_fdt_act( &_fdt, IO$_RELEASE,    exe_std$zeroparm,    BUFFERED_64 );M  K     ini_fdt_act( &_fdt, IO$_SEEK,       exe_std$oneparm,     BUFFERED    ); K     ini_fdt_act( &_fdt, IO$_FORMAT,     exe_std$oneparm,     BUFFERED    );)  K     ini_fdt_act( &_fdt, IO$_SETMODE,    exe_std$setchar,     BUFFERED_64 ); K     ini_fdt_act( &_fdt, IO$_SETCHAR,    exe_std$setchar,     BUFFERED_64 );T  K     ini_fdt_act( &_fdt, IO$_SENSEMODE,  exe_std$sensemode,   BUFFERED_64 ); K     ini_fdt_act( &_fdt, IO$_SENSECHAR,  exe_std$sensemode,   BUFFERED_64 );   F     ini_fdt_act( &_fdt, IO$_DIAGNOSE,   diagnose_fdt,        DIRECT );       ini_fdt_end( &_fdt );a  C /* If we got this far then everything worked, so return success. */R  <     return( SS$_NORMAL );			/* Return with success status */         }                                       *= /* STRUC_INIT - Device Data Structure Initialization Routine    *C  * This routine is used to initialize the data structures at driver   * loading time.  *	  * Usage:_-  *      struc_init( crb, ddb, idb, orb, ucb )t  *	  * Input:   *      crb     pointer to CRB  *      ddb     pointer to DDB  *      idb     pointer to IDB  *      orb     pointer to ORB  *      ucb     pointer to UCB  *
  * Output:  *      none  *  * Return value:  *      none  *  */   F void struc_init( CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb )     {   [ /*  BREAK( 0x00020000, (int) ucb, 0, 0 );	/@ BREAK: struc_init called -- Can't TRACE yet */   4 /* Initialize the fork lock and device IPL fields */  E     baseucb.ucb$b_flck = SPL$C_IOLOCK8;		/* set up fork lock index */ ;     baseucb.ucb$b_dipl = DEVICE_IPL;		/*  and device IPL */     /* Initialize some UCB fields */  M     baseucb.ucb$l_devchar = ( DEV$M_DIR		/* Device is directory-structured */ C                             + DEV$M_FOD		/* File-oriented device */ J                             + DEV$M_AVL		/* Device is available for use */O                             + DEV$M_ELG		/* Device has error-Logging enabled */ S                             + DEV$M_IDV		/* Device is capable of providing input */nT                             + DEV$M_ODV		/* Device is capable of providing output */B                             + DEV$M_SHR		/* Device is shareable */L                             + DEV$M_RND );	/* Device allows random-access */     baseucb.ucb$l_devchar2 =O                             ( DEV$M_CLU		/* The device is cluster accessible */ G                             + DEV$M_NNM		/* Use "node$" device names */ `                             + DEV$M_NLT );	/* "No Last Track" bad block info on these devices */E     baseucb.ucb$b_devclass  = DC$_DISK;		/* Device class is a disk */_G     baseucb.ucb$b_devtype   = DT$_GENERIC_DK;	/* Device type for DDR */ F     baseucb.ucb$l_devsts    = UCB$M_NOCNVRT;	/* Do NOT convert LBNs */M     baseucb.ucb$w_devbufsiz = BLK_SIZE_512;	/* Default to ATA-sized blocks */BV     baseucb.ucb$l_media_id  = 0x245242B2;	/* Media ID of DQ|IDE50 in magic encoding */       return;B         }D      A /* STRUC_REINIT - Device Data Structure Re-Initialization Routine_  *E  * This routine is used to reinitialize the data structures at driver   * reloading time.  *	  * Usage: -  *      struc_init( crb, ddb, idb, orb, ucb )   *	  * Input:   *      crb     pointer to CRB  *      ddb     pointer to DDB  *      idb     pointer to IDB  *      orb     pointer to ORB  *      ucb     pointer to UCB  *
  * Output:  *      none  *  * Return value:  *      none  *  */_  I void struc_reinit ( CRB *crb, DDB *ddb, IDB *idb, ORB *orb, DQ_UCB *ucb )      {   9     ddb->ddb$ps_ddt = &_ddt;			/* Point ddb to the ddt */uA     ddb->ddb$l_acpd = 'F11';			/* Fill-in the default ACP name */a9     dpt_store_isr( crb, isr );			/* Set up ISR address */C  &     return;					/* Return to caller */         }  e' /* RCT_FDT - IO$_READRCT FDT Processingl  *B  * This routine is the FDT processing routine for the RCT functionG  * code.  The LBN and size are checked and, if ok, the buffer is locked G  * down and the I/O handed off to be processed. A check is made for thesD  * shad modifier.  This func code with the shad modifier is really a9  * check for write logging capability.  We don't do that.f  *	  * Input:   *      irp     pointer to IRP  *      pcb     pointer to PCB  *      ucb     pointer to UCB  *      ccb     pointer to CCB  *
  * Output:  *  * Return value:G  *      SS$_FDT_COMPL -- shows that the routine completed. Note that if 5  *			 if readlock fails, an abortio will already have 4  *			 been done by the readlock code and status from4  *			 readlock is always either normal or fdt_compl.  *  */   8 int rct_fdt( IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb )       {      int status;7X     if (irp->irp$l_func & IO$M_SHADOW)		/* If set, then it's really IO$_WRL. Illegal. */A 	status = exe_std$abortio (irp, pcb, (UCB *) ucb, SS$_ILLIOFUNC);f     else 	{] 	if ( ((UINT)irp->irp$l_qio_p2 > BLK_SIZE_512) || /* Byte count is less than or equal 512? */D2 	     (irp->irp$l_qio_p3 != 0) )			 /* LBN = 0? */D 	    status = exe_std$abortio (irp, pcb, (UCB *) ucb, SS$_BADPARAM); 	elsed 	    {						/* Met the tests */nC 	    irp->irp$l_bcnt = irp->irp$l_qio_p2;	/* Copy the byte count */2; 	    irp->irp$l_media= irp->irp$l_qio_p3;	/* and the LBN */ 7 	    status = exe_std$readlock( irp,		/* Then do it! */d 				       pcb,# 				       (UCB *) ucb,  				       ccb,i& 				       (void *) irp->irp$l_qio_p1, 				       irp->irp$l_bcnt,  				       0 );R 	    if (status == SS$_NORMAL)F 		status=exe_std$qiodrvpkt( irp, (UCB *) ucb );	/* Queue the packet */ 	    } 	}#     return ( status );			/* exit */o     }r d+ /* RDSTATS_FDT - IO$_RDSTATS FDT ProcessingT  * _=  * This routine is the FDT processing routine for the RDSTATST@  * function code.  If the EXTRA_STATS conditional is on, severalD  * statistics are returned to the caller.  Otherwise, the SS$_NODATA  * error is returned.   *	  * Input:,  *      irp     pointer to IRP  *      pcb     pointer to PCB  *      ucb     pointer to UCB  *      ccb     pointer to CCB  *
  * Output:  *  * Return value:C  *      SS$_FDT_COMPL -- shows that the routine completed correctlyf  *  */M  < int rdstats_fdt( IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb )     {)  /     int  *bp;					/* Longword buffer pointer */R"     int  i;					/* Loop counter */  8 /* Check that LBN = 0 and byte count is large enough  */   #ifdef EXTRA_STATSM     irp->irp$l_iost1 = SS$_BADPARAM;		/* Assume an error - Load error code */,             I     if ( (irp->irp$l_qio_p2 >= RDSTATS_LEN) && (irp->irp$l_qio_p3 == 0) )f       {MB         bp = (void *) irp->irp$l_qio_p1;	/* Point to the buffer */G         *bp = ucb->ucb$l_total_ints;		/* Get count of all interrupts */ -         bp++;					/* Move to next longword */WO         *bp = ucb->ucb$l_unsol_ints;		/* Get count of unsolicited interrupts */i-         bp++;					/* Move to next longword */MD         *bp = NUMBER_OF_CRAMS;			/* Copy over the number of CRAMS */
         bp++;:J         *bp = (int) ucb->ucb$ps_xfer_buffer;	/* Transfer buffer address */
         bp++;aB         *bp = (int) ucb->ucb$ps_s0_svapte;	/* Base SPTE address */
         bp++;gA         *bp = (int) ucb->ucb$ps_s0_va;		/* S0 VA (user buffer) */o
         bp++; A         *bp = TIMEOUT_TIME+2;			/* Save size of TIMEOUT vector */B-         bp++;					/* Move to next location */   , /* Copy over the timeout histogram vector */  +         for (i=0; i<=(TIMEOUT_TIME+1); i++)            {IV             *bp = ucb->ucb$l_int_hist[i];	/* Copy over the interrupt time histogram */*             bp++;				/* Advance pointer */               }   D         *bp = ucb->ucb$l_int_tmo;		/* Copy over the timeout count */'         bp++;					/* Advance pointer */O  <         irp->irp$l_iost1 = (RDSTATS_LEN << 16) + SS$_NORMAL;           }  #else 9     irp->irp$l_iost1 = SS$_NODATA;		/* Load error code */o #endif  1     irp->irp$l_iost2 = 0;			/* Clear high IOSB */o>     exe_std$finishio( irp, (UCB *) ucb );	/* Finish the I/O */.     return( SS$_FDT_COMPL );			/*  and exit */         }       - /* DIAGNOSE_FDT - IO$_DIAGNOSE FDT Processing	  *>  * This routine is the FDT processing routine for the DIAGNOSE  * function code.i  *	  * Input:e  *      irp     pointer to IRP  *      pcb     pointer to PCB  *      ucb     pointer to UCB)  *      ccb     pointer to CCB           	  *
  * Output:  *  * Return value:C  *      SS$_FDT_COMPL -- shows that the routine completed correctly   *  */   = int diagnose_fdt( IRP *irp, PCB *pcb, DQ_UCB *ucb, CCB *ccb )  {n#     DIAGNOSE_PARAM *diagnose_param;      int status;T     int64   prvprv;e  5     /* Check if process has the required privilege */   !     sys$setprv(0, 0, 0, &prvprv);I  %     if ( !(prvprv & PRV$M_DIAGNOSE) ) 	         {T
         /*F          *  Jam a more specific privilege-related error into the IOSB.E          *  Replacing the SS$_NOPRIV return with SS$_NODIAGNOSE would E          *  have been preferable, but folks are undoubtedly dependingeF          *  on the SS$_NOPRIV value.  As SS$_NOPRIV was returning with0 	 *  a null IOSB, we effectively hijack it here.          */a*         irp->irp$l_iost1 = SS$_NODIAGNOSE;         irp->irp$l_iost2 = 0;u= 	return(exe_std$abortio( irp, pcb, (UCB *) ucb, SS$_NOPRIV)); 	         }n  :     diagnose_param = (DIAGNOSE_PARAM *) irp->irp$l_qio_p1;  2     ucb->diagnose_opcode = diagnose_param->opcode;0     ucb->diagnose_flags = diagnose_param->flags;  G     ucb->diagnose_command_length = MIN(diagnose_param->command_length,  D                                        MAX_DIAGNOSE_COMMAND_LENGTH);  *     if (ucb->diagnose_command_length > 0) >         memcpy(ucb->diagnose_command, diagnose_param->command,-                ucb->diagnose_command_length);                                 qA     ucb->diagnose_data_length = MIN(diagnose_param->data_length, i<                                     MAX_DIAGNOSE_DATA_SIZE);                t&     if (ucb->diagnose_data_length > 0)>         memcpy(ucb->ucb$ps_xfer_buffer, diagnose_param->data, *                ucb->diagnose_data_length);$                                     :     ucb->diagnose_pad_length = diagnose_param->pad_length;@     ucb->diagnose_phase_timeout = diagnose_param->phase_timeout;J     ucb->diagnose_disconnect_timeout = diagnose_param->disconnect_timeout;  0     irp->irp$l_bcnt = ucb->diagnose_data_length;       if (irp->irp$l_bcnt > 0) {:         status = exe_std$readlock( irp,		/* Then do it! */'                                    pcb,u/                                    (UCB *) ucb,*'                                    ccb, A                                    (void *) diagnose_param->data,o3                                    irp->irp$l_bcnt,I'                                    0 );,     }n  A     exe_std$qiodrvpkt( irp, (UCB *) ucb );	/* Queue the packet */x.     return( SS$_FDT_COMPL );			/*  and exit */   }n            m   o0 /* CTRL_INIT - Controller Initialization Routine  * 	E  * This routine is used to perform controller specific initialization C  * and is called by 1) system startup, 2) during driver loading and $  * 3) during power failure recovery.  *	  * Usage:	  *,  *      status = ctrl_init ( idb, ddb, crb )  *	  * Input:u"  *      idb     pointer to the idb"  *      ddb     pointer to the ddb"  *      crb     Pointer to the crb  *
  * Output:
  *      None.   *  * Return value:8  *      SS$_NORMAL -- unit was initialized successfully.  *  */   . int ctrl_init ( IDB *idb, DDB *ddb, CRB *crb )     {,  S /*  BREAK( 0x00040000, 0, 0, 0 );		/@ BREAK: ctrl_init called -- Can't TRACE yet */   0     return( SS$_NORMAL );			/* Return SUCCESS */         }i      * /* UNIT_INIT - Unit Initialization Routine  *?  * This routine is used to perform unit specific initialization C  * and is called by 1) system startup, 2) during driver loading ande$  * 3) during power failure recovery.  *F  * This routine does very little work.  Its primary job is to start upE  * the fork process that will do the bulk of the unit initialization.   *	  * Usage:/  *'  *      status = unit_init ( idb, ucb )1  *	  * Input:l"  *      idb     pointer to the IDB"  *      ucb     pointer to the UCB  *
  * Output:
  *      None.p  *  * Return value:8  *      SS$_NORMAL -- unit was initialized successfully.  *  */_  ' int unit_init ( IDB *idb, DQ_UCB *ucb )* {   =     if (baseucb.ucb$v_power)			/* Is this power recovery ? */ @         return( SS$_NORMAL );			/* Power recovery - just exit */  G /* Set up and queue fork process to complete the unit initialization */   L     baseucb.ucb$l_fpc = &unit_init_fork;	/* Point to fork routine address */:     exe_std$primitive_fork( 0, (int64) idb, (FKB *) ucb ); 						/* Start fork process */5     return( SS$_NORMAL );			/* Return with success */d   }b     b4 /* UNIT_INIT_FORK - Unit Initialization Fork Routine  *5  * This is the fork routine that does the bulk of the   * unit initialization work.  *	  * Usage:i  *(  *      unit_init_fork ( fr3, idb, ucb )  *	  * Input:k/  *      fr3     Fork routine parameter (unused) "  *      idb     pointer to the IDB"  *      ucb     pointer to the UCB  *
  * Output:
  *      None.   *  * Return value:  *      none  *  * Note:  *F  *   The default device name of "Generic IDE/ATAPI disk" should not beF  *   seen in normal operation. This will normally either be superceded?  *   by either a real device name (read from the device) or the @  *   "Nonexistent IDE/ATAPI disk" fake device name stored by the>  *   PACKACK/SENSECHAR when we fail to read a real name from a  *   non-existent device.   *  */   7 void unit_init_fork( void *fr3, IDB *idb, DQ_UCB *ucb )  {tB     char    model[DTN$K_NAMELEN_MAX+1] = "Generic IDE/ATAPI disk";U     int     mod_len = 22;			/* Length of model string (*WITHOUT* trailing <null>!) */),     DTN     *dtn;				/* Dummy DTN pointer */1     CRAM    *cram_ptr;				/* Pointer to a CRAM */D-     CRCTX   *ctx;				/* Pointer to a CRCTX */ ;     int     index;				/* Index for walking the CRAM list */*)     ADP     *adp;				/* Address of ADP */ )     CRB     *crb;				/* Address of CRB */ )     DDB     *ddb;				/* Address of DDB */ 2     int     status;				/* Routine status values */:     int     page_cnt;				/* Number of pages to allocate */5     int     offset;				/* PTE offset in page table */e\     int     dma_offset=0;                       /* Offset to correct set of DMA Ctl regs. */[     int     dma_csr_base=0;                     /* contents of pci config base address 4 */m1     int     csr_base=0;				/* Base CSR address */lm     int     cmd_base=0;                         /* Double use. Offset to config reg, then config contents. */ m     int     ctl_base=0;                         /* Double use. Offset to config reg, then config contents. */ B     uint64  q_cmd_base;				/* Quadword of Command Register base */B     uint64  q_ctl_base;				/* Quadword of Control Register base */X     uint64  q_dma_csr_base;                     /* A quadword of dma register address */<     IDB     *idb_ptr;				/* CRAM IDB pointer value to use */4     uint64  q_nul = 0;				/* A quadword of zeroes */9     IRP     *irp;				/* Pointer to the IRP we'll build */ H     int32   size;				/* The size of several structures we'll allocate */=     PTE     *svapte;				/* Pointer to PTE that maps our VA */ <     ORB	    *orb;				/* pointer to the object rights data */     5     adp = baseucb.ucb$ps_adp;			/* Get ADP address */C4     crb = baseucb.ucb$l_crb;			/* Get CRB address */4     ddb = baseucb.ucb$l_ddb;			/* Get DDB address */4     orb = baseucb.ucb$l_orb;			/* Get ORB address */  C     ucb->ucb$l_dummy_flgs   = 'Flgs';		/* Put markers in the UCB */IC     ucb->ucb$l_dummy_sens   = 'Sens';		/*   :                    */tC     ucb->ucb$l_dummy_pakt   = 'Pakt';		/*   :                    */DC     ucb->ucb$l_dummy_ints   = 'Ints';		/*   :                    */:C     ucb->ucb$l_dummy_unso   = 'Unso';		/*   :                    */_C     ucb->ucb$l_dummy_hist   = 'Hist';		/*   :                    */ C     ucb->ucb$l_dummy_tmo    = 'Tmo!';		/*   :                    */MC     ucb->ucb$l_dummy_resets = 'Rst!';		/*   :                    */6C     ucb->ucb$l_dummy_trace  = 'Trac';		/*   :                    */iC     ucb->ucb$l_dummy_end    = 'End!';		/*   :                    */   V     ucb->ucb$l_unsolicited_int   = 0;		/* Forget any pending unsolicited interrupts */@     ucb->ucb$l_drive_lba_capable = 0;		/* Clear all the flags */2     ucb->ucb$l_drive_dma_capable = 0;		/*   :   */2     ucb->ucb$l_ctrl_id           = 0;		/*   :   */2     ucb->ucb$l_ctrl_dma_capable  = 0;		/*   :   */2     ucb->ucb$l_atapi_flag        = 0;		/*   :   */2     ucb->ucb$l_2K_flag           = 0;		/*   :   */  C     ucb->ucb$l_drv_head = DRVHD_M_BASE + (baseucb.ucb$w_unit << 4);R@ 						/* Set up drive/head unit bit for later use in commands */  R     ucb->ucb$l_trc_buf      = (void *) 0xDEADDEAD;	/* Indicate no tracing (yet) */6     ucb->ucb$l_trc_index    = 0x0000DEAD;		/*   :   */g     ucb->ucb$l_trc_unit     = baseucb.ucb$w_unit + 1;	/* Set up part of our canonical unit number    */d      #ifdef TRACE_PER_DRIVET     status = exe_std$alononpaged( TRACING*4, &size, (void **) &ucb->ucb$l_trc_buf );0 						/* Allocate pool for our tracing buffer */j     orb->orb$l_reserve2 = (int) ucb->ucb$l_trc_buf; /* provide a place to find the trace buffer address */:     if ( $FAIL( status ) )			/* Check the return status */)         return;					/* Return if error */oT     ucb->ucb$l_trc_index = 0;			/* Point the index to the beginning of the buffer */E     memset(ucb->ucb$l_trc_buf,0x0,size);	/* Clear the trace buffer */_F     TRACE( 0x0FFFFFFF );			/* Record a distinctive starting pattern */&     TRACE( 0x0FF0F0F0 );			/*   :   */&     TRACE( 0x0F0F0F0F );			/*   :   */&     TRACE( 0x0FF0FFFF );			/*   :   */ #endif     #ifdef TRACE_COMMONec     ucb->ucb$l_trc_buf = &trc_dummy;		/* Provide a pointer in the UCB to the common trace buffer */o  A     if (trc_buf_alloc == 0)			/* Only allocate the buffer once */m       {d>         trc_buf_alloc++;			/* Remember we've allocated this */  9         trc_dummy    = 'Trac';			/* Set the ASCII tags */ 9         fixup_dummy  = 'FxUp';			/*   :                */e4         fixup_bcnt   = 0;			/* Zero some counters */4         fixup_boff   = 0;			/*   :                */4         fixup_svapte = 0;			/*   :                */  M         status = exe_std$alononpaged( TRACING*4, &size, (void **) &trc_buf );M0 						/* Allocate pool for our tracing buffer */>         if ( $FAIL( status ) )			/* Check the return status */-             return;					/* Return if error */f  N         trc_index = 0;				/* Point the index to the beginning of the buffer */J         TRACE( 0x0FFFFFFF );			/* Record a distinctive starting pattern */*         TRACE( 0x0FF0F0F0 );			/*   :   */*         TRACE( 0x0F0F0F0F );			/*   :   */*         TRACE( 0x0FF0FFFF );			/*   :   */           }  #endif  5     if (     ( (ddb->ddb$t_name_str[2] & 0x01 ) ==0 )m7 						/* Check controller letter:                    */d7 						/* Secondary controller (DQB, DQD, DQF, etc.)? */ Y           || (baseucb.ucb$w_unit>=2) )		/* DQA2:, DQA3:, DQC2:, DQC3, etc. ?           */)T         ucb->ucb$l_trc_unit += 2;		/* If either, bump canonical unit by 2         */7 						/* Now, 1->DQA0:, 2->DQA1:, 3->DQB0:, 4->DQB1: */c: 						/* allocate enough memory for two device id pages */     Q     status = exe$alononpaged_aln( 1024, 9, (void **)&crb->crb$l_auxstruc, &size);*:     if ( $FAIL( status ) )			/* Check the return status */)         return;					/* Return if error */   F     /* Clear the histogram buffer counts.  Clear each entry from 0 to E      * TIMEOUT_TIME and the overflow count at the end of the vector. c      */ 7     for (index = 0 ; index < TIMEOUT_TIME+1; index++) {eU         ucb->ucb$l_int_hist[index] = 0;		/* Clear the interrupt histogram counters */;     }f  ?     /* set our typical timeout time to default timeout time. */3+     ucb->ucb$l_int_max_wait = TIMEOUT_TIME;   G     /* Read the vendor ID and device ID fields of the IDE controller */I&     status = ioc$read_pci_config( adp,2                                   crb->crb$l_node,2                                   PCI$K_VENDOR_ID,$                                   4,:                                   &(ucb->ucb$l_ctrl_id) );  K     /* Read program interface info for primary/secondary programming mode*/t&     status = ioc$read_pci_config( adp,2                                   crb->crb$l_node,4                                   PCI$K_REVISION_ID,$                                   4,=                                   &(ucb->ucb$l_prog_intfc) );_  E     /* CMD649 is a Marvel Combo Card and the Secondary controller is n      * not pinned out. Q      */,  4     ucb->ucb$l_primary = ddb->ddb$t_name_str[2] & 1;  	 #if ALPHA)&     if (ucb->ucb$l_ctrl_id == CMD649)  	ucb->ucb$l_primary = 1; #endif  @     /* This mapping is based on Native-PCI mode according to the$      *  PCI IDE Controller Spec V1.0      */r     if ( ucb->ucb$l_primary) {-         cmd_base = ctl_base = dma_offset = 0;v     } else {         dma_offset = 8;t)         if ( ucb->ucb$l_ctrl_id == ACER ) $             cmd_base = ctl_base = 8;     }d  &     status = ioc$read_pci_config( adp,2                                   crb->crb$l_node,B                                   PCI$K_BASE_ADDRESS_0 + cmd_base,$                                   4,7                                   (int *)&q_cmd_base );n  &     status = ioc$read_pci_config( adp,2                                   crb->crb$l_node,B                                   PCI$K_BASE_ADDRESS_1 + ctl_base,$                                   4,7                                   (int *)&q_ctl_base );d  9     /*  Now get the DMA ctl register base. If this is thetF         secondary ctlr on a cypress then we must get the base from theI         primary ctlr.  Take advantage of the fact that the chip config inMK         [sysloa]cypress_support always makes primary/secondary node numbers          consecutive.     */B     if  ( !ucb->ucb$l_primary && ucb->ucb$l_ctrl_id == CYPRESS ) {*         status = ioc$read_pci_config( adp,:                                       crb->crb$l_node - 1,;                                       PCI$K_BASE_ADDRESS_4,t(                                       4,?                                       (int *)&q_dma_csr_base );t     } else {)        status = ioc$read_pci_config( adp, 6                                       crb->crb$l_node,;                                       PCI$K_BASE_ADDRESS_4,f(                                       4,?                                       (int *)&q_dma_csr_base );Q     }c   #if 0c=     /* For Controller that does not fill the PCI Base Addressn1      * Registers, use the Legacy Mode Addressing._      */)'     /* Legacy Command Block Register */B     if (!q_cmd_base) r 	if (ucb->ucb$l_primary)! 	    q_cmd_base = PRI_LEG_CMDREG;  	else ! 	    q_cmd_base = SEC_LEG_CMDREG;      '     /* Legacy Control Block Register */C     if (!q_ctl_base) 	if (ucb->ucb$l_primary)# 	    q_ctl_base = PRI_LEG_CNTRLREG;o 	else # 	    q_ctl_base = SEC_LEG_CNTRLREG;  #endif  	 #if IA64    1     /* Hard wire to Secondary Master for i2000 */      if (!q_cmd_base) 	q_cmd_base = SEC_LEG_CMDREG;U       if (!q_ctl_base) 	q_ctl_base = SEC_LEG_CNTRLREG;    #endif  C     /* Secondary unit adder for Acer, CMD649, and similar ctlrs. */	!     q_dma_csr_base += dma_offset;n     /* mask off some bits */     q_cmd_base &= 0xFFFFFFFE;t     q_ctl_base &= 0xFFFFFFFE;e!     q_dma_csr_base &= 0xFFFFFFF8;_  V     status = ioc$map_io( adp,                   /* Map the main CSRs into our space */S                      crb->crb$l_node,           /* Node number of the bus to map */eE                      &q_cmd_base,               /* physical_offset */UB                      0x8,                       /* Bytes to map */@                      IOC$K_BUS_IO_BYTE_GRAN,    /* attributes */.                      &ucb->ucb$q_iohandle_1 );M     if ( $FAIL( status ) )                      /* Check the return status */eE         return;                                 /* Return if error */   V     status = ioc$map_io( adp,                   /* Map the main CSRs into our space */S                      crb->crb$l_node,           /* Node number of the bus to map */ E                      &q_ctl_base,               /* physical_offset */ B                      0x4,                       /* Bytes to map */@                      IOC$K_BUS_IO_BYTE_GRAN,    /* attributes */.                      &ucb->ucb$q_iohandle_2 );M     if ( $FAIL( status ) )                      /* Check the return status */rE         return;                                 /* Return if error */   U     status = ioc$map_io( adp,                   /* Map the DMA CSRs into our space */ S                          crb->crb$l_node,       /* Node number of the bus to map */vE                          &q_dma_csr_base,       /* physical_offset */ B                          0x8,                   /* Bytes to map */@                          IOC$K_BUS_IO_BYTE_GRAN,/* attributes */2                          &ucb->ucb$q_iohandle_3 );M     if ( $FAIL( status ) )                      /* Check the return status *//E         return;                                 /* Return if error */n  C     /* Now, load the CRAMs that we'll use for register accesses. */dZ     cram_ptr = baseucb.ucb$ps_cram;             /* Point to the first CRAM in our chain */P     idb_ptr= NULL;                              /* Use no IDB pointer in CRAM */  <     for ( index=0; index<NUMBER_OF_CMDBLK_CRAMS; index++ ) {%         /* For each non-DMA CSR... */rQ         cram_ptr->cram$l_idb = idb_ptr;         /* Set IDB pointer in the CRAM */ F         ucb->ucb$ps_crams[index] = cram_ptr;    /* Set up UCB table */4         status = ioc$cram_cmd( cram_init[index].cmd,@                                csr_base+cram_init[index].offset,#                                adp,e(                                cram_ptr,B                                (uint64*) &ucb->ucb$q_iohandle_1 );M         if ( $FAIL( status ) )                  /* Check the return status */ E             return;                             /* Return if error */e  S         cram_ptr->cram$l_idb = idb;             /* Set the IDB pointer correctly */ M         cram_ptr->cram$v_der = 1;               /* Disable error reporting */*q         cram_ptr = cram_ptr->cram$l_flink;      /* On to next CRAM pointer, preparing for a possible next pass */A     }e  L     for ( ; index<NUMBER_OF_CMDBLK_CRAMS+NUMBER_OF_CTLBLK_CRAMS; index++ ) {!         /* For each DMA CSR... */*Q         cram_ptr->cram$l_idb = idb_ptr;         /* Set IDB pointer in the CRAM */nF         ucb->ucb$ps_crams[index] = cram_ptr;    /* Set up UCB table */4         status = ioc$cram_cmd( cram_init[index].cmd,7                                cram_init[index].offset, #                                adp,I(                                cram_ptr,B                                (uint64*) &ucb->ucb$q_iohandle_2 );M         if ( $FAIL( status ) )                  /* Check the return status */OE             return;                             /* Return if error */p  S         cram_ptr->cram$l_idb = idb;             /* Set the IDB pointer correctly */,M         cram_ptr->cram$v_der = 1;               /* Disable error reporting */ q         cram_ptr = cram_ptr->cram$l_flink;      /* On to next CRAM pointer, preparing for a possible next pass */d     }   o     for ( ; index<NUMBER_OF_CRAMS; index++ ) {   /* (Continuing our use of the already-initialized index...) */eI                                                 /* For each DMA CSR... */ Q         cram_ptr->cram$l_idb = idb_ptr;         /* Set IDB pointer in the CRAM */lF         ucb->ucb$ps_crams[index] = cram_ptr;    /* Set up UCB table */4         status = ioc$cram_cmd( cram_init[index].cmd,7                                cram_init[index].offset,o#                                adp,f(                                cram_ptr,B                                (uint64*) &ucb->ucb$q_iohandle_3 );M         if ( $FAIL( status ) )                  /* Check the return status */7E             return;                             /* Return if error */c  S         cram_ptr->cram$l_idb = idb;             /* Set the IDB pointer correctly */DM         cram_ptr->cram$v_der = 1;               /* Disable error reporting */)q         cram_ptr = cram_ptr->cram$l_flink;      /* On to next CRAM pointer, preparing for a possible next pass */e     }     "     /* Allocate transfer buffer */O     page_cnt = ( XFER_BUFFER_SIZE + MMG$GL_PAGE_SIZE - 1 ) >> MMG$GL_VPN_TO_VA; 3 						/* Compute the size of the buffer in pages */)O     status = exe_std$alophycntg( page_cnt, (void *) &ucb->ucb$ps_xfer_buffer );n    <     /* Allocate a buffer to hold last ATAPI request-sense */`     status = exe_std$alophycntg( (SENSE_BUFFER_SIZE + MMG$GL_PAGE_SIZE - 1) >> MMG$GL_VPN_TO_VA,E                                 (void *) &ucb->ucb$ps_sense_buffer ); ^     if ( $FAIL( status) )			/* Allocate the sense buffer (usually, just one page -- plenty) */.         return;					/* Just exit on failure */    S     /* Allocate SPTEs for double mapping the user buffer (plus guard + spillage) */rM     status = ldr_std$alloc_pt( page_cnt+3, (void *) &ucb->ucb$ps_s0_svapte );	     if ( $FAIL( status ) ).         return;					/* Just exit on failure */    O     /* Compute S0 address of the double map buffer.  Note that "offset" will */ O     /* be the number of PTEs, not the offset from SPTBASE.  So, the shift is */_O     /* page number to VA, not PTE offset to VA.  A small factor of PTE size. */ 4     offset = ucb->ucb$ps_s0_svapte - mmg$gl_sptbase;P     ucb->ucb$ps_s0_va = (BYTE *) ( (offset << MMG$GL_VPN_TO_VA) | VA$M_SYSTEM ); c>    /* Allocate and initialize the data buffer CRCTX structure.<     * Then load the map registers that cover our data buffer     */  B     status = ioc$alloc_crctx( adp->adp$l_crab,		/* CRAB address */^                               &ucb->ucb$ps_xfer_crctx,	/* Address to save the CRCTX address */E                               SPL$C_IOLOCK8);		/* Lock information */t5     if ( $FAIL( status ) )				/* Did that go okay? */o1         return;						/* Just return on failure */ N     ctx = ucb->ucb$ps_xfer_crctx;			/* Point to the context we just created */X     ctx->crctx$l_item_cnt = XFER_BUFFER_MAP_PAGES + 2;	/* Including 2 for guard pages */C     status = ioc$alloc_cnt_res( adp->adp$l_crab,	/* CRAB address */dW                                 ucb->ucb$ps_xfer_crctx,	/* xfer buffer CRCTX address */ 1                                 0,			/* Unused */ 1                                 0,			/*    :   */a3                                 0 );			/*    :   */ 5     if ( $FAIL( status ) )				/* Did that go okay? */ 1         return;						/* Just return on failure */D  @     mmg_std$svaptechk( ucb->ucb$ps_xfer_buffer, 0, 0, &svapte );0 							/* Get SVAPTE for the data buffer's VA */  4     status = ioc$load_map( adp,				/* ADP address */R                            ucb->ucb$ps_xfer_crctx,	/* xfer buffer CRCTX address */1                            svapte,			/* SVAPTE */_K                            (int) ucb->ucb$ps_xfer_buffer & mmg$gl_bwp_mask,_& 							/* Byte offset into the page */4                            &(ucb->ucb$l_xfer_phy) );6 							/* Address to save the resulting DMA address */5     if ( $FAIL( status ) )				/* Did that go okay? */ 1         return;						/* Just return on failure */$                =    /* Allocate and align a small space to hold our PRDT tableo7     * Allocate and initialize the PRDT CRCTX structure.E5     * Then load the map registers that cover the PRDT_     */Y     status = exe_std$alononpaged( PRDT_TABLE_SIZE*2, &size, (void **) &ucb->ucb$l_prdt ); @     if ( $FAIL( status) )				/* Allocate the PRDT table space *//         return;						/* Just exit on failure */dh     ucb->ucb$l_prdt = (int *)  ( (  ( (int) ucb->ucb$l_prdt ) + PRDT_TABLE_SIZE - 1 ) & PRDT_ADX_MASK );3 							/* Now, force the pointer into alignment. */_3 							/* This also ensures that it doesn't      */E3 							/*   cross any page boundaries            */x  B     status = ioc$alloc_crctx( adp->adp$l_crab,		/* CRAB address */^                               &ucb->ucb$ps_prdt_crctx,	/* Address to save the CRCTX address */E                               SPL$C_IOLOCK8);		/* Lock information */_5     if ( $FAIL( status ) )				/* Did that go okay? */t1         return;						/* Just return on failure */)  N     ctx = ucb->ucb$ps_prdt_crctx;			/* Point to the context we just created */[     ctx->crctx$l_item_cnt = 3;				/* Including 1 page for spillover and 1 page for guard */_C     status = ioc$alloc_cnt_res( adp->adp$l_crab,	/* CRAB address */ P                                 ucb->ucb$ps_prdt_crctx,	/* PRDT CRCTX address */1                                 0,			/* Unused */,1                                 0,			/*    :   */S3                                 0 );			/*    :   */n5     if ( $FAIL( status ) )				/* Did that go okay? */D1         return;						/* Just return on failure */g  Z     mmg_std$svaptechk( ucb->ucb$l_prdt, 0, 0, &svapte );/* Get SVAPTE for the PRDT's VA */  4     status = ioc$load_map( adp,				/* ADP address */K                            ucb->ucb$ps_prdt_crctx,	/* PRDT CRCTX address */i1                            svapte,			/* SVAPTE */lC                            (int) ucb->ucb$l_prdt & mmg$gl_bwp_mask, & 							/* Byte offset into the page */4                            &(ucb->ucb$l_prdt_phy) );6 							/* Address to save the resulting DMA address */5     if ( $FAIL( status ) )				/* Did that go okay? */ 1         return;						/* Just return on failure */      r3     /* Do any controller-specific initialization */C       switch (ucb->ucb$l_ctrl_id)r     {C         case ACER:	         {0j             status = ioc$write_pci_config( adp,		/* Write the CDRC -- CD-ROM (ATAPI?) Control Register  */:                                           crb->crb$l_node,j                                           0x53,		/* Register at offset 0x53 in config space             */;                                           IOC$K_BYTE_LANED, o                                           0x01<<24 );	/* Enabling CD-ROM DMA, shifted into the MS byte lane  */e^             if ( $FAIL( status ) )			/* Check the return status                             */U                 return;					/* Return if error                                     */ P             break;					/* Done with Acer-specific stuff                       */	         } G         default:				/* Anything else (hopefully ISA comes here too!) */ 	         { ,             break;				/* (Nothing to do)  */	         }      }        /* Enable interrupts */lG     status = ioc$node_function( baseucb.ucb$l_crb, IOC$K_ENABLE_INTR ); 3     if ( $FAIL( status ) )			/* Check status and */e/         return;					/*  simply exit if error */   *    /* Size the disk (for non-system disks)6     * or size and pack-ack the disk (for system disks)     */  G     status = exe_std$alononpaged( sizeof(IRP), &size, (void **) &irp );i/     if ( $FAIL( status ) )			/* Check status */E.         return;					/* If it failed, return */  L     memset( irp, 0x0, size );			/* Clear all the memory we just allocated */^     irp->irp$w_size   = size;			/* And make it all into an IO$_PACKACK or IO$_SENSECHAR IRP *//     irp->irp$b_type   = DYN$C_IRP;		/*   :   */ .     irp->irp$l_ucb    = &baseucb;		/*   :   */0     if (&baseucb == sys$ar_bootucb)		/*   :   */4         irp->irp$l_func   = IO$_PACKACK;	/*   :   */     else					/*   :   */6         irp->irp$l_func   = IO$_SENSECHAR;	/*   :   */(     irp->irp$v_physio = 1;			/*   :   */;     irp->irp$l_pid    = (unsigned int) exe_std$deanonpaged;e=     baseucb.ucb$l_qlen++;			/* Bump up our IO queue length */e  L     baseucb.ucb$v_online = 1;			    /* Mark the purported disk as on-line */P     ucb->ucb$r_dq_dt.ucb$l_maxblock = 0x200;	    /* Give a temporary capacity */5     get_geom (ucb->ucb$r_dq_dt.ucb$l_maxblock, ucb );b<     baseucb.ucb$v_bsy = 1;			    /* Mark the unit as busy */  M     ioc_std$initiate( irp, &baseucb );		/* Initiate processing of that IRP */        return;					   }s C" /* REGDUMP - Register Dump Routine  *G  * This is the register dump routine.  It is used to dump the registers 8  * at the time of an error.  It is called at device IPL.  *	  * Input: 4  *      buffer  address of buffer to store registers4  *      arg_2   additional argument passed by caller  *      ucb     pointer to UCB  *
  * Output:  *      none  *  *  * Note:  *<  *  For some reason, the error packet isn't displaying well.=  *  So, hack to. Fudge the pointer based on empirical results 4  *  and add "ssss" and "eeee" to bracket the packet.  *  */   4 void regdump( BYTE *buffer, int arg_2, DQ_UCB *ucb )     {   9     TRACE( 0x03500000 + arg_2 );		/* REGDUMP beginning */t  )     buffer += 5;				/* Advance pointer */i  0     *buffer++ = 's';				/* Bracket the buffer */#     *buffer++ = 's';				/*   :   */k#     *buffer++ = 's';				/*   :   */.#     *buffer++ = 's';				/*   :   */P  5 						/* Put all of the registers into the buffer. */s5 						/* Pad to an even longword                   */tI     *buffer++ = arg_2;				/* Copy over the marker                      */(X     *buffer++ = inp( ucb, RD_DMA_CMD  );	/* Get the DMA command register              */X     *buffer++ = inp( ucb, RD_DMA_DS1  );	/* Get the DMA device-specific register 1    */X     *buffer++ = inp( ucb, RD_DMA_STS  );	/* Get the DMA status register               */X     *buffer++ = inp( ucb, RD_DMA_DS2  );	/* Get the DMA device-specific register 2    */X     *buffer++ = inp( ucb, RD_DMA_AD0  );	/* Get the DMA PRDT Address Register 0       */X     *buffer++ = inp( ucb, RD_DMA_AD1  );	/* Get the DMA PRDT Address Register 1       */X     *buffer++ = inp( ucb, RD_DMA_AD2  );	/* Get the DMA PRDT Address Register 2       */X     *buffer++ = inp( ucb, RD_DMA_AD3  );	/* Get the DMA PRDT Address Register 3       */X     if ( !((ucb->ucb$l_drive_dma_capable == TRUE) && (ucb->ucb$l_ctrl_id == CMD649)) ) {U 	*buffer++ = inp( ucb, RD_ERROR    );	/* Get error                                 */nU 	*buffer++ = inp( ucb, RD_SEC_CNT  );	/* Get sector count                          */vU 	*buffer++ = inp( ucb, RD_SECTOR   );	/* Get sector number                         */ U 	*buffer++ = inp( ucb, RD_CYL_LO   );	/* Get cylinder number (low)                 */PU 	*buffer++ = inp( ucb, RD_CYL_HI   );	/* Get cylinder number (high)                */ U 	*buffer++ = inp( ucb, RD_DRV_HD   );	/* Get drive/head information                */ _ 	*buffer++ = inp( ucb, RD_STS      );	/* Get status, quashing any pending interrupts as well */	B 	*buffer++ = 0;				/* Round up to an even                       */     }*E     *buffer++ = 0;				/*  number of longwords                      */S  8     *buffer++ = 'e';				/* Add tail of buffer bracket */#     *buffer++ = 'e';				/*   :   */ #     *buffer++ = 'e';				/*   :   */A#     *buffer++ = 'e';				/*   :   */f  6     TRACE( 0x03510000 + arg_2 );		/* REGDUMP ending */         }b     / /* STARTIO - Start I/O Routine  *E  * This is the driver start I/O routine.  This routine processes eachx  * of the I/O requests.b  *	  * Input:u-  *      irp     Pointer to I/O request packetp-  *      ucb     Pointer to unit control blocko  *
  * Output:  *      none  *  *  * Note:  *<  *   IO$_SENSECHAR is never queued to us by VMS. Instead, we=  *   queued this IO function code to ourselves as part of our :  *   startup; we do this to size non-system disks. (System  *   disks get IO$_PACKACK.)
  *              */    void startio( KPB *kpb )     {b  -     int     iost1, iost2;			/* IOSB fields */_*     int     temp;				/* Temporary value */)     DQ_UCB  *ucb;				/* Pointer to UCB */n)     IRP     *irp;				/* Pointer to IRP */v     int     status;o   /* Set up necessary pointers */     <     ucb = (DQ_UCB *) kpb->kpb$ps_ucb;		/* Get UCB pointer */                      i2     irp = kpb->kpb$ps_irp;			/* Get IRP pointer */7     ucb->ucb$ps_kpb = kpb;			/* Save the KPB address */	H     ucb->ucb$l_media.lbn = irp->irp$l_media;	/* Copy the disk address */  `     if (baseucb.ucb$l_bcnt != irp->irp$l_bcnt)	/* Is bcnt correct?                            */>       {						/* If not, then...                             */H #ifdef TRACE_COMMON				/*                                             */J         fixup_bcnt++;				/* Bump the event counter                      */= #endif						/*                                             */TR         TRACE(   0x01200000 );			/* UCB$L_BCNT corruption (by IRP over-copy!)   */a         baseucb.ucb$l_bcnt   = irp->irp$l_bcnt;	/* Copy the bcnt from the IRP                  */*           }   `     if (baseucb.ucb$l_boff != irp->irp$l_boff)	/* Is boff correct?                            */>       {						/* If not, then...                             */H #ifdef TRACE_COMMON				/*                                             */J         fixup_boff++;				/* Bump the event counter                      */= #endif						/*                                             */eR         TRACE(   0x01210000 );			/* UCB$L_BOFF corruption (by IRP over-copy!)   */a         baseucb.ucb$l_boff   = irp->irp$l_boff;	/* Copy the boff from the IRP                  */            }l  \     if (baseucb.ucb$l_svapte != irp->irp$l_svapte)	/* Is bcnt correct?                    */7       {							/* If not, then...                     */PH #ifdef TRACE_COMMON				/*                                             */L         fixup_svapte++;				/* Bump the event counter                      */= #endif						/*                                             */ R         TRACE(   0x01220000 );			/* UCB$L_SVAPTE corruption (by IRP over-copy!) */\         baseucb.ucb$l_svapte  = irp->irp$l_svapte;	/* Copy the bcnt from the IRP          */           }g  H     ucb->ucb$l_bcr = baseucb.ucb$l_bcnt;	/* Copy remaining byte count */  _     TRACE( 0x01000000 +   (irp->irp$v_fcode    )           );	/* STARTIO starting...         */(_     TRACE( 0x01010000 + ( ( (int) irp>>16      ) & 0xFFFF) );	/*   :  Log starting IRP_hi    */,_     TRACE( 0x01020000 + ( ( (int) irp          ) & 0xFFFF) );	/*   :  Log starting IRP_lo    */n_     TRACE( 0x01030000 + ( (irp->irp$l_media>>16) & 0xFFFF) );	/*   :  Log starting LBA_hi    */G_     TRACE( 0x01040000 + ( (irp->irp$l_media    ) & 0xFFFF) );	/*   :  Log starting LBA_lo    */cb     TRACE( 0x01050000 + ( (baseucb.ucb$l_bcnt  ) & 0xFFFF) );	/*   :  Log starting bytecount_lo */d     TRACE( 0x01060000 + ( (baseucb.ucb$l_bcnt>>16) & 0xFFFF) );	/*   :  Log starting bytecount_hi */    A /* Check that either volume is valid or this is a physical I/O */n  4     if ( !irp->irp$v_physio && !baseucb.ucb$v_valid)       {p5         ioc_std$reqcom( SS$_VOLINV, 0, (UCB *) ucb );p 						/* Finish I/O */T         BPTRACE( 0x01100000 );			/* BREAK: STARTIO punting on volume not valid... */$         return;					/* And return */           }u  / /* Interpret the LBN according to PHYSIO bit */   @     if (irp->irp$v_physio)			/* Convert from physical format? */       { J         switch (irp->irp$v_fcode)		/* Does this command use an address? */           {   T             case IO$_READLBLK:			/* These shouldn't occur with v_phys set, right? */.             case IO$_WRITELBLK:			/*    :   */b               BPTRACE( 0x01110000 );		/* BREAK: IO$_READLBLK or IO$_WRITELBLOCK with V_PHYS set */" 						/* Fall through anyway... */K             case IO$_SEEK:			/* These can be physical and use an address */u.             case IO$_WRITECHECK:		/*    :   */-             case IO$_READPBLK:			/*    :   */ .             case IO$_WRITEPBLK:			/*    :   */4               {					/* So range-check the address */G                 if (    (ucb->ucb$l_media.pa.sec == 0)				/* [1:n]   */:Y                      || (ucb->ucb$l_media.pa.sec >  baseucb.ucb$b_sectors )	/*   :     */ Y                      || (ucb->ucb$l_media.pa.trk >= baseucb.ucb$b_tracks  )	/* [0:n-1] */t]                      || (ucb->ucb$l_media.pa.cyl >= baseucb.ucb$w_cylinders ) )	/* [0:n-1] */                    {-P                     BPTRACE( 0x00112000 );	/* BREAK: CHS address out of range */C                     ioc_std$reqcom( SS$_BADPARAM, 0, (UCB *) ucb );i$ 						/* Complete the I/O failing */  		    return;			/* And return */                     break;                       }r                   }c  G             default:				/* No address used -- no need to range-check */                break;                 }   \         ucb->ucb$l_media.lbn = (   (   (   (ucb->ucb$l_media.pa.cyl * baseucb.ucb$b_tracks )Y                                      + ucb->ucb$l_media.pa.trk) * baseucb.ucb$b_sectors )cA                                  + ucb->ucb$l_media.pa.sec - 1 ); 2 						/* Convert the physical address to an LBN */           }     & /* Remember the transfer parameters */  9     ucb->ucb$l_org_media = ucb->ucb$l_media.lbn;/* LBN */ H     ucb->ucb$l_org_svapte= baseucb.ucb$l_svapte;/* Page table address */?     ucb->ucb$l_org_bcnt  = baseucb.ucb$l_bcnt;	/* Byte count */_@     ucb->ucb$l_org_boff  = baseucb.ucb$l_boff;	/* Byte offset */  # /* Handle based on function code */r  ;     TRACE( 0x01060000 );			/* Log our calling reqchan... */iH     iost1 = ioc$kp_reqchan( kpb, KPB$K_LOW );	/* Get the data channel */  	 #if ALPHAuC      if ( $FAIL( iost1 ) )			/* Check for failure to get channel */(       {,@         ioc_std$reqcom( iost1, 0, (UCB *) ucb );/* Finish I/O */i         BPTRACE( 0x01130000 + (iost1 &0xFFFF) );/* BREAK: STARTIO punting on failure to get channel... */e"         return;					/* And exit */           }t #endif   >     iost1 = SS$_ILLIOFUNC;			/* Assume illegal I/O function */3     iost2 = 0;					/* Assume no data transferred */        switch (irp->irp$v_fcode)h       {            case IO$_NOP:e8             BPTRACE( 0x01070000 );		/* BREAK: IO$_NOP */:             iost1 = SS$_NORMAL;			/* Status is "normal" */1             break;				/*  and complete the I/O */i           case IO$_UNLOAD:;             BPTRACE( 0x01070001 );		/* BREAK: IO$_UNLOAD */ B             iost1 = unload( ucb );		/* Call the unload function */1             break;				/*  and complete the I/O */U           case IO$_SEEK:9             BPTRACE( 0x01070002 );		/* BREAK: IO$_SEEK */c>             iost1 = seek( ucb );		/* Call the SEEK function */1             break;				/*  and complete the I/O */x           case IO$_DRVCLR:;             BPTRACE( 0x01070004 );		/* BREAK: IO$_DRVCLR */cG             iost1 = drvclr( ucb );		/* Call the DRIVE CLEAR function */ 1             break;				/*  and complete the I/O */            case IO$_PACKACK:u[             iost1 = packack( ucb, 0 );		/* Call PACKACK w/o asserting the init_time_flag */ 1             break;				/*  and complete the I/O */o           case IO$_READRCT: <             BPTRACE( 0x01070009 );		/* BREAK: IO$_READRCT */B             iost1 = readrct( ucb );		/* Get back the drive data */B             iost1 = (iost1 & 0xFFFF) + (baseucb.ucb$l_bcnt << 16);1             break;				/*  and complete the I/O */n           case IO$_AVAILABLE:e>             BPTRACE( 0x01070011 );		/* BREAK: IO$_AVAILABLE */B             iost1 = unload( ucb );		/* Call the unload function */1             break;				/*  and complete the I/O */	           case IO$_DIAGNOSE:%             ucb->ucb$l_sense_key = 0;eK             status = diagnose( ucb );	        /* Call the audio function */i8             temp  = baseucb.ucb$l_bcnt - ucb->ucb$l_bcr;5             iost1 = status | ((temp & 0xFFFF) << 16); T             iost2 = ((ucb->ucb$l_sense_key & 0xFF) << 24) | ((temp >> 16) & 0xFFFF);T             /* the unused byte between the sense key and the upper word is zeroed */1             break;				/*  and complete the I/O */e           case IO$_FORMAT:;             BPTRACE( 0x0107001E );		/* BREAK: IO$_FORMAT */ L             iost1 = SS$_UNSUPPORTED;		/* Return UNSUPPORTED error for now */1             break;				/*  and complete the I/O */r           case IO$_SENSECHAR: W             iost1 = packack( ucb, 1 );		/* Call PACKACK asserting the init_time_flag */s1             break;				/*  and complete the I/O */   >         case IO$_WRITECHECK:                                  ?             BPTRACE( 0x0107000A );		/* BREAK: IO$_WRITECHECK */*         case IO$_READLBLK:         case IO$_READPBLK:C             iost1 = io_read( ucb );		/* Read the required blocks */ >             if ( $FAIL( iost1 ) )		/* Did the read go okay? */1               break;				/* If not, bug out now */ <             if ( IS_SET( irp->irp$l_func, IO$M_DATACHECK ) )  						/* Datacheck requested? */F                 iost1 = datacheck( ucb );	/*  Yes, do the datacheck */8             temp  = baseucb.ucb$l_bcnt - ucb->ucb$l_bcr;4             iost1 = (iost1 & 0xFFFF) + (temp << 16);# 	    iost2 = (temp >> 16) & 0xFFFF;a1             break;				/*  and complete the I/O */e           case IO$_WRITELBLK:b         case IO$_WRITEPBLK: E             iost1 = io_write( ucb );		/* Write the required blocks */u?             if ( $FAIL( iost1 ) )		/* Did the write go okay? */ 1               break;				/* If not, bug out now */a<             if ( IS_SET( irp->irp$l_func, IO$M_DATACHECK ) )  						/* Datacheck requested? */F                 iost1 = datacheck( ucb );	/*  Yes, do the datacheck */8             temp  = baseucb.ucb$l_bcnt - ucb->ucb$l_bcr;4             iost1 = (iost1 & 0xFFFF) + (temp << 16);# 	    iost2 = (temp >> 16) & 0xFFFF;u1             break;				/*  and complete the I/O */i           case IO$_AUDIO:tK             BPTRACE( 0x01070037 );		/* BREAK: IO$_AUDIO (IO$_READPROMPT) */;L             iost1 = SS$_UNSUPPORTED;		/* Return UNSUPPORTED error for now */F /*          iost1 = audio_audio( ucb );		/@ Call the audio function */1             break;				/*  and complete the I/O */   ,         default:				/* Better not happen! */\             BPTRACE( 0x01071FFF );		/* BREAK: Default case taken at IO$_function dispatch */C             break;				/* But if it does, ILLIOFUNC gets returned */f             }C    ]     TRACE( 0x01FC0000 + ( iost1      & 0xFFFF));/* STARTIO finishing... (IOSB_1 low word)  */ ]     TRACE( 0x01FD0000 + ((iost1>>16) & 0xFFFF));/* STARTIO finishing... (IOSB_1 high word) */ ]     TRACE( 0x01FE0000 + ( iost2      & 0xFFFF));/* STARTIO finishing... (IOSB_2 low word)  */t]     TRACE( 0x01FF0000 + ((iost2>>16) & 0xFFFF));/* STARTIO finishing... (IOSB_2 high word) */mC     ioc_std$relchan( (UCB *) ucb );		/* Release the data channel */i  `     if (baseucb.ucb$l_bcnt != irp->irp$l_bcnt)	/* Is bcnt correct?                            */>       {						/* If not, then...                             */R         BPTRACE( 0x01300000 );			/* Blammo!                                     */           }	  `     if (baseucb.ucb$l_boff != irp->irp$l_boff)	/* Is boff correct?                            */>       {						/* If not, then...                             */R         BPTRACE( 0x01310000 );			/* Blammo!                                     */           }e  \     if (baseucb.ucb$l_svapte != irp->irp$l_svapte)	/* Is bcnt correct?                    */7       {							/* If not, then...                     */nR         BPTRACE( 0x01320000 );			/* Blammo!                                     */           } Z     ioc_std$reqcom( iost1, iost2, (UCB *) ucb );/* Finish I/O, providing status in IOSB */      return;					/* And return */         }C     n& /* PACKACK - Perform PACKACK operation  *C  * This routine is used to determine information about the drive soa)  * that is can be mounted and put to use.C  *	  * Input:?&  *      ucb             pointer to UCBA  *      init_time_flag  Set to indicate we're being called during	C  *                        initialization time: modifies processing.   *
  * Output:  *      none  *  * Return value:  *      status value:d  *         SS$_NORMAL - success$0  *         SS$_NODATA - failed to get drive info9  *         SS$_other -- specific error from a lower levelr  *	  * Notes:   *B  *   This is also the function called to process the IO$_SENSECHARC  *   that we queue to ourselves during initialization of non-system.A  *   disks. Processing is essentially the same, but we stop short ?  *   of getting the capacity (for ATAPI drives) and setting thep"  *   ucb$v_valid volume valid bit.  *A  *   If the ATA fetch_drive_info() fails, we could, conceptually,c?  *   look for the magic ATAPI signature in the STS, CYL_LO, andI<  *   CYL_HI registers (STS=0x00: neither 'Ready' nor 'Busy',@  *   CYL_HI=0xEB, CYL_LO=0x14). But instead, we just barge ahead@  *   and do an ATAPI PACKET_IDENTIFY command and see if we get a  *   response.  *>  *   Reportedly, certain TEAC CD-ROM drives refuse to speak toC  *   us until we read the "signature". (This signature is presenteda>  *   by ATAPI devices after a reset or refused command such as8  *   ATA_GET_INFO.) We read the signature, just in case.  *A  *   If an ATAPI drive has just powered up or the medium has just ?  *   been changed, there are certain special conditions we want_<  *   to handle. If we were a more-sophisticated driver, we'd?  *   probably have a state machine handle all this but for now, @  *   we'll just do some empirically-determined retry code. TheseA  *   errors can also "stack up": If the drive has just powered-updC  *   and you have just inserted media into it, you can get SENSE=6,e?  *   ASC=0x29 ("Power on, reset, or bus reset occurred") on onec@  *   retry and immediately get SENSE=6, ASC=0x28 ("``Not ready'';  *   to ``ready'' change , medium may have changed") on the_  *   next retry.  *  */                            . int packack( DQ_UCB *ucb, int init_time_flag )     {   D     char  model[DTN$K_NAMELEN_MAX+1] = "Nonexistent IDE/ATAPI disk";# 						/* Model name upon failure */bT     int   mod_len = 26;				/* Length of model string (*WITHOUT* trailing <null>!) */+     DTN   *dtn;					/* Dummy DTN pointer */o>     int   status;				/* Return status from various routines */'     int   retry;				/* Retry counter */A0     int   cyl_lo;				/* Drive CYL_LO register */0     int   cyl_hi;				/* Drive CYL_HI register */0     int   drvsts;				/* Drive status register */  M     ucb->ucb$l_sense_key = 0xDEADDEAD;		/* Forget any remembered sense key */tY     ucb->ucb$l_asc       = 0xDEADDEAD;		/* Forget any remembered additional sense code */fc     ucb->ucb$l_ascq      = 0xDEADDEAD;		/* Forget any remembered additional sense code qualifier */t  8     status = fetch_drive_info( ucb, 0, init_time_flag ); 						/* Try an ATA get_info */t  /     if ( $FAIL( status ) )			/* Did it fail? */ =       {						/* If so, then read "signature", just in case */ _ 	drvsts = inp( ucb, RD_STS );		/* Read device status, quashing any pending interupts as well */ E 	cyl_hi = inp( ucb, RD_CYL_HI );		/* Read high order cylinder bits */aD 	cyl_lo = inp( ucb, RD_CYL_LO );		/* Read low order cylinder bits */<         status = fetch_drive_info( ucb, 1, init_time_flag );- 						/* And try an ATAPI get_info instead */            }   ;     if ( $FAIL( status ) )			/* Is status still failing? */Q!       {						/* If so, then... */rJ         status = ioc$add_device_type( model, mod_len, (UCB *) ucb, &dtn );B 						/* Change the device name to "Nonexistent IDE/ATAPI disk" */H         return( SS$_NOSUCHDEV );		/* And exit with appropriate status */           }R/ 						/* Either ATA or ATAPI get_info worked */ N     status = process_drive_info( ucb );		/* Collect the returned drive info */  +     if ( $FAIL( status ) )			/* Success? */R>         return( status );			/* If not, then exit with error */  =     if (init_time_flag)				/* Doing this during init_time? */ 	         {dF         return( SS$_NORMAL );			/* If so, all done -- go no further */	         }E  2     if (ucb->ucb$l_atapi_flag != 0)		/* ATAPI ? */       {   D         for (retry=0;retry<8;retry++)		/* Try this eight times... */=           {					/* Drives take ~10 seconds to become ready */_  S             status = atapi_read_capacity( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );(# 						/* Read the drive capacity */i  5             if ( $SUCCESS( status ) )		/* Success? */_C                 break;				/* If so, then break out of retry loop */   E             BPTRACE( 0x04200000 );		/* BREAK: Error during packack */   S             status = atapi_request_sense( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );E6 						/* Read the sense data to see what went wrong */     S             BPTRACE( 0x04210000 );		/* BREAK: After request_sense during packack */t  2             if ( $FAIL( status ) )		/* Success? */E                 return( status );		/* If not, then exit with error */   _             if (    (ucb->ucb$l_asc==0x04)	/* "Logical unit is in process of becoming ready" */ 9                  && (ucb->ucb$l_ascq==0x01) )	/*   :   */a(               {					/* If so, then... */>                 sleep( ucb, 2 );		/* Hang out for 2 seconds */=                 continue;			/* And commence the next retry */e                   }   F             if (ucb->ucb$l_asc==0x28)		/* "Medium may have changed" */?                continue;			/* If so, commence the next retry */   L             if (ucb->ucb$l_asc==0x29)		/* Various "Reset occurred" errors */?                continue;			/* If so, commence the next retry */   I             if (ucb->ucb$l_asc==0x30)		/* Incompatible medium in drive */ H                 return( SS$_MEDOFL );		/* Not much point in re-trying */  ?             if (ucb->ucb$l_asc==0x3A)		/* No medium in drive */ H                 return( SS$_MEDOFL );		/* Not much point in re-trying */  Z             if (    (ucb->ucb$l_asc==0x00)	/* The drive doesn't think an error occurred */9                  && (ucb->ucb$l_ascq==0x00) )	/*   :   */                {tc                 BPTRACE( 0x04220000 );		/* BREAK: Drive denies any error occurred during packack */r@                 continue;			/* Commence the next retry anyway */                   }_  # 						/* Any other sense keys... */ S             BPTRACE( 0x04230000 );		/* BREAK: Unhandled sense key during packack */iM             return( SS$_DRVERR );		/* And default to a nice, safe disaster */b3 						/*   "SYSTEM-W-DRVERR, fatal driver error" */   $               }					/* Next retry */  Q         status = atapi_process_size( ucb );	/* Collect the returned drive info */,/         if ( $FAIL( status ) )			/* Success? */iB             return( status );			/* If not, then exit with error */             }   =     baseucb.ucb$v_valid = 1;			/* Set the Volume VALID bit */q  ?     return( SS$_NORMAL );			/* Return to caller with success */C         }t     t< /* FETCH_DRIVE_INFO - This routine is used to read a drive's,  *                    drive information page  *	  * Input: *  *      ucb             pointer to the UCB4  *      atapi_flag      0 -- to do an ATA drive_info6  *                      1 -- to do an ATAPI drive_infoA  *      init_time_flag  Set to indicate we're being called duringbC  *                        initialization time: modifies processing.N  *
  * Output:  *      none  *
  * Status:  *      SS$_NORMAL --- success-  *      SS$_NODATA --- error reading the paget%  *      SS$_TIMEOUT -- device timeoutc  *  */_  G int fetch_drive_info( DQ_UCB *ucb, int atapi_flag, int init_time_flag )a     {c  /     int  status;				/* Routine return status */ (     int  orig_ipl;				/* Original IPL */.     int  drverr;				/* Drive error register *//     int  drvsts;				/* Drive status register */(     int	    unit;q     CRB	    *crb; 4     ID_PAGE *id_ptr;				/* Pointer to the ID page */       crb=baseucb.ucb$l_crb;6     unit=baseucb.ucb$w_unit;	    /* get unit number */G 						/* (This test is bypassed for ATAPI devices during init time!) */p9     if (    (init_time_flag == 0)		/* After init time? */ I          || (atapi_flag     == 0) )		/* Or trying an ATA (IDE) device? */$%       {						/* If either, then... */rE         status = wait_ready( ucb );		/* Wait for drive to be ready */UC         if ( $FAIL( status ) )			/* Check the status for failure */i7             return( status );			/* Return with error */            }    /*)  * Take out the device lock and raise IPLm  * Write the registers%  * Then issue the appropriate command   *  */-  #     ucb->ucb$l_unsolicited_int = 0;S  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );M     out( ucb, WT_DRV_HD, ucb->ucb$l_drv_head );	/* Select drive and head 0 */   :     if (atapi_flag)				/* Expecting ATA or ATAPI drive? */3         out( ucb, WT_CMD, CMD_ATA_PACKET_IDENTIFY);u! 						/* Expecting ATAPI drive */A     elseI         out( ucb, WT_CMD, CMD_ATA_IDENTIFY_DEV);/* Expecting ATA drive */   8     status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 1 );" 						/* Wait for the interrupt */>     if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */;         return( status );			/* If so, return with status */   ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */t:     if ( IS_SET( drvsts, STS_M_ERR ) )		/* Any errors?  */!       {						/* If so, then... */ @         drverr = inp( ucb, RD_ERROR );		/* Get the error byte */2         return( SS$_NODATA );			/* Return error */           }  						/* Else success, so... */pD     ucb->ucb$l_atapi_flag = atapi_flag;		/* Remember ATA or ATAPI */?     id_ptr = (ID_PAGE *)((crb->crb$l_auxstruc) + (unit * 512));a>     move_sec_from_drive( ucb, (BYTE *) id_ptr, BLK_SIZE_512 );0     return( SS$_NORMAL );			/* Return success */         }b     sD /* PROCESS_DRIVE_INFO - This routine is used to read and process theI  *                      information returned by the drive in the ID page.   *	  * Input: "  *      ucb     pointer to the UCB  *
  * Output:  *      none  *
  * Status:  *      SS$_NORMAL -- successp  *  *  * Note:  *<  *   ATAPI CD-ROM drives don't return any information in the>  *   sectors, heads, and cylinders field of the block returned>  *   returned by identify_drive. So for now, we dummy this up.?  *   atapi_process_size() will fill in the actual values later.   *  */   % int process_drive_info( DQ_UCB *ucb )      {t  ?     char    model[DTN$K_NAMELEN_MAX+1];		/* ASCIZ model name */_4     int     mod_len;				/* Length of model string */4     ID_PAGE *id_ptr;				/* Pointer to the ID page */,     DTN     *dtn;				/* Dummy DTN pointer */4     int     status;				/* Returned routine status */%     int     i;					/* String index */      CRB	    *crb;l     DDB	    *ddb;l     ADP	    *adp;r     int	    unit;      int     channel;  N /* Read the data from the sector buffer into the right place in the id page */          crb=baseucb.ucb$l_crb;     ddb=baseucb.ucb$l_ddb;6     unit=baseucb.ucb$w_unit;	    /* get unit number */     adp = baseucb.ucb$ps_adp;is     channel=ddb->ddb$t_name[2] & 1;    /* bit 0 of 3nd ctlr letter (ie dqB) determines primary/secondary channel */ ?     id_ptr = (ID_PAGE *)((crb->crb$l_auxstruc) + (unit * 512));    /*,  * Do some sanity checks for magnetic drives  *(  * Else force some data for ATAPI drives  *  */p9     if (ucb->ucb$l_atapi_flag == 0)		/* ATA or ATAPI ? */          {					/* ATA *//P         if (    (id_ptr->cyls > MAX_CYLINDER)	/* Check for too many cylinders */O              || (id_ptr->heads > MAX_HEAD+1)	/*   or too many heads          */oQ              || (id_ptr->sectors > MAX_SECTOR)	/*   or too many sectors        */eG              || (id_ptr->cyls == 0)		/*   or too few cylinders       */tH              || (id_ptr->heads == 0)		/*   or too few heads           */K              || (id_ptr->sectors == 0) )	/*   or too few sectors         */ 2           {					/* Any of those are bad, so...  */_             BPTRACE( 0x04300000 );		/* BREAK: Sanity checks failed during PROCESS_DRIVE_INFO *//=             return( SS$_IVADDR );		/* Sanity failed - exit */b               } 1 						/* Copy over the geometry information... */rF         baseucb.ucb$w_cylinders= id_ptr->cyls;	/* Set the cylinders */@         baseucb.ucb$b_tracks   = id_ptr->heads;	/* and tracks */B         baseucb.ucb$b_sectors  = id_ptr->sectors;/* and sectors */O         ucb->ucb$r_dq_dt.ucb$l_maxblock =	/* Now set maxblock based on those */r8                        baseucb.ucb$b_sectors	/*   :   */7                      * baseucb.ucb$b_tracks	/*   :   */r;                      * baseucb.ucb$w_cylinders;	/*   :   */l>         set_geom( ucb );			/* Set the geometry in the drive */  G 	/* If drive will is capable of logical block addressing then use    */ZG 	/* max lba as maxblock and fake  ucb geometry.  An exact geometry   */nG 	/* doesn't seem to be needed, but cyl*trk*sec does have to be >=    */ G 	/* maxblock or the Volume Control Block blockfactor will be 0 and   */ G 	/* cause divide by 0 crashes in mount and/or f11xqp.                */>  B 	ucb->ucb$l_drive_lba_capable = 0;		/* Assume no LBA capability */4 	if ( IS_SET( id_ptr->capabilities_49, CAP_M_LBA ) ) 	    {					/* If LBA capable */)= 	    ucb->ucb$l_drive_lba_capable = 1;	/* Set the LBA flag */rM 	    if ( (UINT)(ucb->ucb$r_dq_dt.ucb$l_maxblock) < id_ptr->lba_total_blocks)  		{s= 		ucb->ucb$r_dq_dt.ucb$l_maxblock = id_ptr->lba_total_blocks;p3 		get_geom (ucb->ucb$r_dq_dt.ucb$l_maxblock, ucb );s 		}c 	    }	         }-     else 	{					/* ATAPI */G         baseucb.ucb$w_cylinders= MAX_CYLINDER+1;/* Set the cylinders */ =         baseucb.ucb$b_tracks   = MAX_HEAD+1;	/* and tracks */ >         baseucb.ucb$b_sectors  = MAX_SECTOR;	/* and sectors */P         ucb->ucb$r_dq_dt.ucb$l_maxblock =	/* and now maxblock, based on those */:                        baseucb.ucb$w_cylinders	/*   :   */7                      * baseucb.ucb$b_tracks	/*   :   */s9                      * baseucb.ucb$b_sectors;	/*   :   */i   	} /*'  * Set flags based on capabilities flag   *  */   '     ucb->ucb$l_drive_dma_capable = 0;		a7     if ( IS_SET( id_ptr->capabilities_49, CAP_M_DMA ) )E)         ucb->ucb$l_drive_dma_capable = 1;>  1     /* Disable DMA on CYpress controller */						 '     if (ucb->ucb$l_ctrl_id == CYPRESS ) " 	ucb->ucb$l_drive_dma_capable = 0;  .     /* Disable DMA on IntelPIIXE controller */*     if (ucb->ucb$l_ctrl_id == INTELPIIXE ))         ucb->ucb$l_drive_dma_capable = 0;t   #if IA64%     if (ucb->ucb$l_ctrl_id == CMD649)r)         ucb->ucb$l_drive_dma_capable = 0;( #endif 			r)     if (ucb->ucb$l_drive_dma_capable) {		  	switch (ucb->ucb$l_ctrl_id) { 	    case ACER:			
             {D> 		/* Enabling DMA mode, 8 word fifo thresh, primary channel */.                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x54, '                             IOC$K_BYTE,D#                             0x99 ); = 		if ( $FAIL( status ) )		/* Return if error               */  		return(status);   @ 		/* Enabling DMA mode, 8 word fifo thresh, secondary channel */.                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x55,t'                             IOC$K_BYTE, #                             0x99 );(= 		if ( $FAIL( status ) )		/* Return if error               */a 		return(status);o 		break;				 	    } 	    case CMD649:  	    {  A                 /* Set-up the DRWTIM0 from the CMD Spec Pri/Mas*/K.                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x54,k'                             IOC$K_BYTE,f#                             0x3F );s  B                 /* Set-up the DRWTIM1 from the CMD Spec Pri/Sla */.                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x56,a'                             IOC$K_BYTE,*#                             0x3F );o 		E                 /* Set-up the CMDTIM from the CMD Spec Pri and Sec */ .                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x52,/'                             IOC$K_BYTE,O#                             0x3F );p  A                 /* Set-up the ARTTIM0 from the CMD Spec Pri/Mas*/e.                 status = ioc$write_pci_config(                              adp,,                             crb->crb$l_node,!                             0x53,/'                             IOC$K_BYTE,x#                             0x40 );  		break;
             }b  
 	    default:x 		break; 	}     }a 	    c /*  * Add the device type namei  *3  * Ok, this is brain damaged, but we have to do it.*9  * Each of the bytes in the ASCII string is byte swapped.   * So, swap them backg  *  */p/     mod_len =(MODEL_LENGTH>DTN$K_NAMELEN_MAX) ?eN               DTN$K_NAMELEN_MAX : MODEL_LENGTH;	/* Set the length of string */  A     for (i=0; i < (mod_len>>1)<<1; i += 2)	/* For each word... */s       {sL         model[i]   = id_ptr->model_number[i+1];	/* Copy the swapped bytes */9         model[i+1] = id_ptr->model_number[i];	/*   :   */:           }   D     if ( (mod_len & 1) == 1)			/* Get the odd last byte if needed */9         model[mod_len-1] = id_ptr->model_number[mod_len];s  N     model[mod_len] = '\0';			/* Make the string ASCIZ so strlen can size it */   /*B  * Now, working backwards along the string, remove trailing spaces  *  */n     for (i=1; i < mod_len; i++)*       {p?         if (model[mod_len - i] != ' ')		/* Is this a space ? */ 2             break;				/* Non-space - leave loop */C         model[mod_len - i] = '\0';		/* Terminate string at space */*           }h  O     mod_len = strlen( model );			/* Get the new length (as ASCII, not ASCIZ) */      /*C  * Now, add the device type and name for Dynamic Device Recognition*  *  */bF     status = ioc$add_device_type( model, mod_len, (UCB *) ucb, &dtn );:     return( SS$_NORMAL );			/* Return success to caller */         }i     iI /* ATAPI_PROCESS_SIZE - This routine is used to process the READ_CAPACITYM@  *                      information returned by the ATAPI drive.  *	  * Input:e"  *      ucb     pointer to the UCB  *
  * Output:  *      none  *
  * Status:  *      SS$_NORMAL ---- Successg?  *      SS$_IVBUFLEN -- Not a 512, 2048, or 2352 byte blocksize   *&  *                                    	  * Notes:   *:  *   1. Both values in the buffer are in big-endian formatD  *   2. The value in the buffer is the *MAXIMUM* LBN, i.e., blocks-1I  *   3. The value in the buffer may be expressed in 2KB (not 512B) blocks   *  *  */-  % int atapi_process_size( DQ_UCB *ucb )+     {   6     BYTE   *sense_ptr;				/* Pointer to the ID page */9     int    blocks;				/* Number of blocks on the volume*/c=     int    blocksize;				/* Bytes per block for the volume */R    2     sense_ptr = (BYTE *) ucb->ucb$ps_sense_buffer;3 						/* Bind onto returned data as a byte array */c  F     blocks =   (   sense_ptr[0]<<24		/* Re-order the maxblock value */0                  | sense_ptr[1]<<16		/*   :   *//                  | sense_ptr[2]<<8		/*   :   */t.                  | sense_ptr[3] )		/*   :   */:               + 1;				/* Account for blocks vs. max LBN */                                 ?     blocksize = sense_ptr[4]<<24		/* And the blocksize value *//-               | sense_ptr[5]<<16		/*   :   */o-               | sense_ptr[6]<<8			/*   :   */++               | sense_ptr[7];			/*   :   */   L     if (    (blocksize!=BLK_SIZE_512)		/* Do we recognize this blocksize? */L          && (blocksize!=BLK_SIZE_2048)		/* SCSI-3 spec'd CD-ROM? blocksize*/M          && (blocksize!=BLK_SIZE_2352) )	/* ATAPI tested CD-ROM blocksize? */sG         return( SS$_IVBUFLEN );			/* If not, "Invalid buffer length" *//     /* s	  *			NOTEI  *F  * Now that the bug with multiple transfers is fixed for CD drives we L  * should work out what is the optimum value to be setting in ucb$l_maxbcnt.  *O  * We also need to a lot of testing with the new number before we do this too!!u  * */]     ucb->ucb$r_dq_dt.ucb$l_maxbcnt = (MAX_ATAPI_512_XFER * BLK_SIZE_512); /* default value */*;     ucb->ucb$l_2K_flag = 0;			/* Clear the 2K block flag */t=     if (blocksize>=BLK_SIZE_2048)		/* CD-ROM-sized blocks? */i!       {						/* If so, then... */e=         ucb->ucb$l_2K_flag = 1;			/* Set the 2K block flag */ L         ucb->ucb$r_dq_dt.ucb$l_maxbcnt = (MAX_ATAPI_2K_XFER * BLK_SIZE_512);9 						/* And set the appropriate maximum transfer size */uD         blocks = (blocks<<2);			/* And account for 4-to-1 packing */           } . 						/* Copy over the geometry information */@     ucb->ucb$r_dq_dt.ucb$l_maxblock = blocks;	/* Set maxblock */5     get_geom (ucb->ucb$r_dq_dt.ucb$l_maxblock, ucb );.     3     return( SS$_NORMAL );			/* Return succeeding */          }     K /* GET_GEOM - this routine is used to get the current geometry of the driveA  *	  * Input: "  *      lbn	Total number of blocks  *	ucb	address of the UCB	  *
  * Output:  *      none  *
  * Status:/  *      SS$_NORMAL ---- success, geometry is ok -  *      SS$_BADPARAM -- geometry is incorrect0  *  */;$ static __int64 dq_isqrt( __int64 x )   {p   __int64 result;a     if ( x <= 1L )     return 1L;     result = x / 2;o  9   // use the built-in to avoid requiring the include filec   //.   while ( __LABS( x / result - result ) > 1L )-     result = ( result + ( x / result )) / 2L;f     return result;   }   * void get_geom( UINT VolSize, DQ_UCB *ucb )   {    __int64 SqRoot;    int lsec;    int ltrk;    int lcyl;+!   int Cylinders, Tracks, Sectors;      SqRoot = dq_isqrt( VolSize );    lsec = dq_isqrt( SqRoot );   ltrk = SqRoot / lsec; .   SqRoot = ((__int64) lsec * (__int64) ltrk );)   lcyl = (VolSize + SqRoot - 1) / SqRoot;.  7   baseucb.ucb$w_cylinders  = (unsigned short int) lcyl;R2   baseucb.ucb$b_tracks     = (unsigned char) ltrk;2   baseucb.ucb$b_sectors    = (unsigned char) lsec;  	   return;    }      /L /* SET_GEOM - this routine is used to set the current geometry in the drive.  *	  * Input: "  *      ucb     pointer to the UCB  *
  * Output:  *      none  *
  * Status:/  *      SS$_NORMAL ---- success, geometry is ok*-  *      SS$_BADPARAM -- geometry is incorrect   *  */    int set_geom( DQ_UCB *ucb )$     {E  )     int   sector;					/* Sector number */a7     int   drv_head;					/* Drive drive/head register */ )     int   cyl;						/* Cylinder number */ 9     int   status;					/* Status returned from routines */t*     int   orig_ipl;					/* Original IPL */1     int   drvsts;					/* Drive status register */.0     int   drverr;					/* Drive error register */  ' /* Attempt to read the maximum block */r  G     sector   = baseucb.ucb$b_sectors;			/* Use highest sector number */F<     drv_head = ucb->ucb$l_drv_head+(baseucb.ucb$b_tracks-1);$ 							/* Use highest head number */N     cyl      = baseucb.ucb$w_cylinders - 1;		/* Use highest cylinder number */   /*)  * Take out the device lock and raise IPL   * Write the registers  * Then issue the commandn  *  */F  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );<     out( ucb, WT_SEC_CNT, sector);			/* Set sectors/track */>     out( ucb, WT_DRV_HD, drv_head);			/* Set heads/cylinder */H     out( ucb, WT_CMD, CMD_ATA_INIT_DEV_PARAMS);		/* Issue the command */  T     status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 2 );/* Wait for the interrupt */?     if ( $FAIL( status ) )				/* Any error (timeout, etc.) ? */p<         return( status );				/* If so, return with status */  @     drvsts = inp( ucb, RD_ALT_STS );			/* Get the status byte */  :     if ( IS_SET( drvsts, STS_M_ERR ) )			/* Any errors? */"       {							/* If so, then... */A         drverr = inp( ucb, RD_ERROR );			/* Get the error byte */ N         BPTRACE( 0x04400000 );				/* BREAK: Drive error during set_geometry */;         return( SS$_IVADDR );				/*  and return an error */            }   =     if ( IS_CLEAR( drvsts, STS_M_DRDY ) )		/* If not READY */L       {VR         BPTRACE( 0x04410000 );				/* BREAK: Drive not ready during set_geometry */?         return( SS$_DRVERR );				/*  return with DRIVE ERROR */W           }*  6     return( SS$_NORMAL );				/* Return with success */         }      IP /* SET_FEATURES - This routine is used to set the current features in the drive.  *	  * Input: "  *      ucb     pointer to the UCB  *
  * Output:  *      none  *
  * Status:/  *      SS$_NORMAL ---- success, geometry is okr-  *      SS$_BADPARAM -- geometry is incorrectb  *  */e  7 int set_features( DQ_UCB *ucb, int feature, int value )      {   1     int   drvsts;					/* Drive status register */y0     int   drverr;					/* Drive error register */*     int   orig_ipl;					/* Original IPL */9     int   status;					/* Status returned from routines */o    <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );E     wait_ready( ucb );					/* Make sure unit is selected and ready */ S     out( ucb, WT_FEATURES, feature );			/* Select the specific feature to be set */*=     out( ucb, WT_SEC_CNT, value );			/* Set specific value */r< 							/*   (A value is only meaningful for feature 0x03) */F     out( ucb, WT_CMD, CMD_ATA_SET_FEATURES );		/* Issue the command */  T     status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 3 );/* Wait for the interrupt */?     if ( $FAIL( status ) )				/* Any error (timeout, etc.) ? */	<         return( status );				/* If so, return with status */  @     drvsts = inp( ucb, RD_ALT_STS );			/* Get the status byte */:     if ( IS_SET( drvsts, STS_M_ERR ) )			/* Any errors? */"       {							/* If so, then... */A         drverr = inp( ucb, RD_ERROR );			/* Get the error byte */eN         BPTRACE( 0x04080300 );				/* BREAK: Drive error during set_features */;         return( SS$_IVADDR );				/*  and return an error */            }u  =     if ( IS_CLEAR( drvsts, STS_M_DRDY ) )		/* If not READY */L       {GR         BPTRACE( 0x04080301 );				/* BREAK: Drive not ready during set_features */?         return( SS$_DRVERR );				/*  return with DRIVE ERROR */0           }   6     return( SS$_NORMAL );				/* Return with success */         }*        /* SEEK - Perform Seek operation  *A  * IDE drives will return immediately upon issuing the first seekfB  * command.  Subsequent commands will actually wait until the seekD  * is completed.  This routine issues only one seek command and thenC  * completes the I/O.  Any subsequent command will be stalled untilP  * the seek is completed.E  *	  * Input:   *      ucb     pointer to UCB  *
  * Output:  *      status value+  *              SS$_NORMAL -- seek complete   *  */e   int seek( DQ_UCB *ucb )P     {0  *     int   status;				/* Status of calls */)     int   orig_ipl;				/* Original IPL */n(     int   cyl;					/* Cylinder number */0     int   drvsts;				/* Drive status register *//     int   drverr;				/* Drive error register */      int   drv_head;	     		B     status = wait_ready( ucb );			/* Wait for drive to be ready */?     if ( $FAIL( status ) )			/* Check the status for failure */ 3         return( status );			/* Return with error */c   /* Set up seek parameters */  ?     cyl = ucb->ucb$l_media.lbn;			/* Get the cylinder number */*   /*)  * Take out the device lock and raise IPLC  * Write the registers  * Then issue the commandC  *  */CD     drv_head= ucb->ucb$l_drv_head;              /* Get drive info */F     if (ucb->ucb$l_drive_lba_capable)           /* If LBA mode, ... */E         drv_head |= DRVHD_M_LBA;                /* Set the LBA bit */u    <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );?     out( ucb, WT_DRV_HD, drv_head);	/* Select drive and head */ =     out( ucb, WT_SECTOR, 1);			/* Put in the sector number */ >     out( ucb, WT_CYL_LO, cyl);			/* Low order cylinder bits */A     out( ucb, WT_CYL_HI, cyl>>8);		/* High order cylinder bits */ L     out( ucb, WT_CMD,    CMD_ATA_SEEK);		/* Attempt to seek to the sector */  8     status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 4 );" 						/* Wait for the interrupt */>     if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */;         return( status );			/* If so, return with status */<  ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */ 9     if ( IS_SET( drvsts, STS_M_ERR ) )		/* Any errors? */t!       {						/* If so, then... */r@         drverr = inp( ucb, RD_ERROR );		/* Get the error byte */E         BPTRACE( 0x04100000 );			/* BREAK: Drive error during seek */ED         return( SS$_DRVERR );			/* Return with DRIVE ERROR status */           }o  5     return( SS$_NORMAL );			/* Return with success */I         }      a) /* DRVCLR - Perform Drive Clear operationk  *	  * Input:	  *      ucb     pointer to UCB  *
  * Output:  *      status value  *  */    int drvclr( DQ_UCB *ucb )      {I       return( SS$_NORMAL );          }       & /* READRCT - Perform READRCT operation  *3  * This routine returns the drive information page.   *	  * Input:A  *      ucb     pointer to UCB  *
  * Output:  *      none  *  * Return value:  *      status value%  *              SS$_NORMAL -- success =  *              SS$_NODATA -- failed to get drive information(  *  */i   int readrct( DQ_UCB *ucb )     {	  0     int   status;				/* Routine return status */)     int   orig_ipl;				/* Original IPL */h0     int   drvsts;				/* Drive status register *//     int   drverr;				/* Drive error register */F6     void  *temp;				/* Dummy for IOC$MOVTOUSER call */     int   drv_head;	  <     status = wait_ready( ucb );			/* Wait for drive ready */2     if ( $FAIL( status ) )			/* Check for error */>         return( status );			/*   and return if there is one */  D     drv_head= ucb->ucb$l_drv_head;              /* Get drive info */F     if (ucb->ucb$l_drive_lba_capable)           /* If LBA mode, ... */E         drv_head |= DRVHD_M_LBA;                /* Set the LBA bit */   <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );B     out( ucb, WT_DRV_HD, drv_head );	/* Select drive and head 0 */F     out( ucb, WT_CMD, CMD_ATA_IDENTIFY_DEV );	/* Ask for drive info */  8     status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 5 );" 						/* Wait for the interrupt */>     if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */;         return( status );			/* If so, return with status */r  ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */e8     if ( IS_SET( drvsts, STS_M_ERR) )		/* Any errors? */        {						/* If so, then.. */@         drverr = inp( ucb, RD_ERROR );		/* Get the error byte */5         return( SS$_NODATA );			/* Exit with error */            }r  O     move_sec_from_drive( ucb, (BYTE *) ucb->ucb$ps_xfer_buffer, BLK_SIZE_512 );C0 						/* Get the returned data from our drive */  Y     ioc_std$movtouser( ucb->ucb$ps_xfer_buffer, baseucb.ucb$l_bcnt, (UCB *) ucb, &temp );T% 						/* Move the data to the user */   5     return( SS$_NORMAL );			/* Return with success */O         }.      _    ( /* DIAGNOSE - Perform DIAGNOSE operation  *H  * This routine implements pass-through of user formatted ATAPI commandsH  * directly to the device, usually for audio function of CD-ROM players.  *	  * Input:   *      ucb     pointer to UCB  *
  * Output:  *      none  *  * Return value:  *      status value%  *              SS$_NORMAL -- successC=  *              SS$_NODATA -- failed to get drive information   *  */    int diagnose(DQ_UCB *ucb ) {_;     BYTE  *packet;				/* The packet bytes within the UCB */ L     int   *packetl;			       	/* The packet (as longwords) within the UCB */1     int    status;				/* Routine return status */ O     int    xfer_cnt;				/* Count of blocks actually transferred (dummy here) */r:     BYTE  *buffer;				/* Pointer to our transfer buffer */9     BYTE  *user_va;				/* Returned user buffer address */      void *svaptr;3  ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */i"     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  Z     packet = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */H     memcpy(packet, ucb->diagnose_command, ucb->diagnose_command_length);R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */       /*S      * Cdrecord calls us with a timeout time in 'ucb->diagnose_disconnect_timeout'.s:      * Use it only if it is greater than our TIMEOUT_TIME.	      */  t8     if (ucb->diagnose_disconnect_timeout > TIMEOUT_TIME)< 	ucb->ucb$l_int_max_wait = ucb->diagnose_disconnect_timeout;     elseY 	ucb->ucb$l_int_max_wait = TIMEOUT_TIME;	/* reset our timeout time back to its default */e  2     if ( (ucb->ucb$l_drive_dma_capable == TRUE) &&# 	 (ucb->ucb$l_ctrl_id == CMD649)) {   2 	/* Queue the Diagnose command with DMA enabled */R 	status = atapi_packet_command(ucb, buffer, baseucb.ucb$l_bcnt, &xfer_cnt, TRUE );       } else {   3 	/* Queue the Diagnose command with DMA disabled */iS 	status = atapi_packet_command(ucb, buffer, baseucb.ucb$l_bcnt, &xfer_cnt, FALSE );_       }   E     if (status == SS$_DRVERR)			/* Did it result in a drive error? */=!       {						/* If so, then... */ F         atapi_request_sense( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );% 						/* Get error info from drive */p1         status = atapi_xlate_error_to_vms( ucb ); ) 						/* Turn it into a VMS error code */(*         return( status );			/* and exit */           }        if (status == SS$_NORMAL) { %         if (baseucb.ucb$l_bcnt > 0) {rF             ioc_std$movtouser(buffer, xfer_cnt, (UCB *) ucb, &svaptr);	         }j     }*  3     ucb->ucb$l_bcr = baseucb.ucb$l_bcnt - xfer_cnt;e       return(status);  }w  e   m2 /* IO_READ - Performs IO$_READxBLK driver function  *E  * This routine issues READ commands to the drive.  This routine williF  * break up the request into segments of not more than 127 sectors per  * command.      p  * d  * Input:              u  *      ucb     pointer to UCB  *
  * Output:  *      status value  *  */e   int io_read( DQ_UCB *ucb )     {*  <     int   offset;				/* Offset within a possible 2K block *//     int   xfer_size;				/* Size (in sectors) */dO     int   xfer_cnt;				/* Count of 512-byte blocks read in the latest segment*/D,     int   blks_xfrd;				/* For-loop index */1     int   byte_cnt;				/* Number of bytes read */D:     BYTE  *buffer;				/* Pointer to our transfer buffer */8     int   xfer_req;				/* Number of sectors requested */0     int   status;				/* Routine return status *//     int   retry_cnt;				/* Error retry count */s3     int   buf_ofs;				/* Offset into user buffer */*9     BYTE  *user_va;				/* Returned user buffer address */g  .     TRACE( 0x07000000 );			/* READ starting */  P     status = wait_ready( ucb );			/* Wait for drive to be ready for a command */9     if ( $FAIL( status ) )			/* Check status for error */ 3         return( status );			/* Return with error */e  / 						/* Compute number of blocks and set up */aE     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE_512 - 1) >> BLK_SHIFT;q;     if (xfer_size == 0)				/* Was there any work to do ? */i>         return( SS$_NORMAL );			/* Exit with success if not */
               R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */8     retry_cnt = 0;				/* Initialize the retry counter */  I     for (blks_xfrd = 0; blks_xfrd < xfer_size;)	/* For each segment... */a       {d  W         xfer_req = xfer_size - blks_xfrd;	/* Compute 512-byte blocks left to be read */   > /* Later, for unbuffered DMA, set up the map registers here */  <         if (ucb->ucb$l_2K_flag)			/* A 2KB sector device? */c              offset = ucb->ucb$l_media.lbn & 0x03;/* Calculate offset within our transfer buffer */ '            else					/* Else if no... */l3              offset = 0;			/* No offset required */n  =         status = read_dispatcher( ucb, xfer_req, &xfer_cnt );H 						/* Read this segment */r?         if ( $FAIL( status ) )			/* How did that segment go? */f           {   _             if (    (ucb->ucb$l_asc==0x04)	/* "Logical unit is in process of becoming ready" */t9                  && (ucb->ucb$l_ascq==0x01) )	/*   :   */I@                 sleep( ucb, 10 );		/* Hang out for 10 seconds */  I             if (ucb->ucb$l_asc==0x30)		/* Incompatible medium in drive */*D                 return( status );		/* Not much point in re-trying */  ?             if (ucb->ucb$l_asc==0x3A)		/* No medium in drive */rD                 return( status );		/* Not much point in re-trying */  T             if (status==SS$_BADPARAM)		/* Bad parameter (e.g., LBN out of range)? */C                 return( status );		/* We won't retry that either */a  E             if (status==SS$_VOLINV)		/* Did the volume go invalid? */ C                 return( status );		/* We won't retry that either */ 0 						/* (A retry might erroneously succeed!) */               if (xfer_cnt == 0)               {e7                 retry_cnt++;			/* Update retry count */	P                 if (retry_cnt == MAX_RETRY/2)	/* Halfway through the retries? */                   { P                     BPTRACE( 0x07010000 );	/* BREAK: read wants to do a reset */?                     reset_ctrl(ucb);		/* If so, reset things */i                       } Q                 if (retry_cnt > MAX_RETRY)	/* Were there too many retries yet? */dA                     return( status );		/* Yes, exit with error */                    }*               }                else           {;@             if (xfer_cnt > 0)			/* Was any data transferred ? */H                 retry_cnt = 0;			/* Clear retry count on each success */               }	  >         if (xfer_cnt == 0)			/* Check that we got something */)             continue;				/* Next retry */   0 /* Later, for unbuffered DMA, skip this block */  7 						/* This segment is now in the transfer buffer. */e- 						/* Move the data segment to the user */uY         byte_cnt = xfer_cnt << BLK_SHIFT;	/* Calculate the byte count for this segment */	i         if (byte_cnt > ucb->ucb$l_bcr)		/* Check if the transfer exceeded the user's desired bytecount */ ]             byte_cnt = ucb->ucb$l_bcr;		/* If so, minimize it to the user's actual request */bO         buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE_512; @ 						/* Calculate the offset (so far) into the user's buffer */<         user_va = map_user_buffer( ucb, buf_ofs, byte_cnt );, 						/* Map that part of the user buffer */L         TRACE( 0x07020000 + byte_cnt );		/* READ moving bytes to the user */B         memcpy( user_va, &buffer[offset*BLK_SIZE_512], byte_cnt );0 						/* And copy our data to the user buffer */  J         ucb->ucb$l_bcr -= byte_cnt;		/* Update the byte count remaining */>         ucb->ucb$l_media.lbn += xfer_cnt;	/* Update the LBN */@         blks_xfrd += xfer_cnt;			/* Update the for-loop index */  "           }					/* Next segment */  5     return( SS$_NORMAL );			/* Return with success *//         }*      E /* READ_DISPATCHER - Figure out which routine to use for this segment   *E  * We have (up to) six different handlers for doing the actual reads. 1  * Based on three flags, dispatch to one of them.h  *	  * Input: $  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  * Note:  *D  *   You can modify this routine to select, on a case-by-case basis,,  *   which transfers will be done using DMA.  *  */   ? int read_dispatcher( DQ_UCB *ucb, int xfer_req, int *xfer_cnt ):     {e       int dispatch;*    N     dispatch = (ucb->ucb$l_atapi_flag << 2)		/* Decide which routine to use */8              + (ucb->ucb$l_2K_flag    << 1)		/*   :   */>              + (ucb->ucb$l_drive_dma_capable    );	/*   :   */  A     switch (dispatch)					/* Switch to the appropriate handler */	       {e           case (0x0): e           return read_ata_seg_pio(   ucb, xfer_req, xfer_cnt );		/* ATA, 512-byte sectors, via PIO */	           case (0x1):te           return read_ata_seg_dma(   ucb, xfer_req, xfer_cnt );		/* ATA, 512-byte sectors, via DMA */            case (0x4):rm           return read_atapi_512_seg( ucb, xfer_req, xfer_cnt, FALSE );	/* ATAPI, 512-byte sectors, via PIO */u           case (0x5): l           return read_atapi_512_seg( ucb, xfer_req, xfer_cnt, TRUE );	/* ATAPI, 512-byte sectors, via DMA */           case (0x6): h           return read_atapi_2K_seg(  ucb, xfer_req, xfer_cnt, FALSE );	/* ATAPI, 2KB sectors, via PIO */           case (0x7):Lg           return read_atapi_2K_seg(  ucb, xfer_req, xfer_cnt, TRUE );	/* ATAPI, 2KB sectors, via DMA */*  ,         default:							/* Unexpected case */6           break;							/* Fall into the bugcheck... */             }t  ;     bug_check( INCONSTATE, FATAL, COLD );				/* So be it */ L     return( SS$_ABORT );						/* (You should live so long as to get here) */         }b     _B /* READ_ATA_SEG_PIO - Read one segment from an ATA drive using PIO  *:  * This routine performs the read of a single I/O segment.E  * Each segment is a single read command of not more the MAX_ATA_XFEReD  * sectors. The overall read I/O routine calls this routine for each6  * of the segments until the entire read is completed.  *	  * Input:	$  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  * Note:  *                      ?  *   o Some drives sometimes give the interrupt *VERY* quickly,fB  *     before I can get back to the WFIKPCH. (This probably occursA  *     when cached data is available in the drive.) I handle this ?  *     by caching the fact that an as-yet-unsolicited interrupta  *     occurred.  *  */e  @ int read_ata_seg_pio( DQ_UCB *ucb, int xfer_req, int *xfer_cnt )     {n  /     int   sec;					/* Disk location (sector) */).     int   head;					/* Disk location (head) */9     BYTE *buffer;				/* Pointer to our transfer buffer */D,     int   cyl;					/* Disk location (cyl) */6     int   drv_head;				/* Drive drive/head register */7     int   status;				/* Returned status from routine */c&     int   orig_ipl;				/* Saved IPL */0     int   drvsts;				/* Drive status register *//     int   drverr;				/* Drive error register */-  D     TRACE( 0x07100000 + xfer_req );		/* READ_ATA_SEG_PIO starting */T     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */  D     if (xfer_req > MAX_ATA_XFER)		/* Check for too large a request*/@         xfer_req = MAX_ATA_XFER;		/*  and minimize if too big */  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */6     *xfer_cnt = 0;				/* Clear count of blocks read */  8     drv_head= ucb->ucb$l_drv_head;		/* Get drive info */=     if (ucb->ucb$l_drive_lba_capable)		/* If LBA mode, ... */u7         drv_head |= DRVHD_M_LBA;		/* Set the LBA bit */   M     compute_address( ucb, &sec, &head, &cyl );	/* Compute physical address */    /*)  * Take out the device lock and raise IPLt  * Write the registers  * Then issue the command   *  */r  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );9 						/* Take out the device lock for the first sector */.E     out( ucb, WT_DRV_HD, drv_head|head );	/* Select drive and head */l@     out( ucb, WT_SEC_CNT, xfer_req );		/* Ask for "n" sectors */@     out( ucb, WT_SECTOR, sec );			/* Put in the sector number */?     out( ucb, WT_CYL_LO, cyl );			/* Low order cylinder bits */oB     out( ucb, WT_CYL_HI, cyl>>8 );		/* High order cylinder bits */K     out( ucb, WT_CMD, CMD_ATA_READ_SECS );	/* Attempt to read the sector */-  N     for (;;)					/* Do forever (for each sector in the transfer request)... */         {X  <         status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 6 );" 						/* Wait for the interrupt */B         if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */?             return( status );			/* If so, return with status */s         ; 	drvsts = inp( ucb, RD_ALT_STS );	/* Get the status byte */cA         if ( IS_SET( drvsts, STS_M_ERR ) )	/* Check the status */*,           {					/* If any errors, then... */C             drverr = inp( ucb, RD_ERROR );	/* Get the error byte */_T             BPTRACE( 0x07110000 );		/* BREAK: Drive error during READ_ATA_SEG_PIO */A             return( SS$_DRVERR );		/* Return with error status */                }_  V 	status = wait_ready( ucb );             /* Wait for DRDY before we move from drive */M 	move_sec_from_drive( ucb, &buffer[(*xfer_cnt)*BLK_SIZE_512], BLK_SIZE_512 );nA 						/* Move the sector from the drive to our transfer buffer */m3         *xfer_cnt += 1;				/* Count a block read */s  4         if (*xfer_cnt >= xfer_req )		/* Finished? */C             break;				/* If so, break out of the do-forever loop */w  @         device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );> 						/* Else take out the deviced lock and go 'round again */  8           }					/* Next sector in the do-forever loop */  =     return( SS$_NORMAL );			/* Return to caller succeeding */t         },     lB /* READ_ATA_SEG_DMA - Read one segment from an ATA drive using DMA  *:  * This routine performs the read of a single I/O segment.E  * Each segment is a single read command of not more the MAX_ATA_XFER_D  * sectors. The overall read I/O routine calls this routine for each6  * of the segments until the entire read is completed.  *	  * Input: $  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  * Note:  *?  *   o Some drives sometimes give the interrupt *VERY* quickly, B  *     before I can get back to the WFIKPCH. (This probably occursA  *     when cached data is available in the drive.) I handle thisr?  *     by caching the fact that an as-yet-unsolicited interruptt  *     occurred.  *  */e  @ int read_ata_seg_dma( DQ_UCB *ucb, int xfer_req, int *xfer_cnt ) {,/     int   sec;					/* Disk location (sector) */b.     int   head;					/* Disk location (head) */9     BYTE *buffer;				/* Pointer to our transfer buffer */ ,     int   cyl;					/* Disk location (cyl) */6     int   drv_head;				/* Drive drive/head register */7     int   status;				/* Returned status from routine */E&     int   orig_ipl;				/* Saved IPL */0     int   drvsts;				/* Drive status register *//     int   drverr;				/* Drive error register */     D     TRACE( 0x07800000 + xfer_req );		/* READ_ATA_SEG_DMA starting */T     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */<     *xfer_cnt = 0;				/* Consider none of the blocks read */  D     if (xfer_req > MAX_ATA_XFER)		/* Check for too large a request*/@         xfer_req = MAX_ATA_XFER;		/*  and minimize if too big */  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */  8     drv_head= ucb->ucb$l_drv_head;		/* Get drive info */=     if (ucb->ucb$l_drive_lba_capable)		/* If LBA mode, ... */ 7         drv_head |= DRVHD_M_LBA;		/* Set the LBA bit */d  M     compute_address( ucb, &sec, &head, &cyl );	/* Compute physical address */   ,     load_prdt( ucb );				/* Load the PRDT */  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );B 						/* Take out the device lock so we can write the registers */  C     out( ucb, WT_DMA_CMD, DMA_CMD_M_INBOUND | DMA_CMD_M_INACTIVE ); 7 						/* Make sure the DMA controller is inbound     */l7 						/*   (that is, reading disk -> writing memory) */ 7 						/*   but not active yet                        */xK     out( ucb, WT_DMA_AD0, ( ( (UINT) ucb->ucb$l_prdt_phy )      ) & 0xFF );uK     out( ucb, WT_DMA_AD1, ( ( (UINT) ucb->ucb$l_prdt_phy ) >> 8 ) & 0xFF ); K     out( ucb, WT_DMA_AD2, ( ( (UINT) ucb->ucb$l_prdt_phy ) >>16 ) & 0xFF );sK     out( ucb, WT_DMA_AD3, ( ( (UINT) ucb->ucb$l_prdt_phy ) >>24 ) & 0xFF ); E 						/* Point the controller to the PCI address of our PRDT table */ \     out( ucb, WT_DMA_STS, DMA_STS_M_DRV1 | DMA_STS_M_DRV0 | DMA_STS_M_INT | DMA_STS_M_ERR );3 						/* For now, set both drives as DMA-capable */ G 						/* Write "1"s to INT and ERR to clear them in case they're set */,E     out( ucb, WT_DRV_HD, drv_head|head );	/* Select drive and head */ @     out( ucb, WT_SEC_CNT, xfer_req );		/* Ask for "n" sectors */@     out( ucb, WT_SECTOR, sec );			/* Put in the sector number */?     out( ucb, WT_CYL_LO, cyl );			/* Low order cylinder bits */wB     out( ucb, WT_CYL_HI, cyl>>8 );		/* High order cylinder bits */M     out( ucb, WT_CMD, CMD_ATA_READ_DMA );	/* Attempt to read the sector(s) */ A     out( ucb, WT_DMA_CMD, DMA_CMD_M_INBOUND | DMA_CMD_M_ACTIVE ); 7 						/* Set the DMA controller inbound              */r7 						/*   (that is, reading disk -> writing memory) */ 7 						/*   and active                                */   U     if ( ((ucb->ucb$l_drive_dma_capable == TRUE) && (ucb->ucb$l_ctrl_id == CMD649)) )$9 	status = dq_dma_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 7 ); 	     else b5 	status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 7 );*  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );% 						/* Take out the deviced lock */tU     out( ucb, WT_DMA_CMD, DMA_CMD_M_INACTIVE );	/* Set the DMA controller inactive */   ?     device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );A     >     if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */;         return( status );			/* If so, return with status */   ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */y  T     if ( IS_SET( drvsts,  DMA_STS_M_ERR) )	/* Check the status (saved from above) */'     {						/* If any errors, then... */ @         drverr = inp( ucb, RD_ERROR );		/* Get the error byte */>         return( SS$_DRVERR );			/* Return with error status */(     }						/* Return the deviced lock */  A     *xfer_cnt = xfer_req;			/* Consider all of the blocks read */*  =     return( SS$_NORMAL );			/* Return to caller succeeding */o   }o      K /* READ_ATAPI_512_SEG - Read one segment from a 512-byte-sector ATAPI drivea  *:  * This routine performs the read of a single I/O segment.K  * Each segment is a single read command of not more the MAX_ATAPI_512_XFER D  * sectors. The overall read I/O routine calls this routine for each6  * of the segments until the entire read is completed.  *	  * Input:c$  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer/  *      dma_flag      whether or not to use DMAE
  *           r  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  */v  P int read_atapi_512_seg( DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag )     {*  9     BYTE *buffer;				/* Pointer to our transfer buffer */L1     int   offset;				/* Offset within 2K block */ ;     BYTE  *packet;				/* The packet bytes within the UCB */1E     int   *packetl;				/* The packet (as longwords) within the UCB */ /     int   status;				/* Routine status value */1*     int   orig_ipl;				/* Originial IPL */
              n  J     TRACE( 0x07200000 + xfer_req );		/* READ_ATAPI_512_SEG_PIO starting */  L     if (xfer_req > MAX_ATAPI_512_XFER)		/* Check for too large a transfer */A         xfer_req = MAX_ATAPI_512_XFER;		/*  and limit it if so *//  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */  ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */ "     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  [     packet  = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */u;     packet[0]  = CMD_ATAPI_READ_12;		/* Read(12) command */ * /*  packet[1]  = 0x00;				/@ (Reserved) */C /*  packet[2]  = 0x00;				/@ Address MSB (filled in momentarily) */o, /*  packet[3]  = 0x00;				/@   :      :   */, /*  packet[4]  = 0x00;				/@   :      :   */, /*  packet[5]  = 0x00;				/@   :     LSB  */D     packet[6]  = xfer_req>>24;			/* Transfer length MSB in blocks */:     packet[7]  = xfer_req>>16;			/*   :              :  */9     packet[8]  = xfer_req>>8;			/*   :              :  */?6     packet[9]  = xfer_req;			/*   :             LSB */* /*  packet[10] = 0x00;				/@ (Reserved) */* /*  packet[11] = 0x00;				/@ (Reserved) */M     offset     = fill_packet_w_adx( ucb );	/* Fill the packet address cells*/t  O     status = atapi_packet_command( ucb, buffer, xfer_req, xfer_cnt, dma_flag );wJ 						/* Do the common packet-command processing using appropriate mode */E     if (status == SS$_DRVERR)			/* Did it result in a drive error? */u!       {						/* If so, then... */ F         atapi_request_sense( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );% 						/* Get error info from drive */*1         status = atapi_xlate_error_to_vms( ucb ); ) 						/* Turn it into a VMS error code */b*         return( status );			/* and exit */           }*  <     if ( $FAIL( status ) )			/* Check for any other error */1         return( status );			/*  and exit if so */n   						/* All looks okay */2     return( SS$_NORMAL );			/* Return to caller */         }l     cH /* READ_ATAPI_2K_SEG - Read one segment from a 2Kbyte-sector ATAPI drive  *:  * This routine performs the read of a single I/O segment.J  * Each segment is a single read command of not more the MAX_ATAPI_2K_XFERD  * sectors. The overall read I/O routine calls this routine for each6  * of the segments until the entire read is completed.  *	  * Input:*$  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer/  *      dma_flag      whether or not to use DMAi  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  */e  O int read_atapi_2K_seg( DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag )-     {   9     BYTE *buffer;				/* Pointer to our transfer buffer */ 1     int   offset;				/* Offset within 2K block */,;     BYTE  *packet;				/* The packet bytes within the UCB */ E     int   *packetl;				/* The packet (as longwords) within the UCB */d/     int   status;				/* Routine status value */;)     int   orig_ipl;				/* Original IPL */iD     int   xfer_req_2K;				/* Number of 2Kbyte sectors to transfer */T     int   saved_xfer_req;			/* actual number of blocks that we are going to transfer  E     TRACE( 0x07300000 + xfer_req );		/* READ_ATAPI_2K_SEG starting */a  K     if (xfer_req > MAX_ATAPI_2K_XFER)		/* Check for too large a transfer */ @         xfer_req = MAX_ATAPI_2K_XFER;		/*  and limit it if so */  T     saved_xfer_req = xfer_req;			/* save the number of blocks requested for later */  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */  ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */ "     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  [     packet  = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */	  g     offset     = fill_packet_w_adx( ucb );	/* Fill the packet address cells and calculate the offset */m  k     xfer_req    = xfer_req + offset - 1;	/* Maximize the transfer so it spans any 2K-byte sectors needed */bg     xfer_req_2K = (xfer_req >> 2) + 1;		/* Divide the transfer request by 4 to account for 2K blocks */u 						/*   and add 1 */se     xfer_req    = xfer_req_2K<<2;		/* Now expand the 512-byte-block-oriented xfer_req to encompass */ H 						/*   all of the 2K-byte block(s) to be transferred              */  ;     packet[0]  = CMD_ATAPI_READ_12;		/* Read(12) command */	* /*  packet[1]  = 0x00;				/@ (Reserved) */? /*  packet[2]  = 0x00;				/@ Address MSB (already filled-in) */D, /*  packet[3]  = 0x00;				/@   :      :   */, /*  packet[4]  = 0x00;				/@   :      :   */, /*  packet[5]  = 0x00;				/@   :     LSB  */N     packet[6]  = xfer_req_2K>>24;		/* Transfer length MSB in 2Kbyte sectors */<     packet[7]  = xfer_req_2K>>16;		/*   :              :  */;     packet[8]  = xfer_req_2K>>8;		/*   :              :  */ 9     packet[9]  = xfer_req_2K;			/*   :             LSB */ * /*  packet[10] = 0x00;				/@ (Reserved) */* /*  packet[11] = 0x00;				/@ (Reserved) */    O     status = atapi_packet_command( ucb, buffer, xfer_req, xfer_cnt, dma_flag );eF 						/* Do the common packet-command processing using desired mode */  E     if (status == SS$_DRVERR)			/* Did it result in a drive error? */*!       {						/* If so, then... */4F         atapi_request_sense( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );% 						/* Get error info from drive */D1         status = atapi_xlate_error_to_vms( ucb );M) 						/* Turn it into a VMS error code */ *         return( status );			/* and exit */           }   <     if ( $FAIL( status ) )			/* Check for any other error */1         return( status );			/*  and exit if so */e  %     if (*xfer_cnt > saved_xfer_req)		 ? 	*xfer_cnt = saved_xfer_req;		/* Return requested amount max */o  2     return( SS$_NORMAL );			/* Return to caller */         }n      > /* DATACHECK - Performs data check function for read and write  * requests.  *	  * Input:i  *      ucb     pointer to UCB  *
  * Output:  *      status value(  *              SS$_NORMAL ----- success7  *              SS$_DATACHECK -- data failed to compareI  *  */o   int datacheck( DQ_UCB *ucb )     {/  <     int   offset;				/* Offset within a possible 2K block *//     int   xfer_size;				/* Size (in sectors) */eT     int   xfer_cnt;				/* Count of blocks read (to be compared) in latest segment */,     int   blks_xfrd;				/* For-loop index */:     BYTE  *buffer;				/* Pointer to our transfer buffer */5     int   byte_cnt;				/* Number of bytes compared */c8     int   xfer_req;				/* Number of sectors requested */0     int   status;				/* Routine return status *//     int   retry_cnt;				/* Error retry count */,3     int   buf_ofs;				/* Offset into user buffer */L9     BYTE  *user_va;				/* Returned user buffer address */t    3     TRACE( 0x08000000 );			/* DATACHECK starting */   >     ucb->ucb$l_bcr = ucb->ucb$l_org_bcnt;	/* Get byte count */L     ucb->ucb$l_media.lbn = ucb->ucb$l_org_media;/* Get first block number */B     baseucb.ucb$l_bcnt = ucb->ucb$l_org_bcnt;	/* Get byte count */A     baseucb.ucb$l_svapte = ucb->ucb$l_org_svapte;/* Get SVAPTE */ <     baseucb.ucb$l_boff = ucb->ucb$l_org_boff;	/* Get BOFF */  P     status = wait_ready( ucb );			/* Wait for drive to be ready for a command */6     if ( $FAIL( status ) )			/* Check return status */4         return( status );			/*  and exit on error */  / 						/* Compute number of blocks and set up */iE     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE_512 - 1) >> BLK_SHIFT;e;     if (xfer_size == 0)				/* Was there any work to do ? */ >         return( SS$_NORMAL );			/* Exit with success if not */  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */8     retry_cnt = 0;				/* Initialize the retry counter */  I     for (blks_xfrd = 0; blks_xfrd < xfer_size;)	/* For each segment... */O       {eW         xfer_req = xfer_size - blks_xfrd;	/* Compute 512-byte blocks left to be read */t  <         if (ucb->ucb$l_2K_flag)			/* A 2KB sector device? */c              offset = ucb->ucb$l_media.lbn & 0x03;/* Calculate offset within our transfer buffer */e'            else					/* Else if no... */n3              offset = 0;			/* No offset required */)  =         status = read_dispatcher( ucb, xfer_req, &xfer_cnt );	 						/* Read this segment */e  ?         if ( $FAIL( status ) )			/* How did that segment go? */t           {mD             if (xfer_cnt == 0)			/* If no data was transferred... */               {T7                 retry_cnt++;			/* Update retry count */sP                 if (retry_cnt == MAX_RETRY/2)	/* Halfway through the retries? */                   {eS                     BPTRACE( 0x08010000 );	/* BREAK: datacheck wants to do reset */ A                     reset_ctrl( ucb );		/* If so, reset things */                        }uQ                 if (retry_cnt > MAX_RETRY)	/* Were there too many retries yet? */cA                     return( status );		/* Yes, exit with error */s                   }                }L         else           {i@             if (xfer_cnt > 0)			/* Was any data transferred ? */H                 retry_cnt = 0;			/* Clear retry count on each success */               }/6 						/* This segment is now in our transfer buffer */" 						/* Do the data comparison */  B         byte_cnt = xfer_cnt << BLK_SHIFT;	/* Compute byte count */i         if (byte_cnt > ucb->ucb$l_bcr)		/* Check if the transfer exceeded the user's desired bytecount */t]             byte_cnt = ucb->ucb$l_bcr;		/* If so, minimize it to the user's actual request *//  O         buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE_512; @ 						/* Calculate the offset (so far) into the user's buffer */<         user_va = map_user_buffer( ucb, buf_ofs, byte_cnt );, 						/* Map that part of the user buffer */V         TRACE( 0x08020000 + byte_cnt );		/* DATACHECK comparing bytes with the user */K         status = memcmp( &buffer[offset*BLK_SIZE_512], user_va, byte_cnt );t; 						/* And compare user buffer and our transfer buffer */c9         if (status != 0)			/* Check comparison results */ K             return( SS$_DATACHECK );		/* Failed - return DATACHECK error */r  J         ucb->ucb$l_bcr -= byte_cnt;		/* Update the byte count remaining */<         ucb->ucb$l_media.lbn += xfer_cnt;	/* Bump the LBN */@         blks_xfrd += xfer_cnt;			/* Update the for-loop index */  "           }					/* Next segment */  5     return( SS$_NORMAL );			/* Return with success */          }t     /5 /* IO_WRITE - Performs IO$_WRITExBLK driver functionsr  *	  * Input:   *      ucb     pointer to UCB  *
  * Output:  *      status value  *  */    int io_write( DQ_UCB *ucb )t     {	  4     int   byte_cnt;				/* Number of bytes written *//     int   xfer_size;				/* Size (in sectors) */ O     int   xfer_cnt;				/* Count of blocks actually written in latest segment */n,     int   blks_xfrd;				/* For-loop index */8     int   xfer_req;				/* Number of sectors requested */)     int   status;				/* Routine status */l+     int   retry_cnt;				/* Retry counter */   /     TRACE( 0x09000000 );			/* WRITE starting */S  P     status = wait_ready( ucb );			/* Wait for drive to be ready for a command */2     if ( $FAIL( status ) )			/* Check the error */;         return( status );			/*  if an error, then return */	    / 						/* Compute number of blocks and set up */uE     xfer_size = (baseucb.ucb$l_bcnt + BLK_SIZE_512 - 1) >> BLK_SHIFT; 3     if (xfer_size == 0)				/* Was there any work */ >         return( SS$_NORMAL );			/* Exit with success if not */  8     retry_cnt = 0;				/* Initialize the retry counter */  I     for (blks_xfrd = 0; blks_xfrd < xfer_size;)	/* For each segment... */	       {fZ         xfer_req = xfer_size - blks_xfrd;	/* Compute 512-byte blocks left to be written */  >         status = write_dispatcher( ucb, xfer_req, &xfer_cnt );  ?         if ( $FAIL( status ) )			/* How did that segment go? */E           {	  I             if (ucb->ucb$l_asc==0x30)		/* Incompatible medium in drive */cD                 return( status );		/* Not much point in re-trying */  ?             if (ucb->ucb$l_asc==0x3A)		/* No medium in drive */tD                 return( status );		/* Not much point in re-trying */  T             if (status==SS$_BADPARAM)		/* Bad parameter (e.g., LBN out of range)? */C                 return( status );		/* We won't retry that either */-  E             if (status==SS$_VOLINV)		/* Did the volume go invalid? */uC                 return( status );		/* We won't retry that either */ 0 						/* (A retry might erroneously succeed!) */  L             if (status==SS$_WRITLCK)		/* Medium appers to be write-locked */D                 return( status );		/* Not much point in re-trying */  C             if (xfer_cnt == 0)			/* If no data was transfered... */                { 7                 retry_cnt++;			/* Update retry count */_P                 if (retry_cnt == MAX_RETRY/2)	/* Halfway through the retries? */                   {uO                     BPTRACE( 0x09010000 );	/* BREAK: write wants to do reset */ A                     reset_ctrl( ucb );		/* If so, reset things */i                       } Q                 if (retry_cnt > MAX_RETRY)	/* Were there too many retries yet? */[A                     return( status );		/* Yes, exit with error */a                   }u               }i         else         C           {r@             if (xfer_cnt > 0)			/* Was any data transferred ? */H                 retry_cnt = 0;			/* Clear retry count on each success */               }n  B         byte_cnt = xfer_cnt << BLK_SHIFT;	/* Compute byte count */i         if (byte_cnt > ucb->ucb$l_bcr)		/* Check if the transfer exceeded the user's desired bytecount */ ]             byte_cnt = ucb->ucb$l_bcr;		/* If so, minimize it to the user's actual request */e  F         ucb->ucb$l_bcr -= byte_cnt;		/* Update byte count remaining */>         ucb->ucb$l_media.lbn += xfer_cnt;	/* Update the LBN */@         blks_xfrd += xfer_cnt;			/* Update the for-loop index */           }   @     return( SS$_NORMAL );				/* Return to caller with success */         }a      F /* WRITE_DISPATCHER - Figure out which routine to use for this segment  *F  * We have (up to) six different handlers for doing the actual writes.1  * Based on three flags, dispatch to one of them.L  *	  * Input: $  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  * Note:  *D  *   You can modify this routine to select, on a case-by-case basis,,  *   which transfers will be done using DMA.  *  */s  @ int write_dispatcher( DQ_UCB *ucb, int xfer_req, int *xfer_cnt )     {        int dispatch;_    Q     dispatch = (ucb->ucb$l_atapi_flag    << 2)		/* Decide which routine to use */ ;              + (ucb->ucb$l_2K_flag       << 1)		/*   :   */ <              + (ucb->ucb$l_drive_dma_capable );		/*   :   */  A     switch (dispatch)					/* Switch to the appropriate handler */A       {s           case (0x0):ue           return write_ata_seg_pio(   ucb, xfer_req, xfer_cnt );	/* ATA, 512-byte sectors, via PIO */            case (0x1): e           return write_ata_seg_dma(   ucb, xfer_req, xfer_cnt );	/* ATA, 512-byte sectors, via DMA */D           case (0x4): n           return write_atapi_512_seg( ucb, xfer_req, xfer_cnt, FALSE );	/* ATAPI, 512-byte sectors, via PIO */           case (0x5):/m           return write_atapi_512_seg( ucb, xfer_req, xfer_cnt, TRUE );	/* ATAPI, 512-byte sectors, via DMA */            case (0x6):ri           return write_atapi_2K_seg(  ucb, xfer_req, xfer_cnt, FALSE );	/* ATAPI, 2KB sectors, via PIO */u           case (0x7):eh           return write_atapi_2K_seg(  ucb, xfer_req, xfer_cnt, TRUE );	/* ATAPI, 2KB sectors, via DMA */  ,         default:							/* Unexpected case */6           break;							/* Fall into the bugcheck... */             }   ;     bug_check( INCONSTATE, FATAL, COLD );				/* So be it */_L     return( SS$_ABORT );						/* (You should live so long as to get here) */         })     hB /* WRITE_ATA_SEG_PIO - Write one segment to an ATA drive using PIO  *A  * This routine performs the write of a single I/O segment.  EachrI  * segment is a single read command of not more the MAX_ATA_XFER sectors.rB  * The overall read I/O routine calls this routine for each of the/  * segments until the entire read is completed.   *	  * Input: &  *      ucb             pointer to UCB>  *      xfer_req        number of blocks remaining to transfer  *
  * Output:<  *      xfer_cnt        count of blocks actually transferred  *      status value  *  * Note:  *?  *   o Some drives sometimes give the interrupt *VERY* quickly,tB  *     before I can get back to the WFIKPCH. (This probably occursA  *     when cached data is available in the drive.) I handle thisA?  *     by caching the fact that an as-yet-unsolicited interruptn  *     occurred.  *  */   A int write_ata_seg_pio( DQ_UCB *ucb, int xfer_req, int *xfer_cnt )*     {   3     int   buf_ofs;				/* Offset into user buffer */ 9     BYTE *buffer;				/* Pointer to our transfer buffer */ =     int   byte_cnt;				/* Count of bytes to be transferred */	7     int   cyl;					/* Cylinder number and components */ 6     int   drv_head;				/* Drive drive/head register *//     int   drverr;				/* Drive error register */ 0     int   drvsts;				/* Drive status register */%     int   head;					/* Head number */t(     int   idx;					/* Zero fill index */)     int   orig_ipl;				/* Original IPL */n8     int   remainder;				/* Bytes left at end of block */0     int   sec;					/* Sector number and count *//     int   status;				/* Routine status value */ 7     BYTE  *user_va;				/* Mapped user buffer address */   E     TRACE( 0x09100000 + xfer_req );		/* WRITE_ATA_SEG_PIO starting */oT     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */  F     if (xfer_req > MAX_ATA_XFER)		/* Check for too large a transfer */;         xfer_req = MAX_ATA_XFER;		/*  and limit it if so */i  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */9     *xfer_cnt = 0;				/* Clear count of blocks written */   >     drv_head = ucb->ucb$l_drv_head;		/* Get base drive info */=     if (ucb->ucb$l_drive_lba_capable)		/* If LBA mode, ... */ <         drv_head |= DRVHD_M_LBA;		/*  ... set the LBA bit */  H     compute_address( ucb, &sec, &head, &cyl );	/* Compute the address */  / 						/* Move the data segment from the user */f?     byte_cnt = xfer_req << BLK_SHIFT;		/* Compute byte count */ =     if (byte_cnt > ucb->ucb$l_bcr)		/* Check for too large */*5         byte_cnt = ucb->ucb$l_bcr;		/* Minimize it */   K     buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE_512;e@ 						/* Calculate the offset (so far) into the user's buffer */8     user_va = map_user_buffer( ucb, buf_ofs, byte_cnt );, 						/* Map that part of the user buffer */W     TRACE( 0x09110000 + byte_cnt );		/* WRITE_ATA_SEG_PIO moving bytes from the user *//O     memcpy( buffer, user_va, byte_cnt );	/* Copy the user data to our buffer */a  > 						/* If less than a full block, then zero the remainder */=     remainder = byte_cnt & BLK_MASK;		/* Compute remainder */f-     if (remainder > 0)				/* Is there any? */r!       {						/* If so, then... */bF         remainder = BLK_SIZE_512 - remainder;	/* Compute bytes left */J         for (idx=0; idx < remainder; idx++)	/* For each additional byte */8             buffer[byte_cnt+idx]=0;		/* Zero the byte */           }e   /*)  * Take out the device lock and raise IPLr  * Write the registers  * Then issue the command	  *  */p  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );9 						/* Take out the device lock for the first sector */cE     out( ucb, WT_DRV_HD, drv_head|head );	/* Select drive and head */p@     out( ucb, WT_SEC_CNT, xfer_req );		/* Ask for "n" sectors */@     out( ucb, WT_SECTOR, sec );			/* Put in the sector number */?     out( ucb, WT_CYL_LO, cyl );			/* Low order cylinder bits */xB     out( ucb, WT_CYL_HI, cyl>>8 );		/* High order cylinder bits */M     out( ucb, WT_CMD, CMD_ATA_WRITE_SECS );	/* Attempt to write the sector */   N     for (;;)					/* Do forever (for each sector in the transfer request)... */         {   >         status = wait_drq( ucb );		/* Wait for data request */6         if ( $FAIL( status ) )			/* Check for error */%           {					/* If any, then... */eG             device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );*# 						/* Release the device lock */o?             return( status );			/* And return failing status */N               }u  K 	status = wait_ready( ucb );		/* Wait for DRDY before we move from drive */eR         move_sec_to_drive( ucb, &buffer[(*xfer_cnt)*BLK_SIZE_512], BLK_SIZE_512 );A 						/* Move the sector from our transfer buffer to the drive */h  <         status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 8 );" 						/* Wait for the interrupt */B         if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */?             return( status );			/* If so, return with status */e  B         drvsts = inp( ucb, RD_ALT_STS );	/* Get the status byte */A         if ( IS_SET( drvsts, STS_M_ERR ) )	/* Check the status */b,           {					/* If any errors, then... */C             drverr = inp( ucb, RD_ERROR );	/* Get the error byte *//U             BPTRACE( 0x09120000 );		/* BREAK: Drive error during WRITE_ATA_SEG_PIO */pA             return( SS$_DRVERR );		/* Return with error status */t               }   6         *xfer_cnt += 1;				/* Count a block written */  4         if (*xfer_cnt >= xfer_req )		/* Finished? */C             break;				/* If so, break out of the do-forever loop */p  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );= 						/* Else take out the device lock and go 'round again */t  8           }					/* Next sector in the do-forever loop */  =     return( SS$_NORMAL );			/* Return to caller succeeding */          }      ;B /* WRITE_ATA_SEG_DMA - Write one segment to an ATA drive using DMA  *A  * This routine performs the write of a single I/O segment.  EachRI  * segment is a single read command of not more the MAX_ATA_XFER sectors._B  * The overall read I/O routine calls this routine for each of the/  * segments until the entire read is completed.l  *	  * Input: &  *      ucb             pointer to UCB>  *      xfer_req        number of blocks remaining to transfer  *
  * Output:<  *      xfer_cnt        count of blocks actually transferred  *      status value  *  * Note:  *?  *   o Some drives sometimes give the interrupt *VERY* quickly,cB  *     before I can get back to the WFIKPCH. (This probably occursA  *     when cached data is available in the drive.) I handle this:?  *     by caching the fact that an as-yet-unsolicited interrupt   *     occurred.  *  */   A int write_ata_seg_dma( DQ_UCB *ucb, int xfer_req, int *xfer_cnt )*     {e  3     int   buf_ofs;				/* Offset into user buffer */ 9     BYTE *buffer;				/* Pointer to our transfer buffer */e=     int   byte_cnt;				/* Count of bytes to be transferred */U7     int   cyl;					/* Cylinder number and components */ 6     int   drv_head;				/* Drive drive/head register *//     int   drverr;				/* Drive error register */r0     int   drvsts;				/* Drive status register */%     int   head;					/* Head number */ (     int   idx;					/* Zero fill index */)     int   orig_ipl;				/* Original IPL */n8     int   remainder;				/* Bytes left at end of block */0     int   sec;					/* Sector number and count *//     int   status;				/* Routine status value */i7     BYTE  *user_va;				/* Mapped user buffer address */A  E     TRACE( 0x09800000 + xfer_req );		/* WRITE_ATA_SEG_DMA starting */yT     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */?     *xfer_cnt = 0;				/* Consider none of the blocks written */i  F     if (xfer_req > MAX_ATA_XFER)		/* Check for too large a transfer */;         xfer_req = MAX_ATA_XFER;		/*  and limit it if so */e  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */>     drv_head = ucb->ucb$l_drv_head;		/* Get base drive info */=     if (ucb->ucb$l_drive_lba_capable)		/* If LBA mode, ... */ <         drv_head |= DRVHD_M_LBA;		/*  ... set the LBA bit */H     compute_address( ucb, &sec, &head, &cyl );	/* Compute the address */    H /* Later, for unbuffered DMA, skip this and set map registers instead */ /*   :   */, /*   :   */o/ 						/* Move the data segment from the user */ ?     byte_cnt = xfer_req << BLK_SHIFT;		/* Compute byte count */*=     if (byte_cnt > ucb->ucb$l_bcr)		/* Check for too large */)5         byte_cnt = ucb->ucb$l_bcr;		/* Minimize it */s  K     buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE_512;w@ 						/* Calculate the offset (so far) into the user's buffer */8     user_va = map_user_buffer( ucb, buf_ofs, byte_cnt );, 						/* Map that part of the user buffer */W     TRACE( 0x09810000 + byte_cnt );		/* WRITE_ATA_SEG_DMA moving bytes from the user */ O     memcpy( buffer, user_va, byte_cnt );	/* Copy the user data to our buffer */i  > 						/* If less than a full block, then zero the remainder */=     remainder = byte_cnt & BLK_MASK;		/* Compute remainder */ -     if (remainder > 0)				/* Is there any? */ !       {						/* If so, then... */sF         remainder = BLK_SIZE_512 - remainder;	/* Compute bytes left */J         for (idx=0; idx < remainder; idx++)	/* For each additional byte */8             buffer[byte_cnt+idx]=0;		/* Zero the byte */           }(   /*   :   */	 /*   :   */vH /* Later, for unbuffered DMA, skip this and set map registers instead */     /*)  * Take out the device lock and raise IPLs  * Write the registers  * Then issue the commandD  *  */e  ,     load_prdt( ucb );				/* Load the PRDT */  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );B 						/* Take out the device lock so we can write the registers */  D     out( ucb, WT_DMA_CMD, DMA_CMD_M_OUTBOUND | DMA_CMD_M_INACTIVE );7 						/* Make sure the DMA controller is outbound    */ 7 						/*   (that is, reading memory -> writing disk) */e7 						/*   but not active yet                        */	K     out( ucb, WT_DMA_AD0, ( ( (UINT) ucb->ucb$l_prdt_phy )      ) & 0xFF );*K     out( ucb, WT_DMA_AD1, ( ( (UINT) ucb->ucb$l_prdt_phy ) >> 8 ) & 0xFF );rK     out( ucb, WT_DMA_AD2, ( ( (UINT) ucb->ucb$l_prdt_phy ) >>16 ) & 0xFF );eK     out( ucb, WT_DMA_AD3, ( ( (UINT) ucb->ucb$l_prdt_phy ) >>24 ) & 0xFF );fE 						/* Point the controller to the PCI address of our PRDT table */ \     out( ucb, WT_DMA_STS, DMA_STS_M_DRV1 | DMA_STS_M_DRV0 | DMA_STS_M_INT | DMA_STS_M_ERR );3 						/* For now, set both drives as DMA-capable */.G 						/* Write "1"s to INT and ERR to clear them in case they're set */ E     out( ucb, WT_DRV_HD, drv_head|head );	/* Select drive and head */r@     out( ucb, WT_SEC_CNT, xfer_req );		/* Ask for "n" sectors */@     out( ucb, WT_SECTOR, sec );			/* Put in the sector number */?     out( ucb, WT_CYL_LO, cyl );			/* Low order cylinder bits */.B     out( ucb, WT_CYL_HI, cyl>>8 );		/* High order cylinder bits */O     out( ucb, WT_CMD, CMD_ATA_WRITE_DMA );	/* Attempt to write the sector(s) */eB     out( ucb, WT_DMA_CMD, DMA_CMD_M_OUTBOUND | DMA_CMD_M_ACTIVE );6 						/* Set the DMA controller outbound            */6 						/*   (that is, reading memory-> writing disk) */6 						/*   and active                               */     U     if ( ((ucb->ucb$l_drive_dma_capable == TRUE) && (ucb->ucb$l_ctrl_id == CMD649)) )d9 	status = dq_dma_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 9 );/     else5 	status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 9 );e     <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );% 						/* Take out the deviced lock */ U     out( ucb, WT_DMA_CMD, DMA_CMD_M_INACTIVE );	/* Set the DMA controller inactive */b  ?     device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );t  >     if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */;         return( status );			/* If so, return with status */a  I     drvsts = inp( ucb, RD_ALT_STS );            /* Get the status byte */   Y     if ( IS_SET( drvsts, STS_M_ERR ) )          /* Check the status (saved from above) */rL       {                                         /* If any errors, then... */H         drverr = inp( ucb, RD_ERROR );          /* Get the error byte */a         BPTRACE( 0x09820000 );                  /* BREAK: Drive error during WRITE_ATA_SEG_PIO */*N         return( SS$_DRVERR );                   /* Return with error status */           }I  D     *xfer_cnt = xfer_req;			/* Consider all of the blocks written */  =     return( SS$_NORMAL );			/* Return to caller succeeding */          }N     )K /* WRITE_ATAPI_512_SEG - Write one segment to a 512-byte-sector ATAPI drivet  *;  * This routine performs the write of a single I/O segment.vL  * Each segment is a single write command of not more the MAX_ATAPI_512_XFERE  * sectors. The overall write I/O routine calls this routine for eachu7  * of the segments until the entire write is completed.D  *	  * Input:N$  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transfer=  *      buffer        address of buffer to transfer data froma/  *      dma_flag      whether or not to use DMAA  *  *
  * Output::  *      xfer_cnt      count of blocks actually transferred  *      status value  *  */D  Q int write_atapi_512_seg( DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag )*     {   3     int   buf_ofs;				/* Offset into user buffer */n:     BYTE  *buffer;				/* Pointer to our transfer buffer */=     int   byte_cnt;				/* Count of bytes to be transferred */h(     int   idx;					/* Zero fill index */1     int   offset;				/* Offset within 2K block */(;     BYTE  *packet;				/* The packet bytes within the UCB */ E     int   *packetl;				/* The packet (as longwords) within the UCB */)8     int   remainder;				/* Bytes left at end of block *//     int   status;				/* Routine status value */n7     BYTE  *user_va;				/* Mapped user buffer address */ )     int   orig_ipl;				/* Original IPL */v    G     TRACE( 0x09200000 + xfer_req );		/* WRITE_ATAPI_512_SEG starting */l  L     if (xfer_req > MAX_ATAPI_512_XFER)		/* Check for too large a transfer */A         xfer_req = MAX_ATAPI_512_XFER;		/*  and limit it if so */-  R     buffer = (BYTE *) ucb->ucb$ps_xfer_buffer;	/* Initialize our buffer pointer */;     byte_cnt = 0;				/* Clear count of bytes transferred */   / 						/* Move the data segment from the user */n?     byte_cnt = xfer_req << BLK_SHIFT;		/* Compute byte count */i=     if (byte_cnt > ucb->ucb$l_bcr)		/* Check for too large */n5         byte_cnt = ucb->ucb$l_bcr;		/* Minimize it */	  K     buf_ofs = (ucb->ucb$l_media.lbn - ucb->ucb$l_org_media) * BLK_SIZE_512;G@ 						/* Calculate the offset (so far) into the user's buffer */8     user_va = map_user_buffer( ucb, buf_ofs, byte_cnt );, 						/* Map that part of the user buffer */W     TRACE( 0x09210000 + byte_cnt );		/* WRITE_ATA_SEG_PIO moving bytes from the user */rO     memcpy( buffer, user_va, byte_cnt );	/* Copy the user data to our buffer */   > 						/* If less than a full block, then zero the remainder */=     remainder = byte_cnt & BLK_MASK;		/* Compute remainder */ -     if (remainder > 0)				/* Is there any? */o!       {						/* If so, then... */*F         remainder = BLK_SIZE_512 - remainder;	/* Compute bytes left */J         for (idx=0; idx < remainder; idx++)	/* For each additional byte */8             buffer[byte_cnt+idx]=0;		/* Zero the byte */           }   ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */i"     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  [     packet  = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */t=     packet[0]  = CMD_ATAPI_WRITE_12;		/* Write(12) command */t* /*  packet[1]  = 0x00;				/@ (Reserved) */C /*  packet[2]  = 0x00;				/@ Address MSB (filled in momentarily) */ , /*  packet[3]  = 0x00;				/@   :      :   */, /*  packet[4]  = 0x00;				/@   :      :   */, /*  packet[5]  = 0x00;				/@   :     LSB  */D     packet[6]  = xfer_req>>24;			/* Transfer length MSB in blocks */:     packet[7]  = xfer_req>>16;			/*   :              :  */9     packet[8]  = xfer_req>>8;			/*   :              :  */q6     packet[9]  = xfer_req;			/*   :             LSB */* /*  packet[10] = 0x00;				/@ (Reserved) */* /*  packet[11] = 0x00;				/@ (Reserved) */M     offset     = fill_packet_w_adx( ucb );	/* Fill the packet address cells*/b  O     status = atapi_packet_command( ucb, buffer, xfer_req, xfer_cnt, dma_flag );uJ 						/* Do the common packet-command processing using appropriate mode */  E     if (status == SS$_DRVERR)			/* Did it result in a drive error? *//!       {						/* If so, then... *//F         atapi_request_sense( ucb, (BYTE *) ucb->ucb$ps_sense_buffer );% 						/* Get error info from drive */ 1         status = atapi_xlate_error_to_vms( ucb ); ) 						/* Turn it into a VMS error code */ *         return( status );			/* and exit */           }l  <     if ( $FAIL( status ) )			/* Check for any other error */1         return( status );			/*  and exit if so */=  2     return( SS$_NORMAL );			/* Return to caller */         }      rH /* WRITE_ATAPI_2K_SEG - Write one segment to a 2Kbyte-sector ATAPI drive
  *            K  * This routine would performs the write of a single I/O segment, but punts_N  * because we don't yet know how to do the necessary Read/Modify/write(s) thatN  * would be required to write VMS-sized 512-byte-blocks within 2Kbyte sectors.  *	  * Input:e$  *      ucb           pointer to UCB<  *      xfer_req      number of blocks remaining to transferM  *      dma_flag      whether or not to use DMA (a dummy parameter right now)d  *
  * Output:C  *      xfer_cnt      count of blocks actually transferred (unused)	  *      status value  *  */   P int write_atapi_2K_seg( DQ_UCB *ucb, int xfer_req, int *xfer_cnt, int dma_flag )     {   J     TRACE( 0x09300000 + xfer_req );		/* WRITE_ATAPI_2K_SEG_PIO starting */  _     return( SS$_WRITLCK );			/* We don't know how to write 2K (CD-ROM/DVD-ROM sized) blocks? */f6 						/* (Presently, we'd need a read-modify-write) */       }e     tA /* ATAPI_READ_CAPACITY - Read the drive capacity and bytes/sector   *	  * Input:M$  *      ucb           pointer to UCB=  *      buffer        address of buffer to transfer data intob  *
  * Output:  *      status value<  *      Uninterpreted capacity data in the designated buffer  *  */s  4 int atapi_read_capacity( DQ_UCB *ucb, BYTE *buffer )     {s  ;     BYTE  *packet;				/* The packet bytes within the UCB */oE     int   *packetl;				/* The packet (as longwords) within the UCB */ P     int    xfer_cnt;				/* Count of sectors actually transferred (dummy here) */    ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */ "     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  Z     packet = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */E     packet[0]  = CMD_ATAPI_READ_CAPACITY;	/* Read capacity command */E* /*  packet[1]  = 0x00;				/@ (Reserved) */+ /*  packet[2]  = 0x00;				/@ Address MSB */t+ /*  packet[3]  = 0x00;				/@   :      :  */ + /*  packet[4]  = 0x00;				/@   :      :  */n+ /*  packet[5]  = 0x00;				/@   :     LSB */ * /*  packet[6]  = 0x00;				/@ (Reserved) */* /*  packet[7]  = 0x00;				/@ (Reserved) */* /*  packet[8]  = 0x00;				/@ (Reserved) */* /*  packet[9]  = 0x00;				/@ (Reserved) */* /*  packet[10] = 0x00;				/@ (Reserved) */* /*  packet[11] = 0x00;				/@ (Reserved) */  G     return( atapi_packet_command( ucb, buffer, 0, &xfer_cnt, FALSE ) );	= 						/* Do the common packet-command processing using PIO *//       }e          o: /* ATAPI_REQUEST_SENSE - Get the sense keys from the drive  *	  * Input:;$  *      ucb           pointer to UCB=  *      buffer        address of buffer to transfer data intoi  *
  * Output:  *      status value2  *      sense, asc, and ascq fields in ucb updated  *  */0  4 int atapi_request_sense( DQ_UCB *ucb, BYTE *buffer )     {k  ;     BYTE  *packet;				/* The packet bytes within the UCB */BL     int   *packetl;			       	/* The packet (as longwords) within the UCB */1     int    status;				/* Routine return status */ O     int    xfer_cnt;				/* Count of blocks actually transferred (dummy here) */n    ^     packetl = (int *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a longword array */-     packetl[0] = 0;				/* Clear the packet */a"     packetl[1] = 0;				/*   :   */"     packetl[2] = 0;				/*   :   */  Z     packet = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */E     packet[0]  = CMD_ATAPI_REQUEST_SENSE;	/* Request_Sense command */d* /*  packet[1]  = 0x00;				/@ (Reserved) */* /*  packet[2]  = 0x00;				/@ (Reserved) */* /*  packet[3]  = 0x00;				/@ (Reserved) */1     packet[4]  =   18;				/* Allocation Length */t* /*  packet[5]  = 0x00;				/@ (Reserved) */* /*  packet[6]  = 0x00;				/@ (Reserved) */* /*  packet[7]  = 0x00;				/@ (Reserved) */* /*  packet[8]  = 0x00;				/@ (Reserved) */* /*  packet[9]  = 0x00;				/@ (Reserved) */* /*  packet[10] = 0x00;				/@ (Reserved) */* /*  packet[11] = 0x00;				/@ (Reserved) */             F     status = atapi_packet_command( ucb, buffer, 0, &xfer_cnt, FALSE );= 						/* Do the common packet-command processing using PIO */p  <     if ( $FAIL( status ) )			/* Check for any other error */1         return( status );			/*  and exit if so */g  _     TRACE( 0x0C000000    + (buffer[2] & 0x0F) );/* ATAPI_REQUEST_SENSE storing the sense_key */	C     ucb->ucb$l_sense_key = (buffer[2] & 0x0F);	/* Save sense key */)R     TRACE( 0x0C010000    + buffer[12] );	/* ATAPI_REQUEST_SENSE storing the ASC */H     ucb->ucb$l_asc       = buffer[12];		/* Save additional sense code */\     TRACE( 0x0C020000    + buffer[13] );	/* ATAPI_REQUEST_SENSE storing the ASC Qualifier */R     ucb->ucb$l_ascq      = buffer[13];		/* Save additional sense code qualifier */  5     return( status );				/* And return with status */=            };       rZ /* ATAPI_PACKET_COMMAND - Do the common ATAPI packet command processing using desired mode  *	  * Input:T$  *      ucb           pointer to UCB=  *      buffer        address of buffer to transfer data into b  *      xfer_req      number of blocks remaining to transfer (NOTE: 512-byte blocks! Not sectors!).  *      dma_flag      whether or not to us DMA  *  *
  * Output:  *      vms status valueN  *      xfer_cnt      count of blocks actually transferred.  For IO$_DIAGNOSE,:  *                    count of BYTES actually transferred.  *  *	  * Notes:f  *<  *    There are differences in the way drives from different?  *    vendors operate during the Packet command. In particular:t  *?  *      - Some drives (including the Toshiba drives) don't giveoD  *        an interrupt as DRQ asserts to request the command packet.B  *        Per the ATAPI spec dated 6/95, section 4.7, item 4, thisC  *        interrupt is optional. The code handles this situation byu/  *        explicitly waiting for DRQ to assert.d  *@  *      - The Sony drives don't seem to (always? ever?) give theC  *        expected interrupt as DRQ asserts to request that we read B  *        data from the drive. It may be that the drive is alreadyA  *        ready with cached data and I'm squashing the 'rupt with*?  *        the read of the STATUS (STS) register. In any case, Ip=  *        handle this by checking for the drive to already beo>  *        non-busy and DRQ prior to waiting for the interrupt.  *B  *      - Some drives sometimes give the interrupt *VERY* quickly,E  *        before I can get back to the WFIKPCH. (This probably occursoD  *        when cached data is available in the drive.) I handle thisB  *        by caching the fact that an as-yet-unsolicited interrupt  *        occurred.   * h*  */                                         ` int atapi_packet_command( DQ_UCB *ucb, BYTE *buffer, int xfer_req, int *xfer_cnt, int dma_flag )     {e                                  7     int   drv_head;					/* Drive drive/head register */ 0     int   status;					/* Routine status value */*     int   orig_ipl;					/* Original IPL */4     int   reason;					/* Drive "interrupt reason" */5     int   drvsts;    					/* Drive status register */	0     int   drverr;					/* Drive error register */9     int   drvdrq;					/* Drive DRQ bit from STS/ALTSTS */t/     int   drvbytcnt;					/* Drive byte count */f:     int   buffer_size;					/* Size of the target buffer */     IRP   *irp;t     BYTE  *packet;     int data_dir = FALSE;t     C     TRACE( 0x02000000 );				/* ATAPI_PACKET_COMMAND_DMA starting */   [     ucb->ucb$l_unsolicited_int = 0;			/* Forget any pending unsolicited interrupts       */tT     reason    = 0xDEADDEAD;				/* Invalidate this, just in case anyone's looking  */L     *xfer_cnt = 0;					/* Consider none of the blocks transfered          */N     buffer_size = 0;					/* Set this to a default that's guaranteed to fail */i     if (buffer == (BYTE *) ucb->ucb$ps_xfer_buffer)	/* Pointing to the transfer buffer?                */ _         buffer_size = XFER_BUFFER_SIZE;			/* If so, remember that size                       */ej     if (buffer == (BYTE *) ucb->ucb$ps_sense_buffer)	/* Pointing to the sense buffer?                   */_         buffer_size = SENSE_BUFFER_SIZE;		/* If so, remember that size                       */e< 							/* Else we don't know any other buffer sizes       */< 							/*    -- leave it zero                             */  C     status = wait_ready( ucb );				/* Wait for drive to be ready */ @     if ( $FAIL( status ) )				/* Check the status for failure */4         return( status );				/* Return with error */  ?     drv_head = ucb->ucb$l_drv_head;			/* Get base drive info */y>     if (ucb->ucb$l_drive_lba_capable)			/* If LBA mode, ... */=         drv_head |= DRVHD_M_LBA;			/*  ... set the LBA bit */c   /*)  * Take out the device lock and raise IPLl  * Write the registers   * Then issue the packet command5  * Then follow the drive's lead as to what to do next;  *  */           <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );C 							/* Take out the device lock so we can write the registers */=T     out( ucb, WT_DRV_HD, drv_head );			/* Select drive, ignore head               */     if (dma_flag)a       {f 			c% 	packet = (BYTE *) ucb->ucb$b_packet;o  0         load_prdt( ucb );				/* Load the PRDT */  7 	if ( (packet [0] == 0x0A) || (packet [0] == 0x2A)  || c6 	     (packet [0] == 0xAA) || (packet [0] == 0x55) )  V 	    data_dir = TRUE;				/* Command in Write direction(write-6,10,12 & mode sel-10) */  A 							/* Determine the Data Direction and set the appropriate */*, 							/*   DMA flags for the transfer				*/         if (data_dir)					E 	    out( ucb, WT_DMA_CMD, DMA_CMD_M_OUTBOUND | DMA_CMD_M_INACTIVE );i         elseD 	    out( ucb, WT_DMA_CMD, DMA_CMD_M_INBOUND | DMA_CMD_M_INACTIVE );  4 							/* For now, set both drives as DMA-capable */H 							/* Write "1"s to INT and ERR to clear them in case they're set */`         out( ucb, WT_DMA_STS, DMA_STS_M_DRV1 | DMA_STS_M_DRV0 | DMA_STS_M_INT | DMA_STS_M_ERR );F 							/* Point the controller to the PCI address of our PRDT table */5 	outl(ucb, WTL_DMA_AD0, (UINT) ucb->ucb$l_prdt_phy );n               }          if (dma_flag) V         out( ucb, WT_FEATURES, 0x01 );			/* No Overlap (bit <1>), Yes DMA (bit <0>) */     elseU         out( ucb, WT_FEATURES, 0x00 );			/* No Overlap (bit <1>), No DMA (bit <0>) */(W     out( ucb, WT_CYL_LO, buffer_size );			/* Low order cylinder bits/bytecount       */tY     out( ucb, WT_CYL_HI, buffer_size>>8 );		/* High order cylinder bits/bytecount      */uZ     out( ucb, WT_CMD, CMD_ATA_PACKET_CMD );		/* Issue the "packet" command              */a     device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE ); /* release and let ints happen */	  L     status = wait_drq( ucb );				/* Explicitly wait for DRQ (Toshiba fix) */3     if ( $FAIL( status ) )				/* Check for error */f#       {							/* If any, then... */m\         BPTRACE( 0x02010000 );				/* BREAK: WAIT_DRQ() failed during atapi_packet_command */?         return( SS$_CTRLERR );				/*  and return complaining */t           }*  <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );J     for (;;)						/* Now, forever process based on the drive's requests */         {   @         drvsts = inp( ucb, RD_ALT_STS );		/* Read status byte */  S         if (    (dma_flag)				/* If we're doing a DMA transfer                   */ f              && ( (reason & ~STS_M_DRQ)==0x01) )	/*   and the last state was "Get Packet"           */F           {						/*                                                 */X             TRACE( 0x02060000 );			/*   ATAPI quashing interrupt-bypass 'cause of DMA */Q             drvsts = 0;					/*   then quash the captured status byte so we     */ J               }						/*   don't allow the interrupt to be bypassed      */  O         if (    ( (drvsts & STS_M_BSY) == 0 )		/* Is the drive already idle? */ X              && ( (drvsts & STS_M_DRQ) != 0 ) )		/*    and waiting with DRQ asserted? */2           {						/* If so, bypass WFIKPCH, etc. */T             TRACE( 0x02020000 );			/* ATAPI taking the already-DRQ WFIKPCH bypass */\             ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */`             drvsts = inp( ucb, RD_STS );		/* Read status byte to quash any pending interrupts */G             device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );?6               }						/* And release the device lock */         else4           {						/* Else wait for an interrupt... */   	    if (dma_flag) {  A 							/* Determine the Data Direction and set the appropriate */ , 							/*   DMA flags for the transfer				*/ 		if ( data_dir)D 		    out( ucb, WT_DMA_CMD, DMA_CMD_M_OUTBOUND | DMA_CMD_M_ACTIVE ); 		elseC 		    out( ucb, WT_DMA_CMD, DMA_CMD_M_INBOUND | DMA_CMD_M_ACTIVE );i 		S 		if ( ((ucb->ucb$l_drive_dma_capable == TRUE) && (ucb->ucb$l_ctrl_id == CMD649)) )$? 		    status = dq_dma_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 11 );  		else; 		    status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 11 );/ 		    
 	    } else {d7 		status = dq_wfikpch( ucb->ucb$ps_kpb, orig_ipl, 11 );r1 							/* Wait for the interrupt for Normal IO */   
             }   , 							/* Set the DMA controller inactive */ 	    if (dma_flag)   	      {		    > 		    device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );J 		    out( ucb, WT_DMA_CMD, DMA_CMD_M_INACTIVE );	/* assure dma aborted */A 		    device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );t 	      }  F             if ( $FAIL( status ) )			/* Any error (timeout, etc.) ? */               {r 		if (status == SS$_TIMEOUT) 		   { 		   reset_ctrl(ucb);l 		   }W                 BPTRACE( 0x020F0000 );			/* BREAK: ATAPI is handling a WFIPTCH error */tC                 return( status );			/* If so, return with status */M                   }r 	    p= 		drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */                }   b         if ( IS_SET( drvsts, STS_M_ERR ) )		/* Any errors?                                      */G           {						/* If so, then ...                                  */lb             drverr = inp( ucb, RD_ERROR );		/* Get the error byte                               */c             BPTRACE( 0x02030000 + drverr );		/* BREAK: ATAPI drive error, "sense_key" stored     */ b             ucb->ucb$l_sense_key = drverr;		/* Save latest sense key                            */= 							/*   (Note: Raw register -- not in justified form!) */AZ             return( SS$_DRVERR );			/* Caller may fill in more detail later             */               }I  F         drvdrq = ( drvsts & STS_M_DRQ );		/* Get DRQ bit (val=0x08) */H         reason = inp( ucb, RD_SEC_CNT );		/* See what the drive wants */B         reason &= 0x07;					/* Keep just [0:0:0:0:0:RLS:IO:CoD] */:         reason &= 0x03;					/* Throw away RELease, too. */6         reason |= drvdrq;				/* 'OR' in the DRQ bit */& 							/*  [0:0:0:0:DRQ:RLS:IO:CoD] */  H         switch (reason)					/* Dispatch based on that combined reason */           {x    B             case (0x00):				/* Write-data (and no DRQ) to drive */6               {						/* *THAT* would be a surprise! */a                 BPTRACE( 0x02040000 );			/* BREAK: ATAPI error: "Write-data" requested w/o DRQ *//F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }s  >             case (STS_M_DRQ+0x00):			/* Write data to drive */               {nC                 TRACE( 0x02040002 );			/* ATAPI Write-Data phase */a  n                 drvbytcnt =   inp( ucb, RD_CYL_LO )	/* Get the bytecount now desired by the drive           */r                             | inp( ucb, RD_CYL_HI )<<8;	/*    :                                                 */h                 if (drvbytcnt > buffer_size)		/* Is it too big to transfer?                           */R                   {					/* If so, then...                                       */f                     BPTRACE( 0x02040008 );		/* BREAK: ATAPI error: Bytecount mismatch on write-data */e                     return( SS$_DRVERR );		/* Make that an error instead of possibly               */tA 							/*   over-running our buffer                            */                        }*M                 /* For DIAGNOSE operations, return count of BYTES tranfered. uO                  * For all other operations, return count of BLOCKS transfered.                   */r  (                 irp = baseucb.ucb$l_irp;6                 if (irp->irp$l_func == IO$_DIAGNOSE) {M                     /* Move the sector from our transfer buffer to the drive. K                      * Note that 1 was added to drvbytcnt to force odd bytenC                      * transfers to be rounded up to the next word.e                      */dN                     move_sec_to_drive( ucb, buffer + *xfer_cnt, drvbytcnt+1 );L                     *xfer_cnt += drvbytcnt;		/* Count of bytes transfered */                 } else { 0[                     move_sec_to_drive( ucb, &buffer[(*xfer_cnt)*BLK_SIZE_512], drvbytcnt );0B 							/* Move the sector from our transfer buffer to the drive */Q                     *xfer_cnt += ( (drvbytcnt + BLK_SIZE_512 - 1) >> BLK_SHIFT );A! 							/* Count blocks written */  		} H                 device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );*    							/* Take the device lock again */+ 							/* As we go back to WFIKPCH again */c                 break;                   }       B             case (0x01):				/* Command packet wanted but no DRQ */6               {						/* *THAT* would be a surprise! */[                 BPTRACE( 0x02040001 );			/* BREAK: ATAPI error: "Cmd Pkt wanted" w/o DRQ */sF                 return( SS$_DRVERR );			/* Then, make that an error */                   } '                                        k@             case (STS_M_DRQ+0x01):			/* Command packet wanted */               {uG                 BYTE  *packet;				/* The packet bytes within the UCB */	  G                 TRACE( 0x02040009 );			/* ATAPI Cmd Pkt Wanted phase */   H                 device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );( 								/* Take the device lock again */g                 packet = (BYTE *) ucb->ucb$b_packet;		/* Bind onto packet in the UCB as a byte array *//e                 outw_t( ucb, WT_DATA, packet[ 0]|(packet[ 1]<<8) );/* Push out packet to the drive *//N                 outw_t( ucb, WT_DATA, packet[ 2]|(packet[ 3]<<8) );/*   :   */N                 outw_t( ucb, WT_DATA, packet[ 4]|(packet[ 5]<<8) );/*   :   */N                 outw_t( ucb, WT_DATA, packet[ 6]|(packet[ 7]<<8) );/*   :   */N                 outw_t( ucb, WT_DATA, packet[ 8]|(packet[ 9]<<8) );/*   :   */N                 outw_t( ucb, WT_DATA, packet[10]|(packet[11]<<8) );/*   :   */>                 break;						/* And go back to WFIKPCH again */                   }       8             case (0x02):				/* "Get data" without DRQ */6               {						/* *THAT* would be a surprise! */U                 BPTRACE( 0x02040002 );			/* BREAK: ATAPI error: "Get data" w/o DRQ */TF                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }   ]             case (STS_M_DRQ+0x02):			/* Get the data from the silo                         */;M               {						/* and into the transfer buffer                       */*p                                                         /*                                                    */_                 TRACE( 0x0204000A );			/* ATAPI Get-Data phase                               */LY                 if (dma_flag)				/* Doing a DMA transfer?                              */eP                   {					/* If so, we shouldn't be here -- this is a bad thing!*/d                     BPTRACE( 0x02060001 );		/* ATAPI Get-Data phase quashed 'cause of DMA         */p                       }                                 /*                                                    */Q                 else					/* We're doing PIO -- go ahead and get the data       */rp                   {                                     /*                                                    */p                     drvbytcnt =   inp( ucb, RD_CYL_LO )	/* Get the bytecount now desired by the drive         */p                               | inp( ucb, RD_CYL_HI )<<8;/*    :                                              */h                   if (drvbytcnt > buffer_size)		/* Is it too big to transfer?                         */R                     {					/* If so, then...                                     */f                       BPTRACE( 0x02050000 );		/* BREAK: ATAPI error: Bytecount mismatch on get_data */e                       return( SS$_DRVERR );		/* Make that an error instead of possibly             */ U                         }				/*   over-running our buffer                          */	p                                                         /*                                                    */  O                   /* For DIAGNOSE operations, return count of BYTES tranfered. *Q                    * For all other operations, return count of BLOCKS transfered.c                    */   *                   irp = baseucb.ucb$l_irp;9                   if (irp->irp$l_func == IO$_DIAGNOSE) {  I                     /* Move the sector from the drive to our xfer buffer.rK                      * Note that 1 was added to drvbytcnt to force odd byteo?                      * transfers to be rounded up to next word.n                      */ M                     move_sec_from_drive( ucb, buffer+*xfer_cnt, drvbytcnt+1); L                     *xfer_cnt += drvbytcnt;		/* Count of bytes transfered */                   } else {^                      move_sec_from_drive( ucb, &buffer[(*xfer_cnt)*BLK_SIZE_512], drvbytcnt );? 							/* Move the sector from the drive to our xfer buffer  */.R                      *xfer_cnt += ( (drvbytcnt + BLK_SIZE_512 - 1) >> BLK_SHIFT );T                        					/* Count blocks read                                  */                   } J                   device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );? 							/* Take the device lock again                         */f? 							/* As we go back to WFIKPCH again                     */	                     }                    break;                   }d      P             case (0x03):				/* Reason 0x03 *WITHOUT* DRQ indicates completion */               {	J                 TRACE( 0x02040003 );			/* ATAPI Normal Completion phase */@                 if (dma_flag)				/* Using DMA? If so, then... */V                     *xfer_cnt = xfer_req;		/* Consider all of the blocks transfered */N                 return( SS$_NORMAL );			/* So break out of the forever loop */3                 break;					/* (Break for safety) */                    }	  T             case (STS_M_DRQ+0x03):			/* DRQ + Message from drive (future feature) */6               {						/* *THAT* would be a surprise! */b                 BPTRACE( 0x0204000B );			/* BREAK: ATAPI error: "Message" from drive (with DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }A      7             case (0x04):				/* "Release" without DRQ */-6               {						/* *THAT* would be a surprise! */a                 BPTRACE( 0x02040004 );			/* BREAK: ATAPI error: "Release" from drive (w/o DRQ) */bF                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }   =             case (STS_M_DRQ+0x04):			/* "Release" with DRQ */ 6               {						/* Either way, it's surprising */b                 BPTRACE( 0x0204000C );			/* BREAK: ATAPI error: "Release" from drive (with DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }       7             case (0x05):				/* Undefined reason 0x05 */ 6               {						/* *THAT* would be a surprise! */X                 BPTRACE( 0x02040005 );			/* BREAK: ATAPI error: Reason=0x05 (w/o DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }e  F             case (STS_M_DRQ+0x05):			/* Undefined reason 0x05 + DRQ */6               {						/* *THAT* would be a surprise! */X                 BPTRACE( 0x0204000D );			/* BREAK: ATAPI error: Reason=0x5 (with DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }       7             case (0x06):				/* Undefined reason 0x06 */r6               {						/* *THAT* would be a surprise! */W                 BPTRACE( 0x02040006 );			/* BREAK: ATAPI error: Reason=0x6 (w/o DRQ) */eF                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }t  F             case (STS_M_DRQ+0x06):			/* Undefined reason DRQ + 0x06 */6               {						/* *THAT* would be a surprise! */X                 BPTRACE( 0x0204000E );			/* BREAK: ATAPI error: Reason=0x6 (with DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }       7             case (0x07):				/* Undefined reason 0x07 */t6               {						/* *THAT* would be a surprise! */W                 BPTRACE( 0x02040007 );			/* BREAK: ATAPI error: Reason=0x7 (w/o DRQ) */ F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }U  F             case (STS_M_DRQ+0x07):			/* Undefined reason DRQ + 0x07 */6               {						/* *THAT* would be a surprise! */X                 BPTRACE( 0x0204000F );			/* BREAK: ATAPI error: Reason=0x7 (with DRQ) */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }_      8             default:					/* Out-of-range combination? */?               {						/* *THAT* would *REALLY* be a surprise! */hW                 BPTRACE( 0x020400FF );			/* BREAK: ATAPI error: Out-of-bounds Reason */ D                 bug_check( INCONSTATE, FATAL, COLD );	/* So be it */F                 return( SS$_DRVERR );			/* Then, make that an error */                 break;                   }r  ,               }						/* End of the switch */  .           }						/* End of the forever loop */  #       }							/* Never gets here */e     wD /* ATAPI_XLATE_ERROR_TO_VMS - Map the sense keys to a VMS error code  *	  * Input:V@  *      sense_buffer     address of buffer to transfer data from  *
  * Output:  *      vms status value  *  */   + int atapi_xlate_error_to_vms( DQ_UCB *ucb )    {/                    b     int asc;
     int ascq;T    <     asc  = ucb->ucb$l_asc;			/* Get additional sense code */G     ascq = ucb->ucb$l_ascq;			/* Get additional sense code qualifier */-  \     if ( (asc==0x04) && (ascq==0x01) )		/* "Logical unit is in process of becoming ready" */C         return( SS$_MEDOFL );			/*   becomes "Medium is offline" */M/ 						/* Higher-level code will handle this. */c   						/* More inclusively, */sC     if (asc==0x04)				/* Various "Logical unit not ready" errors */)F         return( SS$_MEDOFL );			/*   all become "Medium is offline" */  @     if (asc==0x21)				/* "Logical block address out of range" */?         return( SS$_VOLINV );			/*   becomes "Bad Parameter" */,  5     if (asc==0x28)				/* "Medium may have changed" */b=       {						/*   becomes "Volume is not software enabled" */ D         baseucb.ucb$v_valid = 0;		/* Also clear the VALID bit and */;         return( SS$_VOLINV );			/* And return the status */            }   ;     if (asc==0x29)				/* Various "Reset occurred" errors */uB         return( SS$_MEDOFL );			/*   become "Medium is offline" */  @     if (asc==0x30)				/* Various "Incompatible medium" errors */B         return( SS$_MEDOFL );			/*   become "Medium is offline" */  ?     if (asc==0x3A)				/* Various "Medium not present" errors */oB         return( SS$_MEDOFL );			/*   become "Medium is offline" */  `     BPTRACE( 0x02060000 );			/* BREAK: Untranslated sense key during atapi_xlate_error_to_vms */M     return( SS$_DRVERR );			/* All else defaults to a nice, safe, disaster */i3 						/*   "%SYSTEM-W-DRVERR, fatal drive error" */t         }t     *E /* COMPUTE_ADDRESS - This routine is used to compute the head, sector 5  * and track information from a logical block number.r  *?  * Note that on IDE disks, sector numbers start at 1.  Head and   * cylinder numbers start at 0.   *G  * LBA mode addressing is handled if the LBA flag is set.  In LBA mode,*D  * the address is still returned in the sec, head and cyl locations,A  * but it is simply the sections of the LBA.  The callers of thisuA  * routine simply write these value to the registers, so this allP  * works just fine.r  *	  * Input: "  *      ucb     pointer to the UCB  *
  * Output:0  *              CHS mode                LBA mode0  *      sec     sector number           LBA[0:7]2  *      head    head number             LBA[24:27]1  *      cyl     cylinder number         LBA[8:23]s  *  */s  B void compute_address( DQ_UCB *ucb, int *sec, int *head, int *cyl )     {/  >     if (ucb->ucb$l_drive_lba_capable)			/* LBA or CSH mode? */         {							/* LBA mode... */eE         *sec  =  ucb->ucb$l_media.lbn        & 0x00FF;	/* Bits 0-7 */2H         *cyl  = (ucb->ucb$l_media.lbn >> 8)  & 0xFFFF;	/* Bits 8 - 23 */I         *head = (ucb->ucb$l_media.lbn >> 24) & 0x000F;	/* Bits 24 - 27 */r           }A       else         {							/* CSH mode... */          int temp;cA         *sec  = ucb->ucb$l_media.lbn % baseucb.ucb$b_sectors + 1;e=         temp  = ucb->ucb$l_media.lbn / baseucb.ucb$b_sectors;*,         *head = temp % baseucb.ucb$b_tracks;,         *cyl  = temp / baseucb.ucb$b_tracks;           }i         }y     >E /* FILL_PACKET_W_ADX - This routine is used to fill the address fieldcE  *                     in the packet based on the logical blck numberc  *	  * Input:d"  *      ucb     pointer to the UCB  *
  * Output:9  *      packet  certain field in the packet are filled-inb  *  *	  * Notes:,  *6  *   o Packets always use SCSI-style (~LBA) addressing  *&  *   o In packets, the MSB comes first  *  */_  $ int fill_packet_w_adx( DQ_UCB *ucb )     {        int cd_rom_lbn;n     int offset;u;     BYTE  *packet;				/* The packet bytes within the UCB */o    Z     packet = (BYTE *) ucb->ucb$b_packet;	/* Bind onto packet in the UCB as a byte array */  =     cd_rom_lbn = ucb->ucb$l_media.lbn;		/* Get desired LBN */f7     offset     = 0;				/* Assume no offset in buffer */i  =     if (ucb->ucb$l_2K_flag)			/* 2K blocks on this device? */e!       {						/* If so, then... */tM         offset     = cd_rom_lbn & 0x03;		/* Calculate offset within buffer */ ?         cd_rom_lbn = cd_rom_lbn>>2;		/* Then divide LBN by 4 */h           }n  C     packet[2] = (cd_rom_lbn >> 24) & 0x00FF;	/* LBN bits [24:31] */kC     packet[3] = (cd_rom_lbn >> 16) & 0x00FF;	/* LBN bits [16:23] */ C     packet[4] = (cd_rom_lbn >>  8) & 0x00FF;	/* LBN bits  [8:15] */aC     packet[5] = (cd_rom_lbn      ) & 0x00FF;	/* LBN bits  [0:7]  */)  8     return( offset );				/* Return the offset, if any */         }      ;D /* LOAD_PRDT - This routine is used to load the PRDT with 8 pointersB  *             pointing to the 8 PCI pages that map through to our  *             transfer buffer.:  *	  * Input: %  *      ucb        pointer to the UCBf  *
  * Output:  *      none  *  *  * Note:  *E  *   Right now, we just load the PRDT with (essentially) static data; F  *   this could easily be done at unit_init_fork time. But when we getC  *   to the point of doing direct DMA, this routine could get a lot0F  *   more sophisticated (see the "More PRDT Fun" note in the beginningH  *   comments). At that point, the work would definitely need to be doneE  *   at the point where it is done now, namely, the beginning of eache  *   transfer.  *  */g   void load_prdt( DQ_UCB *ucb )t     {   #     int   i;					/* Loop counter */vB     int   page_base_adx;			/* Starting address of this PCI page */(     PRDT  *prdt_tbl;				/* PRDT table */    e     prdt_tbl = (PRDT *) ucb->ucb$l_prdt;	/* Bind onto the PRDT as a vector of PRDT entries         */	l     page_base_adx = (UINT) ucb->ucb$l_xfer_phy;	/* Get the beginning PCI address of the xfer_buffer       */  j     for ( i=0; i<XFER_BUFFER_MAP_PAGES; i++ )	/* Now, for each of the 8 pages in our transfer buffer... */       {Sj         prdt_tbl[i].phys_adx = page_base_adx;	/* Load the physical address field                        */l         prdt_tbl[i].count    = MMG$GL_PAGE_SIZE;/* Load the bytecount field with 8K bytes                 */a         prdt_tbl[i].flags    = 0x0;		/* Clear the End-of-Table marker in this PRDT entry       */ h         page_base_adx += prdt_tbl[i].count;	/* Bump the PCI address onwards for the next pass         */L           }					/* Next page                                              */  i     prdt_tbl[i-1].flags    = DMA_PRDT_M_EDT;	/* Set the End-of-Table marker in the last PRDT entry     */c         }n     oG /* MOVE_SEC_FROM_DRIVE - This routine is used to move a sector from the "  * disk drive on a READ operation.  *	  * Input:*%  *      ucb        pointer to the UCB 2  *      buffer     pointer to buffer to place data4  *      bytecount  number of bytesto read from drive  *
  * Output:)  *      buffer     updated buffer pointer?  *      none  *  *  * Note:  *@  *   Right now, we just get data words in from the drive as fast@  *   as our little Alpha Processor will let us. Some day, with a;  *   faster processor, it may be necessary to actually polls=  *   whether DRQ is asserted before getting each word in fromt  *   the drive.   *J  *   (DRQ is constantly asserted throughout the duration of this routine.)  *  */(  D void move_sec_from_drive( DQ_UCB *ucb, BYTE *buffer, int bytecount ) { #     int   i;					/* Loop counter */p9     WORD *w_buffer;				/* Point to the buffer as words */   H     TRACE( 0x0A000000 + bytecount );		/* MOVE_SEC_FROM_DRIVE starting */  I     w_buffer = (WORD *) buffer;			/* Bind onto the buffer as words */            J     for (i=0; i<(bytecount>>1); i++)		/* For all the requested words... */*     {						/* Future DRQ test goes here */J 	 w_buffer[i] = inpw( ucb, RD_DATA );	/* Get and enbuffer the data word */     }i }h     sC /* MOVE_SEC_TO_DRIVE - This routine is used to move a sector to thea#  * disk drive on a WRITE operation.0  *	  * Input:e%  *      ucb        pointer to the UCBA1  *      buffer     pointer to buffer to read data 5  *      bytecount  number of bytes to write to drive.   *
  * Output:)  *      buffer     updated buffer pointer   *      none  *  *  * Note:  *@  *   Right now, we just push data words out to the drive as fast@  *   as our little Alpha Processor will let us. Some day, with a;  *   faster processor, it may be necessary to actually poll	<  *   whether DRQ is asserted before pushing each word out to  *   the drive.n  *J  *   (DRQ is constantly asserted throughout the duration of this routine.)  *  */   B void move_sec_to_drive( DQ_UCB *ucb, BYTE *buffer, int bytecount ) {   #     int   i;					/* Loop counter */o9     WORD *w_buffer;				/* Point to the buffer as words */a     int drvsts;      int status;*     volatile int j;* 		F     TRACE( 0x0B000000 + bytecount );		/* MOVE_SEC_TO_DRIVE starting */     E     w_buffer = (WORD *) buffer;			/* Bind onto the buffer as words */e  J     for (i=0; i<(bytecount>>1); i++)		/* For all the requested words... */     {gA 	outw( ucb, WT_DATA, w_buffer[i] );	/* Write out the data word */t     }  }       F /* MAP_USER_BUFFER - this routine is used to directly map a section of  * the users buffer.  *	  * Input:p"  *      ucb     pointer to the UCB6  *      offset  offset to start of buffer to be mapped#  *      length  total length to map	  *
  * Output:  *      user_va0)  *      returned address of mapped bufferc  *  */p  < BYTE *map_user_buffer( DQ_UCB *ucb, int offset, int length )            {A        int     pfn;			   	/* PFN */0     int     first_pte;				/* First PTE number */4     int     pte_cnt;				/* Number of pages to map */%     int     i;					/* Loop counter *//*     int     byte_ofs;				/* Byte offset */3     PTE     *user_pte;				/* Current PTE pointer */ /     BYTE    *s0_va;				/* Current S0 address */a4     PTE     *s0_pte;				/* Current S0 PTE address */4     BYTE    *user_va;				/* Mapped buffer address */8     uint64  *clr_pte;				/* Pointer used to clear PTE */  	 #if ALPHAt@ #define PTE_BITS PTE$C_KOWN + PTE$C_KW + PTE$M_VALID + PTE$M_ASM #else_4 #define PTE_BITS PTE$C_KOWN + PTE$C_KW + PTE$M_VALID #endif  2 /* Calculate sizes, base PTE addresses and such */  F     offset += baseucb.ucb$l_boff;		/* Compute true offset from page */J     byte_ofs = offset & mmg$gl_bwp_mask;	/* Compute byte offset in page */C     first_pte = (offset >> MMG$GL_VPN_TO_VA) * PTE$C_BYTES_PER_PTE;u 						/* Compute PTE offset */^     pte_cnt = ( ( (offset & mmg$gl_bwp_mask) + length) + mmg$gl_bwp_mask) >> MMG$GL_VPN_TO_VA; 						/* Compute page count */A     user_pte = (PTE *) ( (int) baseucb.ucb$l_svapte + first_pte);(% 						/* Compute first PTE address */_C     s0_va   = ucb->ucb$ps_s0_va;		/* S0 address of mapped region */=>     s0_pte  = ucb->ucb$ps_s0_svapte;		/* Get S0 PTE address */  J /* Loop over all of the PTEs and set them to double map the user buffer */       for (i=0; i<pte_cnt; i++)c       {PB         if (user_pte->pte$v_valid)		/* Check for VALID user PTE */E             pfn = user_pte->pte$v_pfn;		/* It is - get copy of PFN */e         elseK             pfn = ioc_std$ptetopfn( user_pte );	/* Find PFN the hard way */E  9 /* The following should be set field by field, but PTEDEFe9  * doesn't have a proper definition for this, and franklyv=  * it's a pain !  So, define some bits and use them directly.d  *  *=  *      s0_pte->pte$v_own = PTE$C_KOWN;		/@ Owner = Kernel @/nG  *      s0_pte->pte$v_prot = PTE$C_KW;		/@ Protection = Kernel Write @/d2  *      s0_pte->pte$v_valid = 1;		/@ Valid page @/:  *      s0_pte->pte$v_asm = 1;			/@ Address space match @/  */c  :         clr_pte = (void *) s0_pte;		/* Point to the PTE */H         *clr_pte = PTE_BITS;			/* Clear the PTE and set constant bits */<         s0_pte->pte$v_pfn = pfn;		/* Now, include the PFN */>         mmg$tbi_single( s0_va );		/* Invalidate the address */@         s0_va += MMG$GL_PAGE_SIZE;		/* Point to the next page *//         s0_pte++;				/* Point to next S0 PTE */ 3         user_pte++;				/* Point to next user PTE */r           }    /* Now, make a guard page */  6     clr_pte = (void *) s0_pte;			/* Get PTE address */'     *clr_pte= 0;				/*  and clear it */ ;     mmg$tbi_single( s0_va );			/* Invalidate the address */   ) /* Return the S0 VA of the user buffer */v  >     user_va = (BYTE *) ( (int) ucb->ucb$ps_s0_va + byte_ofs );7     return( user_va );				/* Return with the address */t         }t      . /* UNLOAD - Perform IO$_UNLOAD driver function  *	  * Input:   *      ucb     pointer to UCB  *
  * Output:  *      status value=  *              SS$_NORMAL -- function completed successfullyu  *  */d   int unload( DQ_UCB *ucb )d     {h  8     baseucb.ucb$v_valid = 0;			/* Clear the VALID bit */5     return( SS$_NORMAL );			/* Return with success */i         }t     mC /* WAIT_READY - Wait Until The Drive Is Ready.  This means that thed:  * BSY status bit is clear and the DRDY status bit is set.  *	  * Input:a  *      ucb     pointer to UCB  *
  * Output:  *      status value@  *              SS$_NORMAL ----- function completed successfully3  *              SS$_DEVACTIVE -- BUSY never cleared	  *  * Note:  *F  *   If DRV_HD is currently pointing at a non-existent drive (because,B  *   perhaps, the user last tried to mount a non-existent device),E  *   all the registers (including ALT_STS) tend to say "0xFF". RathercD  *   than wait forever for this fake "busy" signal to clear, we just@  *   barge ahead and select the drive we really want to talk to.  *  */0   int wait_ready( DQ_UCB *ucb )i     {e  /     int   status;				/* Routine status value */ 0     int   drvsts;				/* Drive status register */>     int   cyl_hi;				/* High-order byte of cylinder address */=     int   cyl_lo;				/* Low-order byte of cylinder address */l     int	  drv_head;o  4     TRACE( 0x03100000 );			/* WAIT_READY starting */  ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */ B     if (drvsts!=0xFF)				/* If it looks like a real drive, then */       { C         if ( IS_SET( drvsts, STS_M_BSY ) )	/* Is the drive busy? */ $           {					/* If so, then... */Z             status = wait_busy( ucb );		/* Make sure BUSY is clear on the current drive */@             if ( $FAIL( status ) )		/* Check status for error */               {	b                 TRACE( 0x03110000 );		/* WAIT_BUSY failed for WAIT_READY before drive selection */A                 return( status );		/* Exit with the error code */e                   }l               }e           })  D     drv_head= ucb->ucb$l_drv_head;              /* Get drive info */F     if (ucb->ucb$l_drive_lba_capable)           /* If LBA mode, ... */E         drv_head |= DRVHD_M_LBA;                /* Set the LBA bit */A  W     out( ucb, WT_DRV_HD, drv_head );	/* Select the drive we really want (and head 0) */   ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */tB     if (drvsts==0xFF)				/* If it looks like a real drive, then */       {I`         TRACE( 0x03120000 );			/* WAIT_READY trying to select an apparently-nonexistent drive */A         return( SS$_DEVOFFLINE );		/* Exit with the error code */            }f  O     if ( IS_SET( drvsts, STS_M_BSY ) )		/* Is the newly-selected drive busy? */d!       {						/* If so, then... *//T         status = wait_busy( ucb );		/* Make sure BUSY is clear on this drive, too */=         if ( $FAIL( status ) )			/* Check status for error */m           {d]             TRACE( 0x03130000 );		/* WAIT_BUSY failed for WAIT_READY after drive selection */a>             return( status );			/* Exit with the error code */               }r           }o  D     if ( IS_SET( drvsts, STS_M_DRDY ) )		/* Check for drive READY */       { :         TRACE( 0x03140000 );			/* WAIT_READY succeeding */@         return( SS$_NORMAL );			/* Return succeeding if ready */           }   ? 						/* Collect the other two pieces of the ATAPI signature */uH     cyl_hi = inp( ucb, RD_CYL_HI );		/* Read high order cylinder bits */G     cyl_lo = inp( ucb, RD_CYL_LO );		/* Read low order cylinder bits */D^     if ( (drvsts==ATAPI_SIG_STS) && (cyl_hi==ATAPI_SIG_CYL_HI) && (cyl_lo==ATAPI_SIG_CYL_LO) )       {gP         TRACE( 0x03150000 );			/* WAIT_READY barging ahead on ATAPI signature */V         return( SS$_NORMAL );			/* If we see ATAPI signature, barge ahead w/o ready */           })  _     if ( (drvsts==ATAPI_SIG_STSE) && (cyl_hi==ATAPI_SIG_CYL_HI) && (cyl_lo==ATAPI_SIG_CYL_LO) )        { _         TRACE( 0x03160000 );			/* WAIT_READY barging ahead on ATAPI signature (w/ error bit) */DV         return( SS$_NORMAL );			/* If we see ATAPI signature, barge ahead w/o ready */           }b  F     TRACE( 0x03170000 );			/* WAIT_READY failing on non-ready drive */D     return( SS$_DEVACTIVE );			/* Otherwise, exit with failure if *// 						/*   not ready and not ATAPI signature */e       }       ' /* WAIT_BUSY - Wait for BSY to be clearP  *	  * Input:0  *      ucb     pointer to UCB  *
  * Output:  *      status value  *  */u   int wait_busy( DQ_UCB *ucb )     {m  2     int      status;				/* Routine status value */2     int     drvsts;				/* Drive status register */5     __int64  delta_time;			/* Timedwait delta time */t4     __int64  end_value;				/* Timedwait end value */  2 /* Check to see if the drive is ready right now */  3     TRACE( 0x03200000 );			/* WAIT_BUSY starting */   ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */ @     if ( IS_CLEAR( drvsts, STS_M_BSY ) )	/* If not busy, then */       { R         TRACE( 0x03210000 );			/* WAIT_BUSY normal exit -- was already not-busy */;         return( SS$_NORMAL );			/* Drive is ready - exit */r           }	  ' /* Drive is busy - wait a bit for it */    /* Set up the timedwait */  4     delta_time = DRQ_TIME;			/* Set DRQ wait time */<     status = exe$timedwait_setup( &delta_time, &end_value );3     if ( $FAIL( status) )			/* Check for success */T       {!J         TRACE( 0x03220000 );			/* WAIT_BUSY exe$timedwait_setup failure */@         return( status );			/* Return with the failure status */           }e  ! /* Spin until ready or timeout */   L     while ( ( status=exe$timedwait_complete( &end_value ) ) == SS$_CONTINUE)       { ?         drvsts = inp( ucb, RD_ALT_STS );	/* Read status byte */aK         if ( IS_CLEAR( drvsts, STS_M_BSY ) )	/* Check for it to be clear */o           {RK             TRACE( 0x03230000 );		/* WAIT_BUSY "became not-busy" success */l=             return( SS$_NORMAL );		/* BUSY is clear - exit */                }            }e  E /* Ok - still not ready.  Let's reset the controller and try again */l  E     BPTRACE( 0x03240000 );			/* BREAK: wait_busy wants to do reset */ /     reset_ctrl( ucb );				/* Attempt a reset */ ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */)@     if ( IS_CLEAR( drvsts, STS_M_BSY ) )	/* If not busy, then */       {iL         TRACE( 0x03250000 );			/* WAIT_BUSY "became not-busy" after reset */:         return( SS$_NORMAL );			/*  return with success */           }/     else       {sO         TRACE( 0x03260000 );			/* WAIT_BUSY "still busy" after reset failure */rA         return( SS$_CTRLERR );			/* Exit with controller error */            }o       }t      8 /* WAIT_DRQ - Wait for DRQ to be set and BSY to be clear  *	  * Input:c  *      ucb     pointer to UCB  *
  * Output:  *      status value  *  */*   int wait_drq( DQ_UCB *ucb )e     {l  2     int      status;				/* Routine status value */3     int      drvsts;				/* Drive status register */ 5     __int64  delta_time;			/* Timedwait delta time */t4     __int64  end_value;				/* Timedwait end value */  2 /* Check to see if the drive is ready right now */  2     TRACE( 0x03300000 );			/* WAIT_DRQ starting */  ?     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte */ A     if ( IS_CLEAR( drvsts, STS_M_BSY ) )	/* Is the drive busy? */s"       {						/* If not, then... */A         if ( IS_SET( drvsts, STS_M_DRQ ) )	/*  get the DRQ bit */            { O             TRACE( 0x03310000 );		/* WAIT_DRQ normal exit -- was already DRQ */ N             return( SS$_NORMAL );		/* Drive is ready and DRQ is set -- exit */               }            }   6 /* Drive is busy or DRQ not set - wait a bit for it */   /* Set up the timedwait */  4     delta_time = DRQ_TIME;			/* Set DRQ wait time */<     status = exe$timedwait_setup( &delta_time, &end_value );4     if ( $FAIL( status ) )			/* Check for success */       { I         TRACE( 0x03320000 );			/* WAIT_DRQ exe$timedwait_setup failure */ @         return( status );			/* Return with the failure status */           }D  ! /* Spin until ready or timeout */=  K     while ( (status=exe$timedwait_complete( &end_value ) ) == SS$_CONTINUE)7       {KF         drvsts = inp( ucb, RD_ALT_STS );	/* No, so read status byte */,         if ( IS_CLEAR( drvsts, STS_M_BSY ) )           {'.             if ( IS_SET( drvsts, STS_M_DRQ ) )               { K                 TRACE( 0x03330000 );		/* WAIT_DRQ "became ready" success */ F                 return( SS$_NORMAL );		/* Looks ok - set new status */                   }	               }u           }i  M     TRACE( 0x03340000 );			/* WAIT_DRQ ending with TIMEOUT waiting for DRQ */t6     return( status );				/* Return with status code */         }*     m  K /* DQ_WFIKPCH - Wait for Interrupt and Keep Channel (opionally w/Histogram)   *=  * This routine is a jacket around the normal ioc$kp_wfikpch. G  * This routine may also keep the time completion histogram up to date.   *	  * Input: %  *      kpb        pointer to the KPB*C  *      orig_ipl   IPL to restore to when releasing the device lock @  *      erl_param  An arbitrary parameter passed from our callerC  *                 which will be passed onto dumpreg if we timeout. D  *                 We only use the param to identify (for posterity)!  *                 who called us.o  *
  * Output:  *      status value  *  */   7 int dq_wfikpch( KPB *kpb, int orig_ipl, int erl_param )T     {o  -     DQ_UCB      *ucb;				/* Pointer to UCB */ 8     int         status;				/* Returned routine status */=     extern int  EXE$GL_ABSTIM;			/* Current time (seconds) */rA     int         time;				/* Starting time, later, Elapsed time */      int		drvsts;     int		drverr;  >     ucb    = (DQ_UCB *) kpb->kpb$ps_ucb;	/* Get UCB pointer */  5     TRACE( 0x03400000 );			/* DQ_WFIKPTCH starting */   \     drvsts = inp( ucb, RD_ALT_STS );		/* Get the status byte (just for tracing's benefit) */  Z     if (ucb->ucb$l_unsolicited_int!=0)		/* Is an unsolicited interrupt already pending? */.       {						/* If so, bypass WFIKPCH, etc. */_         TRACE( 0x03410000 );			/* DQ_WFIKPCH taking the pending-unsolicited-interrupt bypass */eX         ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */Q     	inp( ucb, RD_STS );			/* Read status byte to quash any pending interrupts */ C         device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE ); # 						/* Release the device lock */f;         return( SS$_NORMAL );			/* And return succeeding */o           }a/ 						/* Else we'll wait for an interrupt... */   6     time = EXE$GL_ABSTIM;			/* Get the current time */F     status = ioc$kp_wfikpch( kpb, ucb->ucb$l_int_max_wait, orig_ipl );>     time = EXE$GL_ABSTIM - time;		/* Calculate elapsed time */;     TRACE( 0x03420000 + time );			/* IOC$KP_WFIKPTCH end */P     if (time > TIMEOUT_TIME)B 	ucb->ucb$l_int_hist[TIMEOUT_TIME]++;	/* Bump a histogram entry */     else; 	ucb->ucb$l_int_hist[time]++;		/* Bump a histogram entry */d  \     ucb->ucb$l_int_max_wait = TIMEOUT_TIME;	/* reset our timeout time back to its default */    9     if (status == SS$_TIMEOUT)			/* Interrupt timeout? */e!       {						/* If so, then... */ I         ucb->ucb$l_int_tmo++;			/* Bump the explicit timeout indicator */_3         erl_std$devictmo( erl_param, (UCB *) ucb ); % 						/* Handle the device timeout */	4         exe$kp_fork( ucb->ucb$ps_kpb, (FKB *) ucb ); 						/* Fork, and... */=         BPTRACE( 0x03430000 );			/* BREAK: WFIKPCH timeout */l;         return( status );			/* Return with status intact */T           }e  ;     if ( $FAIL( status ) )			/* Any other WFIKPCH error? */c!       {						/* If so, then... */BC         device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );]G         BPTRACE( 0x03440000 );			/* BREAK: Non-timeout WFIKPCH error */u9         return( status );			/*  and return with status *//           } * 						/* All is well after the 'rupt... */  T     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */  9     status = exe$kp_fork( ucb->ucb$ps_kpb, (FKB *) ucb ); ! 						/* Drop back to fork IPL */      status = SS$_NORMAL;  5     return( status );				/* and return with status */            }a    7 /* DQ_DMA_WFIKPCH - Wait for Interrupt and Keep Channel   *I  * This routine is a jacket around the normal ioc$kp_wfikpch on a DMA IO.   *	  * Input:A%  *      kpb        pointer to the KPB C  *      orig_ipl   IPL to restore to when releasing the device lockQ@  *      erl_param  An arbitrary parameter passed from our callerC  *                 which will be passed onto dumpreg if we timeout. D  *                 We only use the param to identify (for posterity)!  *                 who called us.	  *
  * Output:  *      status value  *  */   ; int dq_dma_wfikpch( KPB *kpb, int orig_ipl, int erl_param )  { -     DQ_UCB      *ucb;				/* Pointer to UCB */ 8     int         status;				/* Returned routine status */=     extern int  EXE$GL_ABSTIM;			/* Current time (seconds) */ A     int         time;				/* Starting time, later, Elapsed time */   >     ucb    = (DQ_UCB *) kpb->kpb$ps_ucb;	/* Get UCB pointer */  Z     if (ucb->ucb$l_unsolicited_int!=0)		/* Is an unsolicited interrupt already pending? */,     {						/* If so, bypass WFIKPCH, etc. */X         ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */' 	out( ucb, WT_DMA_STS, DMA_STS_M_INT );eC         device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE ); # 						/* Release the device lock */ ;         return( SS$_NORMAL );			/* And return succeeding */      }   6     time = EXE$GL_ABSTIM;			/* Get the current time */F     status = ioc$kp_wfikpch( kpb, ucb->ucb$l_int_max_wait, orig_ipl );>     time = EXE$GL_ABSTIM - time;		/* Calculate elapsed time */  \     ucb->ucb$l_int_max_wait = TIMEOUT_TIME;	/* reset our timeout time back to its default */    9     if (status == SS$_TIMEOUT)			/* Interrupt timeout? */I     {						/* If so, then... */ I         ucb->ucb$l_int_tmo++;			/* Bump the explicit timeout indicator */ 3         erl_std$devictmo( erl_param, (UCB *) ucb ); % 						/* Handle the device timeout *//4         exe$kp_fork( ucb->ucb$ps_kpb, (FKB *) ucb ); 						/* Fork, and... */;         return( status );			/* Return with status intact */*     }   ;     if ( $FAIL( status ) )			/* Any other WFIKPCH error? */      {						/* If so, then... */ C         device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE );u9         return( status );			/*  and return with status */r     }i  T     ucb->ucb$l_unsolicited_int = 0;		/* Forget any pending unsolicited interrupts */9     status = exe$kp_fork( ucb->ucb$ps_kpb, (FKB *) ucb );n! 						/* Drop back to fork IPL */ 5     return( status );				/* and return with status */u }r      $ /* RESET_CTRL - Reset the controller  *B  * This routine issues a RESET to the controller. It does this forD  * ATA devices by using the RESET bit and for ATAPI devices by using$  * the ATAPI Software REset command.  *B  * It then waits for the BUSY bit to clear.  If the BUSY bit isn'tH  * cleared within a certain time, we decide that the controller is dead.  *	  * Input:e  *      ucb     pointer to UCB  *
  * Output:  *      status value/  *              SS$_NORMAL --- successful resetr9  *              SS$_CTRLERR -- controller failed to RESETt  *  */Z   int reset_ctrl( DQ_UCB *ucb )      {   )     int   orig_ipl;				/* Original IPL */ /     int   status;				/* Routine status value */ 6     int   drv_head;				/* Drive drive/head register */0     int   drvsts;				/* Drive status register */&     int   loop;					/* Loop counter */    4     TRACE( 0x00070000 );			/* RESET_CTRL starting */;     ucb->ucb$l_resets++;			/* Count a reset issued by us */   <     device_lock( baseucb.ucb$l_dlck, RAISE_IPL, &orig_ipl );$ 						/* Take out the device lock */  :     if (ucb->ucb$l_atapi_flag==0)		/* ATAPI flag clear? */4       {						/* If so, ATA RESET -- Use reset bit */:         out( ucb, WT_DEV_CTL, (CTL_M_SRST | CTL_M_nIEN) );( 						/* Set the Reset + no_ints bits */K         out( ucb, WT_DEV_CTL, 0x00 );		/* Cear the Reset + no_ints bits  */a           }f     else3       {						/* ATAPI RESET -- Use reset command */)  B         drv_head = ucb->ucb$l_drv_head;		/* Get base drive info */@         if (ucb->ucb$l_drive_lba_capable)	/* If LBA mode, ... */@             drv_head |= DRVHD_M_LBA;		/*  ... set the LBA bit */H         out( ucb, WT_DRV_HD, drv_head );	/* Select drive, ignore head */5         out( ucb, WT_CMD, CMD_ATA_ATAPI_SOFT_RESET );a3           }					/* Issue the ATAPI reset command */   ?     device_unlock( baseucb.ucb$l_dlck, orig_ipl, SMP_RESTORE ); ' 						/* And release the device lock */   P     for (loop=0; loop<RESET_TIME>>1; loop++)	/* Now wait for a few seconds... */       {dH         status = sleep( ucb, 2 );		/* Sleep a bit (up to two seconds) */1 						/* (First sleep allows drive to go busy) */ :         if ( $FAIL( status ) )			/* Check the KP status */;             return( status );			/* Failed - exit w/error */rB         drvsts = inp( ucb, RD_ALT_STS );	/* Get the status byte */D         if ( IS_CLEAR( drvsts, STS_M_BSY ) )	/* If not busy, then */>             return( SS$_NORMAL );		/* Drive is ready - exit */           }   F     return( SS$_CTRLERR );			/* It never became ready again -- punt */         }      	 /* SLEEP - Kill some timeu  *  *	  * Usage:   *      SLEEP (seconds)0  *	  * Input::  *      ucb      pointer to UCBQ!  *      seconds  seconds to sleepR  *
  * Output:  *      none  *  * Return value:+  *      status of the exe$kp_fork_wait call   *  */(  % int sleep( DQ_UCB *ucb, int seconds )0     {   
     int loop;      int status;w    8     TRACE( 0x00080000 + seconds );		/* SLEEP starting */  &     for (loop=0; loop<seconds; loop++)       { B         status = exe$kp_fork_wait( ucb->ucb$ps_kpb, (FKB *) ucb );:         if ( $FAIL( status ) )			/* Check the KP status */;             return( status );			/* Failed - exit w/error */            }/       return( SS$_NORMAL );         }      " /* ISR - Interrupt Service Routine  *  *  *	  * Usage:6  *      ISR (idb)   *	  * Input:u  *      idb     pointer to IDB  *
  * Output:  *      none  *  * Return value:  *      none  *  */    void isr( IDB *idb )     {   ,     DQ_UCB *ucb;				/* Pointer to the UCB */     int	   drvsts;  K /* Get pointer to the UCB;  If null, then there is none and we just exit */r  K     ucb = (DQ_UCB *) idb->idb$ps_owner;		/* Get UCB address from the IDB */m     if (ucb == NULL):         return;					/* Unowned and unexpected - dismiss */>     ucb->ucb$l_total_ints++;			/* Increment interrupt count */  J /* There's an owner.  If the interrupt is expected, then restart the KP */  ?     device_lock( baseucb.ucb$l_dlck, NORAISE_IPL, NOSAVE_IPL ); # 						/* Acquire the device lock */k  L     if (baseucb.ucb$v_int)			/* Is this an expected interrupt?            */<       {						/* If so, then...                            */N         TRACE( 0x0E000000 );			/* Expected interrupt                        */P         baseucb.ucb$v_int = 0;			/* Clear "interrupt expected"                */P         baseucb.ucb$v_tim = 0;			/* Clear TIMEOUT expected bit                */N         fork( (void (*)()) exe$kp_restart, ucb->ucb$ps_kpb, SS$_NORMAL, ucb );?           }					/* Fork off a routine to restart the stalled */h5 						/*   mainline kernel process                 */A<     else					/* Else unexpected interrupt...              */<       {						/*                                           */N         TRACE( 0x0E100000 );			/* Unexpected interrupt!                     */X         ucb->ucb$l_unsolicited_int = 1;		/* An unsolicited interrupt is now pending   */Q         ucb->ucb$l_unsol_ints++;		/* Increment unsolicited interrupt count     */I           }T  %     /* Clear the Pending Interrupt */ &     drvsts = inp ( ucb, RD_DMA_STS);		T     if ( ((IS_SET( drvsts, DMA_STS_M_ACTIVE)) && (ucb->ucb$l_ctrl_id == CMD649)) ) {  ? 	/* This is a DMA IO.  Write the Clear Pending Interrupt Bit */ ( 	out( ucb, WT_DMA_STS, DMA_STS_M_INT );	    q     } else {  =B 	/* This is a PIO.  Read Status Byte to Clear Pending Interrupt */ 	inp( ucb, RD_STS );			t          }o  B     device_unlock( baseucb.ucb$l_dlck, NOLOWER_IPL, SMP_RESTORE );# 						/* Release the device lock */y+     TRACE( 0x0E200000 );			/* ISR ending */c8     return;					/* Return to the interrupt dispatcher */         }t     c8 /* INP - This routine is used to read a byte from a CSR.  *	  * Input:i"  *      ucb     pointer to the UCB  *      reg     register index  *
  * Output:  *      none  *  * Return value:&  *      byte of data read from the CSR  *  *//    BYTE inp( DQ_UCB *ucb, int reg )     {m  -     CRAM  *cram_ptr;				/* Pointer to CRAM */*)     int   status;				/* Routine status */	#     BYTE  data;					/* Data byte */   ?     cram_ptr = ucb->ucb$ps_crams[reg];		/* Point to the CRAM */A<     status   = ioc$cram_io( cram_ptr );		/* Read the byte */C     data = (cram_ptr->cram$q_rdata >> cram_init[reg].shift) & 0xFF;e   #ifdef TRACE_DATA_TOO ?     TRACE( 0x05000000 | ((reg>>1)<<16) | data );/* Byte read */  #endif  -     return( data );				/* Return the value */e         }      e9 /* INPW - This routine is used to read a word from a CSR.   *	  * Input:3"  *      ucb     pointer to the UCB  *      reg     register index  *
  * Output:  *      none  *  * Return value:&  *      word of data read from the CSR  *  */e  ! WORD inpw( DQ_UCB *ucb, int reg )t     {/  1     CRAM  *cram_ptr;				/* Pointer to the CRAM */ /     int   status;				/* Routine status value */-$     WORD  data;					/* Data value */  ;     cram_ptr = ucb->ucb$ps_crams[reg];		/* Point to CRAM */u<     status   = ioc$cram_io( cram_ptr );		/* Read the word */C     data = cram_ptr->cram$q_rdata >> cram_init[reg].shift & 0xFFFF;t   #ifdef TRACE_PIO_READ_DATA_TOO?     TRACE( 0x05400000 | ((reg>>1)<<16) | data );/* Word read */f #endif  /     return( data );				/* Send back the data */d         },     n7 /* OUT - This routine is used to write a byte to a CSR.   *	  * Input:r"  *      ucb     pointer to the UCB  *      reg     register index2  *      data    data byte to be written to the CSR  *
  * Output:  *      none  *  */*  + void out( DQ_UCB *ucb, int reg, BYTE data )      {o  1     CRAM  *cram_ptr;				/* Pointer to the CRAM */ *     int   status;				/* Returned status */  >     cram_ptr = ucb->ucb$ps_crams[reg];		/* Get correct CRAM */:     cram_ptr->cram$q_wdata = data << cram_init[reg].shift; 						/* Position data */ @     status   = ioc$cram_io( cram_ptr );		/* Perform the write */   #ifdef TRACE_DATA_TOO*B     TRACE( 0x06000000 | ((reg>>1)<<16) | data);	/* Byte written */ #endif         }l     b@ /* OUTW - This routine is used to write a word of data to a CSR.  *	  * Input:_"  *      ucb     pointer to the UCB  *      reg     register index2  *      data    data word to be written to the CSR  *
  * Output:  *      none  *  */d  , void outw( DQ_UCB *ucb, int reg, WORD data )     {c  -     CRAM  *cram_ptr;				/* Pointer to CRAM */ )     int   status;				/* Routine status */   ?     cram_ptr = ucb->ucb$ps_crams[reg];		/* Point to the CRAM */y:     cram_ptr->cram$q_wdata = data << cram_init[reg].shift; 						/* Position the data */ =     status   = ioc$cram_io( cram_ptr );		/* Write the word */*   #ifdef TRACE_PIO_WRITE_DATA_TOOeC     TRACE( 0x06400000 | ((reg>>1)<<16) | data ); /* Word written */c #endif         }       O /* OUTW_T - This routine is used to write a word of ATAPI packet data to a CSR.o  *	  * Input:e"  *      ucb     pointer to the UCB  *      reg     register index2  *      data    data word to be written to the CSR  *
  * Output:  *      none  *  *  * Note:  *B  *   This routine only exists because it provides an unconditionalC  *   trace of the outw() calls that write the ATAPI packet, even ifi"  *   TRACE_DATA_TOO isn't defined.  *  */   . void outw_t( DQ_UCB *ucb, int reg, WORD data )     {-  -     CRAM  *cram_ptr;				/* Pointer to CRAM */e)     int   status;				/* Routine status */   ?     cram_ptr = ucb->ucb$ps_crams[reg];		/* Point to the CRAM */r:     cram_ptr->cram$q_wdata = data << cram_init[reg].shift; 						/* Position the data */ =     status   = ioc$cram_io( cram_ptr );		/* Write the word */k  P     TRACE( 0x06800000 | ((reg >>1)<<16) | data );/* ATAPI packet word written */         }_  D /* OUTL - This routine is used to write a longword of data to a CSR.  *	  * Input:;"  *      ucb     pointer to the UCB  *      reg     register index-  *      data    data to be written to the CSRR  *
  * Output:  *      none  *  */R  + void outl( DQ_UCB *ucb, int reg, int data )t     {I  -     CRAM  *cram_ptr;				/* Pointer to CRAM */a)     int   status;				/* Routine status */   ?     cram_ptr = ucb->ucb$ps_crams[reg];		/* Point to the CRAM */*:     cram_ptr->cram$q_wdata = data << cram_init[reg].shift; 						/* Position the data */i=     status   = ioc$cram_io( cram_ptr );		/* Write the word */    #ifdef TRACE_DATA_TOOg:     TRACE( 0x06440000 | ((reg>>1)<<16) | (data & 0xFFFF));@     TRACE( 0x06440000 | ((reg>>1)<<16) | ((data>>16) & 0xFFFF)); #endif         },