$IF 0
Mine Seeker GNU/GPL Version 1.1 - DOS version of the classic old game.
Created with PowerBASIC for DOS 3.50
Copyright (C) 2001-2002 by Bla Valek   E-mail: bvalek2@freemail.hu

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

$ENDIF
$COM 0
$COMPILE EXE
$CPU 8086
$DEBUG MAP OFF
$DEBUG PBDEBUG OFF
$DEBUG PATH OFF
$DEBUG UNIT OFF
$DIM ARRAY
$ERROR ALL OFF
$LIB ALL OFF
$OPTIMIZE SPEED
$OPTION CNTLBREAK OFF
$SOUND 0
$STACK 32766
$STRING 1

DEFINT A-Z
%False = 0
%True = NOT %False

CLS
LOCATE 1, 1: PRINT ""; STRING$(78, 196); "";
FOR a% = 2 TO 24
    LOCATE a%, 1: PRINT ""; TAB(80); "";
NEXT a%
LOCATE 25, 1: PRINT ""; STRING$(78, 196); "";
COLOR 3

LOCATE 3, 24: PRINT "ARE YOU READY FOR THE CHALLENGE?"
COLOR 7
LOCATE 6, 4: PRINT "YOUR LOCATION : BOSNIA-HERCEGOVINA"
LOCATE 7, 4: PRINT "YOUR MISSION  : SEEK FOR LANDMINES IN THE REGION"
LOCATE 12, 4: PRINT "ON THE"
COLOR 12
LOCATE 10, 15: PRINT "M   M I N   N EEEEE       FFFFF I EEEEE L     DDDD"
LOCATE 11, 15: PRINT "MM MM I NN  N E           F     I E     L     D   D"
LOCATE 12, 15: PRINT "M M M I N N N EEE         FFF   I EEE   L     D   D"
LOCATE 13, 15: PRINT "M   M I N  NN E           F     I E     L     D   D"
LOCATE 14, 15: PRINT "M   M I N   N EEEEE       F     I EEEEE LLLLL DDDD"
COLOR 14
LOCATE 17, 30: PRINT "G O O D   L U C K !"
COLOR 7
LOCATE 24, 4: PRINT "Press any key to continue"
IF INPUT$(1) = "" THEN
END IF

DO

failed% = %False
won% = %False
found% = 0

SCREEN 0
WIDTH 80, 25
CLS
DO
INPUT "Columns(1 TO 80)"; cols%
LOOP UNTIL cols% > 0 AND cols% < 81
DO
INPUT "Rows(1 TO 50)"; rows%
LOOP UNTIL rows% > 0 AND rows% < 51
DO
PRINT "mines(1 TO"; STR$(cols% * rows%);
INPUT ")"; mines%
LOOP UNTIL mines% > 0 AND mines% < cols% * rows% + 1

REDIM table(cols% + 1, rows% + 1, 1) AS STRING * 1
SHARED table()
SHARED nested%
SHARED cols%
SHARED rows%
DIM UseMouse AS SHARED INTEGER
UseMouse = -1

SELECT CASE rows%
CASE 1 TO 25: wid% = 25
CASE 26 TO 43: wid% = 43
CASE 44 TO 50: wid% = 50
END SELECT

WIDTH 80, wid%
CLS
RANDOMIZE TIMER

IF NOT MsThere THEN
    PRINT "No mouse driver present!"
    END 1
ELSE
    PRINT "Found a"; MsButtons; "button mouse."
END IF

PRINT "Press any key to continue"

MsSetWindow 0, 0, rows%, cols%
MsCursorOn
MouseWait Ky$, Button, Row, Column

CLS
COLOR 7, 0

REDIM minelist%(1 TO mines%, 1)
FOR n% = 1 TO mines%
    DO
        minelist%(n%, 0) = RND(1, cols%)
        minelist%(n%, 1) = RND(1, rows%)
        IF table(minelist%(n%, 0), minelist%(n%, 1), 0) <> CHR$(&H0F) THEN
            table(minelist%(n%, 0), minelist%(n%, 1), 0) = CHR$(&H0F)
            EXIT DO
        END IF
    LOOP
NEXT n%
FOR y% = 1 TO rows%
    FOR x% = 1 TO cols%
        IF table(x%, y%, 0) <> CHR$(&H0F) THEN
            s% = 0
            IF (table(x% + 1, y% + 1, 0) = CHR$(&H0F)) AND (x% + 1 <> cols% + 1) AND (y% + 1 <> rows% + 1) THEN s% = s% + 1
            IF (table(x% + 1, y% - 1, 0) = CHR$(&H0F)) AND (x% + 1 <> cols% + 1) AND (y% - 1 <> 0) THEN s% = s% + 1
            IF (table(x% + 1, y%, 0) = CHR$(&H0F)) AND (x% + 1 <> cols% + 1) THEN s% = s% + 1
            IF (table(x% - 1, y% + 1, 0) = CHR$(&H0F)) AND (x% - 1 <> 0) AND (y% + 1 <> rows% + 1) THEN s% = s% + 1
            IF (table(x% - 1, y% - 1, 0) = CHR$(&H0F)) AND (x% - 1 <> 0) AND (y% - 1 <> 0) THEN s% = s% + 1
            IF (table(x% - 1, y%, 0) = CHR$(&H0F)) AND (x% - 1 <> 0) THEN s% = s% + 1
            IF (table(x%, y% + 1, 0) = CHR$(&H0F)) AND (y% + 1 <> rows% + 1) THEN s% = s% + 1
            IF (table(x%, y% - 1, 0) = CHR$(&H0F)) AND (y% - 1 <> 0) THEN s% = s% + 1
            table(x%, y%, 0) = TRIM$(STR$(s%))
        END IF
        table(x%, y%, 1) = "H"
    NEXT x%
NEXT y%

GOSUB display

starttime! = TIMER

DO
    MouseWait Ky$, Button, Row, Column

SELECT CASE Button
CASE 1
    IF table(Column, Row, 1) <> "F" THEN
        table(Column, Row, 1) = "S"
        IF table(Column, Row, 0) = "0" THEN cleanfield Column, Row
    END IF
CASE 2
    SELECT CASE table(Column, Row, 1)
    CASE "F": table(Column, Row, 1) = "?"
    CASE "?": table(Column, Row, 1) = "H"
    CASE "H": table(Column, Row, 1) = "F"
    END SELECT
END SELECT

    MsCursorOff

    GOSUB display

    IF failed THEN
        FOR n% = 1 TO mines%
            COLOR 12, 0
            LOCATE minelist%(n%, 1), minelist%(n%, 0)
            PRINT CHR$(&H0F);
            IF table(minelist%(n%, 0), minelist%(n%, 1), 1) = "F" THEN
                found% = found% + 1
            END IF
        NEXT n%
        COLOR 15
        LOCATE 8, 10: PRINT "YOUR MISSION IS A FAILURE"
        EXIT DO
    END IF
    IF won THEN
        found% = mines%
        FOR n% = 1 TO mines%
            COLOR 14, 0
            LOCATE minelist%(n%, 1), minelist%(n%, 0)
            PRINT "F";
        NEXT n%
        COLOR 15
        LOCATE 8, 10: PRINT "YOUR MISSION IS COMPLISHED"
        EXIT DO
    END IF

    MsCursorOn
    IF ASCII(Ky$) = 27 THEN EXIT DO
    SLEEP .15

LOOP

playtime! = TIMER - starttime!

IF playtime! < .054 THEN playtime! = .054

COLOR 15
LOCATE 10, 10: PRINT "Mines found:"; found%
LOCATE 11, 10: PRINT "Mines missed:"; mines% - found%
LOCATE 12, 10: PRINT "Play time:"; playtime!
LOCATE 13, 10: PRINT "Score:"; CQUD(1000000 * ((found% / playtime!) / (mines% - found% + 1))) / 1000000
LOCATE 15, 10: INPUT "Do you want a new game (y=yes)? ", deci$
MsCursorOff
IF UCASE$(deci$) = "Y" THEN ELSE EXIT DO

LOOP

WIDTH 80, 25
COLOR 7
CLS
PRINT "Mine Seeker GNU/GPL Version 1.1 - DOS version of the classic old game."
PRINT "Created with PowerBASIC for DOS 3.50"
PRINT "Copyright (C) 2001-2002 by Bla Valek   E-mail: bvalek2@freemail.hu"
END

display:

flag% = 0
FOR y% = 1 TO rows%
    FOR x% = 1 TO cols%
        LOCATE y%, x%
        SELECT CASE table(x%, y%, 1)
        CASE "S"
            IF table(x%, y%, 0) = CHR$(&H0F) THEN
                failed = %True
                COLOR 4, 0
            ELSE
                COLOR VAL(table(x%, y%, 0)), 0
            END IF
            PRINT table(x%, y%, 0);
        CASE "F"
            flag% = flag% + 1
            COLOR 14, 0
            PRINT table(x%, y%, 1);
        CASE "?"
            flag% = flag% + 1
            COLOR 13, 0
            PRINT table(x%, y%, 1);
        CASE "H"
            flag% = flag% + 1
            COLOR 7, 0
            PRINT CHR$(&HFE);
        END SELECT
    NEXT x%
NEXT y%
IF (flag% = mines%) AND (failed = %False) THEN won = %True

RETURN

SUB MouseWait(Ky$, Button, Row, Column)

DO
    MsStatus Button, Row, Column
    Ky$ = INKEY$
LOOP UNTIL Button OR LEN(Ky$)

END SUB

SUB cleanfield (c AS INTEGER, r AS INTEGER)

    IF FRE(-3) < 1000 THEN EXIT SUB

    IF (c + 1 < cols% + 1) AND (r + 1 < rows% + 1) AND (table(c + 1, r + 1, 1) <> "S") AND (table(c + 1, r + 1, 1) <> "F") THEN
        table(c + 1, r + 1, 1) = "S"
        IF table(c + 1, r + 1, 0) = "0" THEN cleanfield c + 1, r + 1
    END IF
    IF (c + 1 < cols% + 1) AND (r - 1 > 0) AND (table(c + 1, r - 1, 1) <> "S") AND (table(c + 1, r - 1, 1) <> "F") THEN
        table(c + 1, r - 1, 1) = "S"
        IF table(c + 1, r - 1, 0) = "0" THEN cleanfield c + 1, r - 1
    END IF
    IF (c + 1 < cols% + 1) AND (table(c + 1, r, 1) <> "S") AND (table(c + 1, r, 1) <> "F") THEN
        table(c + 1, r, 1) = "S"
        IF table(c + 1, r, 0) = "0" THEN cleanfield c + 1, r
    END IF
    IF (c - 1 > 0) AND (r + 1 < rows% + 1) AND (table(c - 1, r + 1, 1) <> "S") AND (table(c - 1, r + 1, 1) <> "F") THEN
        table(c - 1, r + 1, 1) = "S"
        IF table(c - 1, r + 1, 0) = "0" THEN cleanfield c - 1, r + 1
    END IF
    IF (c - 1 > 0) AND (r - 1 > 0) AND (table(c - 1, r - 1, 1) <> "S") AND (table(c - 1, r - 1, 1) <> "F") THEN
        table(c - 1, r - 1, 1) = "S"
        IF table(c - 1, r - 1, 0) = "0" THEN cleanfield c - 1, r - 1
    END IF
    IF (c - 1 > 0) AND (table(c - 1, r, 1) <> "S") AND (table(c - 1, r, 1) <> "F") THEN
        table(c - 1, r, 1) = "S"
        IF table(c - 1, r, 0) = "0" THEN cleanfield c - 1, r
    END IF
    IF (r + 1 < rows% + 1) AND (table(c, r + 1, 1) <> "S") AND (table(c, r + 1, 1) <> "F") THEN
        table(c, r + 1, 1) = "S"
        IF table(c, r + 1, 0) = "0" THEN cleanfield c, r + 1
    END IF
    IF (r - 1 > 0) AND (table(c, r - 1, 1) <> "S") AND (table(c, r - 1, 1) <> "F") THEN
        table(c, r - 1, 1) = "S"
        IF table(c, r - 1, 0) = "0" THEN cleanfield c, r - 1
    END IF

END SUB

FUNCTION MsThere PUBLIC AS INTEGER

  ! push DS                 ; save DS for PowerBASIC

  ! xor  AX, AX             ; clear AX
  ! int  &H33               ; call mouse driver
  ! xor  BX, BX             ; clear BX, assume no mouse present
  ! or   AX, AX             ; does AX = 0?
  ! jz   MsThereDone        ; yes, we're done
  ! dec  BX                 ; no, make it -1

MsThereDone:
  ! mov  SS: UseMouse, BX   ; set flag for other mouse routines
  ! mov  FUNCTION, BX       ; put BX in RetVal variable
  ! pop  DS                 ; restore DS

END FUNCTION

FUNCTION MsButtons PUBLIC

  ! push DS                  ; save DS for PowerBASIC

  ! xor  AX, AX              ; clear AX
  ! int  &H33                ; call mouse driver
  ! or   BX, BX              ; does BX = 0?
  ! jns  MsButtonsDone       ; no, we're done
  ! mov  BX, 2               ; yes, it's a two button mouse

MsButtonsDone:
  ! mov  FUNCTION, BX       ; put BX in RetVal variable
  ! pop  DS                 ; restore DS

END FUNCTION

SUB MsCursorOn PUBLIC

  IF UseMouse THEN
    ! push DS                ; save DS for PowerBASIC

    ! mov  AX, 1             ; mouse driver function 1, turn on cursor
    ! int  &H33              ; call driver

    ! pop  DS                ; restore DS
  END IF

END SUB

SUB MsCursorOff PUBLIC

  IF UseMouse THEN
    ! push DS                ; save DS for PowerBASIC

    ! mov  AX, 2             ; mouse driver function 2, turn off cursor
    ! int  &H33              ; call driver

    ! pop  DS                ; restore DS
  END IF

END SUB

SUB MsStatus(Button AS INTEGER, Row AS INTEGER, Column AS INTEGER) PUBLIC

  IF UseMouse THEN
    ! push DS                ; save DS for PowerBASIC

    ! mov  AX, &H03          ; function 03h, get mouse status
    ! int  &H33              ; call mouse interrupt

    ! les  DI, Button        ; point ES:DI to Button
    ! mov  ES:[DI], BX       ; put active button(s) in variable

    ! les  DI, Row           ; point ES:DI to Row
    ! mov  ES:[DI], DX       ; put mouse row in variable

    ! les  DI, Column        ; point ES:DI to Column
    ! mov  ES:[DI], CX       ; put mouse column in variable

    ! pop  DS                ; restore DS for PowerBASIC

    IF (pbvScrnMode = 7) OR (pbvScrnMode = 0) THEN
      Row    = (Row \ 8) + 1   'if text mode, then fix coordinates
      Column = (Column \ 8) + 1
    END IF
  END IF

END SUB

SUB MsSetWindow(BYVAL Row  AS INTEGER, BYVAL Col  AS INTEGER,_
                BYVAL Rows AS INTEGER, BYVAL Cols AS INTEGER) PUBLIC


  IF UseMouse THEN
    Rows = Row + Rows - 1    ' adjust rows to real coordinates
    Cols = Col + Cols - 1    ' adjust cols to real coordinates

    IF (pbvScrnMode = 7) OR (pbvScrnMode = 0) THEN
      Row  = Row  * 8        ' if text mode, adjust coordinates
      Rows = Rows * 8
      Col  = Col  * 8
      Cols = Cols * 8
    END IF

    ! push DS                ; save DS for PowerBASIC

    ! mov  CX, Row           ; put start row in CX
    ! mov  DX, Rows          ; put end row in DX
    ! mov  AX, &H08          ; function 08h, set vertical limit
    ! int  &H33              ; call mouse interrupt

    ! mov  CX, Col           ; put start column in CX
    ! mov  DX, Cols          ; put end column in DX
    ! mov  AX, &H07          ; function 07h, set horizontal limit
    ! int  &H33              ; call mouse interrupt

    ! pop  DS                ; restore DS for PowerBASIC

    MsLocate Row, Col        ' move mouse cursor to upper left corner
  END IF

END SUB

SUB MsLocate(BYVAL Row AS INTEGER, BYVAL Column AS INTEGER) PUBLIC

  IF UseMouse THEN
    IF (pbvScrnMode = 7) OR (pbvScrnMode = 0) THEN
      Row    = (Row - 1) * 8      'if text mode, then fix coordinates
      Column = (Column - 1) * 8
    END IF

    ! push DS                ; save DS for PowerBASIC

    ! mov  AX, &H04          ; function 04h, set mouse location
    ! mov  CX, Column        ; put column in CX
    ! mov  DX, Row           ; put row in DX
    ! int  &H33              ; call mouse interrupt

    ! pop  DS                ; restore DS for PowerBASIC
  END IF

END SUB