 #ifdef VAXC   #module UPDUAF "BOL-V1.0/OCT-95" #else ' #pragma module UPDUAF "BOL-V1.0/OCT-95"  #endif  K /* This routine updates login-related information in the user's UAF record.   <    (P) 1995 by Ing. Ferry Bolhr (bol@adv.magwien.gv.at). */  2 #include descrip	/* Definitions for descriptors */+ #include rmsdef		/* RMS$_xxx error codes */ 0 #include ssdef		/* SS$_xxx system error codes */. #include stdio		/* Standard I/O definitions */4 #include string		/* strxxx() function definitions */; #include starlet	/* SYS$xxx() system service definitions */ * #include uaidef		/* UAI$_xxx item codes */  @ #include "chklgidef.h"  /* CHKLGI$_xxx login source constants */@ #include "lgibufdef.h"  /* LGIBUF structure field definitions */9 #include "lgimsgdef.h"  /* LGI$_xxx login status codes */    /***  ***/    /*** UPDUAF() ***/ /*** ======== ***/   /* Input arguments:   ,  lgistat:  Status of login attempt, by value  G  lgi:      Login buffer containing additional information. By reference   ,  curtim:   Login time (binary). By reference      Return codes:           The given login status  -         Any error code returned by SYS$SETUAI     */  P typedef struct dsc$descriptor_s dsc;    /* Abbreviation for descriptor struct.*/  6 int upduaf(int lgistat,struct LGIBUF* lgi,int *curtim) { H  /* For pre-V6 systems, the items UAI$_LASTLOGIN_x and UAI$_LOGFAILS areE     read-only, we can't update them. So simply return the given login      status in this case. */   
 #ifndef V6_OK   return lgistat; #else     int  flags,					/* UAF flags */   status;				/* Return status */   $  $DESCRIPTOR (usrdsc,lgi->T_USRNAM);  >  struct itmlst log_ok[3] =		/* Item list for login success: */  {@   8,UAI$_LASTLOGIN_I,curtim,0,		/* Update last login date and */F   2,UAI$_LOGFAILS,&lgi->W_LOGFAILS,0,	/* time and reset logfailures */   0,0   };     struct itmlst log_fail[3] =  {B   2,UAI$_LOGFAILS,&lgi->W_LOGFAILS,0,	/* Inc no. of logfailures */   0,0   };   @  /* First of all, we need a valid (not pseudo) username. Pseudo-;     users always start with a '<' in their name strings. */   -  if (lgi->T_USRNAM[0] == '<') return lgistat;   C  /* If this is an 'alternate' login (with UAFALTERNATE set to 1 and A     no alternate UAF exists) we can't update a record. Return. */   8  if (lgi->L_IFLAGS & CHKLGI$M_ALTERNATE) return lgistat;  J  /* Well, we can do something. Update length of username in descriptor. */  -  usrdsc.dsc$w_length = strlen(lgi->T_USRNAM);   F  /* If the login status is successful, update last login date/time and     clear # of logfailures. */    if (lgistat & 1)   {   lgi->W_LOGFAILS = 0;  @   /* If this is a non-interactive login, change the item code in      the item list. */  M   if (lgi->L_LGISRC < CHKLGI$_INTERACTIVE) log_ok[0].code = UAI$_LASTLOGIN_N;   "   /* Write back the UAF record. */  0   status = sys$setuai(0,0,&usrdsc,log_ok,0,0,0);  }  else   {1   /* Otherwise, increment login failure count. */      lgi->W_LOGFAILS++;  "   /* Write back the UAF record. */  2   status = sys$setuai(0,0,&usrdsc,log_fail,0,0,0);  }A  /* Fine, that's all. If SYS$SETUAI failed, let the user know. */   )  if (status != SS$_NORMAL) return status;      /* Else return login status. */    else return lgistat;    #endif	/* V6_OK */ } 