#ifndef __UAIDEF_LOADED
#define __UAIDEF_LOADED 1
 
/*** MODULE $uaidef ***/
/*
 Editted for V5.2 changes on 02-Oct-1989 (FJN)
 Editted for VAXC V3.1 changes on 06-Jul-1990 (FJN)
 Editted for V5.4 changes on 28-Nov-1990 (FJN)
*/
/*+                                                                         */
/*                                                                          */
/* Get User Authorization Information Data Identifier Definitions           */
/*                                                                          */
/* **** NOTE ****                                                           */
/*                                                                          */
/*        New items must always be added to the END of each item list       */
/*        so that users will not have to relink.                            */
/*-                                                                         */
#define UAI$_RTYPE 1                    /* UAF record type                  */
#define UAI$_VERSION 2                  /* UAF format version               */
#define UAI$_USRDATOFF 3                /* offset of counted string of user data */
#define UAI$_USERNAME 4                 /* username                         */
#define UAI$_USERNAME_TAG 5             /* tag to differentiate records     */
#define UAI$_UIC 6                      /* user ID code                     */
#define UAI$_MEM 7                      /* member subfield                  */
#define UAI$_GRP 8                      /* group subfield                   */
#define UAI$_SUB_ID 9                   /* user sub-identifier              */
#define UAI$_PARENT_ID 10               /* identifier of owner of this account */
#define UAI$_ACCOUNT 11                 /* account name                     */
#define UAI$_OWNER 12                   /* owner's name                     */
#define UAI$_DEFDEV 13                  /* default device                   */
#define UAI$_DEFDIR 14                  /* default directory                */
#define UAI$_LGICMD 15                  /* login command file               */
#define UAI$_DEFCLI 16                  /* default command interpreter      */
#define UAI$_CLITABLES 17               /* user CLI tables                  */
#define UAI$_PWD 18                     /* hashed password                  */
#define UAI$_PWD2 19                    /* second password                  */
#define UAI$_LOGFAILS 20                /* count of login failures          */
#define UAI$_SALT 21                    /* random password salt             */
#define UAI$_ENCRYPT 22                 /* encryption algorithm             */
#define UAI$_ENCRYPT2 23                /* encryption algorithm for 2nd pwd */
#define UAI$_PWD_LENGTH 24              /* minimum password length          */
#define UAI$_EXPIRATION 25              /* expiration date for account      */
#define UAI$_PWD_LIFETIME 26            /* password lifetime                */
#define UAI$_PWD_DATE 27                /* date of password change          */
#define UAI$_PWD2_DATE 28               /* date of 2nd password change      */
#define UAI$_LASTLOGIN_I 29             /* date of last interactive login   */
#define UAI$_LASTLOGIN_N 30             /* date of last non-interactive login */
 
#define UAI$_PRIV 31                    /* process privilege vector         */
#define UAI$_DEF_PRIV 32                /* default process privileges       */
#define UAI$_MIN_CLASS 33               /* minimum security class           */
#define UAI$_MAX_CLASS 34               /* maximum security class           */
#define UAI$_FLAGS 35                   /* user flags longword              */
#define UAI$_NETWORK_ACCESS_P 36        /* hourly network access, primary   */
#define UAI$_NETWORK_ACCESS_S 37        /* hourly network access, secondary */
#define UAI$_BATCH_ACCESS_P 38          /* hourly batch access, primary     */
#define UAI$_BATCH_ACCESS_S 39          /* hourly batch access, secondary   */
#define UAI$_LOCAL_ACCESS_P 40          /* hourly local access, primary     */
#define UAI$_LOCAL_ACCESS_S 41          /* hourly local access, secondary   */
#define UAI$_DIALUP_ACCESS_P 42         /* hourly dialup access, primary    */
#define UAI$_DIALUP_ACCESS_S 43         /* hourly dialup access, secondary  */
#define UAI$_REMOTE_ACCESS_P 44         /* hourly remote access, primary    */
#define UAI$_REMOTE_ACCESS_S 45         /* hourly remote access, secondary  */
#define UAI$_PRIMEDAYS 46               /* bits representing primary days   */
#define UAI$_PRI 47                     /* base process priority            */
#define UAI$_QUEPRI 48                  /* maximum job queuing priority     */
#define UAI$_MAXJOBS 49                 /* maximum jobs for UIC allowed     */
#define UAI$_MAXACCTJOBS 50             /* maximum jobs for account allowed */
#define UAI$_MAXDETACH 51               /* maximum detached processes for UIC */
 
#define UAI$_PRCCNT 52                  /* subprocess creation limit        */
#define UAI$_BIOLM 53                   /* buffered I/O limit               */
#define UAI$_DIOLM 54                   /* direct I/O limit                 */
#define UAI$_TQCNT 55                   /* timer queue entry limit          */
#define UAI$_ASTLM 56                   /* AST queue limit                  */
#define UAI$_ENQLM 57                   /* enqueue limit                    */
#define UAI$_FILLM 58                   /* open file limit                  */
#define UAI$_SHRFILLM 59                /* shared file limit                */
#define UAI$_WSQUOTA 60                 /* working set size quota           */
#define UAI$_DFWSCNT 61                 /* default working set size         */
#define UAI$_WSEXTENT 62                /* working set size limit           */
#define UAI$_PGFLQUOTA 63               /* page file quota                  */
#define UAI$_CPUTIM 64                  /* CPU time quota                   */
#define UAI$_BYTLM 65                   /* buffered I/O byte count limit    */
#define UAI$_PBYTLM 66                  /* paged buffer I/O byte count limit */
#define UAI$_JTQUOTA 67                 /* job-wide logical name table creationquota */
#define UAI$_PROXY_LIM 68               /* number of proxies user can grant */
#define UAI$_PROXIES 69                 /* number of proxies granted        */
#define UAI$_ACCOUNT_LIM 70             /* number of sub-accounts allowed   */
#define UAI$_ACCOUNTS 71                /* number of sub-accounts in use    */
#define UAI$_USER_DATA  72              /* user data area */
#define UAI$_PASSWORD   73              /* plaintext primary password */
#define UAI$_PASSWORD2  74              /* plaintext secondary password */
/* ADD ITEM-CODES BEFORE THIS COMMENT                                       */
#define UAI$_MAX_ITEM_CODE      75      /* maximum legal item code + 1 */
/* Define the various encryption codes, returned by the encryption algorithm */
/* item.                                                                    */
#define UAI$C_AD_II 0                   /* AUTODIN-II 32 bit crc code       */
#define UAI$C_PURDY 1                   /* Purdy polynomial over salted input */
 
#define UAI$C_PURDY_V 2                 /* Purdy polynomial + variable length username */
#define UAI$C_PURDY_S           3       /* purdy_v folded into password length */
#define UAI$C_PREFERED_ALGORITHM 3      /* prefered hash algorithm (subject to change) */
#define UAI$C_CUST_ALGORITHM    128     /* customer algorithm division */
#define UAI$C_MAX_PWD_LENGTH    32      /* maximum plaintext password */
/* Define the flags for the user flags longword.                            */
#define UAI$M_DISCTLY 1
#define UAI$M_DEFCLI 2
#define UAI$M_LOCKPWD 4
#define UAI$M_RESTRICTED    8
#define UAI$M_DISACNT 16
#define UAI$M_DISWELCOM 32
#define UAI$M_DISMAIL 64
#define UAI$M_NOMAIL 128
#define UAI$M_GENPWD 256
#define UAI$M_PWD_EXPIRED 512
#define UAI$M_PWD2_EXPIRED 1024
#define UAI$M_AUDIT 2048
#define UAI$M_DISREPORT 4096
#define UAI$M_DISRECONNECT 8192
#define UAI$M_AUTOLOGIN 16384
#define UAI$M_DISFORCE_PWD_CHANGE 32768
#define UAI$M_CAPTIVE           0X10000
#define UAI$M_DISIMAGE          0X20000
#define UAI$M_DISPWDDIC 0X40000
#define UAI$M_DISPWDHIS 0X80000
#pragma nostandard
struct flags {                          /* user flags longword              */
    unsigned uai$v_disctly : 1;         /* no user control-y                */
    unsigned uai$v_defcli : 1;          /* only allow user default CLI      */
    unsigned uai$v_lockpwd : 1;         /* disable SET PASSWORD command     */
    unsigned uai$v_restricted : 1;      /* restricted account (pre-V5.2 captive) */
    unsigned uai$v_disacnt : 1;         /* no interactive login             */
    unsigned uai$v_diswelcom : 1;       /* skip welcome message             */
    unsigned uai$v_dismail : 1;         /* skip new mail message            */
    unsigned uai$v_nomail : 1;          /* disable mail delivery            */
    unsigned uai$v_genpwd : 1;          /* passwords must be generated      */
    unsigned uai$v_pwd_expired : 1;     /* password has expired             */
    unsigned uai$v_pwd2_expired : 1;    /* 2nd password has expired         */
    unsigned uai$v_audit : 1;           /* audit all actions                */
    unsigned uai$v_disreport : 1;       /* skip last login messages         */
    unsigned uai$v_disreconnect : 1;    /* inhibit reconnections            */
    unsigned uai$v_autologin : 1;       /* auto-login only                  */
    unsigned uai$v_disforce_pwd_change : 1; /* disable forced password change */
 
    unsigned uai$v_captive : 1;         /* captive account (no overrides) */
    unsigned uai$v_disimage : 1;        /* disable arbitrary image activation */
 
    unsigned uai$v_dispwddic : 1;       /* disable password dictionary filter */
 
    unsigned uai$v_dispwdhis : 1;       /* disable password history search */
    } ;
/* Define the flags representing primary days.                              */
struct primedays {                      /* bits representing primary days   */
    unsigned uai$v_monday : 1;          /* bit clear means this is a primary day */
    unsigned uai$v_tuesday : 1;         /* bit set means this is an off day */
    unsigned uai$v_wednesday : 1;
    unsigned uai$v_thursday : 1;
    unsigned uai$v_friday : 1;
    unsigned uai$v_saturday : 1;
    unsigned uai$v_sunday : 1;
    unsigned uai$v_fill_6 : 1;
    } ;
#pragma standard
#define UAI$V_DISCTLY   0
#define UAI$V_DEFCLI    1
#define UAI$V_LOCKPWD   2
#define UAI$V_CAPTIVE   3
#define UAI$V_DISACNT   4
#define UAI$V_DISWELCOM 5
#define UAI$V_DISMAIL   6
#define UAI$V_NOMAIL    7
#define UAI$V_GENPWD    8
#define UAI$V_PWD_EXPIRED       9
#define UAI$V_PWD2_EXPIRED      10
#define UAI$V_AUDIT     11
#define UAI$V_DISREPORT 12
#define UAI$V_DISRECONNECT      13
#define UAI$V_AUTOLOGIN 14
#define UAI$V_DISFORCE_PWD_CHANGE       15
#define UAI$V_MONDAY    0
#define UAI$V_TUESDAY   1
#define UAI$V_WEDNESDAY 2
#define UAI$V_THURSDAY  3
#define UAI$V_FRIDAY    4
#define UAI$V_SATURDAY  5
#define UAI$V_SUNDAY    6
 
#endif                                  /* __UAIDEF_LOADED */
